/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.Serializable;
import java.util.Enumeration;
import org.apache.lucene.document.DocumentFieldEnumeration;
import org.apache.lucene.document.DocumentFieldList;
import org.apache.lucene.document.Field;

public final class Document
implements Serializable {
    DocumentFieldList fieldList = null;
    private float boost = 1.0f;

    public void setBoost(float f) {
        this.boost = f;
    }

    public float getBoost() {
        return this.boost;
    }

    public final void add(Field field) {
        this.fieldList = new DocumentFieldList(field, this.fieldList);
    }

    public final Field getField(String string) {
        DocumentFieldList documentFieldList = this.fieldList;
        while (documentFieldList != null) {
            if (documentFieldList.field.name().equals(string)) {
                return documentFieldList.field;
            }
            documentFieldList = documentFieldList.next;
        }
        return null;
    }

    public final String get(String string) {
        Field field = this.getField(string);
        if (field != null) {
            return field.stringValue();
        }
        return null;
    }

    public final Enumeration fields() {
        return new DocumentFieldEnumeration(this);
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Document<");
        DocumentFieldList documentFieldList = this.fieldList;
        while (documentFieldList != null) {
            stringBuffer.append(documentFieldList.field.toString());
            if (documentFieldList.next != null) {
                stringBuffer.append(" ");
            }
            documentFieldList = documentFieldList.next;
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }
}

