/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Hashtable;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.SegmentsTermDocs;
import org.apache.lucene.index.SegmentsTermEnum;
import org.apache.lucene.index.SegmentsTermPositions;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.store.Directory;

final class SegmentsReader
extends IndexReader {
    protected SegmentReader[] readers;
    protected int[] starts;
    private Hashtable normsCache = new Hashtable();
    private int maxDoc = 0;
    private int numDocs = -1;

    SegmentsReader(Directory directory, SegmentReader[] segmentReaderArray) throws IOException {
        super(directory);
        this.readers = segmentReaderArray;
        this.starts = new int[this.readers.length + 1];
        int n = 0;
        while (n < this.readers.length) {
            this.starts[n] = this.maxDoc;
            this.maxDoc += this.readers[n].maxDoc();
            ++n;
        }
        this.starts[this.readers.length] = this.maxDoc;
    }

    public final synchronized int numDocs() {
        if (this.numDocs == -1) {
            int n = 0;
            int n2 = 0;
            while (n2 < this.readers.length) {
                n += this.readers[n2].numDocs();
                ++n2;
            }
            this.numDocs = n;
        }
        return this.numDocs;
    }

    public final int maxDoc() {
        return this.maxDoc;
    }

    public final Document document(int n) throws IOException {
        int n2 = this.readerIndex(n);
        return this.readers[n2].document(n - this.starts[n2]);
    }

    public final boolean isDeleted(int n) {
        int n2 = this.readerIndex(n);
        return this.readers[n2].isDeleted(n - this.starts[n2]);
    }

    final synchronized void doDelete(int n) throws IOException {
        this.numDocs = -1;
        int n2 = this.readerIndex(n);
        this.readers[n2].doDelete(n - this.starts[n2]);
    }

    /*
     * Unable to fully structure code
     */
    private final int readerIndex(int var1_1) {
        var2_2 = 0;
        var3_3 = this.readers.length - 1;
        while (var3_3 >= var2_2) {
            var4_4 = var2_2 + var3_3 >> 1;
            var5_5 = this.starts[var4_4];
            if (var1_1 < var5_5) {
                var3_3 = var4_4 - 1;
                continue;
            }
            if (var1_1 <= var5_5) ** GOTO lbl13
            var2_2 = var4_4 + 1;
            continue;
lbl-1000:
            // 1 sources

            {
                ++var4_4;
lbl13:
                // 2 sources

                ** while (var4_4 + 1 < this.readers.length && this.starts[var4_4 + 1] == var5_5)
            }
lbl14:
            // 1 sources

            return var4_4;
        }
        return var3_3;
    }

    public final synchronized byte[] norms(String string) throws IOException {
        byte[] byArray = (byte[])this.normsCache.get(string);
        if (byArray != null) {
            return byArray;
        }
        byArray = new byte[this.maxDoc()];
        int n = 0;
        while (n < this.readers.length) {
            this.readers[n].norms(string, byArray, this.starts[n]);
            ++n;
        }
        this.normsCache.put(string, byArray);
        return byArray;
    }

    public final TermEnum terms() throws IOException {
        return new SegmentsTermEnum(this.readers, this.starts, null);
    }

    public final TermEnum terms(Term term) throws IOException {
        return new SegmentsTermEnum(this.readers, this.starts, term);
    }

    public final int docFreq(Term term) throws IOException {
        int n = 0;
        int n2 = 0;
        while (n2 < this.readers.length) {
            n += this.readers[n2].docFreq(term);
            ++n2;
        }
        return n;
    }

    public final TermDocs termDocs() throws IOException {
        return new SegmentsTermDocs(this.readers, this.starts);
    }

    public final TermPositions termPositions() throws IOException {
        return new SegmentsTermPositions(this.readers, this.starts);
    }

    final synchronized void doClose() throws IOException {
        int n = 0;
        while (n < this.readers.length) {
            this.readers[n].close();
            ++n;
        }
    }
}

