/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.HitQueue;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Searchable;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.TopDocs;

public class MultiSearcher
extends Searcher
implements Searchable {
    private Searchable[] searchables;
    private int[] starts;
    private int maxDoc = 0;

    public MultiSearcher(Searchable[] searchableArray) throws IOException {
        this.searchables = searchableArray;
        this.starts = new int[searchableArray.length + 1];
        int n = 0;
        while (n < searchableArray.length) {
            this.starts[n] = this.maxDoc;
            this.maxDoc += searchableArray[n].maxDoc();
            ++n;
        }
        this.starts[searchableArray.length] = this.maxDoc;
    }

    public void close() throws IOException {
        int n = 0;
        while (n < this.searchables.length) {
            this.searchables[n].close();
            ++n;
        }
    }

    public int docFreq(Term term) throws IOException {
        int n = 0;
        int n2 = 0;
        while (n2 < this.searchables.length) {
            n += this.searchables[n2].docFreq(term);
            ++n2;
        }
        return n;
    }

    public Document doc(int n) throws IOException {
        int n2 = this.searcherIndex(n);
        return this.searchables[n2].doc(n - this.starts[n2]);
    }

    /*
     * Unable to fully structure code
     */
    public int searcherIndex(int var1_1) {
        var2_2 = 0;
        var3_3 = this.searchables.length - 1;
        while (var3_3 >= var2_2) {
            var4_4 = var2_2 + var3_3 >> 1;
            var5_5 = this.starts[var4_4];
            if (var1_1 < var5_5) {
                var3_3 = var4_4 - 1;
                continue;
            }
            if (var1_1 <= var5_5) ** GOTO lbl13
            var2_2 = var4_4 + 1;
            continue;
lbl-1000:
            // 1 sources

            {
                ++var4_4;
lbl13:
                // 2 sources

                ** while (var4_4 + 1 < this.searchables.length && this.starts[var4_4 + 1] == var5_5)
            }
lbl14:
            // 1 sources

            return var4_4;
        }
        return var3_3;
    }

    public int maxDoc() throws IOException {
        return this.maxDoc;
    }

    public TopDocs search(Query query, Filter filter, int n) throws IOException {
        ScoreDoc[] scoreDocArray;
        HitQueue hitQueue = new HitQueue(n);
        float f = 0.0f;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.searchables.length) {
            scoreDocArray = this.searchables[n3].search(query, filter, n);
            n2 += scoreDocArray.totalHits;
            ScoreDoc[] scoreDocArray2 = scoreDocArray.scoreDocs;
            int n4 = 0;
            while (n4 < scoreDocArray2.length) {
                ScoreDoc scoreDoc = scoreDocArray2[n4];
                if (!(scoreDoc.score >= f)) break;
                scoreDoc.doc += this.starts[n3];
                hitQueue.put(scoreDoc);
                if (hitQueue.size() > n) {
                    hitQueue.pop();
                    f = ((ScoreDoc)hitQueue.top()).score;
                }
                ++n4;
            }
            ++n3;
        }
        scoreDocArray = new ScoreDoc[hitQueue.size()];
        int n5 = hitQueue.size() - 1;
        while (n5 >= 0) {
            scoreDocArray[n5] = (ScoreDoc)hitQueue.pop();
            --n5;
        }
        return new TopDocs(n2, scoreDocArray);
    }

    public void search(Query query, Filter filter, final HitCollector hitCollector) throws IOException {
        int n = 0;
        while (n < this.searchables.length) {
            final int n2 = this.starts[n];
            this.searchables[n].search(query, filter, new HitCollector(){

                public void collect(int n, float f) {
                    hitCollector.collect(n + n2, f);
                }
            });
            ++n;
        }
    }
}

