/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.AppFileLocProvider;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.mozilla.GRE;
import org.eclipse.swt.internal.mozilla.XPCOM;
import org.eclipse.swt.internal.mozilla.XPCOMObject;
import org.eclipse.swt.internal.mozilla.nsIAppShell;
import org.eclipse.swt.internal.mozilla.nsIBaseWindow;
import org.eclipse.swt.internal.mozilla.nsIComponentManager;
import org.eclipse.swt.internal.mozilla.nsIContextMenuListener;
import org.eclipse.swt.internal.mozilla.nsID;
import org.eclipse.swt.internal.mozilla.nsIDOMLocation;
import org.eclipse.swt.internal.mozilla.nsIDOMWindow;
import org.eclipse.swt.internal.mozilla.nsIDOMWindowInternal;
import org.eclipse.swt.internal.mozilla.nsIEmbeddingSiteWindow;
import org.eclipse.swt.internal.mozilla.nsIInterfaceRequestor;
import org.eclipse.swt.internal.mozilla.nsILocalFile;
import org.eclipse.swt.internal.mozilla.nsISupports;
import org.eclipse.swt.internal.mozilla.nsISupportsWeakReference;
import org.eclipse.swt.internal.mozilla.nsIURI;
import org.eclipse.swt.internal.mozilla.nsIWeakReference;
import org.eclipse.swt.internal.mozilla.nsIWebBrowser;
import org.eclipse.swt.internal.mozilla.nsIWebBrowserChrome;
import org.eclipse.swt.internal.mozilla.nsIWebBrowserChromeFocus;
import org.eclipse.swt.internal.mozilla.nsIWebBrowserFocus;
import org.eclipse.swt.internal.mozilla.nsIWebNavigation;
import org.eclipse.swt.internal.mozilla.nsIWebProgressListener;
import org.eclipse.swt.internal.mozilla.nsString;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class Browser
extends Composite {
    nsIWebBrowser webBrowser;
    XPCOMObject supports;
    XPCOMObject weakReference;
    XPCOMObject webProgressListener;
    XPCOMObject webBrowserChrome;
    XPCOMObject webBrowserChromeFocus;
    XPCOMObject embeddingSiteWindow;
    XPCOMObject interfaceRequestor;
    XPCOMObject supportsWeakReference;
    XPCOMObject contextMenuListener;
    int chromeFlags = 1;
    int refCount = 0;
    LocationListener[] locationListeners = new LocationListener[0];
    ProgressListener[] progressListeners = new ProgressListener[0];
    StatusTextListener[] statusTextListeners = new StatusTextListener[0];
    static nsIAppShell appShell;
    static AppFileLocProvider locProvider;
    static int browserCount;
    static final String PACKAGE_PREFIX = "org.eclipse.swt.browser.";

    public Browser(Composite parent, int style) {
        super(parent, style);
        int rc;
        int[] result = new int[1];
        if (++browserCount == 1) {
            String mozillaPath = GRE.mozillaPath;
            if (mozillaPath == null) {
                throw new SWTError(XPCOM.errorMsg((int)-2147467259));
            }
            locProvider = new AppFileLocProvider();
            locProvider.AddRef();
            int[] retVal = new int[1];
            int rc2 = XPCOM.NS_NewLocalFile((String)mozillaPath, (boolean)true, (int[])retVal);
            if (rc2 != 0) {
                throw new SWTError(XPCOM.errorMsg((int)rc2));
            }
            if (retVal[0] == 0) {
                throw new SWTError(XPCOM.errorMsg((int)-2147467261));
            }
            nsILocalFile localFile = new nsILocalFile(retVal[0]);
            rc2 = XPCOM.NS_InitEmbedding((int)localFile.getAddress(), (int)locProvider.getAddress());
            if (rc2 != 0) {
                throw new SWTError(XPCOM.errorMsg((int)rc2));
            }
            localFile.Release();
            rc2 = XPCOM.NS_GetComponentManager((int[])result);
            if (rc2 != 0) {
                throw new SWTError(XPCOM.errorMsg((int)rc2));
            }
            if (result[0] == 0) {
                throw new SWTError(XPCOM.errorMsg((int)-2147467262));
            }
            nsIComponentManager componentManager = new nsIComponentManager(result[0]);
            result[0] = 0;
            rc2 = componentManager.CreateInstance(XPCOM.NS_APPSHELL_CID, 0, nsIAppShell.NS_IAPPSHELL_IID, result);
            if (rc2 != 0) {
                throw new SWTError(XPCOM.errorMsg((int)rc2));
            }
            if (result[0] == 0) {
                throw new SWTError(XPCOM.errorMsg((int)-2147467262));
            }
            componentManager.Release();
            appShell = new nsIAppShell(result[0]);
            rc2 = appShell.Create(null, null);
            if (rc2 != 0) {
                throw new SWTError(XPCOM.errorMsg((int)rc2));
            }
            rc2 = appShell.Spinup();
            if (rc2 != 0) {
                throw new SWTError(XPCOM.errorMsg((int)rc2));
            }
        }
        if ((rc = XPCOM.NS_GetComponentManager((int[])result)) != 0) {
            throw new SWTError(XPCOM.errorMsg((int)rc));
        }
        if (result[0] == 0) {
            throw new SWTError(XPCOM.errorMsg((int)-2147467262));
        }
        nsIComponentManager componentManager = new nsIComponentManager(result[0]);
        result[0] = 0;
        nsID NS_IWEBBROWSER_CID = new nsID("F1EAC761-87E9-11d3-AF80-00A024FFC08C");
        rc = componentManager.CreateInstance(NS_IWEBBROWSER_CID, 0, nsIWebBrowser.NS_IWEBBROWSER_IID, result);
        if (rc != 0) {
            throw new SWTError(XPCOM.errorMsg((int)rc));
        }
        if (result[0] == 0) {
            throw new SWTError(XPCOM.errorMsg((int)-2147467262));
        }
        componentManager.Release();
        this.webBrowser = new nsIWebBrowser(result[0]);
        this.createCOMInterfaces();
        this.AddRef();
        rc = this.webBrowser.SetContainerWindow(this.webBrowserChrome.getAddress());
        if (rc != 0) {
            throw new SWTError(XPCOM.errorMsg((int)rc));
        }
        rc = this.webBrowser.QueryInterface(nsIBaseWindow.NS_IBASEWINDOW_IID, result);
        if (rc != 0) {
            throw new SWTError(XPCOM.errorMsg((int)rc));
        }
        if (result[0] == 0) {
            throw new SWTError(XPCOM.errorMsg((int)-2147467262));
        }
        nsIBaseWindow baseWindow = new nsIBaseWindow(result[0]);
        Rectangle rect = this.getClientArea();
        if (rect.isEmpty()) {
            rect.width = 1;
            rect.height = 1;
        }
        if ((rc = baseWindow.InitWindow(this.handle, 0, 0, 0, rect.width, rect.height)) != 0) {
            throw new SWTError(XPCOM.errorMsg((int)-2147467259));
        }
        rc = baseWindow.Create();
        if (rc != 0) {
            throw new SWTError(XPCOM.errorMsg((int)-2147467259));
        }
        rc = baseWindow.SetVisibility(true);
        if (rc != 0) {
            throw new SWTError(XPCOM.errorMsg((int)-2147467259));
        }
        baseWindow.Release();
        rc = this.webBrowser.AddWebBrowserListener(this.weakReference.getAddress(), nsIWebProgressListener.NS_IWEBPROGRESSLISTENER_IID);
        if (rc != 0) {
            throw new SWTError(XPCOM.errorMsg((int)rc));
        }
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        Browser.this.onDispose();
                        break;
                    }
                    case 11: {
                        Browser.this.onResize();
                        break;
                    }
                    case 15: {
                        Browser.this.onFocusGained(event);
                        break;
                    }
                    case 16: {
                        Browser.this.onFocusLost(event);
                    }
                }
            }
        };
        int[] folderEvents = new int[]{12, 11, 15, 16};
        int i = 0;
        while (i < folderEvents.length) {
            this.addListener(folderEvents[i], listener);
            ++i;
        }
    }

    public void addLocationListener(LocationListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        LocationListener[] newLocationListeners = new LocationListener[this.locationListeners.length + 1];
        System.arraycopy(this.locationListeners, 0, newLocationListeners, 0, this.locationListeners.length);
        this.locationListeners = newLocationListeners;
        this.locationListeners[this.locationListeners.length - 1] = listener;
    }

    public void addProgressListener(ProgressListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        ProgressListener[] newProgressListeners = new ProgressListener[this.progressListeners.length + 1];
        System.arraycopy(this.progressListeners, 0, newProgressListeners, 0, this.progressListeners.length);
        this.progressListeners = newProgressListeners;
        this.progressListeners[this.progressListeners.length - 1] = listener;
    }

    public void addStatusTextListener(StatusTextListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        StatusTextListener[] newStatusTextListeners = new StatusTextListener[this.statusTextListeners.length + 1];
        System.arraycopy(this.statusTextListeners, 0, newStatusTextListeners, 0, this.statusTextListeners.length);
        this.statusTextListeners = newStatusTextListeners;
        this.statusTextListeners[this.statusTextListeners.length - 1] = listener;
    }

    public boolean back() {
        this.checkWidget();
        int[] result = new int[1];
        int rc = this.webBrowser.QueryInterface(nsIWebNavigation.NS_IWEBNAVIGATION_IID, result);
        if (rc != 0) {
            throw new SWTError(XPCOM.errorMsg((int)rc));
        }
        if (result[0] == 0) {
            throw new SWTError(XPCOM.errorMsg((int)-2147467262));
        }
        nsIWebNavigation webNavigation = new nsIWebNavigation(result[0]);
        webNavigation.GoBack();
        webNavigation.Release();
        return rc == 0;
    }

    protected void checkSubclass() {
        int index;
        String name = this.getClass().getName();
        if (!name.substring(0, (index = name.lastIndexOf(46)) + 1).equals(PACKAGE_PREFIX)) {
            SWT.error(43);
        }
    }

    void createCOMInterfaces() {
        int[] nArray = new int[3];
        nArray[0] = 2;
        this.supports = new XPCOMObject(nArray){

            public int method0(int[] args) {
                return Browser.this.QueryInterface(args[0], args[1]);
            }

            public int method1(int[] args) {
                return Browser.this.AddRef();
            }

            public int method2(int[] args) {
                return Browser.this.Release();
            }
        };
        int[] nArray2 = new int[4];
        nArray2[0] = 2;
        nArray2[3] = 2;
        this.weakReference = new XPCOMObject(nArray2){

            public int method0(int[] args) {
                return Browser.this.QueryInterface(args[0], args[1]);
            }

            public int method1(int[] args) {
                return Browser.this.AddRef();
            }

            public int method2(int[] args) {
                return Browser.this.Release();
            }

            public int method3(int[] args) {
                return Browser.this.QueryReferent(args[0], args[1]);
            }
        };
        int[] nArray3 = new int[8];
        nArray3[0] = 2;
        nArray3[3] = 4;
        nArray3[4] = 6;
        nArray3[5] = 3;
        nArray3[6] = 4;
        nArray3[7] = 3;
        this.webProgressListener = new XPCOMObject(nArray3){

            public int method0(int[] args) {
                return Browser.this.QueryInterface(args[0], args[1]);
            }

            public int method1(int[] args) {
                return Browser.this.AddRef();
            }

            public int method2(int[] args) {
                return Browser.this.Release();
            }

            public int method3(int[] args) {
                return Browser.this.OnStateChange(args[0], args[1], args[2], args[3]);
            }

            public int method4(int[] args) {
                return Browser.this.OnProgressChange(args[0], args[1], args[2], args[3], args[4], args[5]);
            }

            public int method5(int[] args) {
                return Browser.this.OnLocationChange(args[0], args[1], args[2]);
            }

            public int method6(int[] args) {
                return Browser.this.OnStatusChange(args[0], args[1], args[2], args[3]);
            }

            public int method7(int[] args) {
                return Browser.this.OnSecurityChange(args[0], args[1], args[2]);
            }
        };
        int[] nArray4 = new int[13];
        nArray4[0] = 2;
        nArray4[3] = 2;
        nArray4[4] = 1;
        nArray4[5] = 1;
        nArray4[6] = 1;
        nArray4[7] = 1;
        nArray4[9] = 2;
        nArray4[11] = 1;
        nArray4[12] = 1;
        this.webBrowserChrome = new XPCOMObject(nArray4){

            public int method0(int[] args) {
                return Browser.this.QueryInterface(args[0], args[1]);
            }

            public int method1(int[] args) {
                return Browser.this.AddRef();
            }

            public int method2(int[] args) {
                return Browser.this.Release();
            }

            public int method3(int[] args) {
                return Browser.this.SetStatus(args[0], args[1]);
            }

            public int method4(int[] args) {
                return Browser.this.GetWebBrowser(args[0]);
            }

            public int method5(int[] args) {
                return Browser.this.SetWebBrowser(args[0]);
            }

            public int method6(int[] args) {
                return Browser.this.GetChromeFlags(args[0]);
            }

            public int method7(int[] args) {
                return Browser.this.SetChromeFlags(args[0]);
            }

            public int method8(int[] args) {
                return Browser.this.DestroyBrowserWindow();
            }

            public int method9(int[] args) {
                return Browser.this.SizeBrowserTo(args[0], args[1]);
            }

            public int method10(int[] args) {
                return Browser.this.ShowAsModal();
            }

            public int method11(int[] args) {
                return Browser.this.IsWindowModal(args[0]);
            }

            public int method12(int[] args) {
                return Browser.this.ExitModalEventLoop(args[0]);
            }
        };
        int[] nArray5 = new int[5];
        nArray5[0] = 2;
        this.webBrowserChromeFocus = new XPCOMObject(nArray5){

            public int method0(int[] args) {
                return Browser.this.QueryInterface(args[0], args[1]);
            }

            public int method1(int[] args) {
                return Browser.this.AddRef();
            }

            public int method2(int[] args) {
                return Browser.this.Release();
            }

            public int method3(int[] args) {
                return Browser.this.FocusNextElement();
            }

            public int method4(int[] args) {
                return Browser.this.FocusPrevElement();
            }
        };
        int[] nArray6 = new int[11];
        nArray6[0] = 2;
        nArray6[3] = 5;
        nArray6[4] = 5;
        nArray6[6] = 1;
        nArray6[7] = 1;
        nArray6[8] = 1;
        nArray6[9] = 1;
        nArray6[10] = 1;
        this.embeddingSiteWindow = new XPCOMObject(nArray6){

            public int method0(int[] args) {
                return Browser.this.QueryInterface(args[0], args[1]);
            }

            public int method1(int[] args) {
                return Browser.this.AddRef();
            }

            public int method2(int[] args) {
                return Browser.this.Release();
            }

            public int method3(int[] args) {
                return Browser.this.SetDimensions(args[0], args[1], args[2], args[3], args[4]);
            }

            public int method4(int[] args) {
                return Browser.this.GetDimensions(args[0], args[1], args[2], args[3], args[4]);
            }

            public int method5(int[] args) {
                return Browser.this.SetFocus();
            }

            public int method6(int[] args) {
                return Browser.this.GetVisibility(args[0]);
            }

            public int method7(int[] args) {
                return Browser.this.SetVisibility(args[0]);
            }

            public int method8(int[] args) {
                return Browser.this.GetTitle(args[0]);
            }

            public int method9(int[] args) {
                return Browser.this.SetTitle(args[0]);
            }

            public int method10(int[] args) {
                return Browser.this.GetSiteWindow(args[0]);
            }
        };
        int[] nArray7 = new int[4];
        nArray7[0] = 2;
        nArray7[3] = 2;
        this.interfaceRequestor = new XPCOMObject(nArray7){

            public int method0(int[] args) {
                return Browser.this.QueryInterface(args[0], args[1]);
            }

            public int method1(int[] args) {
                return Browser.this.AddRef();
            }

            public int method2(int[] args) {
                return Browser.this.Release();
            }

            public int method3(int[] args) {
                return Browser.this.GetInterface(args[0], args[1]);
            }
        };
        int[] nArray8 = new int[4];
        nArray8[0] = 2;
        nArray8[3] = 1;
        this.supportsWeakReference = new XPCOMObject(nArray8){

            public int method0(int[] args) {
                return Browser.this.QueryInterface(args[0], args[1]);
            }

            public int method1(int[] args) {
                return Browser.this.AddRef();
            }

            public int method2(int[] args) {
                return Browser.this.Release();
            }

            public int method3(int[] args) {
                return Browser.this.GetWeakReference(args[0]);
            }
        };
        int[] nArray9 = new int[4];
        nArray9[0] = 2;
        nArray9[3] = 3;
        this.contextMenuListener = new XPCOMObject(nArray9){

            public int method0(int[] args) {
                return Browser.this.QueryInterface(args[0], args[1]);
            }

            public int method1(int[] args) {
                return Browser.this.AddRef();
            }

            public int method2(int[] args) {
                return Browser.this.Release();
            }

            public int method3(int[] args) {
                return Browser.this.OnShowContextMenu(args[0], args[1], args[2]);
            }
        };
    }

    void disposeCOMInterfaces() {
        if (this.supports != null) {
            this.supports.dispose();
            this.supports = null;
        }
        if (this.weakReference != null) {
            this.weakReference.dispose();
            this.weakReference = null;
        }
        if (this.webProgressListener != null) {
            this.webProgressListener.dispose();
            this.webProgressListener = null;
        }
        if (this.webBrowserChrome != null) {
            this.webBrowserChrome.dispose();
            this.webBrowserChrome = null;
        }
        if (this.webBrowserChromeFocus != null) {
            this.webBrowserChromeFocus.dispose();
            this.webBrowserChromeFocus = null;
        }
        if (this.embeddingSiteWindow != null) {
            this.embeddingSiteWindow.dispose();
            this.embeddingSiteWindow = null;
        }
        if (this.interfaceRequestor != null) {
            this.interfaceRequestor.dispose();
            this.interfaceRequestor = null;
        }
        if (this.supportsWeakReference != null) {
            this.supportsWeakReference.dispose();
            this.supportsWeakReference = null;
        }
        if (this.contextMenuListener != null) {
            this.contextMenuListener.dispose();
            this.contextMenuListener = null;
        }
    }

    public boolean forward() {
        this.checkWidget();
        int[] result = new int[1];
        int rc = this.webBrowser.QueryInterface(nsIWebNavigation.NS_IWEBNAVIGATION_IID, result);
        if (rc != 0) {
            throw new SWTError(XPCOM.errorMsg((int)rc));
        }
        if (result[0] == 0) {
            throw new SWTError(XPCOM.errorMsg((int)-2147467262));
        }
        nsIWebNavigation webNavigation = new nsIWebNavigation(result[0]);
        webNavigation.GoForward();
        webNavigation.Release();
        return rc == 0;
    }

    public String getUrl() {
        this.checkWidget();
        int[] aContentDOMWindow = new int[1];
        int rc = this.webBrowser.GetContentDOMWindow(aContentDOMWindow);
        if (rc != 0) {
            throw new SWTError(XPCOM.errorMsg((int)rc));
        }
        if (aContentDOMWindow[0] == 0) {
            throw new SWTError(XPCOM.errorMsg((int)-2147467262));
        }
        nsIDOMWindow domWindow = new nsIDOMWindow(aContentDOMWindow[0]);
        int[] result = new int[1];
        rc = domWindow.QueryInterface(nsIDOMWindowInternal.NS_IDOMWINDOWINTERNAL_IID, result);
        if (rc != 0) {
            throw new SWTError(XPCOM.errorMsg((int)rc));
        }
        if (result[0] == 0) {
            throw new SWTError(XPCOM.errorMsg((int)-2147467262));
        }
        domWindow.Release();
        nsIDOMWindowInternal domWindowInternal = new nsIDOMWindowInternal(result[0]);
        int[] aLocation = new int[1];
        rc = domWindowInternal.GetLocation(aLocation);
        if (rc != 0) {
            throw new SWTError(XPCOM.errorMsg((int)rc));
        }
        if (aLocation[0] == 0) {
            throw new SWTError(XPCOM.errorMsg((int)-2147467262));
        }
        domWindowInternal.Release();
        nsIDOMLocation domLocation = new nsIDOMLocation(aLocation[0]);
        nsString _retval = new nsString();
        rc = domLocation.ToString(_retval.getAddress());
        if (rc != 0) {
            throw new SWTError(XPCOM.errorMsg((int)rc));
        }
        domLocation.Release();
        String url = _retval.toString();
        _retval.dispose();
        return url;
    }

    void onDispose() {
        int[] result = new int[1];
        int rc = this.webBrowser.QueryInterface(nsIBaseWindow.NS_IBASEWINDOW_IID, result);
        if (rc != 0) {
            throw new SWTError(XPCOM.errorMsg((int)rc));
        }
        if (result[0] == 0) {
            throw new SWTError(XPCOM.errorMsg((int)-2147467262));
        }
        nsIBaseWindow baseWindow = new nsIBaseWindow(result[0]);
        rc = baseWindow.Destroy();
        if (rc != 0) {
            throw new SWTError(XPCOM.errorMsg((int)rc));
        }
        baseWindow.Release();
        this.Release();
        this.webBrowser.Release();
        if (--browserCount == 0) {
            if (appShell != null) {
                rc = appShell.Spindown();
                if (rc != 0) {
                    throw new SWTError(XPCOM.errorMsg((int)rc));
                }
                appShell.Release();
                appShell = null;
            }
            locProvider.Release();
            locProvider = null;
            XPCOM.NS_TermEmbedding();
        }
    }

    void onFocusGained(Event e) {
        int[] result = new int[1];
        int rc = this.webBrowser.QueryInterface(nsIWebBrowserFocus.NS_IWEBBROWSERFOCUS_IID, result);
        if (rc != 0) {
            throw new SWTError(XPCOM.errorMsg((int)rc));
        }
        if (result[0] == 0) {
            throw new SWTError(XPCOM.errorMsg((int)-2147467262));
        }
        nsIWebBrowserFocus webBrowserFocus = new nsIWebBrowserFocus(result[0]);
        rc = webBrowserFocus.Activate();
        if (rc != 0) {
            throw new SWTError(XPCOM.errorMsg((int)rc));
        }
        webBrowserFocus.Release();
    }

    void onFocusLost(Event e) {
        int[] result = new int[1];
        int rc = this.webBrowser.QueryInterface(nsIWebBrowserFocus.NS_IWEBBROWSERFOCUS_IID, result);
        if (rc != 0) {
            throw new SWTError(XPCOM.errorMsg((int)rc));
        }
        if (result[0] == 0) {
            throw new SWTError(XPCOM.errorMsg((int)-2147467262));
        }
        nsIWebBrowserFocus webBrowserFocus = new nsIWebBrowserFocus(result[0]);
        rc = webBrowserFocus.Deactivate();
        if (rc != 0) {
            throw new SWTError(XPCOM.errorMsg((int)rc));
        }
        webBrowserFocus.Release();
    }

    void onResize() {
        Rectangle rect = this.getClientArea();
        int[] result = new int[1];
        int rc = this.webBrowser.QueryInterface(nsIBaseWindow.NS_IBASEWINDOW_IID, result);
        if (rc != 0) {
            throw new SWTError(XPCOM.errorMsg((int)rc));
        }
        if (result[0] == 0) {
            throw new SWTError(XPCOM.errorMsg((int)-2147467262));
        }
        nsIBaseWindow baseWindow = new nsIBaseWindow(result[0]);
        rc = baseWindow.SetPositionAndSize(rect.x, rect.y, rect.width, rect.height, true);
        if (rc != 0) {
            throw new SWTError(XPCOM.errorMsg((int)rc));
        }
        baseWindow.Release();
    }

    public void refresh() {
        this.checkWidget();
        int[] result = new int[1];
        int rc = this.webBrowser.QueryInterface(nsIWebNavigation.NS_IWEBNAVIGATION_IID, result);
        if (rc != 0) {
            throw new SWTError(XPCOM.errorMsg((int)rc));
        }
        if (result[0] == 0) {
            throw new SWTError(XPCOM.errorMsg((int)-2147467262));
        }
        nsIWebNavigation webNavigation = new nsIWebNavigation(result[0]);
        rc = webNavigation.Reload(0);
        if (rc != 0) {
            throw new SWTError(XPCOM.errorMsg((int)rc));
        }
        webNavigation.Release();
    }

    public void removeLocationListener(LocationListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.locationListeners.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.locationListeners.length) {
            if (listener == this.locationListeners[i]) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return;
        }
        if (this.locationListeners.length == 1) {
            this.locationListeners = new LocationListener[0];
            return;
        }
        LocationListener[] newLocationListeners = new LocationListener[this.locationListeners.length - 1];
        System.arraycopy(this.locationListeners, 0, newLocationListeners, 0, index);
        System.arraycopy(this.locationListeners, index + 1, newLocationListeners, index, this.locationListeners.length - index - 1);
        this.locationListeners = newLocationListeners;
    }

    public void removeProgressListener(ProgressListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.progressListeners.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.progressListeners.length) {
            if (listener == this.progressListeners[i]) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return;
        }
        if (this.progressListeners.length == 1) {
            this.progressListeners = new ProgressListener[0];
            return;
        }
        ProgressListener[] newProgressListeners = new ProgressListener[this.progressListeners.length - 1];
        System.arraycopy(this.progressListeners, 0, newProgressListeners, 0, index);
        System.arraycopy(this.progressListeners, index + 1, newProgressListeners, index, this.progressListeners.length - index - 1);
        this.progressListeners = newProgressListeners;
    }

    public void removeStatusTextListener(StatusTextListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.statusTextListeners.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.statusTextListeners.length) {
            if (listener == this.statusTextListeners[i]) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return;
        }
        if (this.statusTextListeners.length == 1) {
            this.statusTextListeners = new StatusTextListener[0];
            return;
        }
        StatusTextListener[] newStatusTextListeners = new StatusTextListener[this.statusTextListeners.length - 1];
        System.arraycopy(this.statusTextListeners, 0, newStatusTextListeners, 0, index);
        System.arraycopy(this.statusTextListeners, index + 1, newStatusTextListeners, index, this.statusTextListeners.length - index - 1);
        this.statusTextListeners = newStatusTextListeners;
    }

    public boolean setUrl(String url) {
        this.checkWidget();
        int[] result = new int[1];
        int rc = this.webBrowser.QueryInterface(nsIWebNavigation.NS_IWEBNAVIGATION_IID, result);
        if (rc != 0) {
            throw new SWTError(XPCOM.errorMsg((int)rc));
        }
        if (result[0] == 0) {
            throw new SWTError(XPCOM.errorMsg((int)-2147467262));
        }
        nsIWebNavigation webNavigation = new nsIWebNavigation(result[0]);
        char[] arg = url.toCharArray();
        char[] c = new char[arg.length + 1];
        System.arraycopy(arg, 0, c, 0, arg.length);
        rc = webNavigation.LoadURI(c, 0, 0, 0, 0);
        if (rc != 0) {
            throw new SWTError(XPCOM.errorMsg((int)rc));
        }
        this.onFocusGained(null);
        webNavigation.Release();
        return true;
    }

    public void stop() {
        this.checkWidget();
        int[] result = new int[1];
        int rc = this.webBrowser.QueryInterface(nsIWebNavigation.NS_IWEBNAVIGATION_IID, result);
        if (rc != 0) {
            throw new SWTError(XPCOM.errorMsg((int)rc));
        }
        if (result[0] == 0) {
            throw new SWTError(XPCOM.errorMsg((int)-2147467262));
        }
        nsIWebNavigation webNavigation = new nsIWebNavigation(result[0]);
        rc = webNavigation.Stop(3);
        if (rc != 0) {
            throw new SWTError(XPCOM.errorMsg((int)rc));
        }
        webNavigation.Release();
    }

    int QueryInterface(int riid, int ppvObject) {
        if (riid == 0 || ppvObject == 0) {
            return -2147467262;
        }
        nsID guid = new nsID();
        XPCOM.memmove((nsID)guid, (int)riid, (int)16);
        if (guid.Equals(nsISupports.NS_ISUPPORTS_IID)) {
            XPCOM.memmove((int)ppvObject, (int[])new int[]{this.supports.getAddress()}, (int)4);
            this.AddRef();
            return 0;
        }
        if (guid.Equals(nsIWeakReference.NS_IWEAKREFERENCE_IID)) {
            XPCOM.memmove((int)ppvObject, (int[])new int[]{this.weakReference.getAddress()}, (int)4);
            this.AddRef();
            return 0;
        }
        if (guid.Equals(nsIWebProgressListener.NS_IWEBPROGRESSLISTENER_IID)) {
            XPCOM.memmove((int)ppvObject, (int[])new int[]{this.webProgressListener.getAddress()}, (int)4);
            this.AddRef();
            return 0;
        }
        if (guid.Equals(nsIWebBrowserChrome.NS_IWEBBROWSERCHROME_IID)) {
            XPCOM.memmove((int)ppvObject, (int[])new int[]{this.webBrowserChrome.getAddress()}, (int)4);
            this.AddRef();
            return 0;
        }
        if (guid.Equals(nsIWebBrowserChromeFocus.NS_IWEBBROWSERCHROMEFOCUS_IID)) {
            XPCOM.memmove((int)ppvObject, (int[])new int[]{this.webBrowserChromeFocus.getAddress()}, (int)4);
            this.AddRef();
            return 0;
        }
        if (guid.Equals(nsIEmbeddingSiteWindow.NS_IEMBEDDINGSITEWINDOW_IID)) {
            XPCOM.memmove((int)ppvObject, (int[])new int[]{this.embeddingSiteWindow.getAddress()}, (int)4);
            this.AddRef();
            return 0;
        }
        if (guid.Equals(nsIInterfaceRequestor.NS_IINTERFACEREQUESTOR_IID)) {
            XPCOM.memmove((int)ppvObject, (int[])new int[]{this.interfaceRequestor.getAddress()}, (int)4);
            this.AddRef();
            return 0;
        }
        if (guid.Equals(nsISupportsWeakReference.NS_ISUPPORTSWEAKREFERENCE_IID)) {
            XPCOM.memmove((int)ppvObject, (int[])new int[]{this.supportsWeakReference.getAddress()}, (int)4);
            this.AddRef();
            return 0;
        }
        if (guid.Equals(nsIContextMenuListener.NS_ICONTEXTMENULISTENER_IID)) {
            XPCOM.memmove((int)ppvObject, (int[])new int[]{this.contextMenuListener.getAddress()}, (int)4);
            this.AddRef();
            return 0;
        }
        XPCOM.memmove((int)ppvObject, (int[])new int[1], (int)4);
        return -2147467262;
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    int QueryReferent(int riid, int ppvObject) {
        return this.QueryInterface(riid, ppvObject);
    }

    int GetInterface(int riid, int ppvObject) {
        return this.QueryInterface(riid, ppvObject);
    }

    int GetWeakReference(int ppvObject) {
        XPCOM.memmove((int)ppvObject, (int[])new int[]{this.weakReference.getAddress()}, (int)4);
        this.AddRef();
        return 0;
    }

    int OnStateChange(int aWebProgress, int aRequest, int aStateFlags, int aStatus) {
        if ((aStateFlags & 0x10) != 0 && (aStateFlags & 0x20000) != 0) {
            ProgressEvent event = new ProgressEvent(this);
            int i = 0;
            while (i < this.progressListeners.length) {
                this.progressListeners[i].completed(event);
                ++i;
            }
            StatusTextEvent event2 = new StatusTextEvent(this);
            event2.text = "";
            int i2 = 0;
            while (i2 < this.statusTextListeners.length) {
                this.statusTextListeners[i2].changed(event2);
                ++i2;
            }
        }
        return 0;
    }

    int OnProgressChange(int aWebProgress, int aRequest, int aCurSelfProgress, int aMaxSelfProgress, int aCurTotalProgress, int aMaxTotalProgress) {
        if (this.progressListeners.length == 0) {
            return 0;
        }
        int total = aMaxTotalProgress;
        if (total <= 0) {
            total = Integer.MAX_VALUE;
        }
        ProgressEvent event = new ProgressEvent(this);
        event.current = aCurTotalProgress;
        event.total = aMaxTotalProgress;
        int i = 0;
        while (i < this.progressListeners.length) {
            this.progressListeners[i].changed(event);
            ++i;
        }
        return 0;
    }

    int OnLocationChange(int aWebProgress, int aRequest, int aLocation) {
        if (this.locationListeners.length == 0) {
            return 0;
        }
        nsIURI location = new nsIURI(aLocation);
        int aSpec = XPCOM.nsCString_new();
        location.GetSpec(aSpec);
        int length = XPCOM.nsCString_Length((int)aSpec);
        int buffer = XPCOM.nsCString_get((int)aSpec);
        buffer = XPCOM.nsCString_get((int)aSpec);
        byte[] dest = new byte[length];
        XPCOM.memmove((byte[])dest, (int)buffer, (int)length);
        XPCOM.nsCString_delete((int)aSpec);
        LocationEvent event = new LocationEvent(this);
        event.location = new String(dest);
        int i = 0;
        while (i < this.locationListeners.length) {
            this.locationListeners[i].changed(event);
            ++i;
        }
        return 0;
    }

    int OnStatusChange(int aWebProgress, int aRequest, int aStatus, int aMessage) {
        if (this.statusTextListeners.length == 0) {
            return 0;
        }
        StatusTextEvent event = new StatusTextEvent(this);
        int length = XPCOM.nsCRT_strlen_PRUnichar((int)aMessage);
        char[] dest = new char[length];
        XPCOM.memmove((char[])dest, (int)aMessage, (int)(length * 2));
        event.text = new String(dest);
        int i = 0;
        while (i < this.statusTextListeners.length) {
            this.statusTextListeners[i].changed(event);
            ++i;
        }
        return 0;
    }

    int OnSecurityChange(int aWebProgress, int aRequest, int state) {
        return 0;
    }

    int SetStatus(int statusType, int status) {
        StatusTextEvent event = new StatusTextEvent(this);
        int length = XPCOM.nsCRT_strlen_PRUnichar((int)status);
        char[] dest = new char[length];
        XPCOM.memmove((char[])dest, (int)status, (int)(length * 2));
        String string = new String(dest);
        if (string == null) {
            string = "";
        }
        event.text = string;
        int i = 0;
        while (i < this.statusTextListeners.length) {
            this.statusTextListeners[i].changed(event);
            ++i;
        }
        return 0;
    }

    int GetWebBrowser(int aWebBrowser) {
        int[] ret = new int[1];
        if (this.webBrowser != null) {
            this.webBrowser.AddRef();
            ret[0] = this.webBrowser.getAddress();
        }
        XPCOM.memmove((int)aWebBrowser, (int[])ret, (int)4);
        return 0;
    }

    int SetWebBrowser(int aWebBrowser) {
        if (this.webBrowser != null) {
            this.webBrowser.Release();
        }
        this.webBrowser = aWebBrowser != 0 ? new nsIWebBrowser(aWebBrowser) : null;
        return 0;
    }

    int GetChromeFlags(int aChromeFlags) {
        int[] ret = new int[]{this.chromeFlags};
        XPCOM.memmove((int)aChromeFlags, (int[])ret, (int)4);
        return 0;
    }

    int SetChromeFlags(int aChromeFlags) {
        this.chromeFlags = aChromeFlags;
        return 0;
    }

    int DestroyBrowserWindow() {
        return 0;
    }

    int SizeBrowserTo(int aCX, int aCY) {
        return 0;
    }

    int ShowAsModal() {
        return -2147467263;
    }

    int IsWindowModal(int retval) {
        XPCOM.memmove((int)retval, (int[])new int[1], (int)4);
        return 0;
    }

    int ExitModalEventLoop(int aStatus) {
        return 0;
    }

    int SetDimensions(int flags, int x, int y, int cx, int cy) {
        return 0;
    }

    int GetDimensions(int flags, int x, int y, int cx, int cy) {
        return 0;
    }

    int SetFocus() {
        return 0;
    }

    int GetVisibility(int value) {
        return 0;
    }

    int SetVisibility(int value) {
        return 0;
    }

    int GetTitle(int value) {
        return 0;
    }

    int SetTitle(int value) {
        return 0;
    }

    int GetSiteWindow(int siteWindow) {
        return 0;
    }

    int FocusNextElement() {
        this.traverse(16);
        return 0;
    }

    int FocusPrevElement() {
        this.traverse(8);
        return 0;
    }

    int OnShowContextMenu(int aContextFlags, int aEvent, int aNode) {
        return 0;
    }
}

