/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEvent;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkEventCrossing;
import org.eclipse.swt.internal.gtk.GdkEventExpose;
import org.eclipse.swt.internal.gtk.GdkEventFocus;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.GtkStyle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public abstract class Control
extends Widget
implements Drawable {
    int fixedHandle;
    int drawCount;
    Composite parent;
    Cursor cursor;
    Menu menu;
    Font font;
    String toolTipText;
    Object layoutData;
    Accessible accessible;

    Control() {
    }

    public Control(Composite parent, int style) {
        super(parent, style);
        this.parent = parent;
        this.createWidget(0);
    }

    GdkColor defaultBackground() {
        return this.display.COLOR_WIDGET_BACKGROUND;
    }

    int defaultFont() {
        return this.display.defaultFont;
    }

    GdkColor defaultForeground() {
        return this.display.COLOR_WIDGET_FOREGROUND;
    }

    void deregister() {
        int imHandle;
        super.deregister();
        if (this.fixedHandle != 0) {
            this.display.removeWidget(this.fixedHandle);
        }
        if ((imHandle = this.imHandle()) != 0) {
            this.display.removeWidget(imHandle);
        }
    }

    void enableWidget(boolean enabled) {
        int topHandle = this.topHandle();
        OS.gtk_widget_set_sensitive((int)topHandle, (boolean)enabled);
    }

    int eventHandle() {
        return this.handle;
    }

    void fixFocus() {
        Shell shell = this.getShell();
        Control control = this;
        while ((control = control.parent) != null) {
            if (!control.setFocus() && control != shell) continue;
            return;
        }
    }

    int focusHandle() {
        return this.handle;
    }

    int fontHandle() {
        return this.handle;
    }

    boolean hasFocus() {
        return OS.GTK_WIDGET_HAS_FOCUS((int)this.handle);
    }

    void hookEvents() {
        int eventHandle = this.eventHandle();
        int mask = 32518;
        OS.gtk_widget_add_events((int)eventHandle, (int)mask);
        int windowProc2 = this.display.windowProc2;
        int windowProc3 = this.display.windowProc3;
        OS.g_signal_connect((int)eventHandle, (byte[])OS.popup_menu, (int)windowProc2, (int)25);
        OS.g_signal_connect_after((int)this.handle, (byte[])OS.realize, (int)windowProc2, (int)40);
        OS.g_signal_connect((int)eventHandle, (byte[])OS.show_help, (int)windowProc3, (int)33);
        OS.g_signal_connect((int)eventHandle, (byte[])OS.button_press_event, (int)windowProc3, (int)2);
        OS.g_signal_connect((int)eventHandle, (byte[])OS.button_release_event, (int)windowProc3, (int)3);
        OS.g_signal_connect((int)eventHandle, (byte[])OS.motion_notify_event, (int)windowProc3, (int)24);
        OS.g_signal_connect((int)eventHandle, (byte[])OS.key_press_event, (int)windowProc3, (int)19);
        OS.g_signal_connect((int)eventHandle, (byte[])OS.key_release_event, (int)windowProc3, (int)20);
        OS.g_signal_connect((int)eventHandle, (byte[])OS.focus, (int)windowProc3, (int)40);
        OS.g_signal_connect((int)eventHandle, (byte[])OS.focus_in_event, (int)windowProc3, (int)15);
        OS.g_signal_connect((int)eventHandle, (byte[])OS.focus_out_event, (int)windowProc3, (int)16);
        OS.g_signal_connect((int)eventHandle, (byte[])OS.event_after, (int)windowProc3, (int)13);
        OS.g_signal_connect((int)eventHandle, (byte[])OS.enter_notify_event, (int)windowProc3, (int)11);
        OS.g_signal_connect((int)eventHandle, (byte[])OS.leave_notify_event, (int)windowProc3, (int)21);
        OS.g_signal_connect_after((int)eventHandle, (byte[])OS.expose_event, (int)windowProc3, (int)14);
        int imHandle = this.imHandle();
        if (imHandle != 0) {
            OS.g_signal_connect((int)this.handle, (byte[])OS.unrealize, (int)windowProc2, (int)38);
            OS.g_signal_connect((int)imHandle, (byte[])OS.commit, (int)windowProc3, (int)6);
            OS.g_signal_connect((int)imHandle, (byte[])OS.preedit_changed, (int)windowProc2, (int)26);
        }
        OS.g_signal_connect_after((int)eventHandle, (byte[])OS.button_press_event, (int)windowProc3, (int)-2);
        OS.g_signal_connect_after((int)eventHandle, (byte[])OS.button_release_event, (int)windowProc3, (int)-3);
        OS.g_signal_connect_after((int)eventHandle, (byte[])OS.motion_notify_event, (int)windowProc3, (int)-24);
    }

    int hoverProc(int widget) {
        Event event = new Event();
        int[] x = new int[1];
        int[] y = new int[1];
        int[] mask = new int[1];
        OS.gdk_window_get_pointer((int)0, (int[])x, (int[])y, (int[])mask);
        event.x = x[0];
        event.y = y[0];
        int eventHandle = this.eventHandle();
        int window = OS.GTK_WIDGET_WINDOW((int)eventHandle);
        OS.gdk_window_get_origin((int)window, (int[])x, (int[])y);
        event.x -= x[0];
        event.y -= y[0];
        this.setInputState(event, mask[0]);
        this.postEvent(32, event);
        return 0;
    }

    int topHandle() {
        if (this.fixedHandle != 0) {
            return this.fixedHandle;
        }
        return super.topHandle();
    }

    int paintHandle() {
        return this.handle;
    }

    int paintWindow() {
        int paintHandle = this.paintHandle();
        OS.gtk_widget_realize((int)paintHandle);
        return OS.GTK_WIDGET_WINDOW((int)paintHandle);
    }

    public Point computeSize(int wHint, int hHint) {
        return this.computeSize(wHint, hHint, true);
    }

    Control computeTabGroup() {
        if (this.isTabGroup()) {
            return this;
        }
        return this.parent.computeTabGroup();
    }

    Control[] computeTabList() {
        if (this.isTabGroup() && this.getVisible() && this.getEnabled()) {
            return new Control[]{this};
        }
        return new Control[0];
    }

    Control computeTabRoot() {
        Control[] tabList = this.parent._getTabList();
        if (tabList != null) {
            int index = 0;
            while (index < tabList.length) {
                if (tabList[index] == this) break;
                ++index;
            }
            if (index == tabList.length && this.isTabGroup()) {
                return this;
            }
        }
        return this.parent.computeTabRoot();
    }

    void createWidget(int index) {
        this.checkOrientation(this.parent);
        super.createWidget(index);
        this.setInitialSize();
        this.setZOrder(null, false);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        return this.computeNativeSize(this.handle, wHint, hHint, changed);
    }

    Point computeNativeSize(int h, int wHint, int hHint, boolean changed) {
        int width = OS.GTK_WIDGET_WIDTH((int)h);
        int height = OS.GTK_WIDGET_HEIGHT((int)h);
        OS.gtk_widget_set_size_request((int)h, (int)-1, (int)-1);
        GtkRequisition requisition = new GtkRequisition();
        OS.gtk_widget_size_request((int)h, (GtkRequisition)requisition);
        OS.gtk_widget_set_size_request((int)h, (int)width, (int)height);
        width = wHint == -1 ? requisition.width : wHint;
        height = hHint == -1 ? requisition.height : hHint;
        return new Point(width, height);
    }

    public Accessible getAccessible() {
        this.checkWidget();
        if (this.accessible == null) {
            this.accessible = Accessible.internal_new_Accessible(this);
        }
        return this.accessible;
    }

    public Rectangle getBounds() {
        this.checkWidget();
        int topHandle = this.topHandle();
        int x = OS.GTK_WIDGET_X((int)topHandle);
        int y = OS.GTK_WIDGET_Y((int)topHandle);
        int width = OS.GTK_WIDGET_WIDTH((int)topHandle);
        int height = OS.GTK_WIDGET_HEIGHT((int)topHandle);
        return new Rectangle(x, y, width, height);
    }

    public void setBounds(Rectangle rect) {
        this.checkWidget();
        if (rect == null) {
            this.error(4);
        }
        this.setBounds(rect.x, rect.y, rect.width, rect.height);
    }

    public void setBounds(int x, int y, int width, int height) {
        this.checkWidget();
        this.setBounds(x, y, width, height, true, true);
    }

    void moveHandle(int x, int y) {
        int topHandle = this.topHandle();
        int parentHandle = this.parent.parentingHandle();
        OS.gtk_fixed_move((int)parentHandle, (int)topHandle, (int)x, (int)y);
    }

    void resizeHandle(int width, int height) {
        int topHandle = this.topHandle();
        OS.gtk_widget_set_size_request((int)topHandle, (int)width, (int)height);
        if (topHandle != this.handle) {
            OS.gtk_widget_set_size_request((int)this.handle, (int)width, (int)height);
        }
        GtkRequisition requisition = new GtkRequisition();
        OS.gtk_widget_size_request((int)this.handle, (GtkRequisition)requisition);
    }

    boolean setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        int topHandle = this.topHandle();
        int flags = OS.GTK_WIDGET_FLAGS((int)topHandle);
        OS.GTK_WIDGET_SET_FLAGS((int)topHandle, (int)256);
        boolean sameOrigin = true;
        boolean sameExtent = true;
        if (move) {
            int oldX = OS.GTK_WIDGET_X((int)topHandle);
            int oldY = OS.GTK_WIDGET_Y((int)topHandle);
            boolean bl = sameOrigin = x == oldX && y == oldY;
            if (!sameOrigin) {
                this.moveHandle(x, y);
            }
        }
        if (resize) {
            width = Math.max(1, width);
            height = Math.max(1, height);
            int oldWidth = OS.GTK_WIDGET_WIDTH((int)topHandle);
            int oldHeight = OS.GTK_WIDGET_HEIGHT((int)topHandle);
            boolean bl = sameExtent = width == oldWidth && height == oldHeight;
            if (!sameExtent) {
                this.resizeHandle(width, height);
            }
        }
        if (!sameOrigin || !sameExtent) {
            int parentHandle = this.parent.parentingHandle();
            OS.gtk_container_resize_children((int)parentHandle);
        }
        if ((flags & 0x100) == 0) {
            OS.GTK_WIDGET_UNSET_FLAGS((int)topHandle, (int)256);
        }
        if (!sameOrigin) {
            this.sendEvent(10);
        }
        if (!sameExtent) {
            this.sendEvent(11);
        }
        return !sameOrigin || !sameExtent;
    }

    public Point getLocation() {
        this.checkWidget();
        int topHandle = this.topHandle();
        int x = OS.GTK_WIDGET_X((int)topHandle);
        int y = OS.GTK_WIDGET_Y((int)topHandle);
        return new Point(x, y);
    }

    public void setLocation(Point location) {
        this.checkWidget();
        if (location == null) {
            this.error(4);
        }
        this.setLocation(location.x, location.y);
    }

    public void setLocation(int x, int y) {
        this.checkWidget();
        this.setBounds(x, y, 0, 0, true, false);
    }

    public Point getSize() {
        this.checkWidget();
        int topHandle = this.topHandle();
        int width = OS.GTK_WIDGET_WIDTH((int)topHandle);
        int height = OS.GTK_WIDGET_HEIGHT((int)topHandle);
        return new Point(width, height);
    }

    public void setSize(Point size) {
        this.checkWidget();
        if (size == null) {
            this.error(4);
        }
        this.setSize(size.x, size.y);
    }

    public void setSize(int width, int height) {
        this.checkWidget();
        this.setBounds(0, 0, width, height, false, true);
    }

    public void moveAbove(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (this.parent != control.parent) {
                return;
            }
        }
        this.setZOrder(control, true);
    }

    public void moveBelow(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (this.parent != control.parent) {
                return;
            }
        }
        this.setZOrder(control, false);
    }

    public void pack() {
        this.pack(true);
    }

    public void pack(boolean changed) {
        this.setSize(this.computeSize(-1, -1, changed));
    }

    public void setLayoutData(Object layoutData) {
        this.checkWidget();
        this.layoutData = layoutData;
    }

    public Point toControl(int x, int y) {
        this.checkWidget();
        int eventHandle = this.eventHandle();
        OS.gtk_widget_realize((int)eventHandle);
        int window = OS.GTK_WIDGET_WINDOW((int)eventHandle);
        int[] origin_x = new int[1];
        int[] origin_y = new int[1];
        OS.gdk_window_get_origin((int)window, (int[])origin_x, (int[])origin_y);
        return new Point(x - origin_x[0], y - origin_y[0]);
    }

    public Point toControl(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.toControl(point.x, point.y);
    }

    public Point toDisplay(int x, int y) {
        this.checkWidget();
        int eventHandle = this.eventHandle();
        OS.gtk_widget_realize((int)eventHandle);
        int window = OS.GTK_WIDGET_WINDOW((int)eventHandle);
        int[] origin_x = new int[1];
        int[] origin_y = new int[1];
        OS.gdk_window_get_origin((int)window, (int[])origin_x, (int[])origin_y);
        return new Point(origin_x[0] + x, origin_y[0] + y);
    }

    public Point toDisplay(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.toDisplay(point.x, point.y);
    }

    public void addControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addFocusListener(FocusListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(15, typedListener);
        this.addListener(16, typedListener);
    }

    public void addHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(28, typedListener);
    }

    public void addKeyListener(KeyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(2, typedListener);
        this.addListener(1, typedListener);
    }

    public void addMouseListener(MouseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(3, typedListener);
        this.addListener(4, typedListener);
        this.addListener(8, typedListener);
    }

    public void addMouseMoveListener(MouseMoveListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(5, typedListener);
    }

    public void addMouseTrackListener(MouseTrackListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(6, typedListener);
        this.addListener(7, typedListener);
        this.addListener(32, typedListener);
    }

    public void addPaintListener(PaintListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(9, typedListener);
    }

    public void addTraverseListener(TraverseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(31, typedListener);
    }

    public void removeControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, listener);
        this.eventTable.unhook(11, listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(15, listener);
        this.eventTable.unhook(16, listener);
    }

    public void removeHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, listener);
    }

    public void removeKeyListener(KeyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(2, listener);
        this.eventTable.unhook(1, listener);
    }

    public void removeMouseListener(MouseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(3, listener);
        this.eventTable.unhook(4, listener);
        this.eventTable.unhook(8, listener);
    }

    public void removeMouseMoveListener(MouseMoveListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(5, listener);
    }

    public void removeMouseTrackListener(MouseTrackListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(6, listener);
        this.eventTable.unhook(7, listener);
        this.eventTable.unhook(32, listener);
    }

    public void removePaintListener(PaintListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(9, listener);
    }

    public void removeTraverseListener(TraverseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(31, listener);
    }

    Menu[] findMenus(Control control) {
        if (this.menu != null && this != control) {
            return new Menu[]{this.menu};
        }
        return new Menu[0];
    }

    void fixChildren(Shell newShell, Shell oldShell, Decorations newDecorations, Decorations oldDecorations, Menu[] menus) {
        oldShell.fixShell(newShell, this);
        oldDecorations.fixDecorations(newDecorations, this, menus);
    }

    public boolean forceFocus() {
        this.checkWidget();
        Shell shell = this.getShell();
        shell.setSavedFocus(this);
        if (!this.isEnabled() || !this.isVisible()) {
            return false;
        }
        shell.bringToTop(false);
        int focusHandle = this.focusHandle();
        OS.gtk_widget_grab_focus((int)focusHandle);
        return OS.gtk_widget_is_focus((int)focusHandle);
    }

    public Color getBackground() {
        this.checkWidget();
        return Color.gtk_new(this.display, this.getBackgroundColor());
    }

    GdkColor getBackgroundColor() {
        return this.getBgColor();
    }

    GdkColor getBgColor() {
        int fontHandle = this.fontHandle();
        GtkStyle style = new GtkStyle();
        OS.memmove((GtkStyle)style, (int)OS.gtk_widget_get_style((int)fontHandle));
        GdkColor color = new GdkColor();
        color.pixel = style.bg0_pixel;
        color.red = style.bg0_red;
        color.green = style.bg0_green;
        color.blue = style.bg0_blue;
        return color;
    }

    GdkColor getBaseColor() {
        int fontHandle = this.fontHandle();
        GtkStyle style = new GtkStyle();
        OS.memmove((GtkStyle)style, (int)OS.gtk_widget_get_style((int)fontHandle));
        GdkColor color = new GdkColor();
        color.pixel = style.base0_pixel;
        color.red = style.base0_red;
        color.green = style.base0_green;
        color.blue = style.base0_blue;
        return color;
    }

    public int getBorderWidth() {
        this.checkWidget();
        return 0;
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 0x40) == 0;
    }

    public Font getFont() {
        this.checkWidget();
        if (this.font != null) {
            return this.font;
        }
        return Font.gtk_new(this.display, this.defaultFont());
    }

    int getFontDescription() {
        int fontHandle = this.fontHandle();
        GtkStyle style = new GtkStyle();
        OS.memmove((GtkStyle)style, (int)OS.gtk_widget_get_style((int)fontHandle));
        return style.font_desc;
    }

    public Color getForeground() {
        this.checkWidget();
        return Color.gtk_new(this.display, this.getForegroundColor());
    }

    GdkColor getForegroundColor() {
        return this.getFgColor();
    }

    GdkColor getFgColor() {
        int fontHandle = this.fontHandle();
        GtkStyle style = new GtkStyle();
        OS.memmove((GtkStyle)style, (int)OS.gtk_widget_get_style((int)fontHandle));
        GdkColor color = new GdkColor();
        color.pixel = style.fg0_pixel;
        color.red = style.fg0_red;
        color.green = style.fg0_green;
        color.blue = style.fg0_blue;
        return color;
    }

    Point getIMCaretPos() {
        return new Point(0, 0);
    }

    GdkColor getTextColor() {
        int fontHandle = this.fontHandle();
        GtkStyle style = new GtkStyle();
        OS.memmove((GtkStyle)style, (int)OS.gtk_widget_get_style((int)fontHandle));
        GdkColor color = new GdkColor();
        color.pixel = style.text0_pixel;
        color.red = style.text0_red;
        color.green = style.text0_green;
        color.blue = style.text0_blue;
        return color;
    }

    public Object getLayoutData() {
        this.checkWidget();
        return this.layoutData;
    }

    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    public Monitor getMonitor() {
        this.checkWidget();
        Monitor monitor = null;
        int screen = OS.gdk_screen_get_default();
        if (screen != 0) {
            int monitorNumber = OS.gdk_screen_get_monitor_at_window((int)screen, (int)this.paintWindow());
            GdkRectangle dest = new GdkRectangle();
            OS.gdk_screen_get_monitor_geometry((int)screen, (int)monitorNumber, (GdkRectangle)dest);
            monitor = new Monitor();
            monitor.handle = monitorNumber;
            monitor.x = dest.x;
            monitor.y = dest.y;
            monitor.width = dest.width;
            monitor.height = dest.height;
            monitor.clientX = monitor.x;
            monitor.clientY = monitor.y;
            monitor.clientWidth = monitor.width;
            monitor.clientHeight = monitor.height;
        } else {
            monitor = this.display.getPrimaryMonitor();
        }
        return monitor;
    }

    public Composite getParent() {
        this.checkWidget();
        return this.parent;
    }

    Control[] getPath() {
        int count = 0;
        Shell shell = this.getShell();
        Control control = this;
        while (control != shell) {
            ++count;
            control = control.parent;
        }
        control = this;
        Control[] result = new Control[count];
        while (control != shell) {
            result[--count] = control;
            control = control.parent;
        }
        return result;
    }

    public Shell getShell() {
        this.checkWidget();
        return this._getShell();
    }

    Shell _getShell() {
        return this.parent._getShell();
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public boolean getVisible() {
        this.checkWidget();
        return OS.GTK_WIDGET_VISIBLE((int)this.topHandle());
    }

    int gtk_button_press_event(int widget, int event) {
        Shell shell = this._getShell();
        GdkEventButton gdkEvent = new GdkEventButton();
        OS.memmove((GdkEventButton)gdkEvent, (int)event, (int)64);
        this.display.dragStartX = (int)gdkEvent.x;
        this.display.dragStartY = (int)gdkEvent.y;
        this.display.dragging = false;
        int button = gdkEvent.button;
        int type = gdkEvent.type != 5 ? 3 : 8;
        this.sendMouseEvent(type, button, event);
        int result = 0;
        if ((this.state & 0x10000) != 0 && gdkEvent.button == 3 && gdkEvent.type == 4 && this.showMenu((int)gdkEvent.x_root, (int)gdkEvent.y_root)) {
            result = 1;
        }
        if (!shell.isDisposed()) {
            shell.setActiveControl(this);
        }
        return result;
    }

    int gtk_button_release_event(int widget, int event) {
        GdkEventButton gdkEvent = new GdkEventButton();
        OS.memmove((GdkEventButton)gdkEvent, (int)event, (int)64);
        this.sendMouseEvent(4, gdkEvent.button, event);
        return 0;
    }

    int gtk_commit(int imcontext, int text) {
        if (text == 0) {
            return 0;
        }
        int length = OS.strlen((int)text);
        if (length == 0) {
            return 0;
        }
        byte[] buffer = new byte[length];
        OS.memmove((byte[])buffer, (int)text, (int)length);
        char[] chars = Converter.mbcsToWcs(null, buffer);
        this.sendIMKeyEvent(1, null, chars);
        return 0;
    }

    int gtk_enter_notify_event(int widget, int event) {
        GdkEventCrossing gdkEvent = new GdkEventCrossing();
        OS.memmove((GdkEventCrossing)gdkEvent, (int)event, (int)68);
        if (gdkEvent.mode != 0) {
            return 0;
        }
        if (gdkEvent.subwindow != 0) {
            return 0;
        }
        this.sendMouseEvent(6, 0, event);
        return 0;
    }

    int gtk_event_after(int widget, int gdkEvent) {
        GdkEvent event = new GdkEvent();
        OS.memmove((GdkEvent)event, (int)gdkEvent, (int)64);
        switch (event.type) {
            case 4: {
                if ((this.state & 0x10000) != 0) break;
                GdkEventButton gdkEventButton = new GdkEventButton();
                OS.memmove((GdkEventButton)gdkEventButton, (int)gdkEvent, (int)64);
                if (gdkEventButton.button != 3) break;
                this.showMenu((int)gdkEventButton.x_root, (int)gdkEventButton.y_root);
                break;
            }
            case 12: {
                GdkEventFocus gdkEventFocus = new GdkEventFocus();
                OS.memmove((GdkEventFocus)gdkEventFocus, (int)gdkEvent, (int)12);
                this.sendFocusEvent(gdkEventFocus.in != 0 ? 15 : 16);
            }
        }
        return 0;
    }

    int gtk_expose_event(int widget, int eventPtr) {
        if (!this.hooks(9) && !this.filters(9)) {
            return 0;
        }
        GdkEventExpose gdkEvent = new GdkEventExpose();
        OS.memmove((GdkEventExpose)gdkEvent, (int)eventPtr, (int)36);
        Event event = new Event();
        event.count = gdkEvent.count;
        event.x = gdkEvent.area_x;
        event.y = gdkEvent.area_y;
        event.width = gdkEvent.area_width;
        event.height = gdkEvent.area_height;
        GC gc = event.gc = new GC(this);
        Region region = Region.gtk_new(this.display, gdkEvent.region);
        gc.setClipping(region);
        this.sendEvent(9, event);
        gc.dispose();
        event.gc = null;
        return 0;
    }

    int gtk_focus(int widget, int event) {
        return 1;
    }

    int gtk_focus_in_event(int widget, int event) {
        if (this.handle != 0) {
            int imHandle;
            int oldIMHandle;
            Control oldControl = this.display.imControl;
            if (oldControl != this && oldControl != null && !oldControl.isDisposed() && (oldIMHandle = oldControl.imHandle()) != 0) {
                OS.gtk_im_context_reset((int)oldIMHandle);
            }
            if ((this.hooks(1) || this.hooks(2)) && (imHandle = this.imHandle()) != 0) {
                OS.gtk_im_context_focus_in((int)imHandle);
            }
        }
        return 0;
    }

    int gtk_focus_out_event(int widget, int event) {
        int imHandle;
        if (this.handle != 0 && (this.hooks(1) || this.hooks(2)) && (imHandle = this.imHandle()) != 0) {
            OS.gtk_im_context_focus_out((int)imHandle);
        }
        return 0;
    }

    int gtk_key_press_event(int widget, int event) {
        if (!this.hasFocus()) {
            return 0;
        }
        int imHandle = this.imHandle();
        if (imHandle != 0 && OS.gtk_im_context_filter_keypress((int)imHandle, (int)event)) {
            return 1;
        }
        GdkEventKey gdkEvent = new GdkEventKey();
        OS.memmove((GdkEventKey)gdkEvent, (int)event, (int)36);
        if (this.translateTraversal(gdkEvent)) {
            return 1;
        }
        if (this.isDisposed()) {
            return 0;
        }
        return this.sendKeyEvent(1, gdkEvent) ? 0 : 1;
    }

    int gtk_key_release_event(int widget, int event) {
        if (!this.hasFocus()) {
            return 0;
        }
        int imHandle = this.imHandle();
        if (imHandle != 0 && OS.gtk_im_context_filter_keypress((int)imHandle, (int)event)) {
            return 1;
        }
        GdkEventKey gdkEvent = new GdkEventKey();
        OS.memmove((GdkEventKey)gdkEvent, (int)event, (int)36);
        return this.sendKeyEvent(2, gdkEvent) ? 0 : 1;
    }

    int gtk_leave_notify_event(int widget, int event) {
        this.display.removeMouseHoverTimeout(this.handle);
        GdkEventCrossing gdkEvent = new GdkEventCrossing();
        OS.memmove((GdkEventCrossing)gdkEvent, (int)event, (int)68);
        if (gdkEvent.mode != 0) {
            return 0;
        }
        if (gdkEvent.subwindow != 0) {
            return 0;
        }
        this.sendMouseEvent(7, 0, event);
        return 0;
    }

    int gtk_motion_notify_event(int widget, int event) {
        if (this.hooks(29) && !this.display.dragging) {
            int[] state = new int[1];
            OS.gdk_event_get_state((int)event, (int[])state);
            if ((state[0] & 0x100) != 0) {
                double[] px = new double[1];
                double[] py = new double[1];
                OS.gdk_event_get_coords((int)event, (double[])px, (double[])py);
                if (OS.gtk_drag_check_threshold((int)this.handle, (int)this.display.dragStartX, (int)this.display.dragStartY, (int)((int)px[0]), (int)((int)py[0]))) {
                    this.display.dragging = true;
                    this.postEvent(29);
                }
            }
        }
        if (this.hooks(32) || this.filters(32)) {
            this.display.addMouseHoverTimeout(this.handle);
        }
        this.sendMouseEvent(5, 0, event);
        return 0;
    }

    int gtk_popup_menu(int widget) {
        int[] x = new int[1];
        int[] y = new int[1];
        OS.gdk_window_get_pointer((int)0, (int[])x, (int[])y, null);
        this.showMenu(x[0], y[0]);
        return 0;
    }

    int gtk_preedit_changed(int imcontext) {
        this.display.showIMWindow(this);
        return 0;
    }

    int gtk_realize(int widget) {
        int window = OS.GTK_WIDGET_WINDOW((int)this.paintHandle());
        int imHandle = this.imHandle();
        if (imHandle != 0) {
            OS.gtk_im_context_set_client_window((int)imHandle, (int)window);
        }
        if (this.cursor != null && this.cursor.isDisposed()) {
            return 0;
        }
        int gdkCursor = this.cursor != null ? this.cursor.handle : 0;
        OS.gdk_window_set_cursor((int)window, (int)gdkCursor);
        return 0;
    }

    int gtk_show_help(int widget, int helpType) {
        this.sendHelpEvent(helpType);
        return 0;
    }

    int gtk_unrealize(int widget) {
        int imHandle = this.imHandle();
        if (imHandle != 0) {
            OS.gtk_im_context_set_client_window((int)imHandle, (int)0);
        }
        return 0;
    }

    public int internal_new_GC(GCData data) {
        int gdkGC;
        this.checkWidget();
        int window = this.paintWindow();
        if (window == 0) {
            SWT.error(2);
        }
        if ((gdkGC = OS.gdk_gc_new((int)window)) == 0) {
            this.error(2);
        }
        if (data != null) {
            int mask = 0x6000000;
            if ((data.style & mask) == 0) {
                data.style |= this.style & (mask | 0x8000000);
            }
            int fontHandle = this.fontHandle();
            GtkStyle style = new GtkStyle();
            OS.memmove((GtkStyle)style, (int)OS.gtk_widget_get_style((int)fontHandle));
            GdkColor foreground = new GdkColor();
            foreground.pixel = style.fg0_pixel;
            foreground.red = style.fg0_red;
            foreground.green = style.fg0_green;
            foreground.blue = style.fg0_blue;
            GdkColor background = new GdkColor();
            background.pixel = style.bg0_pixel;
            background.red = style.bg0_red;
            background.green = style.bg0_green;
            background.blue = style.bg0_blue;
            data.drawable = window;
            data.device = this.display;
            data.background = background;
            data.foreground = foreground;
            data.font = this.font != null ? this.font.handle : this.defaultFont();
        }
        return gdkGC;
    }

    int imHandle() {
        return 0;
    }

    public void internal_dispose_GC(int gdkGC, GCData data) {
        this.checkWidget();
        OS.g_object_unref((int)gdkGC);
    }

    public boolean isReparentable() {
        this.checkWidget();
        return true;
    }

    boolean isShowing() {
        if (!this.isVisible()) {
            return false;
        }
        Control control = this;
        while (control != null) {
            Point size = control.getSize();
            if (size.x == 1 || size.y == 1) {
                return false;
            }
            control = control.parent;
        }
        return true;
    }

    boolean isTabGroup() {
        int code;
        Control[] tabList = this.parent._getTabList();
        if (tabList != null) {
            int i = 0;
            while (i < tabList.length) {
                if (tabList[i] == this) {
                    return true;
                }
                ++i;
            }
        }
        if (((code = this.traversalCode(0, null)) & 0x60) != 0) {
            return false;
        }
        return (code & 0x18) != 0;
    }

    boolean isTabItem() {
        int code;
        Control[] tabList = this.parent._getTabList();
        if (tabList != null) {
            int i = 0;
            while (i < tabList.length) {
                if (tabList[i] == this) {
                    return false;
                }
                ++i;
            }
        }
        return ((code = this.traversalCode(0, null)) & 0x60) != 0;
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    boolean isFocusAncestor() {
        Control control = this.display.getFocusControl();
        while (control != null && control != this) {
            control = control.parent;
        }
        return control == this;
    }

    public boolean isFocusControl() {
        this.checkWidget();
        return this.hasFocus();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible() && this.parent.isVisible();
    }

    Decorations menuShell() {
        return this.parent.menuShell();
    }

    void register() {
        int imHandle;
        super.register();
        if (this.fixedHandle != 0) {
            this.display.addWidget(this.fixedHandle, this);
        }
        if ((imHandle = this.imHandle()) != 0) {
            this.display.addWidget(imHandle, this);
        }
    }

    public void redraw() {
        this.checkWidget();
        int paintHandle = this.paintHandle();
        int width = OS.GTK_WIDGET_WIDTH((int)paintHandle);
        int height = OS.GTK_WIDGET_HEIGHT((int)paintHandle);
        this.redrawWidget(0, 0, width, height, true);
    }

    public void redraw(int x, int y, int width, int height, boolean all) {
        this.checkWidget();
        this.redrawWidget(x, y, width, height, all);
    }

    void redrawWidget(int x, int y, int width, int height, boolean all) {
        int window = this.paintWindow();
        GdkRectangle rect = new GdkRectangle();
        rect.x = x;
        rect.y = y;
        rect.width = width;
        rect.height = height;
        OS.gdk_window_invalidate_rect((int)window, (GdkRectangle)rect, (boolean)all);
    }

    void releaseChild() {
        this.parent.removeControl(this);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.fixedHandle = 0;
    }

    void releaseWidget() {
        this.display.removeMouseHoverTimeout(this.handle);
        super.releaseWidget();
        int imHandle = this.imHandle();
        if (imHandle != 0) {
            OS.gtk_im_context_reset((int)imHandle);
            OS.gtk_im_context_set_client_window((int)imHandle, (int)0);
        }
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.dispose();
        }
        this.menu = null;
        this.cursor = null;
        this.toolTipText = null;
        this.parent = null;
        this.layoutData = null;
    }

    void sendFocusEvent(int type) {
        Shell shell = this._getShell();
        this.sendEvent(type);
        switch (type) {
            case 15: {
                if (shell.isDisposed()) break;
                shell.setActiveControl(this);
                break;
            }
            case 16: {
                Display display;
                Control control;
                if (shell.isDisposed() || (control = (display = shell.display).getFocusControl()) != null && shell == control.getShell()) break;
                shell.setActiveControl(null);
            }
        }
    }

    boolean sendHelpEvent(int helpType) {
        Control control = this;
        while (control != null) {
            if (control.hooks(28)) {
                control.postEvent(28);
                return true;
            }
            control = control.parent;
        }
        return false;
    }

    char[] sendIMKeyEvent(int type, GdkEventKey keyEvent, char[] chars) {
        int index = 0;
        int count = 0;
        while (index < chars.length) {
            Event event = new Event();
            event.character = chars[index];
            if (keyEvent != null) {
                event.time = keyEvent.time;
                this.setInputState(event, keyEvent.state);
            }
            this.sendEvent(type, event);
            if (this.isDisposed()) {
                return null;
            }
            if (event.doit) {
                chars[count++] = chars[index];
            }
            ++index;
        }
        if (count == 0) {
            return null;
        }
        if (index != count) {
            char[] result = new char[count];
            System.arraycopy(chars, 0, result, 0, count);
            return result;
        }
        return chars;
    }

    boolean sendKeyEvent(int type, GdkEventKey keyEvent) {
        int length = keyEvent.length;
        if (length <= 1) {
            Event event = new Event();
            event.time = keyEvent.time;
            this.setKeyState(event, keyEvent);
            this.sendEvent(type, event);
            if (this.isDisposed()) {
                return false;
            }
            return event.doit;
        }
        byte[] buffer = new byte[length];
        OS.memmove((byte[])buffer, (int)keyEvent.string, (int)length);
        char[] chars = Converter.mbcsToWcs(null, buffer);
        return this.sendIMKeyEvent(type, keyEvent, chars) != null;
    }

    void sendMouseEvent(int type, int button, int gdkEvent) {
        Event event = new Event();
        event.time = OS.gdk_event_get_time((int)gdkEvent);
        event.button = button;
        double[] x = new double[1];
        double[] y = new double[1];
        OS.gdk_event_get_coords((int)gdkEvent, (double[])x, (double[])y);
        event.x = (int)x[0];
        event.y = (int)y[0];
        int[] state = new int[1];
        OS.gdk_event_get_state((int)gdkEvent, (int[])state);
        this.setInputState(event, state[0]);
        this.postEvent(type, event);
    }

    public void setBackground(Color color) {
        GdkColor gdkColor;
        this.checkWidget();
        if (color == null) {
            gdkColor = this.defaultBackground();
        } else {
            if (color.isDisposed()) {
                SWT.error(5);
            }
            gdkColor = color.handle;
        }
        this.setBackgroundColor(gdkColor);
    }

    void setBackgroundColor(GdkColor color) {
        OS.gtk_widget_modify_bg((int)this.handle, (int)0, (GdkColor)color);
    }

    public void setCapture(boolean capture) {
        this.checkWidget();
    }

    public void setCursor(Cursor cursor) {
        this.checkWidget();
        if (cursor != null && cursor.isDisposed()) {
            this.error(5);
        }
        this.cursor = cursor;
        int gdkCursor = cursor != null ? cursor.handle : 0;
        int window = OS.GTK_WIDGET_WINDOW((int)this.paintHandle());
        if (window != 0) {
            OS.gdk_window_set_cursor((int)window, (int)gdkCursor);
            OS.gdk_flush();
        }
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        if (enabled) {
            if ((this.state & 0x40) == 0) {
                return;
            }
            this.state &= 0xFFFFFFBF;
        } else {
            if ((this.state & 0x40) != 0) {
                return;
            }
            this.state |= 0x40;
        }
        boolean fixFocus = !enabled && this.isFocusAncestor();
        this.enableWidget(enabled);
        if (fixFocus) {
            this.fixFocus();
        }
    }

    public boolean setFocus() {
        this.checkWidget();
        return this.forceFocus();
    }

    public void setFont(Font font) {
        int fontDesc;
        this.checkWidget();
        this.font = font;
        if (font == null) {
            fontDesc = this.defaultFont();
        } else {
            if (font.isDisposed()) {
                SWT.error(5);
            }
            fontDesc = font.handle;
        }
        this.setFontDescription(fontDesc);
    }

    void setFontDescription(int font) {
        OS.gtk_widget_modify_font((int)this.handle, (int)font);
    }

    public void setForeground(Color color) {
        GdkColor gdkColor;
        this.checkWidget();
        if (color == null) {
            gdkColor = this.defaultForeground();
        } else {
            if (color.isDisposed()) {
                SWT.error(5);
            }
            gdkColor = color.handle;
        }
        this.setForegroundColor(gdkColor);
    }

    void setForegroundColor(GdkColor color) {
        OS.gtk_widget_modify_fg((int)this.handle, (int)0, (GdkColor)color);
    }

    void setInitialSize() {
        this.resizeHandle(1, 1);
        int parentHandle = this.parent.parentingHandle();
        OS.gtk_container_resize_children((int)parentHandle);
    }

    public void setMenu(Menu menu) {
        this.checkWidget();
        if (menu != null) {
            if ((menu.style & 8) == 0) {
                this.error(37);
            }
            if (menu.parent != this.menuShell()) {
                this.error(32);
            }
        }
        this.menu = menu;
    }

    public boolean setParent(Composite parent) {
        this.checkWidget();
        if (parent == null) {
            SWT.error(4);
        }
        if (parent.isDisposed()) {
            SWT.error(5);
        }
        if (this.parent == parent) {
            return true;
        }
        this.releaseChild();
        Shell newShell = parent.getShell();
        Shell oldShell = this.getShell();
        Decorations newDecorations = parent.menuShell();
        Decorations oldDecorations = this.menuShell();
        Menu[] menus = oldShell.findMenus(this);
        if (oldShell != newShell || oldDecorations != newDecorations) {
            this.fixChildren(newShell, oldShell, newDecorations, oldDecorations, menus);
            newDecorations.fixAccelGroup();
            oldDecorations.fixAccelGroup();
        }
        int topHandle = this.topHandle();
        int newParent = parent.parentingHandle();
        int x = OS.GTK_WIDGET_X((int)topHandle);
        int y = OS.GTK_WIDGET_Y((int)topHandle);
        OS.gtk_widget_reparent((int)topHandle, (int)newParent);
        OS.gtk_fixed_move((int)newParent, (int)topHandle, (int)x, (int)y);
        this.parent = parent;
        return true;
    }

    boolean setRadioSelection(boolean value) {
        return false;
    }

    public void setRedraw(boolean redraw) {
        this.checkWidget();
        this.drawCount = redraw ? --this.drawCount : ++this.drawCount;
    }

    boolean setTabGroupFocus() {
        return this.setTabItemFocus();
    }

    boolean setTabItemFocus() {
        if (!this.isShowing()) {
            return false;
        }
        return this.setFocus();
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        Shell shell = this._getShell();
        this.toolTipText = string;
        shell.setToolTipText(this.handle, this.toolTipText);
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        int topHandle = this.topHandle();
        if (OS.GTK_WIDGET_VISIBLE((int)topHandle) == visible) {
            return;
        }
        if (visible) {
            this.sendEvent(22);
            OS.gtk_widget_show((int)topHandle);
        } else {
            OS.gtk_widget_hide((int)topHandle);
            OS.gtk_widget_unrealize((int)topHandle);
            this.sendEvent(23);
        }
    }

    void setZOrder(Control sibling, boolean above) {
        this.setZOrder(sibling, above, true);
    }

    void setZOrder(Control sibling, boolean above, boolean fixChildren) {
        int topHandle = this.topHandle();
        int siblingHandle = sibling != null ? sibling.topHandle() : 0;
        int window = OS.GTK_WIDGET_WINDOW((int)topHandle);
        if (above) {
            if (window != 0) {
                OS.gdk_window_raise((int)window);
            }
            if (fixChildren) {
                this.parent.moveAbove(topHandle, siblingHandle);
            }
        } else {
            if (window != 0) {
                OS.gdk_window_lower((int)window);
            }
            if (fixChildren) {
                this.parent.moveBelow(topHandle, siblingHandle);
            }
        }
        if (!above && fixChildren && this.parent.parentingHandle() == this.parent.fixedHandle && (window = OS.GTK_WIDGET_WINDOW((int)this.parent.handle)) != 0) {
            OS.gdk_window_lower((int)window);
        }
    }

    boolean showMenu(int x, int y) {
        Event event = new Event();
        event.x = x;
        event.y = y;
        this.sendEvent(35, event);
        if (event.doit && this.menu != null && !this.menu.isDisposed()) {
            this.menu.createIMMenu(this.imHandle());
            if (event.x != x || event.y != y) {
                this.menu.setLocation(event.x, event.y);
            }
            this.menu.setVisible(true);
            return true;
        }
        return false;
    }

    void sort(int[] items) {
        int length = items.length;
        int gap = length / 2;
        while (gap > 0) {
            int i = gap;
            while (i < length) {
                int j = i - gap;
                while (j >= 0) {
                    if (items[j] <= items[j + gap]) {
                        int swap = items[j];
                        items[j] = items[j + gap];
                        items[j + gap] = swap;
                    }
                    j -= gap;
                }
                ++i;
            }
            gap /= 2;
        }
    }

    public boolean traverse(int traversal) {
        this.checkWidget();
        if (!this.isFocusControl() && !this.setFocus()) {
            return false;
        }
        Event event = new Event();
        event.doit = true;
        event.detail = traversal;
        return this.traverse(event);
    }

    boolean translateTraversal(GdkEventKey keyEvent) {
        int detail = 0;
        int key = keyEvent.keyval;
        int code = this.traversalCode(key, keyEvent);
        boolean all = false;
        switch (key) {
            case 65307: 
            case 65385: {
                all = true;
                detail = 2;
                break;
            }
            case 65293: 
            case 65421: {
                all = true;
                detail = 4;
                break;
            }
            case 65056: 
            case 65289: {
                boolean next = (keyEvent.state & 1) == 0;
                switch (keyEvent.state) {
                    case 1: 
                    case 4: {
                        code |= 0x18;
                    }
                }
                detail = next ? 16 : 8;
                break;
            }
            case 65361: 
            case 65362: 
            case 65363: 
            case 65364: {
                boolean next = key == 65364 || key == 65363;
                detail = next ? 64 : 32;
                break;
            }
            case 65365: 
            case 65366: {
                all = true;
                if ((keyEvent.state & 4) == 0) {
                    return false;
                }
                code |= 0x300;
                detail = key == 65366 ? 512 : 256;
                break;
            }
            default: {
                return false;
            }
        }
        Event event = new Event();
        event.doit = (code & detail) != 0;
        event.detail = detail;
        event.time = keyEvent.time;
        this.setKeyState(event, keyEvent);
        Shell shell = this.getShell();
        Control control = this;
        do {
            if (control.traverse(event)) {
                return true;
            }
            if (!event.doit && control.hooks(31)) {
                return false;
            }
            if (control == shell) {
                return false;
            }
            control = control.parent;
        } while (all && control != null);
        return false;
    }

    int traversalCode(int key, GdkEventKey event) {
        int code = 28;
        Shell shell = this.getShell();
        if (shell.parent != null) {
            code |= 2;
        }
        return code;
    }

    boolean traverse(Event event) {
        this.sendEvent(31, event);
        if (this.isDisposed()) {
            return false;
        }
        if (!event.doit) {
            return false;
        }
        switch (event.detail) {
            case 0: {
                return true;
            }
            case 2: {
                return this.traverseEscape();
            }
            case 4: {
                return this.traverseReturn();
            }
            case 16: {
                return this.traverseGroup(true);
            }
            case 8: {
                return this.traverseGroup(false);
            }
            case 64: {
                return this.traverseItem(true);
            }
            case 32: {
                return this.traverseItem(false);
            }
            case 128: {
                return this.traverseMnemonic(event);
            }
            case 512: {
                return this.traversePage(true);
            }
            case 256: {
                return this.traversePage(false);
            }
        }
        return false;
    }

    boolean traverseEscape() {
        return false;
    }

    boolean traverseGroup(boolean next) {
        Control root = this.computeTabRoot();
        Control group = this.computeTabGroup();
        Control[] list = root.computeTabList();
        int length = list.length;
        int index = 0;
        while (index < length) {
            if (list[index] == group) break;
            ++index;
        }
        if (index == length) {
            return false;
        }
        int start = index;
        int offset = next ? 1 : -1;
        while ((index = (index + offset + length) % length) != start) {
            Control control = list[index];
            if (control.isDisposed() || !control.setTabGroupFocus() || this.isDisposed() || this.isFocusControl()) continue;
            return true;
        }
        if (group.isDisposed()) {
            return false;
        }
        return group.setTabGroupFocus();
    }

    boolean traverseItem(boolean next) {
        Control[] children = this.parent._getChildren();
        int length = children.length;
        int index = 0;
        while (index < length) {
            if (children[index] == this) break;
            ++index;
        }
        int start = index;
        int offset = next ? 1 : -1;
        while ((index = (index + offset + length) % length) != start) {
            Control child = children[index];
            if (child.isDisposed() || !child.isTabItem() || !child.setTabItemFocus()) continue;
            return true;
        }
        return false;
    }

    boolean traverseReturn() {
        return false;
    }

    boolean traversePage(boolean next) {
        return false;
    }

    boolean traverseMnemonic(Event event) {
        return true;
    }

    public void update() {
        this.checkWidget();
        OS.gdk_flush();
        int window = this.paintWindow();
        int gc = OS.gdk_gc_new((int)window);
        OS.gdk_gc_set_exposures((int)gc, (boolean)true);
        OS.gdk_draw_drawable((int)window, (int)gc, (int)window, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0);
        OS.g_object_unref((int)gc);
        int event = 0;
        while ((event = OS.gdk_event_get_graphics_expose((int)window)) != 0) {
            OS.gtk_main_do_event((int)event);
            OS.gdk_event_free((int)event);
        }
        OS.gdk_window_process_updates((int)window, (boolean)false);
    }
}

