/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public class Decorations
extends Canvas {
    String text;
    Image image;
    boolean minimized;
    boolean maximized;
    Menu menuBar;
    Menu[] menus;
    Control savedFocus;
    Button defaultButton;
    Button saveDefault;
    int accelGroup;

    Decorations() {
    }

    public Decorations(Composite parent, int style) {
        super(parent, Decorations.checkStyle(style));
    }

    static int checkStyle(int style) {
        if ((style & 0x4C0) != 0) {
            style |= 0x20;
        }
        return style;
    }

    void add(Menu menu) {
        if (this.menus == null) {
            this.menus = new Menu[4];
        }
        int i = 0;
        while (i < this.menus.length) {
            if (this.menus[i] == null) {
                this.menus[i] = menu;
                return;
            }
            ++i;
        }
        Menu[] newMenus = new Menu[this.menus.length + 4];
        newMenus[this.menus.length] = menu;
        System.arraycopy(this.menus, 0, newMenus, 0, this.menus.length);
        this.menus = newMenus;
    }

    Control computeTabGroup() {
        return this;
    }

    Control computeTabRoot() {
        return this;
    }

    void createAccelGroup() {
        if (this.accelGroup != 0) {
            return;
        }
        this.accelGroup = OS.gtk_accel_group_new();
        if (this.accelGroup == 0) {
            SWT.error(2);
        }
        int shellHandle = this.topHandle();
        OS.gtk_window_add_accel_group((int)shellHandle, (int)this.accelGroup);
    }

    void createWidget(int index) {
        super.createWidget(index);
        this.text = "";
    }

    void destroyAccelGroup() {
        if (this.accelGroup == 0) {
            return;
        }
        int shellHandle = this.topHandle();
        OS.gtk_window_remove_accel_group((int)shellHandle, (int)this.accelGroup);
        this.accelGroup = 0;
    }

    void fixAccelGroup() {
        if (this.menuBar == null) {
            return;
        }
        this.destroyAccelGroup();
        this.createAccelGroup();
        this.menuBar.addAccelerators(this.accelGroup);
    }

    void fixDecorations(Decorations newDecorations, Control control, Menu[] menus) {
        if (this == newDecorations) {
            return;
        }
        if (control == this.savedFocus) {
            this.savedFocus = null;
        }
        if (control == this.defaultButton) {
            this.defaultButton = null;
        }
        if (control == this.saveDefault) {
            this.saveDefault = null;
        }
        if (menus == null) {
            return;
        }
        Menu menu = control.menu;
        if (menu != null) {
            int index = 0;
            while (index < menus.length) {
                if (menus[index] == menu) {
                    control.setMenu(null);
                    return;
                }
                ++index;
            }
            menu.fixMenus(newDecorations);
        }
    }

    public Button getDefaultButton() {
        this.checkWidget();
        return this.defaultButton != null ? this.defaultButton : this.saveDefault;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    public boolean getMaximized() {
        this.checkWidget();
        return this.maximized;
    }

    public Menu getMenuBar() {
        this.checkWidget();
        return this.menuBar;
    }

    public boolean getMinimized() {
        this.checkWidget();
        return this.minimized;
    }

    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    boolean isTabGroup() {
        return true;
    }

    boolean isTabItem() {
        return false;
    }

    Decorations menuShell() {
        return this;
    }

    void remove(Menu menu) {
        if (this.menus == null) {
            return;
        }
        int i = 0;
        while (i < this.menus.length) {
            if (this.menus[i] == menu) {
                this.menus[i] = null;
                return;
            }
            ++i;
        }
    }

    void releaseWidget() {
        if (this.menuBar != null) {
            this.menuBar.releaseResources();
        }
        this.menuBar = null;
        if (this.menus != null) {
            int i = 0;
            while (i < this.menus.length) {
                Menu menu = this.menus[i];
                if (menu != null && !menu.isDisposed()) {
                    menu.dispose();
                }
                ++i;
            }
        }
        this.menus = null;
        super.releaseWidget();
        this.image = null;
    }

    boolean restoreFocus() {
        if (this.savedFocus != null && this.savedFocus.isDisposed()) {
            this.savedFocus = null;
        }
        boolean restored = this.savedFocus != null && this.savedFocus.setFocus();
        this.savedFocus = null;
        return restored;
    }

    public void setDefaultButton(Button button) {
        this.checkWidget();
        int buttonHandle = 0;
        if (button != null) {
            if (button.isDisposed()) {
                this.error(5);
            }
            buttonHandle = button.handle;
        }
        this.saveDefault = this.defaultButton = button;
        OS.gtk_window_set_default((int)this.topHandle(), (int)buttonHandle);
    }

    public void setImage(Image image) {
        this.checkWidget();
        this.image = image;
        int pixmap = 0;
        int mask = 0;
        if (image != null) {
            pixmap = image.pixmap;
            mask = image.mask;
        }
        int window = OS.GTK_WIDGET_WINDOW((int)this.topHandle());
        OS.gdk_window_set_icon((int)window, (int)0, (int)pixmap, (int)mask);
    }

    public void setMaximized(boolean maximized) {
        this.checkWidget();
        this.maximized = maximized;
    }

    public void setMenuBar(Menu menu) {
        this.checkWidget();
        if (this.menuBar == menu) {
            return;
        }
        if (menu != null) {
            if ((menu.style & 2) == 0) {
                this.error(33);
            }
            if (menu.parent != this) {
                this.error(32);
            }
        }
        this.menuBar = menu;
    }

    public void setMinimized(boolean minimized) {
        this.checkWidget();
        this.minimized = minimized;
    }

    void setSavedFocus(Control control) {
        if (this == control) {
            return;
        }
        this.savedFocus = control;
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.text = string;
    }

    boolean traverseItem(boolean next) {
        return false;
    }

    boolean traverseReturn() {
        Button button;
        Button button2 = button = this.defaultButton != null ? this.defaultButton : this.saveDefault;
        if (button == null || button.isDisposed()) {
            return false;
        }
        if (!button.isVisible() || !button.isEnabled()) {
            return true;
        }
        int shellHandle = this._getShell().topHandle();
        return OS.gtk_window_activate_default((int)shellHandle);
    }
}

