/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;

public class Group
extends Composite {
    int clientHandle;
    int labelHandle;
    String text = "";

    public Group(Composite parent, int style) {
        super(parent, Group.checkStyle(style));
    }

    static int checkStyle(int style) {
        return style & 0xFFFFFCFF;
    }

    int clientHandle() {
        return this.clientHandle;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        Point defaultSize = this.computeNativeSize(this.handle, wHint, hHint, changed);
        Point size = this.layout != null ? this.layout.computeSize(this, wHint, hHint, changed) : this.minimumSize();
        int width = size.x;
        int height = size.y;
        if (width == 0) {
            width = 64;
        }
        if (height == 0) {
            height = 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        Rectangle trim = this.computeTrim(0, 0, width, height);
        width = Math.max(trim.width, defaultSize.x);
        height = trim.height;
        return new Point(trim.width, trim.height);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        int clientX = OS.GTK_WIDGET_X((int)this.clientHandle);
        int clientY = OS.GTK_WIDGET_Y((int)this.clientHandle);
        return new Rectangle(x -= clientX, y -= clientY, width += clientX + clientX, height += clientX + clientY);
    }

    void createHandle(int index) {
        this.state |= 0x800;
        this.fixedHandle = OS.gtk_fixed_new();
        if (this.fixedHandle == 0) {
            this.error(2);
        }
        OS.gtk_fixed_set_has_window((int)this.fixedHandle, (boolean)true);
        this.handle = OS.gtk_frame_new(null);
        if (this.handle == 0) {
            this.error(2);
        }
        this.labelHandle = OS.gtk_label_new(null);
        if (this.labelHandle == 0) {
            this.error(2);
        }
        OS.g_object_ref((int)this.labelHandle);
        OS.gtk_object_sink((int)this.labelHandle);
        this.clientHandle = OS.gtk_fixed_new();
        if (this.clientHandle == 0) {
            this.error(2);
        }
        int parentHandle = this.parent.parentingHandle();
        OS.gtk_container_add((int)parentHandle, (int)this.fixedHandle);
        OS.gtk_container_add((int)this.fixedHandle, (int)this.handle);
        OS.gtk_container_add((int)this.handle, (int)this.clientHandle);
        OS.gtk_widget_show((int)this.handle);
        OS.gtk_widget_show((int)this.clientHandle);
        OS.gtk_widget_show((int)this.labelHandle);
        OS.gtk_widget_show((int)this.fixedHandle);
        if ((this.style & 4) != 0) {
            OS.gtk_frame_set_shadow_type((int)this.handle, (int)1);
        }
        if ((this.style & 8) != 0) {
            OS.gtk_frame_set_shadow_type((int)this.handle, (int)2);
        }
        if ((this.style & 0x10) != 0) {
            OS.gtk_frame_set_shadow_type((int)this.handle, (int)3);
        }
        if ((this.style & 0x40) != 0) {
            OS.gtk_frame_set_shadow_type((int)this.handle, (int)4);
        }
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.clientHandle);
        this.display.removeWidget(this.labelHandle);
    }

    void enableWidget(boolean enabled) {
        OS.gtk_widget_set_sensitive((int)this.labelHandle, (boolean)enabled);
    }

    int eventHandle() {
        return this.fixedHandle;
    }

    void fixGroup() {
        int flags = OS.GTK_WIDGET_FLAGS((int)this.handle);
        OS.GTK_WIDGET_SET_FLAGS((int)this.handle, (int)256);
        GtkRequisition requisition = new GtkRequisition();
        OS.gtk_widget_size_request((int)this.handle, (GtkRequisition)requisition);
        OS.gtk_container_resize_children((int)this.handle);
        if ((flags & 0x100) == 0) {
            OS.GTK_WIDGET_UNSET_FLAGS((int)this.handle, (int)256);
        }
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        int width = OS.GTK_WIDGET_WIDTH((int)this.clientHandle);
        int height = OS.GTK_WIDGET_HEIGHT((int)this.clientHandle);
        return new Rectangle(0, 0, width, height);
    }

    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    int parentingHandle() {
        return this.clientHandle;
    }

    void register() {
        super.register();
        this.display.addWidget(this.clientHandle, this);
        this.display.addWidget(this.labelHandle, this);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.labelHandle = 0;
        this.clientHandle = 0;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.labelHandle != 0) {
            OS.g_object_unref((int)this.labelHandle);
        }
        this.text = null;
    }

    void setBackgroundColor(GdkColor color) {
        super.setBackgroundColor(color);
        OS.gtk_widget_modify_bg((int)this.fixedHandle, (int)0, (GdkColor)color);
    }

    void setFontDescription(int font) {
        super.setFontDescription(font);
        OS.gtk_widget_modify_font((int)this.labelHandle, (int)font);
    }

    void setForegroundColor(GdkColor color) {
        super.setForegroundColor(color);
        OS.gtk_widget_modify_fg((int)this.labelHandle, (int)0, (GdkColor)color);
    }

    void setOrientation() {
        super.setOrientation();
        if ((this.style & 0x4000000) != 0) {
            OS.gtk_widget_set_direction((int)this.handle, (int)2);
            OS.gtk_widget_set_direction((int)this.labelHandle, (int)2);
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.text = string;
        char[] chars = this.fixMnemonic(string);
        byte[] buffer = Converter.wcsToMbcs(null, chars, true);
        OS.gtk_label_set_text_with_mnemonic((int)this.labelHandle, (byte[])buffer);
        if (string.length() != 0) {
            if (OS.gtk_frame_get_label_widget((int)this.handle) == 0) {
                OS.gtk_frame_set_label_widget((int)this.handle, (int)this.labelHandle);
            }
        } else {
            OS.gtk_frame_set_label_widget((int)this.handle, (int)0);
        }
        this.fixGroup();
    }
}

