/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.gtk.OS;

class ImageList {
    int[] pixbufs;
    Image[] images = new Image[4];

    public ImageList() {
        this.pixbufs = new int[4];
    }

    public int add(Image image) {
        int index = 0;
        while (index < this.images.length) {
            if (this.images[index] != null && this.images[index].isDisposed()) {
                OS.g_object_unref((int)this.pixbufs[index]);
                this.images[index] = null;
                this.pixbufs[index] = 0;
            }
            if (this.images[index] == null) break;
            ++index;
        }
        int[] w = new int[1];
        int[] h = new int[1];
        OS.gdk_drawable_get_size((int)image.pixmap, (int[])w, (int[])h);
        int width = w[0];
        int height = h[0];
        boolean hasMask = image.mask != 0;
        int pixbuf = OS.gdk_pixbuf_new((int)0, (boolean)hasMask, (int)8, (int)width, (int)height);
        if (pixbuf == 0) {
            SWT.error(2);
        }
        int colormap = OS.gdk_colormap_get_system();
        OS.gdk_pixbuf_get_from_drawable((int)pixbuf, (int)image.pixmap, (int)colormap, (int)0, (int)0, (int)0, (int)0, (int)width, (int)height);
        if (hasMask) {
            int gdkMaskImagePtr = OS.gdk_drawable_get_image((int)image.mask, (int)0, (int)0, (int)width, (int)height);
            if (gdkMaskImagePtr == 0) {
                SWT.error(2);
            }
            int stride = OS.gdk_pixbuf_get_rowstride((int)pixbuf);
            int pixels = OS.gdk_pixbuf_get_pixels((int)pixbuf);
            byte[] line = new byte[stride];
            int y = 0;
            while (y < height) {
                int offset = pixels + y * stride;
                OS.memmove((byte[])line, (int)offset, (int)stride);
                int x = 0;
                while (x < width) {
                    if (OS.gdk_image_get_pixel((int)gdkMaskImagePtr, (int)x, (int)y) == 0) {
                        line[x * 4 + 3] = 0;
                    }
                    ++x;
                }
                OS.memmove((int)offset, (byte[])line, (int)stride);
                ++y;
            }
            OS.g_object_unref((int)gdkMaskImagePtr);
        }
        if (index == this.images.length) {
            Image[] newImages = new Image[this.images.length + 4];
            System.arraycopy(this.images, 0, newImages, 0, this.images.length);
            this.images = newImages;
            int[] newPixbufs = new int[this.pixbufs.length + 4];
            System.arraycopy(this.pixbufs, 0, newPixbufs, 0, this.pixbufs.length);
            this.pixbufs = newPixbufs;
        }
        this.pixbufs[index] = pixbuf;
        this.images[index] = image;
        return index;
    }

    public void dispose() {
        if (this.pixbufs == null) {
            return;
        }
        int index = 0;
        while (index < this.pixbufs.length) {
            if (this.pixbufs[index] != 0) {
                OS.g_object_unref((int)this.pixbufs[index]);
            }
            ++index;
        }
        this.images = null;
        this.pixbufs = null;
    }

    public Image get(int index) {
        return this.images[index];
    }

    int getPixbuf(int index) {
        return this.pixbufs[index];
    }

    public int indexOf(Image image) {
        if (image == null) {
            return -1;
        }
        int index = 0;
        while (index < this.images.length) {
            if (image == this.images[index]) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    int indexOf(int pixbuf) {
        if (pixbuf == 0) {
            return -1;
        }
        int index = 0;
        while (index < this.images.length) {
            if (pixbuf == this.pixbufs[index]) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public boolean isDisposed() {
        return this.images == null;
    }

    public void remove(Image image) {
        if (image == null) {
            return;
        }
        int index = 0;
        while (index < this.images.length) {
            if (image == this.images[index]) {
                OS.g_object_unref((int)this.pixbufs[index]);
                this.images[index] = null;
                this.pixbufs[index] = 0;
            }
            ++index;
        }
    }

    public int size() {
        int result = 0;
        int index = 0;
        while (index < this.images.length) {
            if (this.images[index] != null) {
                if (this.images[index].isDisposed()) {
                    OS.g_object_unref((int)this.pixbufs[index]);
                    this.images[index] = null;
                    this.pixbufs[index] = 0;
                }
                if (this.images[index] != null) {
                    ++result;
                }
            }
            ++index;
        }
        return result;
    }
}

