/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEvent;
import org.eclipse.swt.internal.gtk.GdkEventFocus;
import org.eclipse.swt.internal.gtk.GdkEventWindowState;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.GtkStyle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TypedListener;

public class Shell
extends Decorations {
    int shellHandle;
    int tooltipsHandle;
    boolean hasFocus;
    boolean mapped;
    int oldX;
    int oldY;
    int oldWidth;
    int oldHeight;
    Control lastActive;

    public Shell() {
        this((Display)null);
    }

    public Shell(int style) {
        this((Display)null, style);
    }

    public Shell(Display display) {
        this(display, 1264);
    }

    public Shell(Display display, int style) {
        this(display, null, style);
    }

    Shell(Display display, Shell parent, int style) {
        this.checkSubclass();
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        this.style = Shell.checkStyle(style);
        this.parent = parent;
        this.display = display;
        this.createWidget(0);
    }

    public Shell(Shell parent) {
        this(parent, 2144);
    }

    public Shell(Shell parent, int style) {
        this(null, parent, style);
    }

    static int checkStyle(int style) {
        if (((style = Decorations.checkStyle(style)) & 0x4000) != 0) {
            style &= 0xFFFFFB0F;
        }
        int mask = 229376;
        int bits = style & ~mask;
        if ((style & 0x20000) != 0) {
            return bits | 0x20000;
        }
        if ((style & 0x10000) != 0) {
            return bits | 0x10000;
        }
        if ((style & 0x8000) != 0) {
            return bits | 0x8000;
        }
        return bits;
    }

    public void addShellListener(ShellListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(21, typedListener);
        this.addListener(19, typedListener);
        this.addListener(20, typedListener);
        this.addListener(26, typedListener);
        this.addListener(27, typedListener);
    }

    void adjustTrim() {
        int[] width = new int[1];
        int[] height = new int[1];
        OS.gtk_window_get_size((int)this.shellHandle, (int[])width, (int[])height);
        int window = OS.GTK_WIDGET_WINDOW((int)this.shellHandle);
        GdkRectangle rect = new GdkRectangle();
        OS.gdk_window_get_frame_extents((int)window, (GdkRectangle)rect);
        int trimWidth = Math.max(0, rect.width - width[0]);
        int trimHeight = Math.max(0, rect.height - height[0]);
        boolean hasTitle = false;
        boolean hasResize = false;
        boolean hasBorder = false;
        if ((this.style & 8) == 0) {
            hasTitle = (this.style & 0x4E0) != 0;
            hasResize = (this.style & 0x10) != 0;
            boolean bl = hasBorder = (this.style & 0x800) != 0;
        }
        if (hasTitle) {
            if (hasResize) {
                this.display.titleResizeTrimWidth = trimWidth;
                this.display.titleResizeTrimHeight = trimHeight;
                return;
            }
            if (hasBorder) {
                this.display.titleBorderTrimWidth = trimWidth;
                this.display.titleBorderTrimHeight = trimHeight;
                return;
            }
            this.display.titleTrimWidth = trimWidth;
            this.display.titleTrimHeight = trimHeight;
            return;
        }
        if (hasResize) {
            this.display.resizeTrimWidth = trimWidth;
            this.display.resizeTrimHeight = trimHeight;
            return;
        }
        if (hasBorder) {
            this.display.borderTrimWidth = trimWidth;
            this.display.borderTrimHeight = trimHeight;
            return;
        }
    }

    void bringToTop(boolean force) {
        if ((this.style & 0x4000) != 0) {
            return;
        }
        if (!OS.GTK_WIDGET_VISIBLE((int)this.shellHandle)) {
            return;
        }
        if (this.hasFocus) {
            return;
        }
        Shell shell = this.display.getActiveShell();
        if (!force) {
            if (shell == null) {
                return;
            }
            int focusHandle = OS.gtk_window_get_focus((int)shell.shellHandle);
            if (focusHandle == 0 || !OS.GTK_WIDGET_HAS_FOCUS((int)focusHandle)) {
                return;
            }
        }
        if (shell != null) {
            shell.hasFocus = false;
        }
        OS.gtk_window_present((int)this.shellHandle);
        this.hasFocus = true;
    }

    public void close() {
        this.checkWidget();
        this.closeWidget();
    }

    void closeWidget() {
        if (!this.isEnabled()) {
            return;
        }
        Event event = new Event();
        this.sendEvent(21, event);
        if (event.doit && !this.isDisposed()) {
            this.dispose();
        }
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        Rectangle trim = super.computeTrim(x, y, width, height);
        int trimWidth = this.trimWidth();
        int trimHeight = this.trimHeight();
        trim.x -= trimWidth / 2;
        trim.y -= trimHeight - trimWidth / 2;
        trim.width += trimWidth;
        trim.height += trimHeight;
        if (this.menuBar != null) {
            int menuBarHeight = OS.GTK_WIDGET_HEIGHT((int)this.menuBar.handle);
            trim.y -= menuBarHeight;
            trim.height += menuBarHeight;
        }
        return trim;
    }

    void createHandle(int index) {
        int bits;
        this.state |= 0x1800;
        int type = 0;
        if ((this.style & 0x4000) != 0) {
            type = 1;
        }
        this.shellHandle = OS.gtk_window_new((int)type);
        if (this.shellHandle == 0) {
            SWT.error(2);
        }
        if (this.parent != null) {
            OS.gtk_window_set_transient_for((int)this.shellHandle, (int)this.parent.topHandle());
            OS.gtk_window_set_destroy_with_parent((int)this.shellHandle, (boolean)true);
        }
        OS.gtk_widget_set_size_request((int)this.shellHandle, (int)0, (int)0);
        OS.gtk_window_set_resizable((int)this.shellHandle, (boolean)true);
        this.createScrolledHandle(this.shellHandle);
        OS.gtk_widget_realize((int)this.shellHandle);
        int window = OS.GTK_WIDGET_WINDOW((int)this.shellHandle);
        int decorations = 0;
        if ((this.style & 8) == 0) {
            if ((this.style & 0x80) != 0) {
                decorations |= 0x20;
            }
            if ((this.style & 0x400) != 0) {
                decorations |= 0x40;
            }
            if ((this.style & 0x10) != 0) {
                decorations |= 4;
            }
            if ((this.style & 0x800) != 0) {
                decorations |= 2;
            }
            if ((this.style & 0x40) != 0) {
                decorations |= 0x10;
            }
            if ((this.style & 0x20) != 0) {
                decorations |= 8;
            }
            if ((this.style & 0x10) != 0) {
                decorations |= 2;
            }
        }
        OS.gdk_window_set_decorations((int)window, (int)decorations);
        OS.gtk_window_set_title((int)this.shellHandle, (byte[])new byte[1]);
        if ((this.style & 0x4000) != 0) {
            OS.gdk_window_set_override_redirect((int)window, (boolean)true);
        }
        if ((this.style & 0x818) == 0) {
            OS.gtk_container_set_border_width((int)this.shellHandle, (int)1);
            GtkStyle style = new GtkStyle();
            OS.memmove((GtkStyle)style, (int)OS.gtk_widget_get_style((int)this.shellHandle));
            GdkColor color = new GdkColor();
            color.red = style.black_red;
            color.green = style.black_green;
            color.blue = style.black_blue;
            color.pixel = style.black_pixel;
            OS.gtk_widget_modify_bg((int)this.shellHandle, (int)0, (GdkColor)color);
        }
        boolean modal = (this.style & (bits = 229376)) != 0 || this.parent != null && (this.parent.style & bits) != 0;
        OS.gtk_window_set_modal((int)this.shellHandle, (boolean)modal);
    }

    boolean hasBorder() {
        return false;
    }

    void hookEvents() {
        super.hookEvents();
        int shellMapProc = this.display.shellMapProc;
        int windowProc3 = this.display.windowProc3;
        OS.g_signal_connect((int)this.shellHandle, (byte[])OS.map_event, (int)windowProc3, (int)22);
        OS.g_signal_connect((int)this.shellHandle, (byte[])OS.unmap_event, (int)windowProc3, (int)37);
        OS.g_signal_connect((int)this.shellHandle, (byte[])OS.window_state_event, (int)windowProc3, (int)41);
        OS.g_signal_connect((int)this.shellHandle, (byte[])OS.size_allocate, (int)windowProc3, (int)34);
        OS.g_signal_connect((int)this.shellHandle, (byte[])OS.configure_event, (int)windowProc3, (int)7);
        OS.g_signal_connect((int)this.shellHandle, (byte[])OS.delete_event, (int)windowProc3, (int)8);
        OS.g_signal_connect((int)this.shellHandle, (byte[])OS.event_after, (int)windowProc3, (int)13);
        OS.g_signal_connect((int)this.shellHandle, (byte[])OS.map_event, (int)shellMapProc, (int)0);
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    void register() {
        super.register();
        this.display.addWidget(this.shellHandle, this);
    }

    void releaseChild() {
    }

    int topHandle() {
        return this.shellHandle;
    }

    void fixShell(Shell newShell, Control control) {
        if (this == newShell) {
            return;
        }
        if (control == this.lastActive) {
            this.setActiveControl(null);
        }
        if (this.tooltipsHandle != 0) {
            this.setToolTipText(control.handle, null);
        }
        newShell.setToolTipText(control.handle, control.toolTipText);
    }

    public Point getLocation() {
        this.checkWidget();
        int[] x = new int[1];
        int[] y = new int[1];
        OS.gtk_window_get_position((int)this.shellHandle, (int[])x, (int[])y);
        return new Point(x[0], y[0]);
    }

    public Point getSize() {
        this.checkWidget();
        int width = OS.GTK_WIDGET_WIDTH((int)this.scrolledHandle);
        int height = OS.GTK_WIDGET_HEIGHT((int)this.scrolledHandle);
        if (this.menuBar != null) {
            int barHandle = this.menuBar.handle;
            height += OS.GTK_WIDGET_HEIGHT((int)barHandle);
        }
        return new Point(width + this.trimWidth(), height + this.trimHeight());
    }

    public int getImeInputMode() {
        this.checkWidget();
        return 0;
    }

    Shell _getShell() {
        return this;
    }

    public Shell[] getShells() {
        this.checkWidget();
        int count = 0;
        Shell[] shells = this.display.getShells();
        int i = 0;
        while (i < shells.length) {
            Composite shell = shells[i];
            while ((shell = shell.getParent()) != null && shell != this) {
            }
            if (shell == this) {
                ++count;
            }
            ++i;
        }
        int index = 0;
        Shell[] result = new Shell[count];
        int i2 = 0;
        while (i2 < shells.length) {
            Composite shell = shells[i2];
            while ((shell = shell.getParent()) != null && shell != this) {
            }
            if (shell == this) {
                result[index++] = shells[i2];
            }
            ++i2;
        }
        return result;
    }

    int gtk_configure_event(int widget, int event) {
        int[] x = new int[1];
        int[] y = new int[1];
        OS.gtk_window_get_position((int)this.shellHandle, (int[])x, (int[])y);
        if (this.oldX != x[0] || this.oldY != y[0]) {
            this.oldX = x[0];
            this.oldY = y[0];
            this.sendEvent(10);
        }
        return 0;
    }

    int gtk_delete_event(int widget, int event) {
        this.closeWidget();
        return 1;
    }

    int gtk_event_after(int widget, int event) {
        int result = super.gtk_event_after(widget, event);
        if (widget == this.shellHandle) {
            GdkEvent gdkEvent = new GdkEvent();
            OS.memmove((GdkEvent)gdkEvent, (int)event, (int)4);
            if (gdkEvent.type == 12) {
                GdkEventFocus focusEvent = new GdkEventFocus();
                OS.memmove((GdkEventFocus)focusEvent, (int)event, (int)12);
                this.hasFocus = focusEvent.in != 0;
                this.postEvent(this.hasFocus ? 26 : 27);
            }
        }
        return result;
    }

    int gtk_map_event(int widget, int event) {
        this.minimized = false;
        this.sendEvent(20);
        return 0;
    }

    int gtk_size_allocate(int widget, int allocation) {
        int[] width = new int[1];
        int[] height = new int[1];
        OS.gtk_window_get_size((int)this.shellHandle, (int[])width, (int[])height);
        if (this.oldWidth != width[0] || this.oldHeight != height[0]) {
            this.oldWidth = width[0];
            this.oldHeight = height[0];
            this.resizeBounds(width[0], height[0], true);
        }
        return 0;
    }

    int gtk_unmap_event(int widget, int event) {
        this.minimized = true;
        this.sendEvent(19);
        return 0;
    }

    int gtk_window_state_event(int widget, int event) {
        GdkEventWindowState gdkEvent = new GdkEventWindowState();
        OS.memmove((GdkEventWindowState)gdkEvent, (int)event, (int)20);
        this.minimized = (gdkEvent.new_window_state & 2) != 0;
        this.maximized = (gdkEvent.new_window_state & 4) != 0;
        return 0;
    }

    public void open() {
        int focusHandle;
        this.checkWidget();
        this.setVisible(true);
        this.bringToTop(false);
        if (!(this.restoreFocus() || (focusHandle = OS.gtk_window_get_focus((int)this.shellHandle)) != 0 && focusHandle != this.handle)) {
            this.traverseGroup(true);
        }
    }

    public void removeShellListener(ShellListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(21, listener);
        this.eventTable.unhook(19, listener);
        this.eventTable.unhook(20, listener);
        this.eventTable.unhook(26, listener);
        this.eventTable.unhook(27, listener);
    }

    public void setActive() {
        this.checkWidget();
        this.bringToTop(false);
    }

    void setActiveControl(Control control) {
        if (control != null && control.isDisposed()) {
            control = null;
        }
        if (this.lastActive != null && this.lastActive.isDisposed()) {
            this.lastActive = null;
        }
        if (this.lastActive == control) {
            return;
        }
        Control[] activate = control == null ? new Control[]{} : control.getPath();
        Control[] deactivate = this.lastActive == null ? new Control[]{} : this.lastActive.getPath();
        this.lastActive = control;
        int index = 0;
        int length = Math.min(activate.length, deactivate.length);
        while (index < length) {
            if (activate[index] != deactivate[index]) break;
            ++index;
        }
        int i = deactivate.length - 1;
        while (i >= index) {
            if (!deactivate[i].isDisposed()) {
                deactivate[i].sendEvent(27);
            }
            --i;
        }
        i = activate.length - 1;
        while (i >= index) {
            if (!activate[i].isDisposed()) {
                activate[i].sendEvent(26);
            }
            --i;
        }
    }

    void resizeBounds(int width, int height, boolean notify) {
        int menuHeight = 0;
        if (this.menuBar != null) {
            int menuHandle = this.menuBar.handle;
            OS.gtk_widget_set_size_request((int)menuHandle, (int)-1, (int)-1);
            GtkRequisition requisition = new GtkRequisition();
            OS.gtk_widget_size_request((int)menuHandle, (GtkRequisition)requisition);
            menuHeight = requisition.height;
            OS.gtk_widget_set_size_request((int)menuHandle, (int)width, (int)menuHeight);
            height = Math.max(1, height - menuHeight);
        }
        OS.gtk_fixed_move((int)this.fixedHandle, (int)this.scrolledHandle, (int)0, (int)menuHeight);
        OS.gtk_widget_set_size_request((int)this.scrolledHandle, (int)width, (int)height);
        OS.gtk_container_resize_children((int)this.fixedHandle);
        if (notify) {
            this.sendEvent(11);
            if (this.layout != null) {
                this.layout.layout(this, false);
            }
        }
    }

    boolean setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        if (move) {
            int[] x_pos = new int[1];
            int[] y_pos = new int[1];
            OS.gtk_window_get_position((int)this.shellHandle, (int[])x_pos, (int[])y_pos);
            this.oldX = x_pos[0];
            this.oldY = y_pos[0];
            OS.gtk_window_move((int)this.shellHandle, (int)x, (int)y);
        }
        if (resize) {
            int[] w = new int[1];
            int[] h = new int[1];
            OS.gtk_window_get_size((int)this.shellHandle, (int[])w, (int[])h);
            this.oldWidth = w[0];
            this.oldHeight = h[0];
            width = Math.max(1, width - this.trimWidth());
            height = Math.max(1, height - this.trimHeight());
            OS.gtk_window_resize((int)this.shellHandle, (int)width, (int)height);
            this.resizeBounds(width, height, true);
        }
        return move || resize;
    }

    public void setImeInputMode(int mode) {
        this.checkWidget();
    }

    void setInitialSize() {
        int width = OS.gdk_screen_width() * 5 / 8;
        int height = OS.gdk_screen_height() * 5 / 8;
        OS.gtk_widget_set_size_request((int)this.scrolledHandle, (int)width, (int)height);
        OS.gtk_window_resize((int)this.shellHandle, (int)width, (int)height);
        OS.gtk_container_resize_children((int)this.fixedHandle);
    }

    public void setMaximized(boolean maximized) {
        this.checkWidget();
        super.setMaximized(maximized);
        if (maximized) {
            OS.gtk_window_maximize((int)this.shellHandle);
        } else {
            OS.gtk_window_unmaximize((int)this.shellHandle);
        }
    }

    public void setMenuBar(Menu menu) {
        int menuHandle;
        boolean both;
        this.checkWidget();
        if (this.menuBar == menu) {
            return;
        }
        boolean bl = both = menu != null && this.menuBar != null;
        if (menu != null) {
            if ((menu.style & 2) == 0) {
                this.error(33);
            }
            if (menu.parent != this) {
                this.error(32);
            }
        }
        if (this.menuBar != null) {
            menuHandle = this.menuBar.handle;
            OS.gtk_widget_hide((int)menuHandle);
            this.destroyAccelGroup();
        }
        this.menuBar = menu;
        if (this.menuBar != null) {
            menuHandle = menu.handle;
            OS.gtk_widget_show((int)menuHandle);
            this.createAccelGroup();
            this.menuBar.addAccelerators(this.accelGroup);
        }
        int[] width = new int[1];
        int[] height = new int[1];
        OS.gtk_window_get_size((int)this.shellHandle, (int[])width, (int[])height);
        this.resizeBounds(width[0], height[0], !both);
    }

    public void setMinimized(boolean minimized) {
        this.checkWidget();
        if (this.minimized == minimized) {
            return;
        }
        super.setMinimized(minimized);
        if (minimized) {
            OS.gtk_window_iconify((int)this.shellHandle);
        } else {
            OS.gtk_window_deiconify((int)this.shellHandle);
            this.bringToTop(false);
        }
    }

    public void setText(String string) {
        super.setText(string);
        int length = string.length();
        char[] chars = new char[Math.max(6, length) + 1];
        string.getChars(0, length, chars, 0);
        int i = length;
        while (i < chars.length) {
            chars[i] = 32;
            ++i;
        }
        byte[] buffer = Converter.wcsToMbcs(null, chars, true);
        OS.gtk_window_set_title((int)this.shellHandle, (byte[])buffer);
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if (OS.GTK_WIDGET_MAPPED((int)this.shellHandle) == visible) {
            return;
        }
        if (visible) {
            int grabHandle = OS.gtk_grab_get_current();
            if (grabHandle != 0) {
                OS.gtk_grab_remove((int)grabHandle);
                OS.gdk_pointer_ungrab((int)0);
            }
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
            this.mapped = false;
            OS.gtk_widget_show((int)this.shellHandle);
            while (!this.isDisposed() && !this.mapped) {
                OS.gtk_main_iteration();
            }
            if (this.isDisposed()) {
                return;
            }
            this.adjustTrim();
        } else {
            OS.gtk_widget_hide((int)this.shellHandle);
            this.sendEvent(23);
        }
    }

    void setZOrder(Control sibling, boolean above) {
        this.setZOrder(sibling, above, false);
    }

    int shellMapProc(int handle, int arg0, int user_data) {
        this.mapped = true;
        return 0;
    }

    boolean traverseEscape() {
        if (this.parent == null) {
            return false;
        }
        if (!this.isVisible() || !this.isEnabled()) {
            return false;
        }
        this.close();
        return true;
    }

    int trimHeight() {
        if ((this.style & 8) != 0) {
            return 0;
        }
        boolean hasTitle = false;
        boolean hasResize = false;
        boolean hasBorder = false;
        hasTitle = (this.style & 0x4E0) != 0;
        hasResize = (this.style & 0x10) != 0;
        boolean bl = hasBorder = (this.style & 0x800) != 0;
        if (hasTitle) {
            if (hasResize) {
                return this.display.titleResizeTrimHeight;
            }
            if (hasBorder) {
                return this.display.titleBorderTrimHeight;
            }
            return this.display.titleTrimHeight;
        }
        if (hasResize) {
            return this.display.resizeTrimHeight;
        }
        if (hasBorder) {
            return this.display.borderTrimHeight;
        }
        return 0;
    }

    int trimWidth() {
        if ((this.style & 8) != 0) {
            return 0;
        }
        boolean hasTitle = false;
        boolean hasResize = false;
        boolean hasBorder = false;
        hasTitle = (this.style & 0x4E0) != 0;
        hasResize = (this.style & 0x10) != 0;
        boolean bl = hasBorder = (this.style & 0x800) != 0;
        if (hasTitle) {
            if (hasResize) {
                return this.display.titleResizeTrimWidth;
            }
            if (hasBorder) {
                return this.display.titleBorderTrimWidth;
            }
            return this.display.titleTrimWidth;
        }
        if (hasResize) {
            return this.display.resizeTrimWidth;
        }
        if (hasBorder) {
            return this.display.borderTrimWidth;
        }
        return 0;
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.shellHandle);
    }

    public void dispose() {
        Shell activeShell;
        if (this.isDisposed()) {
            return;
        }
        OS.gtk_widget_hide((int)this.shellHandle);
        if (this.parent != null && (activeShell = this.display.getActiveShell()) == this) {
            Shell shell = this.parent.getShell();
            shell.bringToTop(false);
        }
        super.dispose();
    }

    public void forceActive() {
        this.checkWidget();
        this.bringToTop(true);
    }

    public Rectangle getBounds() {
        this.checkWidget();
        int[] x = new int[1];
        int[] y = new int[1];
        OS.gtk_window_get_position((int)this.shellHandle, (int[])x, (int[])y);
        int width = OS.GTK_WIDGET_WIDTH((int)this.scrolledHandle);
        int height = OS.GTK_WIDGET_HEIGHT((int)this.scrolledHandle);
        if (this.menuBar != null) {
            int barHandle = this.menuBar.handle;
            height += OS.GTK_WIDGET_HEIGHT((int)barHandle);
        }
        return new Rectangle(x[0], y[0], width + this.trimWidth(), height + this.trimHeight());
    }

    void releaseHandle() {
        super.releaseHandle();
        this.shellHandle = 0;
    }

    void releaseShells() {
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            if (!shell.isDisposed()) {
                shell.releaseResources();
            }
            ++i;
        }
    }

    void releaseWidget() {
        this.releaseShells();
        this.destroyAccelGroup();
        super.releaseWidget();
        if (this.tooltipsHandle != 0) {
            OS.g_object_unref((int)this.tooltipsHandle);
        }
        this.tooltipsHandle = 0;
        this.lastActive = null;
    }

    void setToolTipText(int widget, String string) {
        byte[] buffer = null;
        if (string != null && string.length() > 0) {
            buffer = Converter.wcsToMbcs(null, string, true);
        }
        if (this.tooltipsHandle == 0) {
            this.tooltipsHandle = OS.gtk_tooltips_new();
            if (this.tooltipsHandle == 0) {
                this.error(2);
            }
            OS.g_object_ref((int)this.tooltipsHandle);
            OS.gtk_object_sink((int)this.tooltipsHandle);
        }
        OS.gtk_tooltips_set_tip((int)this.tooltipsHandle, (int)widget, (byte[])buffer, null);
    }
}

