/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TabFolder;

public class TabItem
extends Item {
    int labelHandle;
    int imageHandle;
    int pageHandle;
    Control control;
    TabFolder parent;
    String toolTipText;

    public TabItem(TabFolder parent, int style) {
        super(parent, style);
        this.parent = parent;
        parent.createItem(this, parent.getItemCount());
    }

    public TabItem(TabFolder parent, int style, int index) {
        super(parent, style);
        this.parent = parent;
        parent.createItem(this, index);
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public TabFolder getParent() {
        this.checkWidget();
        return this.parent;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    void releaseChild() {
        super.releaseChild();
        int index = this.parent.indexOf(this);
        if (index == this.parent.getSelectionIndex() && this.control != null) {
            this.control.setVisible(false);
        }
        this.parent.destroyItem(this);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.imageHandle = 0;
        this.labelHandle = 0;
        this.pageHandle = 0;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
    }

    public void setControl(Control control) {
        this.checkWidget();
        Control oldControl = this.control;
        Control newControl = control;
        this.control = control;
        int index = this.parent.indexOf(this);
        if (index != this.parent.getSelectionIndex()) {
            if (newControl != null) {
                newControl.setVisible(false);
            }
            return;
        }
        if (newControl != null) {
            newControl.setBounds(this.parent.getClientArea());
            newControl.setVisible(true);
        }
        if (oldControl != null) {
            oldControl.setVisible(false);
        }
    }

    void setFontDescription(int font) {
        OS.gtk_widget_modify_font((int)this.labelHandle, (int)font);
        OS.gtk_widget_modify_font((int)this.imageHandle, (int)font);
    }

    void setForegroundColor(GdkColor color) {
        OS.gtk_widget_modify_fg((int)this.labelHandle, (int)0, (GdkColor)color);
        OS.gtk_widget_modify_fg((int)this.imageHandle, (int)0, (GdkColor)color);
    }

    public void setImage(Image image) {
        this.checkWidget();
        super.setImage(image);
        if (image != null) {
            OS.gtk_image_set_from_pixmap((int)this.imageHandle, (int)image.pixmap, (int)image.mask);
            OS.gtk_widget_show((int)this.imageHandle);
        } else {
            OS.gtk_image_set_from_pixmap((int)this.imageHandle, (int)0, (int)0);
            OS.gtk_widget_hide((int)this.imageHandle);
        }
        this.parent.fixPage();
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        super.setText(string);
        char[] chars = this.fixMnemonic(string);
        byte[] buffer = Converter.wcsToMbcs(null, chars, true);
        OS.gtk_label_set_text_with_mnemonic((int)this.labelHandle, (byte[])buffer);
        if (string.length() != 0) {
            OS.gtk_widget_show((int)this.labelHandle);
        } else {
            OS.gtk_widget_hide((int)this.labelHandle);
        }
        this.parent.fixPage();
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
    }
}

