/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.engine.synthesis.text;

import com.sun.speech.engine.synthesis.BaseSynthesizerQueueItem;
import java.net.URL;
import javax.speech.synthesis.Speakable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class TextSynthesizerQueueItem
extends BaseSynthesizerQueueItem {
    public static final String JSML = "jsml";
    public static final String[] JSML_ATTRIBUTES = new String[]{"lang", "mark"};
    public static final String DIV = "div";
    public static final String[] DIV_ATTRIBUTES = new String[]{"type", "mark"};
    public static final String VOICE = "voice";
    public static final String[] VOICE_ATTRIBUTES = new String[]{"voice", "gender", "age", "variant", "name", "mark"};
    public static final String SAYAS = "sayas";
    public static final String[] SAYAS_ATTRIBUTES = new String[]{"class", "mark"};
    public static final String PHONEME = "phoneme";
    public static final String[] PHONEME_ATTRIBUTES = new String[]{"original", "mark"};
    public static final String EMPHASIS = "emphasis";
    public static final String[] EMPHASIS_ATTRIBUTES = new String[]{"level", "mark"};
    public static final String BREAK = "break";
    public static final String[] BREAK_ATTRIBUTES = new String[]{"size", "time", "mark"};
    public static final String PROSODY = "prosody";
    public static final String[] PROSODY_ATTRIBUTES = new String[]{"rate", "volume", "pitch", "range", "mark"};
    public static final String MARKER = "marker";
    public static final String[] MARKER_ATTRIBUTES = new String[]{"mark"};
    public static final String ENGINE = "engine";
    public static final String[] ENGINE_ATTRIBUTES = new String[]{"name", "data", "mark"};
    public static final String[] ELEMENTS = new String[]{"jsml", "div", "voice", "sayas", "phoneme", "emphasis", "break", "prosody", "marker", "engine"};
    public static final String[][] ELEMENT_ATTRIBUTES = new String[][]{JSML_ATTRIBUTES, DIV_ATTRIBUTES, VOICE_ATTRIBUTES, SAYAS_ATTRIBUTES, PHONEME_ATTRIBUTES, EMPHASIS_ATTRIBUTES, BREAK_ATTRIBUTES, PROSODY_ATTRIBUTES, MARKER_ATTRIBUTES, ENGINE_ATTRIBUTES};
    public static final String COMMAND_PREFIX = "/";
    public static final String COMMAND_SUFFIX = "/";
    public static final String DATA_PREFIX = "[";
    public static final String DATA_SUFFIX = "]";
    public static final String ELEMENT_START = "start";
    public static final String ELEMENT_END = "end";

    public String getTypeString() {
        if (this.isPlainText()) {
            return "Plain-text String";
        }
        if (this.getSource() instanceof String) {
            return "JSML from String";
        }
        if (this.getSource() instanceof Speakable) {
            return "JSML from Speakable";
        }
        if (this.getSource() instanceof URL) {
            return "JSML from URL";
        }
        return "Unknown Output";
    }

    protected void linearize(Node node, StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = this.processNode(node, stringBuffer);
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            this.linearize(node2, stringBuffer);
            node2 = node2.getNextSibling();
        }
        if (stringBuffer2 != null) {
            stringBuffer.append(stringBuffer2);
        }
    }

    protected StringBuffer processNode(Node node, StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = null;
        short s = node.getNodeType();
        switch (s) {
            case 2: {
                break;
            }
            case 9: {
                break;
            }
            case 1: {
                stringBuffer2 = this.processElement((Element)node, stringBuffer);
                break;
            }
            case 3: {
                stringBuffer.append(((Text)node).getData());
                break;
            }
            case 7: {
                break;
            }
            case 10: {
                break;
            }
            case 12: {
                break;
            }
            case 8: {
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 11: {
                break;
            }
        }
        return stringBuffer2;
    }

    protected StringBuffer processElement(Element element, StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = null;
        String string = element.getTagName();
        int n = 0;
        while (n < ELEMENTS.length) {
            if (ELEMENTS[n].equals(string)) {
                stringBuffer2 = this.processAttributes(element, ELEMENT_ATTRIBUTES[n]);
                break;
            }
            ++n;
        }
        stringBuffer.append("/" + string + " " + ELEMENT_START);
        if (stringBuffer2 != null) {
            stringBuffer.append(stringBuffer2);
        }
        stringBuffer.append("/");
        StringBuffer stringBuffer3 = new StringBuffer("/" + string + " " + ELEMENT_END);
        if (stringBuffer2 != null) {
            stringBuffer3.append(stringBuffer2);
        }
        stringBuffer3.append("/");
        return stringBuffer3;
    }

    protected StringBuffer processAttributes(Element element, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            if (element.hasAttribute(stringArray[n])) {
                String string = element.getAttribute(stringArray[n]);
                stringBuffer.append(DATA_PREFIX + stringArray[n] + "=" + string + DATA_SUFFIX);
            }
            ++n;
        }
        return stringBuffer;
    }

    public String getEngineText() {
        if (this.isPlainText()) {
            return this.text;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Document document = this.getDocument();
        this.linearize(document, stringBuffer);
        return stringBuffer.toString();
    }
}

