/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts;

import com.sun.speech.freetts.InputMode;
import com.sun.speech.freetts.Voice;
import com.sun.speech.freetts.VoiceManager;
import com.sun.speech.freetts.audio.AudioPlayer;
import com.sun.speech.freetts.audio.JavaClipAudioPlayer;
import com.sun.speech.freetts.audio.JavaStreamingAudioPlayer;
import com.sun.speech.freetts.audio.MultiFileAudioPlayer;
import com.sun.speech.freetts.audio.NullAudioPlayer;
import com.sun.speech.freetts.audio.RawFileAudioPlayer;
import com.sun.speech.freetts.audio.SingleFileAudioPlayer;
import com.sun.speech.freetts.en.us.CMUDiphoneVoice;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioSystem;

public class FreeTTS {
    private static final String VERSION = "freetts Version 1.1.1, Aug 29, 2002";
    private Voice voice;
    private static AudioPlayer audioPlayer = null;
    private boolean silent = false;
    private String audioFile = null;
    private boolean multiAudio = false;
    private boolean streamingAudio = false;
    private InputMode inputMode = InputMode.INTERACTIVE;

    public FreeTTS() {
        this(new CMUDiphoneVoice(true));
        this.voice.getFeatures().setString("databaseName", "cmu_kal/diphone_units16.bin");
    }

    public FreeTTS(Voice voice) {
        this.voice = voice;
    }

    public void startup() {
        this.voice.load();
        if (!this.getSilentMode()) {
            if (this.streamingAudio) {
                audioPlayer = new JavaStreamingAudioPlayer();
            } else if (this.audioFile != null) {
                AudioFileFormat.Type type = this.getAudioType(this.audioFile);
                if (type != null) {
                    audioPlayer = this.multiAudio ? new MultiFileAudioPlayer(FreeTTS.getBasename(this.audioFile), type) : new SingleFileAudioPlayer(FreeTTS.getBasename(this.audioFile), type);
                } else {
                    try {
                        audioPlayer = new RawFileAudioPlayer(this.audioFile);
                    }
                    catch (IOException iOException) {
                        System.out.println("Can't open " + this.audioFile + " " + iOException);
                    }
                }
            } else {
                audioPlayer = new JavaClipAudioPlayer();
            }
        }
        if (audioPlayer == null) {
            audioPlayer = new NullAudioPlayer();
        }
        this.voice.setAudioPlayer(audioPlayer);
    }

    private AudioFileFormat.Type getAudioType(String string) {
        AudioFileFormat.Type[] typeArray = AudioSystem.getAudioFileTypes();
        String string2 = FreeTTS.getExtension(string);
        int n = 0;
        while (n < typeArray.length) {
            if (typeArray[n].getExtension().equals(string2)) {
                return typeArray[n];
            }
            ++n;
        }
        return null;
    }

    private static String getExtension(String string) {
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return null;
        }
        return string.substring(n + 1);
    }

    private static String getBasename(String string) {
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public void shutdown() {
        audioPlayer.close();
        this.voice.close();
    }

    public boolean textToSpeech(String string) {
        return this.voice.speak(string);
    }

    private boolean batchTextToSpeech(String string) {
        this.voice.startBatch();
        boolean bl = this.textToSpeech(string);
        this.voice.endBatch();
        return bl;
    }

    private boolean lineToSpeech(String string) {
        boolean bl = true;
        this.voice.startBatch();
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null && bl) {
                bl = this.textToSpeech(string2);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            this.voice.error("can't read " + string);
        }
        this.voice.endBatch();
        return bl;
    }

    protected Voice getVoice() {
        return this.voice;
    }

    public boolean streamToSpeech(InputStream inputStream) {
        this.voice.startBatch();
        boolean bl = this.voice.speak(inputStream);
        this.voice.endBatch();
        return bl;
    }

    public boolean urlToSpeech(String string) {
        boolean bl = false;
        try {
            URL uRL = new URL(string);
            InputStream inputStream = uRL.openStream();
            bl = this.streamToSpeech(inputStream);
        }
        catch (IOException iOException) {
            System.err.println("Can't read data from " + string);
        }
        return bl;
    }

    public boolean fileToSpeech(String string) {
        boolean bl = false;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            bl = this.streamToSpeech(fileInputStream);
        }
        catch (IOException iOException) {
            System.err.println("Can't read data from " + string);
        }
        return bl;
    }

    public void setSilentMode(boolean bl) {
        this.silent = bl;
    }

    public boolean getSilentMode() {
        return this.silent;
    }

    public void setInputMode(InputMode inputMode) {
        this.inputMode = inputMode;
    }

    public InputMode getInputMode() {
        return this.inputMode;
    }

    public void setAudioFile(String string) {
        this.audioFile = string;
    }

    public void setMultiAudio(boolean bl) {
        this.multiAudio = bl;
    }

    public void setStreamingAudio(boolean bl) {
        this.streamingAudio = bl;
    }

    static void usage(String string) {
        System.out.println(VERSION);
        System.out.println("Usage:");
        System.out.println("    -detailedMetrics: turn on detailed metrics");
        System.out.println("    -dumpAudio file : dump audio to file ");
        System.out.println("    -dumpAudioTypes : dump the possible output types");
        System.out.println("    -dumpMultiAudio file : dump audio to file ");
        System.out.println("    -dumpRelations  : dump the relations ");
        System.out.println("    -dumpUtterance  : dump the final utterance");
        System.out.println("    -dumpWave file  : dump the final wave to file");
        System.out.println("    -file file      : speak text from given file");
        System.out.println("    -lines file     : render lines from a file");
        System.out.println("    -help           : shows usage information");
        System.out.println("    -metrics        : turn on metrics");
        System.out.println("    -run  name      : sets the name of the run");
        System.out.println("    -silent         : don't say anything");
        System.out.println("    -streaming      : use streaming audio player");
        System.out.println("    -text say me    : speak given text");
        System.out.println("    -url path       : speak text from given URL");
        System.out.println("    -verbose        : verbose output");
        System.out.println("    -version        : shows version number");
        System.out.println("    -voice VOICE    : " + string);
    }

    private static void interactiveMode(FreeTTS freeTTS) {
        try {
            while (true) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                System.out.print("Enter text: ");
                System.out.flush();
                String string = bufferedReader.readLine();
                if (string == null || string.length() == 0) {
                    freeTTS.shutdown();
                    System.exit(0);
                    continue;
                }
                freeTTS.batchTextToSpeech(string);
            }
        }
        catch (IOException iOException) {
            return;
        }
    }

    private static void dumpAudioTypes() {
        AudioFileFormat.Type[] typeArray = AudioSystem.getAudioFileTypes();
        int n = 0;
        while (n < typeArray.length) {
            System.out.println(typeArray[n].getExtension());
            ++n;
        }
    }

    public static void main(String[] stringArray) {
        Object object;
        String string = null;
        String string2 = null;
        Object var3_3 = null;
        boolean bl = false;
        Voice voice = null;
        VoiceManager voiceManager = new VoiceManager();
        String string3 = voiceManager.toString();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-voice")) {
                if (++n < stringArray.length) {
                    object = stringArray[n];
                    if (voiceManager.contains((String)object)) {
                        voice = voiceManager.getVoice((String)object);
                        break;
                    }
                    System.out.println("Invalid voice: " + (String)object);
                    System.out.println("  Valid voices are " + string3);
                    System.exit(1);
                    break;
                }
                FreeTTS.usage(string3);
                System.exit(1);
                break;
            }
            ++n;
        }
        if (voice == null) {
            voice = voiceManager.getVoice("kevin");
        }
        object = new FreeTTS(voice);
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].equals("-metrics")) {
                voice.setMetrics(true);
            } else if (stringArray[n2].equals("-detailedMetrics")) {
                voice.setDetailedMetrics(true);
            } else if (stringArray[n2].equals("-silent")) {
                ((FreeTTS)object).setSilentMode(true);
            } else if (stringArray[n2].equals("-streaming")) {
                ((FreeTTS)object).setStreamingAudio(true);
            } else if (stringArray[n2].equals("-verbose")) {
                voice.setVerbose(true);
            } else if (stringArray[n2].equals("-dumpUtterance")) {
                voice.setDumpUtterance(true);
            } else if (stringArray[n2].equals("-dumpAudioTypes")) {
                bl = true;
            } else if (stringArray[n2].equals("-dumpRelations")) {
                voice.setDumpRelations(true);
            } else if (stringArray[n2].equals("-dumpWave")) {
                if (++n2 < stringArray.length) {
                    voice.setWaveDumpFile(stringArray[n2]);
                } else {
                    FreeTTS.usage(string3);
                }
            } else if (stringArray[n2].equals("-dumpAudio")) {
                if (++n2 < stringArray.length) {
                    ((FreeTTS)object).setAudioFile(stringArray[n2]);
                } else {
                    FreeTTS.usage(string3);
                }
            } else if (stringArray[n2].equals("-dumpMultiAudio")) {
                if (++n2 < stringArray.length) {
                    ((FreeTTS)object).setAudioFile(stringArray[n2]);
                    ((FreeTTS)object).setMultiAudio(true);
                } else {
                    FreeTTS.usage(string3);
                }
            } else if (stringArray[n2].equals("-version")) {
                System.out.println(VERSION);
            } else if (stringArray[n2].equals("-voice")) {
                ++n2;
            } else if (stringArray[n2].equals("-help")) {
                FreeTTS.usage(string3);
            } else {
                if (stringArray[n2].equals("-text")) {
                    ((FreeTTS)object).setInputMode(InputMode.TEXT);
                    StringBuffer stringBuffer = new StringBuffer();
                    int n3 = n2 + 1;
                    while (n3 < stringArray.length) {
                        stringBuffer.append(stringArray[n3]);
                        stringBuffer.append(" ");
                        ++n3;
                    }
                    string = stringBuffer.toString();
                    break;
                }
                if (stringArray[n2].equals("-file")) {
                    if (++n2 < stringArray.length) {
                        string2 = stringArray[n2];
                        ((FreeTTS)object).setInputMode(InputMode.FILE);
                    } else {
                        FreeTTS.usage(string3);
                    }
                } else if (stringArray[n2].equals("-lines")) {
                    if (++n2 < stringArray.length) {
                        string2 = stringArray[n2];
                        ((FreeTTS)object).setInputMode(InputMode.LINES);
                    } else {
                        FreeTTS.usage(string3);
                    }
                } else if (stringArray[n2].equals("-url")) {
                    if (++n2 < stringArray.length) {
                        string2 = stringArray[n2];
                        ((FreeTTS)object).setInputMode(InputMode.URL);
                    } else {
                        FreeTTS.usage(string3);
                    }
                } else if (stringArray[n2].equals("-run")) {
                    if (++n2 < stringArray.length) {
                        voice.setRunTitle(stringArray[n2]);
                    } else {
                        FreeTTS.usage(string3);
                    }
                } else {
                    System.out.println("Unknown option:" + stringArray[n2]);
                }
            }
            ++n2;
        }
        if (bl) {
            FreeTTS.dumpAudioTypes();
        }
        ((FreeTTS)object).startup();
        if (((FreeTTS)object).getInputMode() == InputMode.TEXT) {
            super.batchTextToSpeech(string);
        } else if (((FreeTTS)object).getInputMode() == InputMode.FILE) {
            ((FreeTTS)object).fileToSpeech(string2);
        } else if (((FreeTTS)object).getInputMode() == InputMode.URL) {
            ((FreeTTS)object).urlToSpeech(string2);
        } else if (((FreeTTS)object).getInputMode() == InputMode.LINES) {
            super.lineToSpeech(string2);
        } else {
            FreeTTS.interactiveMode((FreeTTS)object);
        }
        if (!((FreeTTS)object).getVoice().isMetrics() || !((FreeTTS)object).getSilentMode()) {
            // empty if block
        }
        ((FreeTTS)object).shutdown();
        System.exit(0);
    }
}

