/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts;

import com.sun.speech.freetts.Dumpable;
import com.sun.speech.freetts.FeatureProcessor;
import com.sun.speech.freetts.FeatureSet;
import com.sun.speech.freetts.ItemContents;
import com.sun.speech.freetts.ProcessException;
import com.sun.speech.freetts.Relation;
import com.sun.speech.freetts.Utterance;
import com.sun.speech.freetts.Voice;
import java.io.PrintWriter;
import java.util.StringTokenizer;

public class Item
implements Dumpable {
    private Relation ownerRelation;
    private ItemContents contents;
    private Item parent;
    private Item daughter;
    private Item next;
    private Item prev;

    public Item(Relation relation, ItemContents itemContents) {
        this.ownerRelation = relation;
        this.contents = itemContents != null ? itemContents : new ItemContents();
        this.parent = null;
        this.daughter = null;
        this.next = null;
        this.prev = null;
        this.getSharedContents().addItemRelation(relation.getName(), this);
    }

    public Item getItemAs(String string) {
        return this.getSharedContents().getItemRelation(string);
    }

    public Relation getOwnerRelation() {
        return this.ownerRelation;
    }

    public ItemContents getSharedContents() {
        return this.contents;
    }

    public boolean hasDaughters() {
        return this.daughter != null;
    }

    public Item getDaughter() {
        return this.daughter;
    }

    public Item getNthDaughter(int n) {
        Item item = this.daughter;
        int n2 = 0;
        while (n2++ != n && item != null) {
            item = item.next;
        }
        return item;
    }

    /*
     * Unable to fully structure code
     */
    public Item getLastDaughter() {
        var1_1 = this.daughter;
        if (var1_1 != null) ** GOTO lbl5
        return null;
lbl-1000:
        // 1 sources

        {
            var1_1 = var1_1.next;
lbl5:
            // 2 sources

            ** while (var1_1.next != null)
        }
lbl6:
        // 1 sources

        return var1_1;
    }

    public Item addDaughter(Item item) {
        Item item2;
        Item item3 = this.getLastDaughter();
        if (item3 != null) {
            item2 = item3.appendItem(item);
        } else {
            ItemContents itemContents = item == null ? new ItemContents() : item.getSharedContents();
            item2 = new Item(this.getOwnerRelation(), itemContents);
            item2.parent = this;
            this.daughter = item2;
        }
        return item2;
    }

    public Item createDaughter() {
        return this.addDaughter(null);
    }

    public Item getParent() {
        Item item = this;
        while (item.prev != null) {
            if (item == null) {
                return null;
            }
            item = item.prev;
        }
        return item.parent;
    }

    public Utterance getUtterance() {
        return this.getOwnerRelation().getUtterance();
    }

    public FeatureSet getFeatures() {
        return this.getSharedContents().getFeatures();
    }

    public void dump(PrintWriter printWriter, int n, String string) {
        String string2 = string + ":" + this.toString();
        this.getFeatures().dump(printWriter, n, string2);
        if (this.hasDaughters()) {
            Item item = this.getDaughter();
            while (item != null) {
                item.dump(printWriter, n + 8, "d");
                item = item.next;
            }
        }
    }

    public Object findFeature(String string) {
        String string2;
        String string3;
        Voice voice = this.getOwnerRelation().getUtterance().getVoice();
        Object object = null;
        int n = string.lastIndexOf(".");
        if (n == -1) {
            string3 = string;
            string2 = null;
        } else {
            string3 = string.substring(n + 1);
            string2 = string.substring(0, n);
        }
        Item item = this.findItem(string2);
        if (item != null) {
            FeatureProcessor featureProcessor = voice.getFeatureProcessor(string3);
            if (featureProcessor != null) {
                try {
                    object = featureProcessor.process(item);
                }
                catch (ProcessException processException) {
                    System.err.println("Trouble while processing " + featureProcessor.toString());
                }
            } else {
                object = item.getFeatures().getObject(string3);
            }
        }
        object = object == null ? "0" : object;
        return object;
    }

    public Item findItem(String string) {
        Item item = this;
        if (string == null) {
            return this;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":.");
        while (item != null && stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("n")) {
                item = item.getNext();
                continue;
            }
            if (string2.equals("p")) {
                item = item.getPrevious();
                continue;
            }
            if (string2.equals("nn")) {
                if ((item = item.getNext()) == null) continue;
                item = item.getNext();
                continue;
            }
            if (string2.equals("pp")) {
                if ((item = item.getPrevious()) == null) continue;
                item = item.getPrevious();
                continue;
            }
            if (string2.equals("parent")) {
                item = item.getParent();
                continue;
            }
            if (string2.equals("daughter")) {
                item = item.getDaughter();
                continue;
            }
            if (string2.equals("daughtern")) {
                item = item.getLastDaughter();
                continue;
            }
            if (string2.equals("R")) {
                String string3 = stringTokenizer.nextToken();
                item = item.getSharedContents().getItemRelation(string3);
                continue;
            }
            System.out.println("findItem: bad feature " + string2 + " in " + string);
        }
        return item;
    }

    public Item getNext() {
        return this.next;
    }

    public Item getPrevious() {
        return this.prev;
    }

    public Item appendItem(Item item) {
        ItemContents itemContents = item == null ? null : item.getSharedContents();
        Item item2 = new Item(this.getOwnerRelation(), itemContents);
        item2.next = this.next;
        if (this.next != null) {
            this.next.prev = item2;
        }
        this.attach(item2);
        if (this.ownerRelation.getTail() == this) {
            this.ownerRelation.setTail(item2);
        }
        return item2;
    }

    void attach(Item item) {
        this.next = item;
        item.prev = this;
    }

    public Item prependItem(Item item) {
        ItemContents itemContents = item == null ? null : item.getSharedContents();
        Item item2 = new Item(this.getOwnerRelation(), itemContents);
        item2.prev = this.prev;
        if (this.prev != null) {
            this.prev.next = item2;
        }
        item2.next = this;
        this.prev = item2;
        if (this.parent != null) {
            this.parent.daughter = item2;
            item2.parent = this.parent;
            this.parent = null;
        }
        if (this.ownerRelation.getHead() == this) {
            this.ownerRelation.setHead(item2);
        }
        return item2;
    }

    public String toString() {
        String string = this.getFeatures().getString("name");
        if (string == null) {
            string = "";
        }
        return string;
    }

    public boolean equalsShared(Item item) {
        if (item == null) {
            return false;
        }
        return this.getSharedContents().equals(item.getSharedContents());
    }
}

