/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts;

import com.sun.speech.freetts.Dumpable;
import com.sun.speech.freetts.Item;
import com.sun.speech.freetts.ItemContents;
import com.sun.speech.freetts.Utterance;
import com.sun.speech.freetts.util.Utilities;
import java.io.PrintWriter;

public class Relation
implements Dumpable {
    private String name;
    private Utterance owner;
    private Item head;
    private Item tail;
    public static final String TOKEN = "Token";
    public static final String WORD = "Word";
    public static final String PHRASE = "Phrase";
    public static final String SEGMENT = "Segment";
    public static final String SYLLABLE = "Syllable";
    public static final String SYLLABLE_STRUCTURE = "SylStructure";
    public static final String TARGET = "Target";
    public static final String UNIT = "Unit";

    Relation(String string, Utterance utterance) {
        this.name = string;
        this.owner = utterance;
        this.head = null;
        this.tail = null;
    }

    public String getName() {
        return this.name;
    }

    public Item getHead() {
        return this.head;
    }

    void setHead(Item item) {
        this.head = item;
    }

    public Item getTail() {
        return this.tail;
    }

    void setTail(Item item) {
        this.tail = item;
    }

    public Item appendItem() {
        return this.appendItem(null);
    }

    public Item appendItem(Item item) {
        ItemContents itemContents = item == null ? null : item.getSharedContents();
        Item item2 = new Item(this, itemContents);
        if (this.head == null) {
            this.head = item2;
        }
        if (this.tail != null) {
            this.tail.attach(item2);
        }
        this.tail = item2;
        return item2;
    }

    public Utterance getUtterance() {
        return this.owner;
    }

    public void dump(PrintWriter printWriter, int n, String string) {
        Utilities.dump(printWriter, n, "========= Relation: " + string + " =========");
        Item item = this.head;
        while (item != null) {
            item.dump(printWriter, n + 4, string);
            item = item.getNext();
        }
    }
}

