/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.audio;

import com.sun.speech.freetts.audio.AudioPlayer;
import com.sun.speech.freetts.util.BulkTimer;
import com.sun.speech.freetts.util.Utilities;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;

public class JavaClipAudioPlayer
implements AudioPlayer {
    private volatile boolean paused;
    private volatile boolean done = false;
    private volatile boolean cancelled = false;
    private volatile Clip currentClip;
    private float volume = 1.0f;
    private boolean debug = false;
    private BulkTimer timer = new BulkTimer();
    private AudioFormat defaultFormat;
    private AudioFormat currentFormat = this.defaultFormat = new AudioFormat(8000.0f, 16, 1, true, true);
    private boolean firstSample = true;
    private int curIndex = 0;
    private byte[] outputData;
    private LineListener lineListener = new JavaClipLineListener();
    private long closeDelay;
    static /* synthetic */ Class class$javax$sound$sampled$Clip;

    public JavaClipAudioPlayer() {
        this.debug = Utilities.getBoolean("com.sun.speech.freetts.audio.AudioPlayer.debug");
        this.closeDelay = Utilities.getLong("com.sun.speech.freetts.audio.AudioPlayer.closeDelay", 150L);
        this.setPaused(false);
    }

    public synchronized void setAudioFormat(AudioFormat audioFormat) {
        this.currentFormat = audioFormat;
    }

    public AudioFormat getAudioFormat() {
        return this.currentFormat;
    }

    public synchronized void pause() {
        if (!this.isPaused()) {
            this.setPaused(true);
            Clip clip = this.currentClip;
            if (clip != null) {
                clip.stop();
            }
        }
    }

    public synchronized void resume() {
        if (this.isPaused()) {
            this.setPaused(false);
            Clip clip = this.currentClip;
            if (clip != null) {
                clip.start();
            }
            this.notify();
        }
    }

    public synchronized void cancel() {
        this.cancelled = true;
        Clip clip = this.currentClip;
        if (clip != null) {
            clip.close();
        }
    }

    public synchronized void reset() {
        this.timer.start("speakableOut");
    }

    public boolean drain() {
        this.timer.stop("speakableOut");
        return true;
    }

    public synchronized void close() {
        this.done = true;
        this.notify();
    }

    public float getVolume() {
        return this.volume;
    }

    public void setVolume(float f) {
        if (f > 1.0f) {
            f = 1.0f;
        }
        if (f < 0.0f) {
            f = 0.0f;
        }
        this.volume = f;
        Clip clip = this.currentClip;
        if (clip != null) {
            this.setVolume(clip, f);
        }
    }

    private void setPaused(boolean bl) {
        this.paused = bl;
    }

    private boolean isPaused() {
        return this.paused;
    }

    private void setVolume(Clip clip, float f) {
        if (clip.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
            FloatControl floatControl = (FloatControl)clip.getControl(FloatControl.Type.MASTER_GAIN);
            float f2 = floatControl.getMaximum() - floatControl.getMinimum();
            floatControl.setValue(f * f2 + floatControl.getMinimum());
        }
    }

    public synchronized long getTime() {
        return -1L;
    }

    public synchronized void resetTime() {
    }

    public void begin(int n) {
        this.cancelled = false;
        this.timer.start("utteranceOutput");
        this.curIndex = 0;
        this.outputData = new byte[n];
    }

    public synchronized boolean end() {
        boolean bl = true;
        while (!this.done && !this.cancelled && this.isPaused()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
        if (this.done || this.cancelled) {
            this.cancelled = false;
            return false;
        }
        this.timer.start("clipGeneration");
        try {
            DataLine.Info info = new DataLine.Info(class$javax$sound$sampled$Clip == null ? (class$javax$sound$sampled$Clip = JavaClipAudioPlayer.class$("javax.sound.sampled.Clip")) : class$javax$sound$sampled$Clip, this.currentFormat);
            Clip clip = (Clip)AudioSystem.getLine(info);
            clip.addLineListener(this.lineListener);
            clip.open(this.currentFormat, this.outputData, 0, this.outputData.length);
            this.setVolume(clip, this.volume);
            if (this.currentClip != null) {
                throw new IllegalStateException("clip already set");
            }
            this.currentClip = clip;
            clip.start();
            try {
                while (this.currentClip != null) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                bl = false;
            }
        }
        catch (LineUnavailableException lineUnavailableException) {
            System.err.println("Line unavailable");
            System.err.println("Format is " + this.currentFormat);
            bl = false;
        }
        this.timer.stop("clipGeneration");
        this.timer.stop("utteranceOutput");
        bl = !this.cancelled;
        this.cancelled = false;
        return bl;
    }

    public boolean write(byte[] byArray) {
        return this.write(byArray, 0, byArray.length);
    }

    public boolean write(byte[] byArray, int n, int n2) {
        if (this.firstSample) {
            this.firstSample = false;
            this.timer.stop("firstAudio");
        }
        System.arraycopy(byArray, n, this.outputData, this.curIndex, n2);
        this.curIndex += n2;
        return true;
    }

    public String toString() {
        return "JavaClipAudioPlayer";
    }

    private void debugPrint(String string) {
        if (this.debug) {
            System.out.println(this.toString() + ": " + string);
        }
    }

    public void showMetrics() {
        this.timer.show(this.toString());
    }

    public void startFirstSampleTimer() {
        this.timer.start("firstAudio");
        this.firstSample = true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class JavaClipLineListener
    implements LineListener {
        private JavaClipLineListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(LineEvent lineEvent) {
            if (lineEvent.getType().equals(LineEvent.Type.START)) {
                JavaClipAudioPlayer.this.debugPrint("Event  START");
            } else {
                if (lineEvent.getType().equals(LineEvent.Type.STOP)) {
                    JavaClipAudioPlayer.this.debugPrint("Event  STOP");
                    JavaClipAudioPlayer javaClipAudioPlayer = JavaClipAudioPlayer.this;
                    synchronized (javaClipAudioPlayer) {
                        if (!JavaClipAudioPlayer.this.cancelled && !JavaClipAudioPlayer.this.isPaused()) {
                            try {
                                if (JavaClipAudioPlayer.this.closeDelay > 0L) {
                                    Thread.sleep(JavaClipAudioPlayer.this.closeDelay);
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            JavaClipAudioPlayer.this.currentClip.close();
                        }
                    }
                }
                if (lineEvent.getType().equals(LineEvent.Type.OPEN)) {
                    JavaClipAudioPlayer.this.debugPrint("Event OPEN");
                } else if (lineEvent.getType().equals(LineEvent.Type.CLOSE)) {
                    JavaClipAudioPlayer.this.debugPrint("EVNT CLOSE");
                    JavaClipAudioPlayer javaClipAudioPlayer = JavaClipAudioPlayer.this;
                    synchronized (javaClipAudioPlayer) {
                        JavaClipAudioPlayer.this.currentClip = null;
                        JavaClipAudioPlayer.this.notify();
                    }
                }
            }
        }
    }
}

