/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.en.us;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.StringTokenizer;

public class PronounceableFSM {
    private static final String VOCAB_SIZE = "VOCAB_SIZE";
    private static final String NUM_OF_TRANSITIONS = "NUM_OF_TRANSITIONS";
    private static final String TRANSITIONS = "TRANSITIONS";
    protected int vocabularySize;
    protected int[] transitions;
    protected boolean scanFromFront;

    public PronounceableFSM(URL uRL, boolean bl) throws IOException {
        this.scanFromFront = bl;
        InputStream inputStream = uRL.openStream();
        this.loadText(inputStream);
        inputStream.close();
    }

    public PronounceableFSM(int n, int[] nArray, boolean bl) {
        this.vocabularySize = n;
        this.transitions = nArray;
        this.scanFromFront = bl;
    }

    private void loadText(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            if (string.startsWith("***")) continue;
            if (string.startsWith(VOCAB_SIZE)) {
                this.vocabularySize = this.parseLastInt(string);
                continue;
            }
            if (string.startsWith(NUM_OF_TRANSITIONS)) {
                int n = this.parseLastInt(string);
                this.transitions = new int[n];
                continue;
            }
            if (!string.startsWith(TRANSITIONS)) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            String string2 = stringTokenizer.nextToken();
            int n = 0;
            while (stringTokenizer.hasMoreTokens() && n < this.transitions.length) {
                string2 = stringTokenizer.nextToken().trim();
                this.transitions[n++] = Integer.parseInt(string2);
            }
        }
        bufferedReader.close();
    }

    private int parseLastInt(String string) {
        String string2 = string.trim().substring(string.lastIndexOf(" "));
        return Integer.parseInt(string2.trim());
    }

    private int transition(int n, int n2) {
        int n3 = n;
        while (n3 < this.transitions.length) {
            if (this.transitions[n3] % this.vocabularySize == n2) {
                return this.transitions[n3] / this.vocabularySize;
            }
            ++n3;
        }
        return -1;
    }

    public boolean accept(String string) {
        int n;
        int n2 = this.transition(0, 35);
        int n3 = string.length() - 1;
        int n4 = n = this.scanFromFront ? 0 : n3;
        while (0 <= n4 && n4 <= n3) {
            char c = string.charAt(n4);
            int n5 = c == 'n' || c == 'm' ? 78 : ("aeiouy".indexOf(c) != -1 ? 86 : (int)c);
            if ((n2 = this.transition(n2, n5)) == -1) {
                return false;
            }
            if (n5 == 86) {
                return true;
            }
            if (this.scanFromFront) {
                ++n4;
                continue;
            }
            --n4;
        }
        return false;
    }
}

