/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.lexicon;

import com.sun.speech.freetts.lexicon.LetterToSound;
import com.sun.speech.freetts.lexicon.LetterToSoundImpl;
import com.sun.speech.freetts.lexicon.Lexicon;
import com.sun.speech.freetts.util.BulkTimer;
import com.sun.speech.freetts.util.Utilities;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public abstract class LexiconImpl
implements Lexicon {
    protected boolean tokenizeOnLoad = false;
    protected boolean tokenizeOnLookup = false;
    private static final int MAGIC = 12237598;
    private static final int VERSION = 1;
    private URL compiledURL;
    private URL addendaURL;
    private URL letterToSoundURL;
    private Map addenda;
    private Map compiled;
    private LetterToSound letterToSound = null;
    private ArrayList partsOfSpeech = new ArrayList();
    private boolean loaded = false;
    private boolean binary = false;
    private static final String[] NO_PHONES = new String[0];
    private char[] charBuffer = new char[128];
    private boolean useNewIO = Utilities.getProperty("com.sun.speech.freetts.useNewIO", "true").equals("true");

    public LexiconImpl(URL uRL, URL uRL2, URL uRL3, boolean bl) {
        this();
        this.setLexiconParameters(uRL, uRL2, uRL3, bl);
    }

    public LexiconImpl() {
        String string = Utilities.getProperty("com.sun.speech.freetts.lexicon.LexTokenize", "never");
        this.tokenizeOnLoad = string.equals("load");
        this.tokenizeOnLookup = string.equals("lookup");
    }

    protected void setLexiconParameters(URL uRL, URL uRL2, URL uRL3, boolean bl) {
        this.compiledURL = uRL;
        this.addendaURL = uRL2;
        this.letterToSoundURL = uRL3;
        this.binary = bl;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void load() throws IOException {
        BulkTimer.LOAD.start("Lexicon");
        if (this.compiledURL == null) {
            throw new IOException("Can't load lexicon");
        }
        if (this.addendaURL == null) {
            throw new IOException("Can't load lexicon addenda ");
        }
        InputStream inputStream = Utilities.getInputStream(this.compiledURL);
        if (inputStream == null) {
            throw new IOException("Can't load lexicon from " + this.compiledURL);
        }
        InputStream inputStream2 = Utilities.getInputStream(this.addendaURL);
        if (inputStream2 == null) {
            throw new IOException("Can't load lexicon addenda from " + this.addendaURL);
        }
        this.addenda = this.createLexicon(inputStream2, this.binary, 50);
        this.compiled = this.createLexicon(inputStream, this.binary, 65000);
        inputStream2.close();
        inputStream.close();
        this.loaded = true;
        BulkTimer.LOAD.stop("Lexicon");
        this.letterToSound = new LetterToSoundImpl(this.letterToSoundURL, this.binary);
    }

    protected Map createLexicon(InputStream inputStream, boolean bl, int n) throws IOException {
        if (bl) {
            if (this.useNewIO && inputStream instanceof FileInputStream) {
                FileInputStream fileInputStream = (FileInputStream)inputStream;
                return this.loadMappedBinaryLexicon(fileInputStream, n);
            }
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
            return this.loadBinaryLexicon(dataInputStream, n);
        }
        return this.loadTextLexicon(inputStream, n);
    }

    protected Map loadTextLexicon(InputStream inputStream, int n) throws IOException {
        LinkedHashMap linkedHashMap = new LinkedHashMap(n * 4 / 3);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string = bufferedReader.readLine();
        while (string != null) {
            if (!string.startsWith("***")) {
                this.parseAndAdd(linkedHashMap, string);
            }
            string = bufferedReader.readLine();
        }
        return linkedHashMap;
    }

    protected void parseAndAdd(Map map, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        String string2 = null;
        String string3 = stringTokenizer.nextToken();
        String string4 = string3.substring(string3.length() - 1);
        if (!this.partsOfSpeech.contains(string4)) {
            this.partsOfSpeech.add(string4);
        }
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        if (string2 != null && this.tokenizeOnLoad) {
            map.put(string3, this.getPhones(string2));
        } else if (string2 == null) {
            map.put(string3, NO_PHONES);
        } else {
            map.put(string3, string2);
        }
    }

    public String[] getPhones(String string, String string2) {
        String[] stringArray = this.getPhones(this.addenda, string, string2);
        if (stringArray == null) {
            stringArray = this.getPhones(this.compiled, string, string2);
        }
        if (stringArray == null && this.letterToSound != null) {
            stringArray = this.letterToSound.getPhones(string, string2);
        }
        String[] stringArray2 = new String[stringArray.length];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        return stringArray2;
    }

    protected String[] getPhones(Map map, String string, String string2) {
        string2 = LexiconImpl.fixPartOfSpeech(string2);
        String[] stringArray = this.getPhones(map, string + string2);
        int n = 0;
        while (n < this.partsOfSpeech.size() && stringArray == null) {
            if (!string2.equals((String)this.partsOfSpeech.get(n))) {
                stringArray = this.getPhones(map, string + (String)this.partsOfSpeech.get(n));
            }
            ++n;
        }
        return stringArray;
    }

    protected String[] getPhones(Map map, String string) {
        Object v = map.get(string);
        if (v instanceof String[]) {
            return (String[])v;
        }
        if (v instanceof String) {
            String[] stringArray = this.getPhones((String)v);
            if (this.tokenizeOnLookup) {
                map.put(string, stringArray);
            }
            return stringArray;
        }
        return null;
    }

    protected String[] getPhones(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList.toArray(new String[0]);
    }

    public void addAddendum(String string, String string2, String[] stringArray) {
        String string3 = LexiconImpl.fixPartOfSpeech(string2);
        if (!this.partsOfSpeech.contains(string3)) {
            this.partsOfSpeech.add(string3);
        }
        this.addenda.put(string + string3, stringArray);
    }

    public void removeAddendum(String string, String string2) {
        this.addenda.remove(string + LexiconImpl.fixPartOfSpeech(string2));
    }

    private void outString(DataOutputStream dataOutputStream, String string) throws IOException {
        dataOutputStream.writeByte((byte)string.length());
        int n = 0;
        while (n < string.length()) {
            dataOutputStream.writeChar(string.charAt(n));
            ++n;
        }
    }

    private String getString(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readByte();
        int n2 = 0;
        while (n2 < n) {
            this.charBuffer[n2] = dataInputStream.readChar();
            ++n2;
        }
        return new String(this.charBuffer, 0, n);
    }

    private String getString(ByteBuffer byteBuffer) throws IOException {
        int n = byteBuffer.get();
        int n2 = 0;
        while (n2 < n) {
            this.charBuffer[n2] = byteBuffer.getChar();
            ++n2;
        }
        return new String(this.charBuffer, 0, n);
    }

    private void dumpBinaryLexicon(Map map, String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(fileOutputStream));
            List list = this.findPhonemes(map);
            dataOutputStream.writeInt(12237598);
            dataOutputStream.writeInt(1);
            dataOutputStream.writeInt(list.size());
            int n = 0;
            while (n < list.size()) {
                this.outString(dataOutputStream, (String)list.get(n));
                ++n;
            }
            dataOutputStream.writeInt(map.keySet().size());
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                this.outString(dataOutputStream, string2);
                String[] stringArray = this.getPhones(map, string2);
                dataOutputStream.writeByte((byte)stringArray.length);
                int n2 = 0;
                while (n2 < stringArray.length) {
                    int n3 = list.indexOf(stringArray[n2]);
                    if (n3 == -1) {
                        throw new Error("Can't find phoneme index");
                    }
                    dataOutputStream.writeByte((byte)n3);
                    ++n2;
                }
            }
            dataOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new Error("Can't dump binary database " + fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            throw new Error("Can't write binary database " + iOException.getMessage());
        }
    }

    private Map loadMappedBinaryLexicon(FileInputStream fileInputStream, int n) throws IOException {
        FileChannel fileChannel = fileInputStream.getChannel();
        MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, (int)fileChannel.size());
        mappedByteBuffer.load();
        int n2 = 0;
        int n3 = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        LinkedHashMap<String, String[]> linkedHashMap = new LinkedHashMap<String, String[]>(n * 4 / 3);
        if (mappedByteBuffer.getInt() != 12237598) {
            throw new Error("bad magic number in lexicon");
        }
        if (mappedByteBuffer.getInt() != 1) {
            throw new Error("bad version number in lexicon");
        }
        n2 = mappedByteBuffer.getInt();
        int n4 = 0;
        while (n4 < n2) {
            String string = this.getString(mappedByteBuffer);
            arrayList.add(string);
            ++n4;
        }
        n3 = mappedByteBuffer.getInt();
        int n5 = 0;
        while (n5 < n3) {
            String string = this.getString(mappedByteBuffer);
            String string2 = Character.toString(string.charAt(string.length() - 1));
            if (!this.partsOfSpeech.contains(string2)) {
                this.partsOfSpeech.add(string2);
            }
            int n6 = mappedByteBuffer.get();
            String[] stringArray = new String[n6];
            int n7 = 0;
            while (n7 < n6) {
                stringArray[n7] = (String)arrayList.get(mappedByteBuffer.get());
                ++n7;
            }
            linkedHashMap.put(string, stringArray);
            ++n5;
        }
        fileChannel.close();
        return linkedHashMap;
    }

    private Map loadBinaryLexicon(InputStream inputStream, int n) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
        int n2 = 0;
        int n3 = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        LinkedHashMap<String, String[]> linkedHashMap = new LinkedHashMap<String, String[]>();
        if (dataInputStream.readInt() != 12237598) {
            throw new Error("bad magic number in lexicon");
        }
        if (dataInputStream.readInt() != 1) {
            throw new Error("bad version number in lexicon");
        }
        n2 = dataInputStream.readInt();
        int n4 = 0;
        while (n4 < n2) {
            String string = this.getString(dataInputStream);
            arrayList.add(string);
            ++n4;
        }
        n3 = dataInputStream.readInt();
        int n5 = 0;
        while (n5 < n3) {
            String string = this.getString(dataInputStream);
            String string2 = Character.toString(string.charAt(string.length() - 1));
            if (!this.partsOfSpeech.contains(string2)) {
                this.partsOfSpeech.add(string2);
            }
            int n6 = dataInputStream.readByte();
            String[] stringArray = new String[n6];
            int n7 = 0;
            while (n7 < n6) {
                stringArray[n7] = (String)arrayList.get(dataInputStream.readByte());
                ++n7;
            }
            linkedHashMap.put(string, stringArray);
            ++n5;
        }
        dataInputStream.close();
        return linkedHashMap;
    }

    public void dumpBinary(String string) {
        String string2 = string + "_compiled.bin";
        String string3 = string + "_addenda.bin";
        this.dumpBinaryLexicon(this.compiled, string2);
        this.dumpBinaryLexicon(this.addenda, string3);
    }

    private List findPhonemes(Map map) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String[] stringArray = this.getPhones(map, string);
            int n = 0;
            while (n < stringArray.length) {
                if (!arrayList.contains(stringArray[n])) {
                    arrayList.add(stringArray[n]);
                }
                ++n;
            }
        }
        return arrayList;
    }

    public boolean compare(LexiconImpl lexiconImpl) {
        return this.compare(this.addenda, lexiconImpl.addenda) && this.compare(this.compiled, lexiconImpl.compiled);
    }

    private boolean compare(Map map, Map map2) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String[] stringArray = this.getPhones(map, string);
            String[] stringArray2 = this.getPhones(map2, string);
            if (stringArray == null) {
                System.out.println(string + " not found in this.");
                return false;
            }
            if (stringArray2 == null) {
                System.out.println(string + " not found in other.");
                return false;
            }
            if (stringArray.length == stringArray2.length) {
                int n = 0;
                while (n < stringArray.length) {
                    if (!stringArray[n].equals(stringArray2[n])) {
                        return false;
                    }
                    ++n;
                }
                continue;
            }
            return false;
        }
        return true;
    }

    protected static String fixPartOfSpeech(String string) {
        return string == null ? "0" : string;
    }
}

