/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.relp;

import com.sun.speech.freetts.Utterance;
import com.sun.speech.freetts.audio.AudioPlayer;
import com.sun.speech.freetts.relp.FloatList;
import com.sun.speech.freetts.util.Utilities;
import com.sun.speech.freetts.util.WaveUtils;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import javax.sound.sampled.AudioFormat;

public class LPCResult {
    private static final double POST_EMPHASIS = 0.0;
    private int frameSize = 10;
    private int numberOfFrames = 0;
    private short[][] frames = null;
    private int[] times = null;
    private int[] sizes = null;
    private byte[] residuals = null;
    private int numberOfChannels;
    private int sampleRate;
    private int residualFold = 1;
    private float lpcMinimum;
    private float lpcRange;
    private static final int MAX_SAMPLE_SIZE = Utilities.getInteger("com.sun.speech.freetts.LpcResult.maxSamples", 1024);
    private static final float[] residualToFloatMap = new float[256];

    public void resizeFrames(int n) {
        this.times = new int[n];
        this.frames = new short[n][];
        this.sizes = new int[n];
        this.numberOfFrames = n;
    }

    public void resizeResiduals(int n) {
        this.residuals = new byte[n];
    }

    public void setValues(int n, int n2, int n3, float f, float f2) {
        this.numberOfChannels = n;
        this.sampleRate = n2;
        this.lpcMinimum = f;
        this.lpcRange = f2;
    }

    public int getFrameShift(int n) {
        if (0 <= n && n < this.times.length) {
            if (n > 0) {
                return this.times[n] - this.times[n - 1];
            }
            return this.times[n];
        }
        return 0;
    }

    public int getFrameSize() {
        return this.frameSize;
    }

    public short[] getFrame(int n) {
        return this.frames[n];
    }

    public int[] getTimes() {
        return this.times;
    }

    public int getNumberOfFrames() {
        return this.numberOfFrames;
    }

    public int getNumberOfChannels() {
        return this.numberOfChannels;
    }

    public float getLPCMin() {
        return this.lpcMinimum;
    }

    public float getLPCRange() {
        return this.lpcRange;
    }

    public int getNumberOfSamples() {
        if (this.residuals == null) {
            return 0;
        }
        return this.residuals.length;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public int[] getResidualSizes() {
        return this.sizes;
    }

    public byte[] getResiduals() {
        return this.residuals;
    }

    public void setFrameSize(int n) {
        this.frameSize = n;
    }

    public void setNumberOfFrames(int n) {
        this.numberOfFrames = n;
    }

    public void setFrame(int n, short[] sArray) {
        this.frames[n] = sArray;
    }

    public void setTimes(int[] nArray) {
        this.times = nArray;
    }

    public void setNumberOfChannels(int n) {
        this.numberOfChannels = n;
    }

    public void setLPCMin(float f) {
        this.lpcMinimum = f;
    }

    public void setLPCRange(float f) {
        this.lpcRange = f;
    }

    public void setSampleRate(int n) {
        this.sampleRate = n;
    }

    public void setResidualSizes(int[] nArray) {
        int n = 0;
        while (n < this.sizes.length && n < nArray.length) {
            this.sizes[n] = nArray[n];
            ++n;
        }
    }

    public void copyResiduals(byte[] byArray, int n, int n2) {
        int n3 = byArray.length;
        if (n3 < n2) {
            int n4 = (n2 - n3) / 2;
            System.arraycopy(byArray, 0, this.residuals, n + n4, byArray.length);
        } else {
            int n5 = (n3 - n2) / 2;
            System.arraycopy(byArray, n5, this.residuals, n, n2);
        }
    }

    public void copyResidualsPulse(byte[] byArray, int n, int n2) {
        int n3 = byArray.length;
        short s = (short)(byArray[0] + 128);
        if (n3 < n2) {
            this.residuals[(n2 - n3) / 2] = WaveUtils.shortToUlaw(s);
        } else {
            this.residuals[(n3 - n2) / 2] = WaveUtils.shortToUlaw(s);
        }
    }

    private static final byte hibyte(int n) {
        return (byte)(n >>> 8);
    }

    private static final byte lobyte(int n) {
        return (byte)(n & 0xFF);
    }

    public boolean playWave(AudioPlayer audioPlayer) {
        return this.playWaveSamples(audioPlayer, this.getNumberOfSamples() * 2);
    }

    private byte[] getWaveSamples(int n, Utterance utterance) {
        int n2 = this.getNumberOfChannels();
        float f = 0.0f;
        byte[] byArray = new byte[n];
        byte[] byArray2 = this.getResiduals();
        int[] nArray = this.getResidualSizes();
        FloatList floatList = FloatList.createList(n2 + 1);
        FloatList floatList2 = FloatList.createList(n2);
        double d = (double)this.getLPCRange() / 65535.0;
        int n3 = 0;
        boolean bl = true;
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.numberOfFrames) {
            short[] sArray = this.getFrame(n5);
            FloatList floatList3 = floatList2;
            int n6 = 0;
            while (n6 < n2) {
                floatList3.value = (float)(((double)sArray[n6] + 32768.0) * d) + this.lpcMinimum;
                floatList3 = floatList3.next;
                ++n6;
            }
            int n7 = nArray[n5];
            int n8 = 0;
            while (n8 < n7) {
                FloatList floatList4 = floatList.prev;
                float f2 = residualToFloatMap[byArray2[n4] + 128];
                floatList3 = floatList2;
                do {
                    f2 += floatList3.value * floatList4.value;
                    floatList4 = floatList4.prev;
                } while ((floatList3 = floatList3.next) != floatList2);
                int n9 = (int)((double)f2 + (double)f * 0.0);
                byArray[n3++] = LPCResult.hibyte(n9);
                byArray[n3++] = LPCResult.lobyte(n9);
                floatList.value = f = f2;
                floatList = floatList.next;
                ++n8;
                ++n4;
            }
            ++n5;
        }
        return byArray;
    }

    private boolean playWaveSamples(AudioPlayer audioPlayer, int n) {
        boolean bl = true;
        int n2 = this.getNumberOfChannels();
        float f = 0.0f;
        byte[] byArray = new byte[MAX_SAMPLE_SIZE];
        byte[] byArray2 = this.getResiduals();
        int[] nArray = this.getResidualSizes();
        FloatList floatList = FloatList.createList(n2 + 1);
        FloatList floatList2 = FloatList.createList(n2);
        double d = (double)this.getLPCRange() / 65535.0;
        int n3 = 0;
        boolean bl2 = true;
        audioPlayer.begin(n);
        int n4 = 0;
        int n5 = 0;
        while (bl && n5 < this.numberOfFrames) {
            short[] sArray = this.getFrame(n5);
            FloatList floatList3 = floatList2;
            int n6 = 0;
            while (n6 < n2) {
                floatList3.value = (float)(((double)sArray[n6] + 32768.0) * d) + this.lpcMinimum;
                floatList3 = floatList3.next;
                ++n6;
            }
            int n7 = nArray[n5];
            int n8 = 0;
            while (n8 < n7) {
                FloatList floatList4 = floatList.prev;
                float f2 = residualToFloatMap[byArray2[n4] + 128];
                floatList3 = floatList2;
                do {
                    f2 += floatList3.value * floatList4.value;
                    floatList4 = floatList4.prev;
                } while ((floatList3 = floatList3.next) != floatList2);
                int n9 = (int)((double)f2 + (double)f * 0.0);
                byArray[n3++] = LPCResult.hibyte(n9);
                byArray[n3++] = LPCResult.lobyte(n9);
                if (n3 >= MAX_SAMPLE_SIZE) {
                    if (!audioPlayer.write(byArray)) {
                        bl = false;
                    }
                    n3 = 0;
                }
                floatList.value = f = f2;
                floatList = floatList.next;
                ++n8;
                ++n4;
            }
            ++n5;
        }
        if (n3 > 0) {
            bl = audioPlayer.write(byArray, 0, n3);
            n3 = 0;
        }
        if (bl) {
            bl = audioPlayer.end();
        }
        return bl;
    }

    public void dump() {
        this.dump(new OutputStreamWriter(System.out));
    }

    public void dump(Writer writer) {
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setMaximumFractionDigits(6);
        decimalFormat.setMinimumFractionDigits(6);
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(writer));
        if (this.getNumberOfFrames() == 0) {
            printWriter.println("# ========== LPCResult ==========");
            printWriter.println("# Num_of_Frames: " + this.getNumberOfFrames());
            printWriter.flush();
            return;
        }
        printWriter.println("========== LPCResult ==========");
        printWriter.println("Num_of_Frames: " + this.getNumberOfFrames());
        printWriter.println("Num_of_Channels: " + this.getNumberOfChannels());
        printWriter.println("Num_of_Samples: " + this.getNumberOfSamples());
        printWriter.println("Sample_Rate: " + this.sampleRate);
        printWriter.println("LPC_Minimum: " + decimalFormat.format(this.lpcMinimum));
        printWriter.println("LPC_Range: " + decimalFormat.format(this.lpcRange));
        printWriter.println("Residual_Fold: " + this.residualFold);
        printWriter.println("Post_Emphasis: " + decimalFormat.format(0.0));
        printWriter.print("Times:\n");
        int n = 0;
        while (n < this.getNumberOfFrames()) {
            printWriter.print(this.times[n] + " ");
            ++n;
        }
        printWriter.print("\nFrames: ");
        n = 0;
        while (n < this.getNumberOfFrames()) {
            short[] sArray = this.getFrame(n);
            int n2 = 0;
            while (n2 < sArray.length) {
                printWriter.print(sArray[n2] + 32768 + "\n");
                ++n2;
            }
            ++n;
        }
        printWriter.print("\nSizes: ");
        n = 0;
        while (n < this.getNumberOfFrames()) {
            printWriter.print(this.sizes[n] + " ");
            ++n;
        }
        printWriter.print("\nResiduals: ");
        n = 0;
        while (n < this.getNumberOfSamples()) {
            if (this.residuals[n] == 0) {
                printWriter.print(255);
            } else {
                printWriter.print(this.residuals[n] + 128);
            }
            printWriter.print("\n");
            printWriter.flush();
            ++n;
        }
        printWriter.flush();
    }

    public void dumpWave() {
        this.dumpWave(new OutputStreamWriter(System.out));
    }

    public void dumpWave(String string) throws IOException {
        FileWriter fileWriter = new FileWriter(string, true);
        this.getWave().dump(fileWriter);
    }

    private Wave getWave() {
        AudioFormat audioFormat = new AudioFormat(this.getSampleRate(), 16, 1, true, true);
        return new Wave(audioFormat, this.getWaveSamples(this.getNumberOfSamples() * 2, null));
    }

    public void dumpWave(Writer writer) {
        Wave wave = this.getWave();
        wave.dump(writer);
    }

    static {
        short s = 0;
        while (s < residualToFloatMap.length) {
            LPCResult.residualToFloatMap[s] = WaveUtils.ulawToShort(s);
            s = (short)(s + 1);
        }
        LPCResult.residualToFloatMap[128] = WaveUtils.ulawToShort((short)255);
    }

    private static class Wave {
        public static final int DEFAULT_SAMPLE_SIZE_IN_BITS = 16;
        public static final boolean DEFAULT_SIGNED = true;
        public static final boolean DEFAULT_BIG_ENDIAN = false;
        private byte[] samples = null;
        private AudioFormat audioFormat = null;

        Wave(AudioFormat audioFormat, byte[] byArray) {
            this.audioFormat = audioFormat;
            this.samples = byArray;
        }

        public void dump(Writer writer) {
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(writer));
            printWriter.println("#========== Wave ==========");
            printWriter.println("#Type: NULL");
            printWriter.println("#Sample_Rate: " + (int)this.audioFormat.getSampleRate());
            printWriter.println("#Num_of_Samples: " + this.samples.length / 2);
            printWriter.println("#Num_of_Channels: " + this.audioFormat.getChannels());
            if (this.samples != null) {
                int n = 0;
                while (n < this.samples.length) {
                    printWriter.println(WaveUtils.bytesToShort(this.samples[n], this.samples[n + 1]));
                    n += 2;
                }
            }
            printWriter.flush();
        }
    }
}

