/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.relp;

import com.sun.speech.freetts.FeatureSet;
import com.sun.speech.freetts.Item;
import com.sun.speech.freetts.ProcessException;
import com.sun.speech.freetts.Relation;
import com.sun.speech.freetts.Unit;
import com.sun.speech.freetts.Utterance;
import com.sun.speech.freetts.UtteranceProcessor;
import com.sun.speech.freetts.relp.LPCResult;
import com.sun.speech.freetts.relp.Sample;
import com.sun.speech.freetts.relp.SampleInfo;
import com.sun.speech.freetts.util.Utilities;

public class UnitConcatenator
implements UtteranceProcessor {
    private static final int ADD_RESIDUAL_PULSE = 1;
    private static final int ADD_RESIDUAL_WINDOWED = 2;
    private static final int ADD_RESIDUAL = 3;
    public static final String PROP_OUTPUT_LPC = "com.sun.speech.freetts.outputLPC";
    private boolean outputLPC = Utilities.getBoolean("com.sun.speech.freetts.outputLPC");

    public void processUtterance(Utterance utterance) throws ProcessException {
        SampleInfo sampleInfo;
        float f = 0.0f;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        Relation relation = utterance.getRelation("Unit");
        boolean bl = false;
        int n4 = 3;
        String string = utterance.getString("residual_type");
        if (string != null) {
            if (string.equals("pulse")) {
                n4 = 1;
            } else if (string.equals("windowed")) {
                n4 = 2;
            }
        }
        if ((sampleInfo = (SampleInfo)utterance.getObject("SampleInfo")) == null) {
            throw new IllegalStateException("UnitConcatenator: SampleInfo does not exist");
        }
        LPCResult lPCResult = (LPCResult)utterance.getObject("target_lpcres");
        lPCResult.setValues(sampleInfo.getNumberOfChannels(), sampleInfo.getSampleRate(), sampleInfo.getResidualFold(), sampleInfo.getCoeffMin(), sampleInfo.getCoeffRange());
        int[] nArray = lPCResult.getTimes();
        int[] nArray2 = lPCResult.getResidualSizes();
        int n5 = 0;
        if (lPCResult.getNumberOfFrames() > 0) {
            n5 = nArray[lPCResult.getNumberOfFrames() - 1];
        }
        lPCResult.resizeResiduals(n5);
        Item item = relation.getHead();
        while (item != null) {
            FeatureSet featureSet = item.getFeatures();
            String string2 = featureSet.getString("name");
            int n6 = featureSet.getInt("target_end");
            Unit unit = (Unit)featureSet.getObject("unit");
            int n7 = unit.getSize();
            f = 0.0f;
            float f2 = (float)n7 / (float)(n6 - n3);
            int n8 = lPCResult.getNumberOfFrames();
            while (n < n8 && nArray[n] <= n6) {
                int n9;
                Sample sample = unit.getNearestSample(f);
                lPCResult.setFrame(n, sample.getFrameData());
                nArray2[n] = n9 = lPCResult.getFrameShift(n);
                byte[] byArray = sample.getResidualData();
                if (n4 == 1) {
                    lPCResult.copyResidualsPulse(byArray, n2, n9);
                } else {
                    lPCResult.copyResiduals(byArray, n2, n9);
                }
                n2 += n9;
                f += (float)n9 * f2;
                ++n;
            }
            n3 = n6;
            item = item.getNext();
        }
        lPCResult.setNumberOfFrames(n);
        if (this.outputLPC) {
            lPCResult.dump();
        }
    }

    public String toString() {
        return "UnitConcatenator";
    }
}

