/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.util;

import com.sun.speech.freetts.util.Utilities;
import java.text.DecimalFormat;

public class Timer {
    private static final DecimalFormat timeFormatter = new DecimalFormat("###0.0000");
    private static final DecimalFormat percentFormatter = new DecimalFormat("###0.00%");
    private String name;
    private long startTime;
    private long curTime;
    private long count;
    private double sum;
    private long minTime = Long.MAX_VALUE;
    private long maxTime = 0L;
    private boolean notReliable;

    public Timer(String string) {
        this.name = string;
        this.reset();
    }

    public void reset() {
        this.startTime = 0L;
        this.count = 0L;
        this.sum = 0.0;
        this.minTime = Long.MAX_VALUE;
        this.maxTime = 0L;
        this.notReliable = false;
    }

    public void start() {
        if (this.startTime != 0L) {
            this.notReliable = true;
        }
        this.startTime = System.currentTimeMillis();
    }

    public long getCurrentTime() {
        return this.curTime;
    }

    public void stop(boolean bl) {
        if (this.startTime == 0L) {
            this.notReliable = true;
        }
        this.curTime = System.currentTimeMillis() - this.startTime;
        this.startTime = 0L;
        if (this.curTime > this.maxTime) {
            this.maxTime = this.curTime;
        }
        if (this.curTime < this.minTime) {
            this.minTime = this.curTime;
        }
        ++this.count;
        this.sum += (double)this.curTime;
        if (bl) {
            this.showTimesShort(0L);
        }
    }

    public void stop() {
        this.stop(false);
    }

    private String fmtTime(long l) {
        return this.fmtTime((double)l / 1000.0);
    }

    private String fmtTime(double d) {
        return Utilities.pad(timeFormatter.format(d) + "s", 10);
    }

    public void showTimesLong(long l) {
        System.out.println(" Timer:    " + this.name);
        System.out.println(" Count:    " + this.count);
        if (this.notReliable) {
            System.out.println(" Not reliable");
        } else if (this.count == 1L) {
            System.out.println(" Cur Time: " + this.fmtTime(this.curTime));
        } else if (this.count > 1L) {
            System.out.println(" Min Time: " + this.fmtTime(this.minTime));
            System.out.println(" Max Time: " + this.fmtTime(this.maxTime));
            System.out.println(" Avg Time: " + this.fmtTime(this.sum / (double)this.count / 1000.0));
            System.out.println(" Tot Time: " + this.fmtTime(this.sum / 1000.0));
            if (l != 0L) {
                System.out.println(" Percent:  " + percentFormatter.format(this.sum / (double)l));
            }
        }
        System.out.println();
    }

    public static void showTimesShortTitle(String string) {
        String string2 = "# ----------------------------- " + string + "----------------------------------------------------------- ";
        System.out.println(Utilities.pad(string2, 78));
        System.out.print(Utilities.pad("# Name", 15) + " ");
        System.out.print(Utilities.pad("Count", 6));
        System.out.print(Utilities.pad("CurTime", 10));
        System.out.print(Utilities.pad("MinTime", 10));
        System.out.print(Utilities.pad("MaxTime", 10));
        System.out.print(Utilities.pad("AvgTime", 10));
        System.out.print(Utilities.pad("TotTime", 10));
        System.out.print(Utilities.pad("% Total", 8));
        System.out.println();
    }

    public void showTimesShort(long l) {
        double d = 0.0;
        double d2 = this.sum / 1000.0;
        double d3 = 0.0;
        if (this.count == 0L) {
            return;
        }
        if (this.count > 0L) {
            d = this.sum / (double)this.count / 1000.0;
        }
        if (l != 0L) {
            d3 = this.sum / (double)l;
        }
        if (this.notReliable) {
            System.out.print(Utilities.pad(this.name, 15) + " ");
            System.out.println("Not reliable.");
        } else {
            System.out.print(Utilities.pad(this.name, 15) + " ");
            System.out.print(Utilities.pad("" + this.count, 6));
            System.out.print(this.fmtTime(this.curTime));
            System.out.print(this.fmtTime(this.minTime));
            System.out.print(this.fmtTime(this.maxTime));
            System.out.print(this.fmtTime(d));
            System.out.print(this.fmtTime(this.sum / 1000.0));
            System.out.print(percentFormatter.format(d3));
            System.out.println();
        }
    }

    public void showTimes(long l) {
        this.showTimesShort(l);
    }

    public void showTimes() {
        this.showTimesShort(0L);
    }

    public static void main(String[] stringArray) {
        Timer timer = new Timer("testTimer");
        Timer timer2 = new Timer("overall");
        timer.showTimes(0L);
        timer2.start();
        int n = 0;
        while (n < 5) {
            timer.start();
            try {
                Thread.sleep((long)n * 1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            timer.stop(true);
            ++n;
        }
        timer2.stop();
        timer.showTimes(timer2.getCurrentTime());
        timer2.showTimes();
    }
}

