/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import java.util.Hashtable;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledTextBidi;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.custom.StyledTextEvent;
import org.eclipse.swt.custom.StyledTextRenderer;
import org.eclipse.swt.custom.WrappedContent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

class PrintRenderer
extends StyledTextRenderer {
    StyledTextContent logicalContent;
    WrappedContent content;
    Rectangle clientArea;
    GC gc;
    Hashtable lineBackgrounds;
    Hashtable lineStyles;
    Hashtable bidiSegments;

    PrintRenderer(Device device, Font regularFont, boolean isBidi, GC gc, StyledTextContent logicalContent, Hashtable lineBackgrounds, Hashtable lineStyles, Hashtable bidiSegments, int tabLength, Rectangle clientArea) {
        super(device, regularFont, isBidi, clientArea.x);
        this.logicalContent = logicalContent;
        this.lineBackgrounds = lineBackgrounds;
        this.lineStyles = lineStyles;
        this.bidiSegments = bidiSegments;
        this.clientArea = clientArea;
        this.gc = gc;
        this.calculateLineHeight();
        this.setTabLength(tabLength);
        this.content = new WrappedContent(this, logicalContent);
        this.content.wrapLines();
    }

    protected void dispose() {
        this.content = null;
        super.dispose();
    }

    protected void disposeGC(GC gc) {
    }

    protected void drawLineSelectionBackground(String line, int lineOffset, StyleRange[] styles, int paintY, GC gc, StyledTextBidi bidi) {
    }

    protected int[] getBidiSegments(int lineOffset, String lineText) {
        int lineLength = lineText.length();
        int logicalLineOffset = this.getLogicalLineOffset(lineOffset);
        int[] segments = (int[])this.bidiSegments.get(new Integer(logicalLineOffset));
        if (segments == null) {
            segments = new int[]{0, lineLength};
        } else {
            int logicalLineIndex = this.logicalContent.getLineAtOffset(lineOffset);
            int logicalLineLength = this.logicalContent.getLine(logicalLineIndex).length();
            if (lineOffset != logicalLineOffset || lineLength != logicalLineLength) {
                int lineOffsetDelta = lineOffset - logicalLineOffset;
                int newSegmentCount = 0;
                int[] newSegments = new int[segments.length];
                int i = 0;
                while (i < segments.length) {
                    newSegments[i] = Math.max(0, segments[i] - lineOffsetDelta);
                    if (newSegments[i] > lineLength) {
                        newSegments[i] = lineLength;
                        ++newSegmentCount;
                        break;
                    }
                    if (i == 0 || newSegments[i] > 0) {
                        ++newSegmentCount;
                    }
                    ++i;
                }
                segments = new int[newSegmentCount];
                int i2 = 0;
                int newIndex = 0;
                while (i2 < newSegments.length && newIndex < newSegmentCount) {
                    if (i2 == 0 || newSegments[i2] > 0) {
                        segments[newIndex++] = newSegments[i2];
                    }
                    ++i2;
                }
            }
        }
        return segments;
    }

    protected Rectangle getClientArea() {
        return this.clientArea;
    }

    protected StyledTextContent getContent() {
        return this.content;
    }

    protected GC getGC() {
        return this.gc;
    }

    protected int getHorizontalPixel() {
        return 0;
    }

    private int getLogicalLineOffset(int visualLineOffset) {
        int logicalLineIndex = this.logicalContent.getLineAtOffset(visualLineOffset);
        return this.logicalContent.getOffsetAtLine(logicalLineIndex);
    }

    protected StyledTextEvent getLineBackgroundData(int lineOffset, String line) {
        int logicalLineOffset = this.getLogicalLineOffset(lineOffset);
        return (StyledTextEvent)this.lineBackgrounds.get(new Integer(logicalLineOffset));
    }

    protected StyledTextEvent getLineStyleData(int lineOffset, String line) {
        int logicalLineOffset = this.getLogicalLineOffset(lineOffset);
        StyledTextEvent logicalLineEvent = (StyledTextEvent)this.lineStyles.get(new Integer(logicalLineOffset));
        if (logicalLineEvent != null) {
            StyledTextEvent clone = new StyledTextEvent((StyledTextContent)logicalLineEvent.data);
            clone.detail = logicalLineEvent.detail;
            clone.styles = logicalLineEvent.styles;
            clone.text = logicalLineEvent.text;
            logicalLineEvent = this.getLineStyleData(clone, lineOffset, line);
        }
        return logicalLineEvent;
    }

    protected Point getSelection() {
        return new Point(0, 0);
    }

    protected int getStyledTextWidth(String text, int textStartOffset, StyleRange[] lineStyles, int paintX, GC gc) {
        String textSegment;
        int textLength = text.length();
        int textIndex = 0;
        int styleIndex = 0;
        while (styleIndex < lineStyles.length) {
            StyleRange style = lineStyles[styleIndex];
            int styleSegmentStart = style.start - textStartOffset;
            if (styleSegmentStart + style.length >= 0) {
                if (styleSegmentStart >= textLength) break;
                if (textIndex < styleSegmentStart) {
                    textSegment = text.substring(textIndex, styleSegmentStart);
                    this.setLineFont(gc, 0);
                    paintX += gc.stringExtent((String)textSegment).x;
                    textIndex = styleSegmentStart;
                }
                int textEnd = Math.min(textLength, styleSegmentStart + style.length);
                textSegment = text.substring(textIndex, textEnd);
                this.setLineFont(gc, style.fontStyle);
                paintX += gc.stringExtent((String)textSegment).x;
                textIndex = textEnd;
            }
            ++styleIndex;
        }
        if (textIndex < textLength) {
            textSegment = text.substring(textIndex, textLength);
            this.setLineFont(gc, 0);
            paintX += gc.stringExtent((String)textSegment).x;
        }
        return paintX;
    }

    protected StyleRange[] mergeSelectionLineStyles(StyleRange[] styles) {
        return styles;
    }

    protected boolean getWordWrap() {
        return true;
    }

    protected boolean isFullLineSelection() {
        return false;
    }
}

