/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XFontStruct;

public final class Font {
    public int handle;
    public String codePage;
    Device device;

    Font() {
    }

    public Font(Device device, FontData fd) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (fd == null) {
            SWT.error(4);
        }
        this.init(device, new FontData[]{fd});
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Font(Device device, FontData[] fds) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (fds == null) {
            SWT.error(4);
        }
        if (fds.length == 0) {
            SWT.error(5);
        }
        int i = 0;
        while (i < fds.length) {
            if (fds[i] == null) {
                SWT.error(4);
            }
            ++i;
        }
        this.init(device, fds);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Font(Device device, String name, int height, int style) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (name == null) {
            SWT.error(4);
        }
        this.init(device, new FontData[]{new FontData(name, height, style)});
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public void dispose() {
        if (this.handle == 0) {
            return;
        }
        if (this.device.isDisposed()) {
            return;
        }
        if (this.handle == this.device.systemFont.handle) {
            return;
        }
        OS.XmFontListFree(this.handle);
        this.handle = 0;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Font)) {
            return false;
        }
        Font font = (Font)object;
        return this.device == font.device && this.handle == font.handle;
    }

    /*
     * WARNING - void declaration
     */
    static String getCodePage(int xDisplay, int fontList) {
        int fontListEntry;
        int[] buffer = new int[1];
        if (!OS.XmFontListInitFontContext(buffer, fontList)) {
            return null;
        }
        int context = buffer[0];
        XFontStruct fontStruct = new XFontStruct();
        String codePage = null;
        block0: while ((fontListEntry = OS.XmFontListNextEntry(context)) != 0) {
            void var5_6;
            int fontPtr = OS.XmFontListEntryGetFont((int)var5_6, buffer);
            if (buffer[0] == 0) {
                OS.memmove(fontStruct, fontPtr, 80);
                int propPtr = fontStruct.properties;
                int i = 0;
                while (i < fontStruct.n_properties) {
                    int[] prop = new int[2];
                    OS.memmove(prop, propPtr, 8);
                    if (prop[0] == 18) {
                        int ptr = OS.XmGetAtomName(xDisplay, prop[1]);
                        int length = OS.strlen(ptr);
                        byte[] nameBuf = new byte[length];
                        OS.memmove(nameBuf, ptr, length);
                        String xlfd = new String(Converter.mbcsToWcs(null, nameBuf)).toLowerCase();
                        int start = xlfd.lastIndexOf(45);
                        if (start != -1 && start > 0 && (start = xlfd.lastIndexOf(45, start - 1)) != -1 && (codePage = xlfd.substring(start + 1, xlfd.length())).indexOf("iso") == 0 && OS.IsLinux) {
                            codePage = "ISO-" + codePage.substring(3, codePage.length());
                        }
                        OS.XtFree(ptr);
                        continue block0;
                    }
                    propPtr += 8;
                    ++i;
                }
                continue;
            }
            int localePtr = OS.XLocaleOfFontSet(fontPtr);
            int length = OS.strlen(localePtr);
            byte[] locale = new byte[length + 1];
            OS.memmove(locale, localePtr, length);
            OS.setlocale(OS.LC_CTYPE, locale);
            int codesetPtr = OS.nl_langinfo(OS.CODESET);
            length = OS.strlen(codesetPtr);
            byte[] codeset = new byte[length];
            OS.memmove(codeset, codesetPtr, length);
            codePage = new String(Converter.mbcsToWcs(null, codeset));
            OS.setlocale(OS.LC_CTYPE, new byte[1]);
        }
        OS.XmFontListFreeFontContext(context);
        return codePage;
    }

    /*
     * WARNING - void declaration
     */
    public FontData[] getFontData() {
        int fontListEntry;
        if (this.isDisposed()) {
            SWT.error(44);
        }
        int xDisplay = this.device.xDisplay;
        int[] buffer = new int[1];
        if (!OS.XmFontListInitFontContext(buffer, this.handle)) {
            return null;
        }
        int context = buffer[0];
        XFontStruct fontStruct = new XFontStruct();
        int[] fontStructPtr = new int[1];
        int[] fontNamePtr = new int[1];
        String[] xlfds = new String[]{};
        block2: while ((fontListEntry = OS.XmFontListNextEntry(context)) != 0) {
            void var5_8;
            int fontPtr = OS.XmFontListEntryGetFont((int)var5_8, buffer);
            if (buffer[0] == 0) {
                OS.memmove(fontStruct, fontPtr, 80);
                int propPtr = fontStruct.properties;
                int i = 0;
                while (i < fontStruct.n_properties) {
                    int[] prop = new int[2];
                    OS.memmove(prop, propPtr, 8);
                    if (prop[0] == 18) {
                        int ptr = OS.XmGetAtomName(xDisplay, prop[1]);
                        int length = OS.strlen(ptr);
                        byte[] nameBuf = new byte[length];
                        OS.memmove(nameBuf, ptr, length);
                        String xlfd = new String(Converter.mbcsToWcs(null, nameBuf)).toLowerCase();
                        String[] newXlfds = new String[xlfds.length + 1];
                        System.arraycopy(xlfds, 0, newXlfds, 0, xlfds.length);
                        newXlfds[newXlfds.length - 1] = xlfd;
                        xlfds = newXlfds;
                        OS.XtFree(ptr);
                        continue block2;
                    }
                    propPtr += 8;
                    ++i;
                }
                continue;
            }
            int nFonts = OS.XFontsOfFontSet(fontPtr, fontStructPtr, fontNamePtr);
            int[] fontStructs = new int[nFonts];
            OS.memmove(fontStructs, fontStructPtr[0], nFonts * 4);
            int i = 0;
            while (i < nFonts) {
                OS.memmove(fontStruct, fontStructs[i], 80);
                int propPtr = fontStruct.properties;
                int j = 0;
                while (j < fontStruct.n_properties) {
                    int[] prop = new int[2];
                    OS.memmove(prop, propPtr, 8);
                    if (prop[0] == 18) {
                        int ptr = OS.XmGetAtomName(xDisplay, prop[1]);
                        int length = OS.strlen(ptr);
                        byte[] nameBuf = new byte[length];
                        OS.memmove(nameBuf, ptr, length);
                        String xlfd = new String(Converter.mbcsToWcs(null, nameBuf)).toLowerCase();
                        String[] newXlfds = new String[xlfds.length + 1];
                        System.arraycopy(xlfds, 0, newXlfds, 0, xlfds.length);
                        newXlfds[newXlfds.length - 1] = xlfd;
                        xlfds = newXlfds;
                        OS.XFree(ptr);
                        break;
                    }
                    propPtr += 8;
                    ++j;
                }
                ++i;
            }
        }
        OS.XmFontListFreeFontContext(context);
        if (xlfds.length == 0) {
            return null;
        }
        FontData[] fontData = new FontData[xlfds.length];
        try {
            int i = 0;
            while (i < xlfds.length) {
                fontData[i] = FontData.motif_new(xlfds[i]);
                ++i;
            }
        }
        catch (Exception e) {
            return null;
        }
        return fontData;
    }

    public int hashCode() {
        return this.handle;
    }

    void init(Device device, FontData[] fds) {
        byte[] buffer;
        this.device = device;
        FontData firstFd = fds[0];
        if (firstFd.lang != null) {
            String lang = firstFd.lang;
            String country = firstFd.country;
            String variant = firstFd.variant;
            String osLocale = lang;
            if (country != null) {
                osLocale = osLocale + "_" + country;
            }
            if (variant != null) {
                osLocale = osLocale + "." + variant;
            }
            int length = osLocale.length();
            buffer = new byte[length + 1];
            int i = 0;
            while (i < length) {
                buffer[i] = (byte)osLocale.charAt(i);
                ++i;
            }
            OS.setlocale(OS.LC_CTYPE, buffer);
        }
        Point dpi = null;
        if (device.setDPI) {
            dpi = device.getDPI();
        }
        StringBuffer stringBuffer = new StringBuffer();
        int i = 0;
        while (i < fds.length) {
            FontData fd = fds[i];
            int hRes = fd.horizontalResolution;
            int vRes = fd.verticalResolution;
            if (dpi != null) {
                fd.horizontalResolution = dpi.x;
                fd.verticalResolution = dpi.y;
            }
            stringBuffer.append(fd.getXlfd());
            stringBuffer.append(',');
            fd.horizontalResolution = hRes;
            fd.verticalResolution = vRes;
            ++i;
        }
        FontData newFd = new FontData();
        newFd.points = firstFd.points;
        if (OS.IsAIX && OS.IsDBLocale) {
            stringBuffer.append(newFd.getXlfd());
        } else {
            newFd.weight = firstFd.weight;
            newFd.slant = firstFd.slant;
            stringBuffer.append(newFd.getXlfd());
            newFd.weight = null;
            newFd.slant = null;
            stringBuffer.append(',');
            stringBuffer.append(newFd.getXlfd());
        }
        boolean warnings = device.getWarnings();
        device.setWarnings(false);
        buffer = Converter.wcsToMbcs(null, stringBuffer.toString(), true);
        int fontListEntry = OS.XmFontListEntryLoad(device.xDisplay, buffer, 1, OS.XmFONTLIST_DEFAULT_TAG);
        device.setWarnings(warnings);
        if (fontListEntry != 0) {
            this.handle = OS.XmFontListAppendEntry(0, fontListEntry);
            OS.XmFontListEntryFree(new int[]{fontListEntry});
            int codesetPtr = OS.nl_langinfo(OS.CODESET);
            int length = OS.strlen(codesetPtr);
            byte[] codeset = new byte[length];
            OS.memmove(codeset, codesetPtr, length);
            this.codePage = new String(Converter.mbcsToWcs(null, codeset));
        } else {
            Font systemFont = device.systemFont;
            this.handle = systemFont.handle;
            this.codePage = systemFont.codePage;
        }
        if (firstFd.lang != null) {
            OS.setlocale(OS.LC_CTYPE, new byte[0]);
        }
        if (this.handle == 0) {
            SWT.error(2);
        }
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public static Font motif_new(Device device, int handle) {
        if (device == null) {
            device = Device.getDevice();
        }
        Font font = new Font();
        font.device = device;
        font.handle = handle;
        font.codePage = Font.getCodePage(device.xDisplay, handle);
        return font;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Font {*DISPOSED*}";
        }
        return "Font {" + this.handle + "}";
    }
}

