/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;

public class Caret
extends Widget {
    Canvas parent;
    int x;
    int y;
    int width;
    int height;
    boolean isVisible;
    boolean isShowing;
    int blinkRate = 500;
    Image image;
    Font font;

    public Caret(Canvas parent, int style) {
        super(parent, style);
        this.parent = parent;
        this.createWidget(0);
    }

    boolean blinkCaret() {
        if (!this.isVisible) {
            return true;
        }
        if (!this.isShowing) {
            return this.showCaret();
        }
        if (this.blinkRate == 0) {
            return true;
        }
        return this.hideCaret();
    }

    void createWidget(int index) {
        super.createWidget(index);
        this.isVisible = true;
        if (this.parent.getCaret() == null) {
            this.parent.setCaret(this);
        }
    }

    boolean drawCaret() {
        int color;
        if (this.parent == null) {
            return false;
        }
        if (this.parent.isDisposed()) {
            return false;
        }
        int handle = this.parent.handle;
        int window = OS.XtWindow(handle);
        if (window == 0) {
            return false;
        }
        int xDisplay = OS.XtDisplay(handle);
        int gc = OS.XCreateGC(xDisplay, window, 0, null);
        if (OS.IsSunOS) {
            int[] argList = new int[]{OS.XmNforeground, 0, OS.XmNbackground, 0};
            OS.XtGetValues(handle, argList, argList.length / 2);
            int foreground = argList[1];
            int background = argList[3];
            color = foreground ^ background;
        } else {
            int screenNum = OS.XDefaultScreen(xDisplay);
            color = OS.XWhitePixel(xDisplay, screenNum);
        }
        OS.XSetForeground(xDisplay, gc, color);
        OS.XSetFunction(xDisplay, gc, 6);
        int nWidth = this.width;
        int nHeight = this.height;
        if (this.image != null) {
            Rectangle rect = this.image.getBounds();
            nWidth = rect.width;
            nHeight = rect.height;
        }
        if (nWidth <= 0) {
            nWidth = 2;
        }
        OS.XFillRectangle(xDisplay, window, gc, this.x, this.y, nWidth, nHeight);
        OS.XFreeGC(xDisplay, gc);
        return true;
    }

    public Rectangle getBounds() {
        this.checkWidget();
        if (this.image != null) {
            Rectangle rect = this.image.getBounds();
            return new Rectangle(this.x, this.y, rect.width, rect.height);
        }
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public Display getDisplay() {
        Canvas parent = this.parent;
        if (parent == null) {
            this.error(24);
        }
        return parent.getDisplay();
    }

    public Font getFont() {
        this.checkWidget();
        if (this.font != null) {
            return this.font;
        }
        return this.parent.getFont();
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    public Point getLocation() {
        this.checkWidget();
        return new Point(this.x, this.y);
    }

    public Canvas getParent() {
        this.checkWidget();
        return this.parent;
    }

    public Point getSize() {
        this.checkWidget();
        if (this.image != null) {
            Rectangle rect = this.image.getBounds();
            return new Point(rect.width, rect.height);
        }
        return new Point(this.width, this.height);
    }

    public boolean getVisible() {
        this.checkWidget();
        return this.isVisible;
    }

    boolean hideCaret() {
        if (!this.isShowing) {
            return true;
        }
        this.isShowing = false;
        return this.drawCaret();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.isVisible && this.parent.isVisible() && this.parent.hasFocus();
    }

    boolean isFocusCaret() {
        Display display = this.getDisplay();
        return this == display.currentCaret;
    }

    void killFocus() {
        Display display = this.getDisplay();
        if (display.currentCaret != this) {
            return;
        }
        display.setCurrentCaret(null);
        if (this.isVisible) {
            this.hideCaret();
        }
    }

    void releaseChild() {
        super.releaseChild();
        if (this == this.parent.getCaret()) {
            this.parent.setCaret(null);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        Display display = this.getDisplay();
        if (display.currentCaret == this) {
            this.hideCaret();
            display.setCurrentCaret(null);
        }
        this.parent = null;
        this.image = null;
    }

    public void setBounds(int x, int y, int width, int height) {
        this.checkWidget();
        if (this.x == x && this.y == y && this.width == width && this.height == height) {
            return;
        }
        boolean isFocus = this.isFocusCaret();
        if (isFocus) {
            this.hideCaret();
        }
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.parent.updateCaret();
        if (isFocus) {
            this.showCaret();
        }
    }

    public void setBounds(Rectangle rect) {
        this.checkWidget();
        if (rect == null) {
            this.error(4);
        }
        this.setBounds(rect.x, rect.y, rect.width, rect.height);
    }

    void setFocus() {
        Display display = this.getDisplay();
        if (display.currentCaret == this) {
            return;
        }
        display.setCurrentCaret(this);
        if (this.isVisible) {
            this.showCaret();
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            this.error(5);
        }
        this.font = font;
        if (this.isVisible && this.parent.hasFocus()) {
            int handle = this.parent.handle;
            int[] argList = new int[]{OS.XmNfontList, font.handle};
            OS.XmImSetValues(handle, argList, argList.length / 2);
        }
    }

    public void setImage(Image image) {
        boolean isFocus;
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if (isFocus = this.isFocusCaret()) {
            this.hideCaret();
        }
        this.image = image;
        if (isFocus) {
            this.showCaret();
        }
    }

    public void setLocation(int x, int y) {
        this.checkWidget();
        this.setBounds(x, y, this.width, this.height);
    }

    public void setLocation(Point location) {
        this.checkWidget();
        if (location == null) {
            this.error(4);
        }
        this.setLocation(location.x, location.y);
    }

    public void setSize(int width, int height) {
        this.checkWidget();
        this.setBounds(this.x, this.y, width, height);
    }

    public void setSize(Point size) {
        this.checkWidget();
        if (size == null) {
            this.error(4);
        }
        this.setSize(size.x, size.y);
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if (visible == this.isVisible) {
            return;
        }
        this.isVisible = visible;
        if (!this.isFocusCaret()) {
            return;
        }
        if (this.isVisible) {
            this.showCaret();
        } else {
            this.hideCaret();
        }
    }

    boolean showCaret() {
        if (this.isShowing) {
            return true;
        }
        this.isShowing = true;
        return this.drawCaret();
    }
}

