/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XKeyEvent;
import org.eclipse.swt.internal.motif.XtWidgetGeometry;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;

public class Decorations
extends Canvas {
    String label;
    Image image;
    int dialogHandle;
    boolean minimized;
    boolean maximized;
    Menu menuBar;
    Menu[] menus;
    Control savedFocus;
    Button defaultButton;
    Button saveDefault;

    Decorations() {
    }

    public Decorations(Composite parent, int style) {
        super(parent, Decorations.checkStyle(style));
    }

    void add(Menu menu) {
        if (this.menus == null) {
            this.menus = new Menu[4];
        }
        int i = 0;
        while (i < this.menus.length) {
            if (this.menus[i] == null) {
                this.menus[i] = menu;
                return;
            }
            ++i;
        }
        Menu[] newMenus = new Menu[this.menus.length + 4];
        newMenus[this.menus.length] = menu;
        System.arraycopy(this.menus, 0, newMenus, 0, this.menus.length);
        this.menus = newMenus;
    }

    void bringToTop(boolean force) {
        this.moveAbove(null);
    }

    static int checkStyle(int style) {
        if ((style & 0x4C0) != 0) {
            style |= 0x20;
        }
        return style;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    Control computeTabGroup() {
        return this;
    }

    Control computeTabRoot() {
        return this;
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        Rectangle trim = super.computeTrim(x, y, width, height);
        if (this.menuBar != null) {
            XtWidgetGeometry request = new XtWidgetGeometry();
            XtWidgetGeometry result = new XtWidgetGeometry();
            request.request_mode = 4;
            request.width = trim.width;
            OS.XtQueryGeometry(this.menuBar.handle, request, result);
            trim.height += result.height;
        }
        return trim;
    }

    void createHandle(int index) {
        this.state |= 0x1800;
        this.createScrolledHandle(this.parent.handle);
    }

    void createWidget(int index) {
        super.createWidget(index);
        this.label = "";
    }

    int dialogHandle() {
        if (this.dialogHandle != 0) {
            return this.dialogHandle;
        }
        this.dialogHandle = OS.XmCreateDialogShell(this.handle, null, null, 0);
        return this.dialogHandle;
    }

    public Button getDefaultButton() {
        this.checkWidget();
        return this.defaultButton;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    public boolean getMaximized() {
        this.checkWidget();
        return this.maximized;
    }

    public Menu getMenuBar() {
        this.checkWidget();
        return this.menuBar;
    }

    public boolean getMinimized() {
        this.checkWidget();
        return this.minimized;
    }

    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        return this.label;
    }

    boolean isTabGroup() {
        return true;
    }

    boolean isTabItem() {
        return false;
    }

    Decorations menuShell() {
        return this;
    }

    void propagateWidget(boolean enabled) {
        super.propagateWidget(enabled);
        int[] argList = new int[]{OS.XmNmenuBar, 0};
        OS.XtGetValues(this.scrolledHandle, argList, argList.length / 2);
        if (argList[1] != 0) {
            this.propagateHandle(enabled, argList[1]);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.dialogHandle = 0;
    }

    void releaseWidget() {
        if (this.menus != null) {
            int i = 0;
            while (i < this.menus.length) {
                Menu menu = this.menus[i];
                if (menu != null && !menu.isDisposed()) {
                    menu.releaseResources();
                }
                ++i;
            }
        }
        this.menuBar = null;
        this.menus = null;
        super.releaseWidget();
        this.saveDefault = null;
        this.defaultButton = null;
        this.label = null;
    }

    boolean restoreFocus() {
        if (this.savedFocus != null && this.savedFocus.isDisposed()) {
            this.savedFocus = null;
        }
        boolean restored = this.savedFocus != null && this.savedFocus.setFocus();
        this.savedFocus = null;
        return restored;
    }

    void remove(Menu menu) {
        if (this.menus == null) {
            return;
        }
        int i = 0;
        while (i < this.menus.length) {
            if (this.menus[i] == menu) {
                this.menus[i] = null;
                return;
            }
            ++i;
        }
    }

    public void setDefaultButton(Button button) {
        this.checkWidget();
        this.setDefaultButton(button, true);
    }

    void setDefaultButton(Button button, boolean save) {
        if (button == null) {
            if (this.defaultButton == this.saveDefault) {
                if (save) {
                    this.saveDefault = null;
                }
                return;
            }
        } else {
            if (button.isDisposed()) {
                this.error(5);
            }
            if ((button.style & 8) == 0) {
                return;
            }
            if (button == this.defaultButton) {
                return;
            }
        }
        if (this.defaultButton != null && !this.defaultButton.isDisposed()) {
            this.defaultButton.setDefault(false);
        }
        if ((this.defaultButton = button) == null) {
            this.defaultButton = this.saveDefault;
        }
        if (this.defaultButton != null && !this.defaultButton.isDisposed()) {
            this.defaultButton.setDefault(true);
        }
        if (save) {
            this.saveDefault = this.defaultButton;
        }
        if (this.saveDefault != null && this.saveDefault.isDisposed()) {
            this.saveDefault = null;
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        int pixmap = 0;
        int mask = 0;
        if (image != null) {
            if (image.isDisposed()) {
                this.error(5);
            }
            switch (image.type) {
                case 0: {
                    pixmap = image.pixmap;
                    break;
                }
                case 1: {
                    pixmap = image.pixmap;
                    mask = image.mask;
                    break;
                }
                default: {
                    this.error(40);
                }
            }
        }
        this.image = image;
        int[] argList = new int[]{OS.XmNiconPixmap, pixmap, OS.XmNiconMask, mask};
        int topHandle = this.topHandle();
        OS.XtSetValues(topHandle, argList, argList.length / 2);
    }

    public void setMaximized(boolean maximized) {
        this.checkWidget();
        this.maximized = maximized;
    }

    public void setMenuBar(Menu menu) {
        int vHandle;
        this.checkWidget();
        if (this.menuBar == menu) {
            return;
        }
        if (menu != null) {
            if (menu.isDisposed()) {
                this.error(5);
            }
            if ((menu.style & 2) == 0) {
                this.error(33);
            }
            if (menu.parent != this) {
                this.error(32);
            }
        }
        if (this.menuBar != null) {
            if (!this.isEnabled() && this.menuBar.getEnabled()) {
                this.propagateHandle(true, this.menuBar.handle);
            }
            this.menuBar.removeAccelerators();
        }
        if (menu != null) {
            if (!this.isEnabled()) {
                this.propagateHandle(false, menu.handle);
            }
            menu.addAccelerators();
        }
        int[] argList1 = new int[]{OS.XmNwidth, 0, OS.XmNheight, 0};
        OS.XtGetValues(this.handle, argList1, argList1.length / 2);
        int newHandle = menu != null ? menu.handle : 0;
        int oldHandle = this.menuBar != null ? this.menuBar.handle : 0;
        this.menuBar = menu;
        int hHandle = this.horizontalBar != null ? this.horizontalBar.handle : 0;
        int n = vHandle = this.verticalBar != null ? this.verticalBar.handle : 0;
        if (newHandle != 0) {
            OS.XtSetMappedWhenManaged(newHandle, false);
            OS.XtManageChild(newHandle);
        }
        int clientHandle = this.formHandle != 0 ? this.formHandle : this.handle;
        OS.XmMainWindowSetAreas(this.scrolledHandle, newHandle, 0, hHandle, vHandle, clientHandle);
        if (oldHandle != 0) {
            OS.XtUnmanageChild(oldHandle);
        }
        if (newHandle != 0) {
            OS.XtSetMappedWhenManaged(newHandle, true);
        }
        if (newHandle == 0 && OS.XtIsRealized(this.scrolledHandle)) {
            int[] argList = new int[]{OS.XmNwidth, 0, OS.XmNheight, 0, OS.XmNborderWidth, 0};
            OS.XtGetValues(this.scrolledHandle, argList, argList.length / 2);
            OS.XtResizeWidget(this.scrolledHandle, argList[1] + 1, argList[3], argList[5]);
            OS.XtResizeWidget(this.scrolledHandle, argList[1], argList[3], argList[5]);
        }
        int[] argList2 = new int[]{OS.XmNwidth, 0, OS.XmNheight, 0};
        OS.XtGetValues(this.handle, argList2, argList2.length / 2);
        if (argList1[1] != argList2[1] || argList1[3] != argList2[3]) {
            this.sendEvent(11);
            if (this.layout != null) {
                this.layout(false);
            }
        }
    }

    public void setMinimized(boolean minimized) {
        this.checkWidget();
        this.minimized = minimized;
    }

    void setSavedFocus(Control control) {
        if (this == control) {
            return;
        }
        this.savedFocus = control;
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.label = string;
    }

    boolean translateAccelerator(int key, int keysym, XKeyEvent xEvent) {
        if (OS.IsSunOS && this.menuBar != null && this.menuBar.getEnabled()) {
            switch (keysym) {
                case 65505: 
                case 65506: 
                case 65507: 
                case 65508: 
                case 65513: 
                case 65514: {
                    return false;
                }
            }
            if (keysym != 0) {
                switch (keysym) {
                    case 268828432: {
                        keysym = 65480;
                        key = 0;
                        break;
                    }
                    case 268828433: {
                        keysym = 65481;
                        key = 0;
                    }
                }
                keysym &= 0xFFFF;
            }
            switch (keysym) {
                case 65056: {
                    key = 9;
                    break;
                }
                case 32: {
                    key = 32;
                }
            }
            int accelerator = Display.translateKey(keysym);
            if (accelerator == 0) {
                accelerator = key;
            }
            if (accelerator == 0) {
                return false;
            }
            if ((xEvent.state & 8) != 0) {
                accelerator |= 0x10000;
            }
            if ((xEvent.state & 1) != 0) {
                accelerator |= 0x20000;
            }
            if ((xEvent.state & 4) != 0) {
                accelerator |= 0x40000;
            }
            return this.menuBar.translateAccelerator(accelerator);
        }
        return false;
    }

    boolean traverseItem(boolean next) {
        return false;
    }

    boolean traverseReturn() {
        if (this.defaultButton == null || this.defaultButton.isDisposed()) {
            return false;
        }
        if (!this.defaultButton.isVisible() || !this.defaultButton.isEnabled()) {
            return false;
        }
        this.defaultButton.click();
        return true;
    }
}

