/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class FontDialog
extends Dialog {
    private FontData fontData;
    private Font sampleFont;
    private RGB rgb;
    private Color sampleColor;
    private Hashtable characterSets = new Hashtable();
    private boolean okSelected = false;
    private boolean ignoreEvents = false;
    private Shell shell;
    private Combo charSetCombo;
    private Combo faceNameCombo;
    private Combo fontSizeCombo;
    private Combo fontStyleCombo;
    private Combo extStyleCombo;
    private Label sampleLabel;
    private Button okButton;
    private Button cancelButton;
    private Button colorButton;
    private static final String TEXT_SAMPLE = "AaBbYyZz";
    private static final String[] SCALABLE_SIZES = new String[]{"8", "10", "11", "12", "14", "16", "18", "22", "24", "26"};
    private static final int DEFAULT_SIZE = 14;
    private static final String DEFAULT_STYLE = "medium";
    private static final Integer SCALABLE_KEY = new Integer(0);
    private static final Integer NO_SELECTION = new Integer(-1);
    private static final int COLUMN1_WIDTH = 200;
    private static final int COLUMN2_WIDTH = 150;
    private static final int COLUMN3_WIDTH = 100;
    private static final String PREFIX_ISO8859 = "iso8859";
    private static final String PREFIX_ISO646 = "iso646";
    private static final String PREFIX_UNICODE = "ucs";
    private static final String PREFIX_JAPANESE = "jis";
    private static final String PREFIX_SIMPLIFIEDCHINESE = "gb";
    private static final String PREFIX_TRADITIONALCHINESE = "cns";
    private static final String PREFIX_KOREAN = "ks";
    private static final String[] ISO_CHARSETS = new String[]{"", SWT.getMessage("SWT_Charset_Western"), SWT.getMessage("SWT_Charset_EastEuropean"), SWT.getMessage("SWT_Charset_SouthEuropean"), SWT.getMessage("SWT_Charset_NorthEuropean"), SWT.getMessage("SWT_Charset_Cyrillic"), SWT.getMessage("SWT_Charset_Arabic"), SWT.getMessage("SWT_Charset_Greek"), SWT.getMessage("SWT_Charset_Hebrew"), SWT.getMessage("SWT_Charset_Turkish"), SWT.getMessage("SWT_Charset_Nordic"), SWT.getMessage("SWT_Charset_Thai"), "", SWT.getMessage("SWT_Charset_BalticRim"), SWT.getMessage("SWT_Charset_Celtic"), SWT.getMessage("SWT_Charset_Euro"), SWT.getMessage("SWT_Charset_Romanian")};

    public FontDialog(Shell parent) {
        this(parent, 0);
    }

    public FontDialog(Shell parent, int style) {
        super(parent, style | 0x20 | 0x800 | 0x10000);
        this.checkSubclass();
    }

    void addFonts(FontData[] fonts) {
        int i = 0;
        while (i < fonts.length) {
            Integer sizeValue;
            Hashtable<String, FontData> sizeSet;
            String extStyleName;
            Hashtable<Integer, Hashtable<String, FontData>> extStyleSet;
            String faceName;
            Hashtable faceSet;
            FontData font = fonts[i];
            String charSetName = this.getTranslatedCharSet(font);
            Hashtable charSet = (Hashtable)this.characterSets.get(charSetName);
            if (charSet == null) {
                charSet = new Hashtable(9);
                this.characterSets.put(charSetName, charSet);
            }
            if ((faceSet = (Hashtable)charSet.get(faceName = this.getTranslatedFaceName(font))) == null) {
                faceSet = new Hashtable(9);
                charSet.put(faceName, faceSet);
            }
            if ((extStyleSet = (Hashtable<Integer, Hashtable<String, FontData>>)faceSet.get(extStyleName = font.addStyle)) == null) {
                extStyleSet = new Hashtable<Integer, Hashtable<String, FontData>>(9);
                faceSet.put(extStyleName, extStyleSet);
            }
            if ((sizeSet = (Hashtable<String, FontData>)extStyleSet.get(sizeValue = new Integer(font.getHeight()))) == null) {
                sizeSet = new Hashtable<String, FontData>(9);
                extStyleSet.put(sizeValue, sizeSet);
            }
            String style = font.weight;
            sizeSet.put(style, font);
            ++i;
        }
    }

    void createChildren() {
        Label characterSetLabel = new Label(this.shell, 0);
        Label faceNameLabel = new Label(this.shell, 0);
        Label extendedStyleLabel = new Label(this.shell, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        layout.marginWidth = 15;
        layout.marginHeight = 15;
        layout.horizontalSpacing = 10;
        layout.verticalSpacing = 2;
        this.shell.setLayout(layout);
        characterSetLabel.setText(SWT.getMessage("SWT_Character_set") + ":");
        faceNameLabel.setText(SWT.getMessage("SWT_Font") + ":");
        extendedStyleLabel.setText(SWT.getMessage("SWT_Extended_style") + ":");
        new Label(this.shell, 0);
        this.charSetCombo = new Combo(this.shell, 576);
        GridData gridData = new GridData();
        gridData.widthHint = 200;
        gridData.heightHint = 150;
        gridData.verticalSpan = 3;
        this.charSetCombo.setLayoutData(gridData);
        this.charSetCombo.setData(NO_SELECTION);
        this.faceNameCombo = new Combo(this.shell, 576);
        gridData = new GridData();
        gridData.widthHint = 150;
        gridData.heightHint = 150;
        gridData.verticalSpan = 3;
        gridData.verticalAlignment = 4;
        this.faceNameCombo.setLayoutData(gridData);
        this.faceNameCombo.setData(NO_SELECTION);
        this.extStyleCombo = new Combo(this.shell, 576);
        gridData = new GridData();
        gridData.widthHint = 100;
        gridData.heightHint = 150;
        gridData.verticalSpan = 3;
        gridData.verticalAlignment = 4;
        this.extStyleCombo.setLayoutData(gridData);
        this.extStyleCombo.setData(NO_SELECTION);
        this.createButtons();
        this.createEmptyRow();
        Label fontSizeLabel = new Label(this.shell, 0);
        fontSizeLabel.setText(SWT.getMessage("SWT_Size") + ":");
        Label fontStyleLabel = new Label(this.shell, 0);
        fontStyleLabel.setText(SWT.getMessage("SWT_Style") + ":");
        Label fillLabel = new Label(this.shell, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        fillLabel.setLayoutData(gridData);
        this.fontSizeCombo = new Combo(this.shell, 576);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.heightHint = 110;
        this.fontSizeCombo.setLayoutData(gridData);
        this.fontSizeCombo.setData(NO_SELECTION);
        this.fontStyleCombo = new Combo(this.shell, 576);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.fontStyleCombo.setLayoutData(gridData);
        this.fontStyleCombo.setData(NO_SELECTION);
        fillLabel = new Label(this.shell, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        fillLabel.setLayoutData(gridData);
        this.createEmptyRow();
        Group sampleGroup = new Group(this.shell, 0);
        sampleGroup.setText(SWT.getMessage("SWT_Sample"));
        gridData = new GridData();
        gridData.heightHint = 70;
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        sampleGroup.setLayoutData(gridData);
        layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        sampleGroup.setLayout(layout);
        this.sampleLabel = new Label(sampleGroup, 0x1000000);
        this.sampleLabel.setText(TEXT_SAMPLE);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        this.sampleLabel.setLayoutData(gridData);
        this.shell.setSize(445, 410);
    }

    void createEmptyRow() {
        Label fillLabel = new Label(this.shell, 0);
        GridData gridData = new GridData();
        gridData.heightHint = 5;
        gridData.horizontalSpan = ((GridLayout)this.shell.getLayout()).numColumns;
        fillLabel.setLayoutData(gridData);
    }

    void createButtons() {
        this.okButton = new Button(this.shell, 8);
        this.okButton.setText(SWT.getMessage("SWT_OK"));
        this.shell.setDefaultButton(this.okButton);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.widthHint = 70;
        this.okButton.setLayoutData(gridData);
        this.cancelButton = new Button(this.shell, 8);
        this.cancelButton.setText(SWT.getMessage("SWT_Cancel"));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        this.cancelButton.setLayoutData(gridData);
        this.colorButton = new Button(this.shell, 8);
        this.colorButton.setText(SWT.getMessage("SWT_Color"));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        this.colorButton.setLayoutData(gridData);
    }

    Hashtable getExtStyles(String charsetName, String faceName) {
        Hashtable faces = this.getFaces(charsetName);
        if (faces == null) {
            return null;
        }
        return (Hashtable)faces.get(faceName);
    }

    Hashtable getFaces(String charsetName) {
        return (Hashtable)this.getFonts().get(charsetName);
    }

    public FontData getFontData() {
        return this.fontData;
    }

    FontData getFontData(String charsetName, String faceName, String extStyle, int size, String style) {
        Hashtable styles = this.getStyles(charsetName, faceName, extStyle, size);
        if (styles == null) {
            return null;
        }
        return (FontData)styles.get(style);
    }

    Hashtable getFonts() {
        return this.characterSets;
    }

    public RGB getRGB() {
        return this.rgb;
    }

    FontData getSelectionFontData() {
        String charSetName = this.charSetCombo.getText();
        String faceName = this.faceNameCombo.getText();
        String extStyle = this.extStyleCombo.getText();
        int size = 14;
        try {
            size = Integer.valueOf(this.fontSizeCombo.getText());
            if (size < 1) {
                size = 14;
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        String style = this.fontStyleCombo.getText();
        FontData result = this.getFontData(charSetName, faceName, extStyle, size, style);
        if (result == null) {
            result = new FontData();
            result.characterSetRegistry = charSetName;
            result.setName(faceName);
            result.addStyle = extStyle;
            result.weight = style;
        }
        result.setHeight(size);
        return result;
    }

    Hashtable getSizes(String charsetName, String faceName, String extStyle) {
        Hashtable extStyles = this.getExtStyles(charsetName, faceName);
        if (extStyles == null) {
            return null;
        }
        return (Hashtable)extStyles.get(extStyle);
    }

    Hashtable getStyles(String charsetName, String faceName, String extStyle, int size) {
        Hashtable sizes = this.getSizes(charsetName, faceName, extStyle);
        if (sizes == null) {
            return null;
        }
        Hashtable result = (Hashtable)sizes.get(new Integer(size));
        if (result == null) {
            result = (Hashtable)sizes.get(SCALABLE_KEY);
        }
        return result;
    }

    String getTranslatedCharSet(FontData fontData) {
        String characterSet = fontData.characterSetRegistry;
        String translatedCharSet = null;
        if (characterSet.startsWith(PREFIX_ISO8859)) {
            int charSetName = 1;
            try {
                charSetName = Integer.valueOf(fontData.characterSetName);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            characterSet = characterSet + "-" + charSetName;
            if (charSetName < ISO_CHARSETS.length) {
                translatedCharSet = ISO_CHARSETS[charSetName];
            }
        } else if (characterSet.startsWith(PREFIX_ISO646)) {
            translatedCharSet = SWT.getMessage("SWT_Charset_ASCII");
        } else if (characterSet.startsWith(PREFIX_UNICODE)) {
            translatedCharSet = SWT.getMessage("SWT_Charset_Unicode");
        } else if (characterSet.startsWith(PREFIX_JAPANESE)) {
            translatedCharSet = SWT.getMessage("SWT_Charset_Japanese");
        } else if (characterSet.startsWith(PREFIX_SIMPLIFIEDCHINESE)) {
            translatedCharSet = SWT.getMessage("SWT_Charset_SimplifiedChinese");
        } else if (characterSet.startsWith(PREFIX_TRADITIONALCHINESE)) {
            translatedCharSet = SWT.getMessage("SWT_Charset_TraditionalChinese");
        } else if (characterSet.startsWith(PREFIX_KOREAN)) {
            translatedCharSet = SWT.getMessage("SWT_Charset_Korean");
        }
        translatedCharSet = translatedCharSet != null ? translatedCharSet + " (" + characterSet + ')' : characterSet;
        return translatedCharSet;
    }

    String getTranslatedFaceName(FontData fontData) {
        StringBuffer faceNameBuffer;
        if (fontData.foundry != null && fontData.foundry.length() > 0) {
            faceNameBuffer = new StringBuffer(fontData.fontFamily);
            faceNameBuffer.append(" (");
            faceNameBuffer.append(fontData.foundry);
            faceNameBuffer.append(')');
        } else {
            faceNameBuffer = new StringBuffer(fontData.getName());
        }
        return faceNameBuffer.toString();
    }

    void handleEvent(Event event) {
        if (this.ignoreEvents) {
            return;
        }
        if (event.widget instanceof Combo) {
            String text;
            int newSelectIndex;
            Combo combo = (Combo)event.widget;
            int prevSelectIndex = (Integer)combo.getData();
            if (prevSelectIndex != (newSelectIndex = combo.indexOf(text = combo.getText())) || newSelectIndex == -1) {
                this.ignoreEvents = true;
                combo.setData(new Integer(newSelectIndex));
                if (combo == this.charSetCombo) {
                    this.initFaceNameCombo();
                } else if (combo == this.faceNameCombo) {
                    this.initExtStyleCombo();
                } else if (combo == this.extStyleCombo) {
                    this.initSizeCombo();
                } else if (combo == this.fontSizeCombo) {
                    this.initStyleCombo();
                }
                this.updateSampleFont();
                if (newSelectIndex != -1) {
                    combo.select(newSelectIndex);
                }
                this.ignoreEvents = false;
            }
        } else if (event.widget == this.okButton) {
            this.okSelected = true;
            this.shell.close();
        } else if (event.widget == this.cancelButton) {
            this.okSelected = false;
            this.shell.close();
        } else if (event.widget == this.colorButton) {
            ColorDialog colorDialog = new ColorDialog(this.shell, 0);
            colorDialog.setRGB(this.rgb);
            RGB newRgb = colorDialog.open();
            if (newRgb != null) {
                this.rgb = newRgb;
                this.updateSampleColor();
            }
        }
    }

    void initExtStyleCombo() {
        String oldSelect = this.extStyleCombo.getText();
        this.extStyleCombo.removeAll();
        String characterSet = this.charSetCombo.getText();
        String faceName = this.faceNameCombo.getText();
        Hashtable extStyles = this.getExtStyles(characterSet, faceName);
        this.setItemsSorted(this.extStyleCombo, extStyles);
        int selectIndex = this.extStyleCombo.indexOf(oldSelect);
        selectIndex = Math.max(0, selectIndex);
        this.extStyleCombo.select(selectIndex);
        this.extStyleCombo.setData(new Integer(selectIndex));
        this.initSizeCombo();
    }

    void initFaceNameCombo() {
        String oldSelect = this.faceNameCombo.getText();
        this.faceNameCombo.removeAll();
        String charSetText = this.charSetCombo.getText();
        if (charSetText.length() == 0) {
            return;
        }
        Hashtable faceNames = this.getFaces(charSetText);
        this.setItemsSorted(this.faceNameCombo, faceNames);
        int selectIndex = this.faceNameCombo.indexOf(oldSelect);
        selectIndex = Math.max(0, selectIndex);
        this.faceNameCombo.select(selectIndex);
        this.faceNameCombo.setData(new Integer(selectIndex));
        this.initExtStyleCombo();
    }

    void initializeWidgets() {
        Display display = this.shell.getDisplay();
        this.addFonts(display.getFontList(null, false));
        this.addFonts(display.getFontList(null, true));
        this.setItemsSorted(this.charSetCombo, this.getFonts());
        if (this.fontData != null) {
            Font font = new Font((Device)display, this.fontData);
            this.ignoreEvents = true;
            this.setFontCombos(font.getFontData()[0]);
            this.ignoreEvents = false;
            font.dispose();
        }
        this.updateSampleFont();
        this.updateSampleColor();
    }

    void initSizeCombo() {
        int selectIndex;
        String oldSelect = this.fontSizeCombo.getText();
        this.fontSizeCombo.removeAll();
        String characterSet = this.charSetCombo.getText();
        String faceName = this.faceNameCombo.getText();
        String extStyle = this.extStyleCombo.getText();
        Hashtable sizes = this.getSizes(characterSet, faceName, extStyle);
        if (sizes != null) {
            if (sizes.get(SCALABLE_KEY) == null) {
                this.setSizeItemsSorted(sizes.keys());
            } else {
                Vector<Integer> allSizes = new Vector<Integer>();
                int i = 0;
                while (i < SCALABLE_SIZES.length) {
                    allSizes.addElement(Integer.valueOf(SCALABLE_SIZES[i]));
                    ++i;
                }
                Enumeration providedSizes = sizes.keys();
                while (providedSizes.hasMoreElements()) {
                    Integer size = (Integer)providedSizes.nextElement();
                    if (size.equals(SCALABLE_KEY) || allSizes.contains(size)) continue;
                    allSizes.addElement(size);
                }
                this.setSizeItemsSorted(allSizes.elements());
            }
        }
        if ((selectIndex = this.fontSizeCombo.indexOf(oldSelect)) == -1) {
            selectIndex = this.fontSizeCombo.indexOf(String.valueOf(14));
        }
        selectIndex = Math.max(0, selectIndex);
        this.fontSizeCombo.select(selectIndex);
        this.fontSizeCombo.setData(new Integer(selectIndex));
        this.initStyleCombo();
    }

    void initStyleCombo() {
        String oldSelect = this.fontStyleCombo.getText();
        this.fontStyleCombo.removeAll();
        String characterSet = this.charSetCombo.getText();
        String faceName = this.faceNameCombo.getText();
        String extStyle = this.extStyleCombo.getText();
        try {
            int size = Integer.valueOf(this.fontSizeCombo.getText());
            if (size > 0) {
                Hashtable styles = this.getStyles(characterSet, faceName, extStyle, size);
                this.setItemsSorted(this.fontStyleCombo, styles);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        int selectIndex = this.fontStyleCombo.indexOf(oldSelect);
        if (selectIndex == -1) {
            selectIndex = this.fontStyleCombo.indexOf(String.valueOf(DEFAULT_STYLE));
        }
        selectIndex = Math.max(0, selectIndex);
        this.fontStyleCombo.select(selectIndex);
        this.fontStyleCombo.setData(new Integer(selectIndex));
        this.fontStyleCombo.select(Math.max(0, selectIndex));
    }

    void installListeners() {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                FontDialog.this.handleEvent(event);
            }
        };
        this.okButton.addListener(13, listener);
        this.cancelButton.addListener(13, listener);
        this.colorButton.addListener(13, listener);
        this.charSetCombo.addListener(13, listener);
        this.charSetCombo.addListener(24, listener);
        this.faceNameCombo.addListener(24, listener);
        this.fontStyleCombo.addListener(24, listener);
        this.extStyleCombo.addListener(24, listener);
        this.fontSizeCombo.addListener(24, listener);
    }

    public FontData open() {
        this.shell = new Shell(this.getParent(), this.getStyle() | 0x20 | 0x800 | 0x10000);
        this.createChildren();
        this.installListeners();
        FontData originalFontData = this.fontData;
        RGB originalRGB = this.rgb;
        this.initializeWidgets();
        this.openDialog();
        Display display = this.shell.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        FontData result = null;
        if (this.okSelected) {
            result = this.fontData;
        } else {
            this.fontData = originalFontData;
            this.rgb = originalRGB;
        }
        if (this.sampleFont != null) {
            this.sampleFont.dispose();
        }
        this.sampleFont = null;
        if (this.sampleColor != null) {
            this.sampleColor.dispose();
        }
        this.sampleColor = null;
        return result;
    }

    void openDialog() {
        Point pt = this.shell.computeSize(-1, -1, false);
        Rectangle displayRect = this.shell.getDisplay().getBounds();
        int widthLimit = displayRect.width * 7 / 8;
        int heightLimit = displayRect.height * 7 / 8;
        if (pt.x > widthLimit) {
            pt = this.shell.computeSize(widthLimit, -1, false);
        }
        Rectangle parentBounds = this.getParent().getBounds();
        int originX = (parentBounds.width - pt.x) / 2 + parentBounds.x;
        originX = Math.max(originX, 0);
        originX = Math.min(originX, widthLimit - pt.x);
        int originY = (parentBounds.height - pt.y) / 2 + parentBounds.y;
        originY = Math.max(originY, 0);
        originY = Math.min(originY, heightLimit - pt.y);
        this.shell.setBounds(originX, originY, pt.x, pt.y);
        String title = this.getText();
        if (title.length() == 0) {
            title = SWT.getMessage("SWT_FontDialog_Title");
        }
        this.shell.setText(title);
        this.shell.open();
    }

    void setFontCombos(FontData fontData) {
        String characterSet = this.getTranslatedCharSet(fontData);
        String faceName = this.getTranslatedFaceName(fontData);
        this.charSetCombo.setText(characterSet);
        this.charSetCombo.setData(new Integer(this.charSetCombo.indexOf(characterSet)));
        this.initFaceNameCombo();
        this.faceNameCombo.setText(faceName);
        this.faceNameCombo.setData(new Integer(this.faceNameCombo.indexOf(faceName)));
        this.initExtStyleCombo();
        this.extStyleCombo.setText(fontData.addStyle);
        this.extStyleCombo.setData(new Integer(this.extStyleCombo.indexOf(fontData.addStyle)));
        this.initSizeCombo();
        String value = String.valueOf(fontData.getHeight());
        this.fontSizeCombo.setText(value);
        this.fontSizeCombo.setData(new Integer(this.fontSizeCombo.indexOf(value)));
        this.initStyleCombo();
        this.fontStyleCombo.setText(fontData.weight);
        this.fontStyleCombo.setData(new Integer(this.fontStyleCombo.indexOf(fontData.weight)));
    }

    public void setFontData(FontData fontData) {
        this.fontData = fontData;
    }

    public void setRGB(RGB rgb) {
        this.rgb = rgb;
    }

    void setItemsSorted(Combo combo, Hashtable items) {
        if (items == null) {
            return;
        }
        Enumeration itemKeys = items.keys();
        String[] sortedItems = new String[items.size()];
        int index = 0;
        while (itemKeys.hasMoreElements()) {
            String item = (String)itemKeys.nextElement();
            if (item.length() == 0) continue;
            sortedItems[index++] = item;
        }
        if (index != sortedItems.length) {
            String[] newItems = new String[index];
            System.arraycopy(sortedItems, 0, newItems, 0, index);
            sortedItems = newItems;
        }
        this.sort(sortedItems);
        combo.setItems(sortedItems);
    }

    void setSizeItemsSorted(Enumeration itemsEnum) {
        Vector items = new Vector();
        while (itemsEnum.hasMoreElements()) {
            items.addElement(itemsEnum.nextElement());
        }
        Object[] sortedItems = new Integer[items.size()];
        items.copyInto(sortedItems);
        this.sort((Integer[])sortedItems);
        String[] sortedItemStrings = new String[items.size()];
        int i = 0;
        while (i < sortedItemStrings.length) {
            sortedItemStrings[i] = String.valueOf((Integer)sortedItems[i]);
            ++i;
        }
        this.fontSizeCombo.setItems(sortedItemStrings);
    }

    void sort(Integer[] items) {
        int length = items.length;
        int gap = length / 2;
        while (gap > 0) {
            int i = gap;
            while (i < length) {
                int j = i - gap;
                while (j >= 0) {
                    if (items[j] > items[j + gap]) {
                        Integer swap = items[j];
                        items[j] = items[j + gap];
                        items[j + gap] = swap;
                    }
                    j -= gap;
                }
                ++i;
            }
            gap /= 2;
        }
    }

    void sort(String[] items) {
        int length = items.length;
        int gap = length / 2;
        while (gap > 0) {
            int i = gap;
            while (i < length) {
                int j = i - gap;
                while (j >= 0) {
                    if (items[j].compareTo(items[j + gap]) > 0) {
                        String swap = items[j];
                        items[j] = items[j + gap];
                        items[j + gap] = swap;
                    }
                    j -= gap;
                }
                ++i;
            }
            gap /= 2;
        }
    }

    void updateSampleFont() {
        FontData selectionFontData = this.getSelectionFontData();
        if (this.sampleFont != null) {
            this.sampleFont.dispose();
        }
        this.sampleFont = new Font((Device)this.shell.getDisplay(), selectionFontData);
        this.fontData = selectionFontData;
        this.sampleLabel.setFont(this.sampleFont);
    }

    void updateSampleColor() {
        if (this.rgb == null) {
            this.rgb = new RGB(0, 0, 0);
        }
        if (this.sampleColor != null) {
            if (this.sampleColor.getRGB().equals(this.rgb)) {
                return;
            }
            this.sampleColor.dispose();
        }
        this.sampleColor = new Color(this.getParent().getDisplay(), this.rgb);
        this.sampleLabel.setForeground(this.sampleColor);
    }
}

