/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XInputEvent;
import org.eclipse.swt.internal.motif.XKeyEvent;
import org.eclipse.swt.internal.motif.XSetWindowAttributes;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.WidgetTable;

public abstract class Widget {
    public int handle;
    int style;
    int state;
    EventTable eventTable;
    Object data;
    String[] keys;
    Object[] values;
    static final int DISPOSED = 1024;
    static final int HANDLE = 2048;
    static final int CANVAS = 4096;
    static final int DEFAULT_WIDTH = 64;
    static final int DEFAULT_HEIGHT = 64;
    static final char Mnemonic = '&';
    static final int BUTTON_PRESS = 1;
    static final int BUTTON_RELEASE = 2;
    static final int EXPOSURE = 3;
    static final int ENTER_WINDOW = 4;
    static final int FOCUS_CHANGE = 5;
    static final int KEY_PRESS = 6;
    static final int KEY_RELEASE = 7;
    static final int LEAVE_WINDOW = 8;
    static final int ACTIVATE_CALLBACK = 9;
    static final int ARM_CALLBACK = 10;
    static final int BROWSE_SELECTION_CALLBACK = 11;
    static final int CASCADING_CALLBACK = 12;
    static final int DECREMENT_CALLBACK = 13;
    static final int DEFAULT_ACTION_CALLBACK = 14;
    static final int DRAG_CALLBACK = 15;
    static final int EXTENDED_SELECTION_CALLBACK = 16;
    static final int HELP_CALLBACK = 17;
    static final int INCREMENT_CALLBACK = 18;
    static final int MODIFY_VERIFY_CALLBACK = 19;
    static final int PAGE_DECREMENT_CALLBACK = 20;
    static final int PAGE_INCREMENT_CALLBACK = 21;
    static final int SELECTION_CALLBACK = 22;
    static final int TO_BOTTOM_CALLBACK = 23;
    static final int TO_TOP_CALLBACK = 24;
    static final int VALUE_CHANGED_CALLBACK = 25;
    static final int NON_MASKABLE = 26;
    static final int POINTER_MOTION = 27;
    static final int STRUCTURE_NOTIFY = 28;
    static final int MAP_CALLBACK = 29;
    static final int UNMAP_CALLBACK = 30;
    static final int DELETE_WINDOW = 31;
    static final int EXPOSURE_CALLBACK = 32;

    Widget() {
    }

    public Widget(Widget parent, int style) {
        this.checkSubclass();
        this.checkParent(parent);
        this.style = style;
    }

    public void addListener(int eventType, Listener handler) {
        this.checkWidget();
        if (handler == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        this.eventTable.hook(eventType, handler);
    }

    public void addDisposeListener(DisposeListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(12, typedListener);
    }

    static int checkBits(int style, int int0, int int1, int int2, int int3, int int4, int int5) {
        int mask = int0 | int1 | int2 | int3 | int4 | int5;
        if ((style & mask) == 0) {
            style |= int0;
        }
        if ((style & int0) != 0) {
            style = style & ~mask | int0;
        }
        if ((style & int1) != 0) {
            style = style & ~mask | int1;
        }
        if ((style & int2) != 0) {
            style = style & ~mask | int2;
        }
        if ((style & int3) != 0) {
            style = style & ~mask | int3;
        }
        if ((style & int4) != 0) {
            style = style & ~mask | int4;
        }
        if ((style & int5) != 0) {
            style = style & ~mask | int5;
        }
        return style;
    }

    void checkOrientation(Widget parent) {
        this.style &= 0xF7FFFFFF;
        if ((this.style & 0x6000000) == 0 && parent != null) {
            if ((parent.style & 0x2000000) != 0) {
                this.style |= 0x2000000;
            }
            if ((parent.style & 0x4000000) != 0) {
                this.style |= 0x4000000;
            }
        }
        this.style = Widget.checkBits(this.style, 0x2000000, 0x4000000, 0, 0, 0, 0);
    }

    void checkParent(Widget parent) {
        if (parent == null) {
            this.error(4);
        }
        if (!parent.isValidThread()) {
            this.error(22);
        }
        if (parent.isDisposed()) {
            this.error(5);
        }
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    protected void checkWidget() {
        if (!this.isValidThread()) {
            this.error(22);
        }
        if (this.isDisposed()) {
            this.error(24);
        }
    }

    void createHandle(int index) {
    }

    void createWidget(int index) {
        this.createHandle(index);
        this.hookEvents();
        this.register();
        this.manageChildren();
    }

    void deregister() {
        if (this.handle == 0) {
            return;
        }
        WidgetTable.remove(this.handle);
    }

    void destroyWidget() {
        int topHandle = this.topHandle();
        this.releaseHandle();
        if (topHandle != 0) {
            OS.XtDestroyWidget(topHandle);
        }
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (!this.isValidThread()) {
            this.error(22);
        }
        this.releaseChild();
        this.releaseWidget();
        this.destroyWidget();
    }

    void enableHandle(boolean enabled, int widgetHandle) {
        int[] argList = new int[]{OS.XmNsensitive, enabled ? 1 : 0};
        OS.XtSetValues(widgetHandle, argList, argList.length / 2);
    }

    void error(int code) {
        SWT.error(code);
    }

    boolean filters(int eventType) {
        Display display = this.getDisplay();
        return display.filters(eventType);
    }

    public Object getData() {
        this.checkWidget();
        return this.data;
    }

    public Object getData(String key) {
        this.checkWidget();
        if (key == null) {
            this.error(4);
        }
        if (this.keys == null) {
            return null;
        }
        int i = 0;
        while (i < this.keys.length) {
            if (this.keys[i].equals(key)) {
                return this.values[i];
            }
            ++i;
        }
        return null;
    }

    public abstract Display getDisplay();

    String getName() {
        String string = this.getClass().getName();
        int index = string.lastIndexOf(46);
        if (index == -1) {
            return string;
        }
        return string.substring(index + 1, string.length());
    }

    String getNameText() {
        return "";
    }

    public int getStyle() {
        this.checkWidget();
        return this.style;
    }

    void hookEvents() {
    }

    boolean hooks(int eventType) {
        if (this.eventTable == null) {
            return false;
        }
        return this.eventTable.hooks(eventType);
    }

    public boolean isDisposed() {
        if (this.handle != 0) {
            return false;
        }
        if ((this.state & 0x800) != 0) {
            return true;
        }
        return (this.state & 0x400) != 0;
    }

    protected boolean isListening(int eventType) {
        this.checkWidget();
        return this.hooks(eventType);
    }

    boolean isValidSubclass() {
        return Display.isValidClass(this.getClass());
    }

    boolean isValidThread() {
        return this.getDisplay().isValidThread();
    }

    void manageChildren() {
    }

    char mbcsToWcs(int ch) {
        return this.mbcsToWcs(ch, null);
    }

    char mbcsToWcs(int ch, String codePage) {
        int key = ch & 0xFFFF;
        if (key <= 127) {
            return (char)ch;
        }
        byte[] buffer = key <= 255 ? new byte[]{(byte)key} : new byte[]{(byte)(key >> 8 & 0xFF), (byte)(key & 0xFF)};
        char[] result = Converter.mbcsToWcs(codePage, buffer);
        if (result.length == 0) {
            return '\u0000';
        }
        return result[0];
    }

    public void notifyListeners(int eventType, Event event) {
        this.checkWidget();
        if (event == null) {
            this.error(4);
        }
        this.sendEvent(eventType, event);
    }

    void postEvent(int eventType) {
        this.sendEvent(eventType, null, false);
    }

    void postEvent(int eventType, Event event) {
        this.sendEvent(eventType, event, false);
    }

    void propagateHandle(boolean enabled, int widgetHandle) {
        int xDisplay = OS.XtDisplay(widgetHandle);
        if (xDisplay == 0) {
            return;
        }
        int xWindow = OS.XtWindow(widgetHandle);
        if (xWindow == 0) {
            return;
        }
        int event_mask = OS.XtBuildEventMask(widgetHandle);
        int do_not_propagate_mask = 79;
        if (!enabled) {
            event_mask &= ~(do_not_propagate_mask | 0x10 | 0x20);
            do_not_propagate_mask = 0;
        }
        XSetWindowAttributes attributes = new XSetWindowAttributes();
        attributes.event_mask = event_mask;
        attributes.do_not_propagate_mask = do_not_propagate_mask;
        OS.XChangeWindowAttributes(xDisplay, xWindow, 6144, attributes);
    }

    void redrawHandle(int x, int y, int width, int height, int widgetHandle) {
        int display = OS.XtDisplay(widgetHandle);
        if (display == 0) {
            return;
        }
        int window = OS.XtWindow(widgetHandle);
        if (window == 0) {
            return;
        }
        int[] argList = new int[]{OS.XmNborderWidth, 0, OS.XmNborderColor, 0};
        OS.XtGetValues(widgetHandle, argList, argList.length / 2);
        if (argList[1] != 0) {
            OS.XtSetValues(widgetHandle, argList, argList.length / 2);
        }
        OS.XClearArea(display, window, x, y, width, height, true);
    }

    void register() {
        if (this.handle == 0) {
            return;
        }
        WidgetTable.put(this.handle, this);
    }

    void releaseChild() {
    }

    void releaseHandle() {
        this.handle = 0;
        this.state |= 0x400;
    }

    void releaseResources() {
        this.releaseWidget();
        this.releaseHandle();
    }

    void releaseWidget() {
        this.sendEvent(12);
        this.deregister();
        this.eventTable = null;
        this.data = null;
        this.keys = null;
        this.values = null;
    }

    public void removeListener(int eventType, Listener handler) {
        this.checkWidget();
        if (handler == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(eventType, handler);
    }

    protected void removeListener(int eventType, SWTEventListener handler) {
        this.checkWidget();
        if (handler == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(eventType, handler);
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(12, listener);
    }

    void setInputState(Event event, int state) {
        if ((state & 8) != 0) {
            event.stateMask |= 0x10000;
        }
        if ((state & 1) != 0) {
            event.stateMask |= 0x20000;
        }
        if ((state & 4) != 0) {
            event.stateMask |= 0x40000;
        }
        if ((state & 0x100) != 0) {
            event.stateMask |= 0x80000;
        }
        if ((state & 0x200) != 0) {
            event.stateMask |= 0x100000;
        }
        if ((state & 0x400) != 0) {
            event.stateMask |= 0x200000;
        }
    }

    void setInputState(Event event, XInputEvent xEvent) {
        this.setInputState(event, xEvent.state);
    }

    void setKeyState(Event event, XKeyEvent xEvent) {
        if (xEvent.keycode != 0) {
            int key;
            byte[] buffer = new byte[1];
            int[] keysym = new int[1];
            OS.XLookupString(xEvent, buffer, buffer.length, keysym, null);
            if (OS.IsSunOS && keysym[0] != 0) {
                switch (keysym[0]) {
                    case 268828432: {
                        keysym[0] = 65480;
                        buffer[0] = 0;
                        break;
                    }
                    case 268828433: {
                        keysym[0] = 65481;
                        buffer[0] = 0;
                    }
                }
                keysym[0] = keysym[0] & 0xFFFF;
            }
            if ((xEvent.state & 4) != 0 && 0 <= (key = keysym[0]) && key <= 127) {
                if (97 <= key && key <= 122) {
                    key -= 32;
                }
                if (64 > key || key > 95) {
                    buffer[0] = (byte)key;
                }
            }
            if (OS.IsHPUX && keysym[0] != 0) {
                switch (keysym[0]) {
                    case 65425: {
                        keysym[0] = 65478;
                        break;
                    }
                    case 65426: {
                        keysym[0] = 65479;
                        break;
                    }
                    case 65427: {
                        keysym[0] = 65480;
                        break;
                    }
                    case 65428: {
                        keysym[0] = 65481;
                    }
                }
            }
            switch (keysym[0]) {
                case 65056: {
                    buffer[0] = 9;
                    break;
                }
                case 32: {
                    buffer[0] = 32;
                }
            }
            if (keysym[0] != 0) {
                event.keyCode = Display.translateKey(keysym[0]);
            }
            if (buffer[0] != 0) {
                event.character = this.mbcsToWcs(buffer[0] & 0xFF);
            }
        }
        this.setInputState(event, xEvent);
    }

    void sendEvent(Event event) {
        Display display = event.display;
        if (!display.filterEvent(event) && this.eventTable != null) {
            this.eventTable.sendEvent(event);
        }
    }

    void sendEvent(int eventType) {
        this.sendEvent(eventType, null, true);
    }

    void sendEvent(int eventType, Event event) {
        this.sendEvent(eventType, event, true);
    }

    void sendEvent(int eventType, Event event, boolean send) {
        Display display = this.getDisplay();
        if (this.eventTable == null && !display.filters(eventType)) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        event.type = eventType;
        event.display = display;
        event.widget = this;
        if (event.time == 0) {
            event.time = display.getLastEventTime();
        }
        if (send) {
            this.sendEvent(event);
        } else {
            display.postEvent(event);
        }
    }

    public void setData(Object data) {
        this.checkWidget();
        this.data = data;
    }

    public void setData(String key, Object value) {
        this.checkWidget();
        if (key == null) {
            this.error(4);
        }
        if (value == null) {
            if (this.keys == null) {
                return;
            }
            int index = 0;
            while (index < this.keys.length && !this.keys[index].equals(key)) {
                ++index;
            }
            if (index == this.keys.length) {
                return;
            }
            if (this.keys.length == 1) {
                this.keys = null;
                this.values = null;
            } else {
                String[] newKeys = new String[this.keys.length - 1];
                Object[] newValues = new Object[this.values.length - 1];
                System.arraycopy(this.keys, 0, newKeys, 0, index);
                System.arraycopy(this.keys, index + 1, newKeys, index, newKeys.length - index);
                System.arraycopy(this.values, 0, newValues, 0, index);
                System.arraycopy(this.values, index + 1, newValues, index, newValues.length - index);
                this.keys = newKeys;
                this.values = newValues;
            }
            return;
        }
        if (this.keys == null) {
            this.keys = new String[]{key};
            this.values = new Object[]{value};
            return;
        }
        int i = 0;
        while (i < this.keys.length) {
            if (this.keys[i].equals(key)) {
                this.values[i] = value;
                return;
            }
            ++i;
        }
        String[] newKeys = new String[this.keys.length + 1];
        Object[] newValues = new Object[this.values.length + 1];
        System.arraycopy(this.keys, 0, newKeys, 0, this.keys.length);
        System.arraycopy(this.values, 0, newValues, 0, this.values.length);
        newKeys[this.keys.length] = key;
        newValues[this.values.length] = value;
        this.keys = newKeys;
        this.values = newValues;
    }

    public String toString() {
        String string = "*Disposed*";
        if (!this.isDisposed()) {
            string = "*Wrong Thread*";
            if (this.isValidThread()) {
                string = this.getNameText();
            }
        }
        return this.getName() + " {" + string + "}";
    }

    int topHandle() {
        return this.handle;
    }

    boolean translateAccelerator(int key, int keysym, XKeyEvent xEvent) {
        return false;
    }

    boolean translateMnemonic(int key, XKeyEvent xEvent) {
        return false;
    }

    boolean translateTraversal(int key, XKeyEvent xEvent) {
        return false;
    }

    boolean XmProcessTraversal(int widget, int direction) {
        Display display = this.getDisplay();
        boolean oldFocusOut = display.postFocusOut;
        display.postFocusOut = true;
        boolean result = OS.XmProcessTraversal(widget, direction);
        display.postFocusOut = oldFocusOut;
        if (!display.postFocusOut) {
            display.runFocusOutEvents();
        }
        return result;
    }

    int wcsToMbcs(char ch) {
        return this.wcsToMbcs(ch, null);
    }

    int wcsToMbcs(char ch, String codePage) {
        int key = ch & 0xFFFF;
        if (key <= 127) {
            return ch;
        }
        byte[] buffer = Converter.wcsToMbcs(codePage, new char[]{ch}, false);
        if (buffer.length == 1) {
            return (char)buffer[0];
        }
        if (buffer.length == 2) {
            return (char)((buffer[0] & 0xFF) << 8 | buffer[1] & 0xFF);
        }
        return 0;
    }

    int hoverProc(int widget) {
        return 0;
    }

    int timerProc(int id) {
        return 0;
    }

    int windowProc(int w, int client_data, int call_data, int continue_to_dispatch) {
        switch (client_data) {
            case 1: {
                return this.XButtonPress(w, client_data, call_data, continue_to_dispatch);
            }
            case 2: {
                return this.XButtonRelease(w, client_data, call_data, continue_to_dispatch);
            }
            case 4: {
                return this.XEnterWindow(w, client_data, call_data, continue_to_dispatch);
            }
            case 3: {
                return this.XExposure(w, client_data, call_data, continue_to_dispatch);
            }
            case 5: {
                return this.XFocusChange(w, client_data, call_data, continue_to_dispatch);
            }
            case 6: {
                return this.XKeyPress(w, client_data, call_data, continue_to_dispatch);
            }
            case 7: {
                return this.XKeyRelease(w, client_data, call_data, continue_to_dispatch);
            }
            case 8: {
                return this.XLeaveWindow(w, client_data, call_data, continue_to_dispatch);
            }
            case 9: {
                return this.XmNactivateCallback(w, client_data, call_data);
            }
            case 10: {
                return this.XmNarmCallback(w, client_data, call_data);
            }
            case 11: {
                return this.XmNbrowseSelectionCallback(w, client_data, call_data);
            }
            case 12: {
                return this.XmNcascadingCallback(w, client_data, call_data);
            }
            case 13: {
                return this.XmNdecrementCallback(w, client_data, call_data);
            }
            case 14: {
                return this.XmNdefaultActionCallback(w, client_data, call_data);
            }
            case 15: {
                return this.XmNdragCallback(w, client_data, call_data);
            }
            case 16: {
                return this.XmNextendedSelectionCallback(w, client_data, call_data);
            }
            case 17: {
                return this.XmNhelpCallback(w, client_data, call_data);
            }
            case 18: {
                return this.XmNincrementCallback(w, client_data, call_data);
            }
            case 19: {
                return this.XmNmodifyVerifyCallback(w, client_data, call_data);
            }
            case 20: {
                return this.XmNpageDecrementCallback(w, client_data, call_data);
            }
            case 21: {
                return this.XmNpageIncrementCallback(w, client_data, call_data);
            }
            case 22: {
                return this.XmNselectionCallback(w, client_data, call_data);
            }
            case 23: {
                return this.XmNtoBottomCallback(w, client_data, call_data);
            }
            case 24: {
                return this.XmNtoTopCallback(w, client_data, call_data);
            }
            case 25: {
                return this.XmNvalueChangedCallback(w, client_data, call_data);
            }
            case 26: {
                return this.XNonMaskable(w, client_data, call_data, continue_to_dispatch);
            }
            case 27: {
                return this.XPointerMotion(w, client_data, call_data, continue_to_dispatch);
            }
            case 28: {
                return this.XStructureNotify(w, client_data, call_data, continue_to_dispatch);
            }
            case 29: {
                return this.XmNmapCallback(w, client_data, call_data);
            }
            case 30: {
                return this.XmNunmapCallback(w, client_data, call_data);
            }
            case 31: {
                return this.WM_DELETE_WINDOW(w, client_data, call_data);
            }
            case 32: {
                return this.XmNexposureCallback(w, client_data, call_data);
            }
        }
        return 0;
    }

    int WM_DELETE_WINDOW(int w, int client_data, int call_data) {
        return 0;
    }

    int XButtonPress(int w, int client_data, int call_data, int continue_to_dispatch) {
        return 0;
    }

    int XButtonRelease(int w, int client_data, int call_data, int continue_to_dispatch) {
        return 0;
    }

    int XEnterWindow(int w, int client_data, int call_data, int continue_to_dispatch) {
        return 0;
    }

    int XExposure(int w, int client_data, int call_data, int continue_to_dispatch) {
        return 0;
    }

    int XFocusChange(int w, int client_data, int call_data, int continue_to_dispatch) {
        return 0;
    }

    int XKeyPress(int w, int client_data, int call_data, int continue_to_dispatch) {
        return 0;
    }

    int XKeyRelease(int w, int client_data, int call_data, int continue_to_dispatch) {
        return 0;
    }

    int XLeaveWindow(int w, int client_data, int call_data, int continue_to_dispatch) {
        return 0;
    }

    int XPointerMotion(int w, int client_data, int call_data, int continue_to_dispatch) {
        return 0;
    }

    int XmNactivateCallback(int w, int client_data, int call_data) {
        return 0;
    }

    int XmNarmCallback(int w, int client_data, int call_data) {
        return 0;
    }

    int XmNbrowseSelectionCallback(int w, int client_data, int call_data) {
        return 0;
    }

    int XmNcascadingCallback(int w, int client_data, int call_data) {
        return 0;
    }

    int XmNdecrementCallback(int w, int client_data, int call_data) {
        return 0;
    }

    int XmNdefaultActionCallback(int w, int client_data, int call_data) {
        return 0;
    }

    int XmNdragCallback(int w, int client_data, int call_data) {
        return 0;
    }

    int XmNexposureCallback(int w, int client_data, int call_data) {
        return 0;
    }

    int XmNextendedSelectionCallback(int w, int client_data, int call_data) {
        return 0;
    }

    int XmNhelpCallback(int w, int client_data, int call_data) {
        return 0;
    }

    int XmNincrementCallback(int w, int client_data, int call_data) {
        return 0;
    }

    int XmNmapCallback(int w, int client_data, int call_data) {
        return 0;
    }

    int XmNmodifyVerifyCallback(int w, int client_data, int call_data) {
        return 0;
    }

    int XmNpageDecrementCallback(int w, int client_data, int call_data) {
        return 0;
    }

    int XmNpageIncrementCallback(int w, int client_data, int call_data) {
        return 0;
    }

    int XmNselectionCallback(int w, int client_data, int call_data) {
        return 0;
    }

    int XmNtoBottomCallback(int w, int client_data, int call_data) {
        return 0;
    }

    int XmNtoTopCallback(int w, int client_data, int call_data) {
        return 0;
    }

    int XmNunmapCallback(int w, int client_data, int call_data) {
        return 0;
    }

    int XmNvalueChangedCallback(int w, int client_data, int call_data) {
        return 0;
    }

    int XNonMaskable(int w, int client_data, int call_data, int continue_to_dispatch) {
        return 0;
    }

    int XStructureNotify(int w, int client_data, int call_data, int continue_to_dispatch) {
        return 0;
    }
}

