package org.argosdic;

import org.argosdic.resource.ResourceManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

/**
 * AboutDialog.java
 * @author Xavier Cho
 * @version $Revision: 1.1 $ $Date: 2003/09/13 08:32:23 $
 */
public class AboutDialog extends IconAndMessageDialog {
    private Image image;

    /**
     * @param parent
     */
    public AboutDialog(Shell parent) {
        super(parent);

        ResourceManager resources = ResourceManager.getInstance();
        this.image = resources.getImage("image.gnomekr").createImage(); //$NON-NLS-1$

        StringBuffer buffer = new StringBuffer();
        buffer.append(resources.getString("application.title")); //$NON-NLS-1$
        buffer.append("\n\n"); //$NON-NLS-1$
        buffer.append(resources.getString("about.message")); //$NON-NLS-1$
        buffer.append("\n\n"); //$NON-NLS-1$
        buffer.append(resources.getString("about.credit")); //$NON-NLS-1$

        this.message = buffer.toString();

        setBlockOnOpen(true);
    }

    /**
     * @see org.eclipse.jface.dialogs.IconAndMessageDialog#getImage()
     */
    protected Image getImage() {
        return image;
    }

    /**
     * @see org.eclipse.jface.dialogs.Dialog#createButtonsForButtonBar(org.eclipse.swt.widgets.Composite)
     */
    protected void createButtonsForButtonBar(Composite parent) {
        createButton(
            parent,
            IDialogConstants.OK_ID,
            IDialogConstants.OK_LABEL,
            true);
    }

    /**
     * @see org.eclipse.jface.dialogs.IconAndMessageDialog#createMessageArea(org.eclipse.swt.widgets.Composite)
     */
    protected Control createMessageArea(Composite parent) {
        return super.createMessageArea(parent);
    }

    /**
     * @see org.eclipse.jface.dialogs.Dialog#createDialogArea(org.eclipse.swt.widgets.Composite)
     */
    protected Control createDialogArea(Composite parent) {
        createMessageArea(parent);

        return super.createDialogArea(parent);
    }

    /**
     * @see org.eclipse.jface.window.Window#create()
     */
    public void create() {
        super.create();
        getContents().pack();
    }
}
