package org.argosdic;

import org.argosdic.action.ActionMap;
import org.argosdic.action.program.QuitAction;
import org.argosdic.action.program.SettingsAction;
import org.argosdic.action.program.SpeakAction;
import org.argosdic.resource.ResourceManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.SWT;

/**
 * ArgosDicToolBarManager.java
 * @author Xavier Cho
 * @version $Revision: 1.1 $ $Date: 2003/09/13 08:32:23 $
 */
public class ArgosDicToolBarManager extends ToolBarManager {
    protected ActionMap actions;

    public ArgosDicToolBarManager(ArgosDic application) {
        this(application, SWT.FLAT | SWT.WRAP);
    }

    public ArgosDicToolBarManager(ArgosDic application, int style) {
        super(style);

        Assert.isNotNull(application);
        this.actions = application.getActionMap();

        initialize();
    }

    protected void initialize() {
        ResourceManager resources = ResourceManager.getInstance();

        add(actions.get(SpeakAction.class.getName()));
        add(actions.get(SettingsAction.class.getName()));
        add(new Separator());
        add(actions.get(QuitAction.class.getName()));
    }
}
