package org.argosdic.action.dictionary;

import org.argosdic.ArgosDic;
import org.argosdic.action.BaseAction;
import org.argosdic.dictionary.Dictionary;
import org.argosdic.dictionary.DictionaryManager;
import org.argosdic.resource.ResourceManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.Assert;

/**
 * ChangeDictionaryAction.java
 * @author Xavier Cho
 * @version $Revision: 1.2 $ $Date: 2003/09/13 08:32:23 $
 */
public class SetDictionaryAction extends BaseAction {
    private Dictionary dictionary;

    public SetDictionaryAction(ArgosDic application, Dictionary dictionary) {
        super(application, IAction.AS_RADIO_BUTTON);

        Assert.isNotNull(dictionary);

        ResourceManager resources = ResourceManager.getInstance();

        this.dictionary = dictionary;
        this.setText(dictionary.getName());
        this.setToolTipText(dictionary.getDescription());
        this.setImageDescriptor(resources.getImage("image.dictionary")); //$NON-NLS-1$
    }

    public void run() {
        if(isChecked()) {
            DictionaryManager manager = DictionaryManager.getInstance();
            manager.setSelectedDictionary(dictionary.getId());
        }
    }
}
