package org.argosdic.action.program;

import org.argosdic.ArgosDic;
import org.argosdic.action.BaseAction;
import org.argosdic.preference.DictionaryPreferencePage;
import org.argosdic.resource.ResourceManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.JFacePreferences;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.swt.widgets.Shell;

/**
 * SettingsAction.java
 * @author Xavier Cho
 * @version $Revision: 1.1 $ $Date: 2003/09/12 10:23:53 $
 */
public class SettingsAction extends BaseAction {
    private PreferenceManager preferenceManager;

    public SettingsAction(ArgosDic application) {
        super(application);
    }

    public void run() {
        Shell shell = application.getShell();

        if(preferenceManager==null) {
            createPreferenceManager();
        }

        PreferenceDialog dialog = 
            new PreferenceDialog(shell, preferenceManager);

        IPreferenceStore preferences = JFacePreferences.getPreferenceStore();

        dialog.setPreferenceStore(preferences);
        dialog.setMinimumPageSize(540, 380);
        dialog.open();
    }

    protected void createPreferenceManager() {
        this.preferenceManager = new PreferenceManager();

        ResourceManager resources = ResourceManager.getInstance();

        PreferenceNode node = new PreferenceNode(
            DictionaryPreferencePage.NAME, 
            resources.getString("preference.dictionary"),  //$NON-NLS-1$
            null, 
            DictionaryPreferencePage.class.getName());

        preferenceManager.addToRoot(node);
    }
}
