package org.argosdic.preference;

import org.argosdic.resource.ResourceManager;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;

/**
 * DictionaryPreferencePage.java
 * @author Xavier Cho
 * @version $Revision: 1.1 $ $Date: 2003/09/12 10:23:53 $
 */
public class DictionaryPreferencePage extends FieldEditorPreferencePage {
    public final static String NAME = "Dictionary"; //$NON-NLS-1$

    public DictionaryPreferencePage() {
        super(FieldEditorPreferencePage.GRID);
    }

    public DictionaryPreferencePage(String title) {
        super(title, FieldEditorPreferencePage.GRID);
    }

    public DictionaryPreferencePage(String title, ImageDescriptor image) {
        super(title, image, FieldEditorPreferencePage.GRID);
    }

    /**
     * @see org.eclipse.jface.preference.FieldEditorPreferencePage#createFieldEditors()
     */
    protected void createFieldEditors() {
        ResourceManager resources = ResourceManager.getInstance();

        addField(
            new DirectoryFieldEditor(
                "data.dir", //$NON-NLS-1$
                resources.getString("label.preferences.dataDir"), //$NON-NLS-1$
                getFieldEditorParent()));
    }
}
