package org.argosdic.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.FileNameMap;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.util.Assert;

/**
 * MimeTypeMap.java
 * @author Xavier Cho
 * @version $Revision: 1.1 $ $Date: 2003/09/13 08:32:23 $
 */
public class MimeTypeMap implements FileNameMap {
    static Log log = LogFactory.getLog(MimeTypeMap.class);

    private static final String MIME_TYPES = "/org/argosdic/resource/mime.types"; //$NON-NLS-1$
    public static final String MIME_DEFAULT = "application/octet-stream"; //$NON-NLS-1$
    private Map map;

    /**
     *@param properties 
     */
    public MimeTypeMap() {
        this.map = new HashMap(100);

        BufferedReader reader = null;

        if (log.isInfoEnabled()) {
            log.info("Initializing MimeTypeMap..."); //$NON-NLS-1$
        }

        try {
            InputStream in = getClass().getResourceAsStream(MIME_TYPES);
            Assert.isNotNull(in);

            reader = new BufferedReader(new InputStreamReader(in));

            String line = null;
            while ((line = reader.readLine()) != null) {
                StringTokenizer tokenizer = new StringTokenizer(line);

                if (tokenizer.hasMoreTokens()) {
                    String type = tokenizer.nextToken().trim();
                    String ext = null;

                    if (!type.startsWith("#")) { //$NON-NLS-1$
                        while (tokenizer.hasMoreTokens()) {
                            ext = tokenizer.nextToken().trim();
                            map.put(ext, type);
                        }
                    }
                }
            }
        } catch(IOException e) {
            if(log.isWarnEnabled()) {
                String msg = "Unable to initialize MimeTypeMap."; //$NON-NLS-1$
                log.warn(msg, e);
            }
        } finally {
            if (reader != null) {
                try {
                    reader.close();
                } catch(IOException e) {}
            }
        }

        if (log.isInfoEnabled()) {
            log.info("MimeTypeMap has been initialized successfully."); //$NON-NLS-1$
        }
    }

    /**
     * @see java.net.FileNameMap#getContentTypeFor(java.lang.String)
     */
    public String getContentTypeFor(String fileName) {
        Assert.isNotNull(fileName);
        Assert.isNotNull(map);

        if (log.isDebugEnabled()) {
            log.info("File name : " + fileName); //$NON-NLS-1$
        }

        String ext = null;

        int index = fileName.lastIndexOf("."); //$NON-NLS-1$

        if (index != -1) {
            ext = fileName.substring(index + 1).trim().toLowerCase();
        }

        if (log.isDebugEnabled()) {
            log.info("Checking for extension : " + ext); //$NON-NLS-1$
        }

        String contentType = (String) map.get(ext);

        if (log.isDebugEnabled()) {
            log.info("Found mime type : " + contentType); //$NON-NLS-1$
        }

        if (contentType == null) {
            contentType = MIME_DEFAULT;

            if (log.isDebugEnabled()) {
                log.info("Using default mime type : " + MIME_DEFAULT); //$NON-NLS-1$
            }
        }

        return contentType;
    }
}