/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.jobs;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.internal.jobs.ImplicitJobs;
import org.eclipse.core.internal.jobs.InternalJob;
import org.eclipse.core.internal.jobs.JobListeners;
import org.eclipse.core.internal.jobs.JobQueue;
import org.eclipse.core.internal.jobs.LockManager;
import org.eclipse.core.internal.jobs.Semaphore;
import org.eclipse.core.internal.jobs.Worker;
import org.eclipse.core.internal.jobs.WorkerPool;
import org.eclipse.core.internal.runtime.Assert;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.IProgressProvider;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.jobs.LockListener;

public class JobManager
implements IJobManager {
    private static final String OPTION_DEBUG_JOBS = "org.eclipse.core.runtime/jobs";
    private static final String OPTION_DEBUG_JOBS_TIMING = "org.eclipse.core.runtime/jobs/timing";
    public static final boolean DEBUG = Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption("org.eclipse.core.runtime/jobs"));
    public static final boolean DEBUG_TIMING = Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption("org.eclipse.core.runtime/jobs/timing"));
    private static final DateFormat DEBUG_FORMAT = new SimpleDateFormat("HH:mm:ss.SSS");
    private static JobManager instance;
    protected static final long NEVER = Long.MAX_VALUE;
    private final JobListeners jobListeners = new JobListeners();
    private final Object lock = new Object();
    private final LockManager lockManager = new LockManager();
    private WorkerPool pool;
    private IProgressProvider progressProvider = null;
    private final HashSet running;
    private final JobQueue sleeping;
    private final ImplicitJobs implicitJobs = new ImplicitJobs(this);
    private final JobQueue waiting;

    public static synchronized JobManager getInstance() {
        if (instance == null) {
            new JobManager();
        }
        return instance;
    }

    public static synchronized void shutdown() {
        if (instance != null) {
            instance.doShutdown();
        }
        instance = null;
    }

    public static void debug(String msg) {
        StringBuffer msgBuf = new StringBuffer(msg.length() + 40);
        if (DEBUG_TIMING) {
            DEBUG_FORMAT.format(new Date(), msgBuf, new FieldPosition(0));
            msgBuf.append('-');
        }
        msgBuf.append('[').append(Thread.currentThread()).append(']').append(msg);
        System.out.println(msgBuf.toString());
    }

    private JobManager() {
        instance = this;
        Object object = this.lock;
        synchronized (object) {
            this.waiting = new JobQueue();
            this.sleeping = new JobQueue();
            this.running = new HashSet(10);
            this.pool = new WorkerPool(this);
        }
    }

    public void addJobChangeListener(IJobChangeListener listener) {
        this.jobListeners.add(listener);
    }

    public void beginRule(ISchedulingRule rule) {
        this.implicitJobs.begin(rule);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean cancel(InternalJob job) {
        Object object = this.lock;
        synchronized (object) {
            switch (job.getState()) {
                case 0: {
                    return true;
                }
                case 4: {
                    IProgressMonitor monitor = job.getMonitor();
                    if (monitor == null) break;
                    monitor.setCanceled(true);
                    return false;
                }
            }
            this.changeState(job, 0);
        }
        this.jobListeners.done((Job)job, Status.CANCEL_STATUS);
        return true;
    }

    public void cancel(Object family) {
        Iterator it = this.select(family).iterator();
        while (it.hasNext()) {
            this.cancel((Job)it.next());
        }
    }

    private void changeState(InternalJob job, int newState) {
        Object object = this.lock;
        synchronized (object) {
            int oldState = job.internalGetState();
            switch (oldState) {
                case 0: {
                    break;
                }
                case 8: {
                    job.remove();
                    break;
                }
                case 2: {
                    try {
                        this.waiting.remove(job);
                    }
                    catch (RuntimeException runtimeException) {
                        Assert.isLegal(false, "Tried to remove a job that wasn't in the queue");
                    }
                    break;
                }
                case 1: {
                    try {
                        this.sleeping.remove(job);
                    }
                    catch (RuntimeException runtimeException) {
                        Assert.isLegal(false, "Tried to remove a job that wasn't in the queue");
                    }
                    break;
                }
                case 4: {
                    this.running.remove(job);
                    break;
                }
                default: {
                    Assert.isLegal(false, "Invalid job state: " + job + ", state: " + oldState);
                }
            }
            job.internalSetState(newState);
            switch (newState) {
                case 0: 
                case 8: {
                    break;
                }
                case 2: {
                    this.waiting.enqueue(job);
                    break;
                }
                case 1: {
                    this.sleeping.enqueue(job);
                    break;
                }
                case 4: {
                    this.running.add(job);
                    break;
                }
                default: {
                    Assert.isLegal(false, "Invalid job state: " + job + ", state: " + newState);
                }
            }
        }
    }

    private IProgressMonitor createMonitor(Job job) {
        IProgressMonitor monitor = null;
        if (this.progressProvider != null) {
            monitor = this.progressProvider.createMonitor(job);
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        job.setMonitor(monitor);
        return monitor;
    }

    public Job currentJob() {
        Thread current = Thread.currentThread();
        if (current instanceof Worker) {
            return ((Worker)current).currentJob();
        }
        return null;
    }

    private long delayFor(int priority) {
        switch (priority) {
            case 10: {
                return 0L;
            }
            case 20: {
                return 50L;
            }
            case 30: {
                return 100L;
            }
            case 40: {
                return 500L;
            }
            case 50: {
                return 1000L;
            }
        }
        Assert.isTrue(false, "Job has invalid priority: " + priority);
        return 0L;
    }

    private void doShutdown() {
        Job[] toCancel = null;
        Object object = this.lock;
        synchronized (object) {
            toCancel = ((AbstractCollection)this.running).toArray(new Job[this.running.size()]);
            this.sleeping.clear();
            this.waiting.clear();
            this.running.clear();
        }
        int i = 0;
        while (i < toCancel.length) {
            this.cancel(toCancel[i]);
            ++i;
        }
        this.pool.shutdown();
    }

    public void endRule() {
        this.implicitJobs.end();
    }

    /*
     * Unable to fully structure code
     */
    protected void endJob(Job job, IStatus result) {
        internalJob = job;
        blocked = null;
        var5_5 = this.lock;
        synchronized (var5_5) {
            if (result == Job.ASYNC_FINISH) {
                return;
            }
            if (internalJob.getState() == 0) {
                return;
            }
            if (JobManager.DEBUG) {
                JobManager.debug("Ending job: " + job);
            }
            internalJob.setResult(result);
            this.changeState(internalJob, 0);
            internalJob.setMonitor(null);
            blocked = internalJob.previous();
            internalJob.setPrevious(null);
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl19 : MonitorExitStatement: MONITOREXIT : var5_5
            if (true) ** GOTO lbl27
        }
        do {
            previous = blocked.previous();
            if (blocked.internalGetState() == 8) {
                this.changeState(blocked, 2);
                this.pool.jobQueued(blocked);
            }
            blocked = previous;
lbl27:
            // 2 sources

        } while (blocked != null);
        this.jobListeners.done(job, result);
    }

    public Job[] find(Object family) {
        List members = this.select(family);
        return members.toArray(new Job[members.size()]);
    }

    protected InternalJob findBlockingJob(InternalJob waiting) {
        if (waiting.getRule() == null) {
            return null;
        }
        Object object = this.lock;
        synchronized (object) {
            Iterator it = this.running.iterator();
            while (it.hasNext()) {
                InternalJob job = (InternalJob)it.next();
                while (job != null) {
                    if (waiting.isConflicting(job)) {
                        return job;
                    }
                    job = job.previous();
                }
            }
        }
        return null;
    }

    public LockManager getLockManager() {
        return this.lockManager;
    }

    public ILock newLock() {
        return this.lockManager.newLock();
    }

    private Job nextJob() {
        Object object = this.lock;
        synchronized (object) {
            long now = System.currentTimeMillis();
            InternalJob job = this.sleeping.peek();
            while (job != null && job.getStartTime() < now) {
                job.setStartTime(now + this.delayFor(job.getPriority()));
                this.changeState(job, 2);
                job = this.sleeping.peek();
            }
            while ((job = this.waiting.peek()) != null) {
                InternalJob blocker = this.findBlockingJob(job);
                if (blocker == null) break;
                this.changeState(job, 8);
                blocker.addLast(job);
            }
            if (job != null) {
                this.changeState(job, 4);
                if (DEBUG) {
                    JobManager.debug("Starting job: " + job);
                }
            }
            return (Job)job;
        }
    }

    public void removeJobChangeListener(IJobChangeListener listener) {
        this.jobListeners.remove(listener);
    }

    protected void schedule(InternalJob job, long delay) {
        Assert.isNotNull(job, "Job is null");
        if (!job.shouldSchedule()) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (job.getState() != 0) {
                return;
            }
            if (delay > 0L) {
                job.setStartTime(System.currentTimeMillis() + delay);
                this.changeState(job, 1);
            } else {
                job.setStartTime(System.currentTimeMillis() + this.delayFor(job.getPriority()));
                this.changeState(job, 2);
            }
        }
        this.jobListeners.scheduled((Job)job, delay);
        this.pool.jobQueued(job);
    }

    private void select(List members, Object family, InternalJob firstJob, int stateMask) {
        if (firstJob == null) {
            return;
        }
        InternalJob job = firstJob;
        do {
            if (family != null && !job.belongsTo(family) || (job.getState() & stateMask) == 0) continue;
            members.add(job);
        } while ((job = job.previous()) != null && job != firstJob);
    }

    private List select(Object family) {
        return this.select(family, 7);
    }

    private List select(Object family, int stateMask) {
        ArrayList members = new ArrayList();
        Object object = this.lock;
        synchronized (object) {
            if ((stateMask & 4) != 0) {
                Iterator it = this.running.iterator();
                while (it.hasNext()) {
                    this.select(members, family, (InternalJob)it.next(), stateMask);
                }
            }
            if ((stateMask & 2) != 0) {
                this.select(members, family, this.waiting.peek(), stateMask);
            }
            if ((stateMask & 1) != 0) {
                this.select(members, family, this.sleeping.peek(), stateMask);
            }
        }
        return members;
    }

    public void setLockListener(LockListener listener) {
        this.lockManager.setLockListener(listener);
    }

    protected void setPriority(InternalJob job, int newPriority) {
        Object object = this.lock;
        synchronized (object) {
            int oldPriority = job.getPriority();
            if (oldPriority == newPriority) {
                return;
            }
            job.internalSetPriority(newPriority);
            if (job.getState() == 2) {
                long oldStart = job.getStartTime();
                job.setStartTime(oldStart + (this.delayFor(newPriority) - this.delayFor(oldPriority)));
                this.waiting.resort(job);
            }
        }
    }

    public void setProgressProvider(IProgressProvider provider) {
        this.progressProvider = provider;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean sleep(InternalJob job) {
        Object object = this.lock;
        synchronized (object) {
            switch (job.getState()) {
                case 4: {
                    if (job.getMonitor() == null) break;
                    return false;
                }
                case 1: {
                    job.setStartTime(Long.MAX_VALUE);
                    return true;
                }
                case 0: {
                    return true;
                }
            }
            job.setStartTime(Long.MAX_VALUE);
            this.changeState(job, 1);
        }
        this.jobListeners.sleeping((Job)job);
        return true;
    }

    public void sleep(Object family) {
        Iterator it = this.select(family).iterator();
        while (it.hasNext()) {
            this.sleep((InternalJob)it.next());
        }
    }

    protected long sleepHint() {
        Object object = this.lock;
        synchronized (object) {
            block4: {
                if (this.waiting.isEmpty()) break block4;
                return 0L;
            }
            InternalJob next = this.sleeping.peek();
            return next == null ? Long.MAX_VALUE : next.getStartTime() - System.currentTimeMillis();
        }
    }

    protected Job startJob() {
        Job job;
        while ((job = this.nextJob()) != null) {
            if (job.shouldRun()) {
                this.jobListeners.aboutToRun(job);
                if (job.getState() == 4) {
                    job.setMonitor(this.createMonitor(job));
                    this.jobListeners.running(job);
                    return job;
                }
            }
            if (job.getState() == 1) continue;
            this.endJob(job, Status.CANCEL_STATUS);
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void join(InternalJob job) throws InterruptedException {
        JobChangeAdapter listener;
        Semaphore barrier;
        Object object = this.lock;
        synchronized (object) {
            int state = job.getState();
            if (state == 0) {
                return;
            }
            barrier = new Semaphore(null);
            listener = new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    barrier.release();
                }
            };
            job.addJobChangeListener(listener);
        }
        try {
            barrier.acquire(Long.MAX_VALUE);
        }
        catch (Throwable throwable) {
            object = null;
            job.removeJobChangeListener(listener);
            throw throwable;
        }
        {
            object = null;
            job.removeJobChangeListener(listener);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void join(Object family, IProgressMonitor monitor) throws InterruptedException, OperationCanceledException {
        int jobCount;
        List jobs;
        monitor = Policy.monitorFor(monitor);
        JobChangeAdapter listener = null;
        Object object = this.lock;
        synchronized (object) {
            jobs = Collections.synchronizedList(this.select(family, 7));
            jobCount = jobs.size();
            if (jobCount == 0) {
                return;
            }
            listener = new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    jobs.remove(event.getJob());
                }
            };
            this.addJobChangeListener(listener);
        }
        try {
            int jobsLeft;
            monitor.beginTask(Policy.bind("jobs.waitForFamily"), jobCount);
            monitor.subTask(Policy.bind("jobs.waitForFamilySubTask", Integer.toString(jobCount)));
            int reportedWorkDone = 0;
            while ((jobsLeft = jobs.size()) > 0) {
                int actualWorkDone = jobCount - jobsLeft;
                if (reportedWorkDone < actualWorkDone) {
                    monitor.worked(actualWorkDone - reportedWorkDone);
                    reportedWorkDone = actualWorkDone;
                    monitor.subTask(Policy.bind("jobs.waitForFamilySubTask", Integer.toString(jobsLeft)));
                }
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                Thread.sleep(100L);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            monitor.done();
            this.removeJobChangeListener(listener);
            throw throwable;
        }
        {
            Object var9_12 = null;
            monitor.done();
            this.removeJobChangeListener(listener);
            return;
        }
    }

    protected void wakeUp(InternalJob job) {
        Object object = this.lock;
        synchronized (object) {
            if (job.getState() != 1) {
                return;
            }
            job.setStartTime(System.currentTimeMillis() + this.delayFor(job.getPriority()));
            this.changeState(job, 2);
        }
        this.pool.jobQueued(job);
        this.jobListeners.awake((Job)job);
    }

    public void wakeUp(Object family) {
        Iterator it = this.select(family).iterator();
        while (it.hasNext()) {
            this.wakeUp((InternalJob)it.next());
        }
    }

    public Thread getBlockingThread(InternalJob job) {
        Object object = this.lock;
        synchronized (object) {
            if (job.internalGetState() != 8) {
                return null;
            }
            InternalJob next = job.next();
            while (next.next() != null) {
                next = next.next();
            }
            return next == null ? null : next.getThread();
        }
    }
}

