/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.jobs;

import org.eclipse.core.internal.jobs.InternalJob;

public class JobQueue {
    private final InternalJob dummy = new InternalJob("Queue-Head"){};

    public JobQueue() {
        this.dummy.setNext(this.dummy);
        this.dummy.setPrevious(this.dummy);
    }

    public void clear() {
        this.dummy.setNext(this.dummy);
        this.dummy.setPrevious(this.dummy);
    }

    public boolean contains(Object object) {
        InternalJob entry = this.dummy.next();
        while (entry != this.dummy && entry != object) {
            entry = entry.next();
        }
        return entry == object;
    }

    public InternalJob dequeue() {
        InternalJob toRemove = this.dummy.previous();
        if (toRemove == this.dummy) {
            return null;
        }
        return toRemove.remove();
    }

    public void enqueueAll(InternalJob newEntry) {
        while (newEntry != null) {
            InternalJob previous = newEntry.previous();
            this.enqueue(newEntry);
            newEntry = previous;
        }
    }

    public void enqueue(InternalJob newEntry) {
        InternalJob tail = this.dummy.next();
        while (tail != this.dummy && tail.compareTo(newEntry) < 0 && !newEntry.isConflicting(tail)) {
            tail = tail.next();
        }
        newEntry.setNext(tail);
        newEntry.setPrevious(tail.previous());
        tail.previous().setNext(newEntry);
        tail.setPrevious(newEntry);
    }

    public void remove(InternalJob toRemove) {
        toRemove.remove();
    }

    public void resort(InternalJob entry) {
        this.remove(entry);
        this.enqueue(entry);
    }

    public boolean isEmpty() {
        return this.dummy.next() == this.dummy;
    }

    public InternalJob peek() {
        return this.dummy.previous() == this.dummy ? null : this.dummy.previous();
    }
}

