/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import java.util.Hashtable;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleType;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.accessibility.gtk.ATK;
import org.eclipse.swt.internal.accessibility.gtk.AtkObjectFactoryClass;
import org.eclipse.swt.internal.accessibility.gtk.GTypeInfo;
import org.eclipse.swt.internal.gtk.OS;

class AccessibleFactory {
    int handle;
    AccessibleType accessibleType;
    Callback atkObjectFactoryCB_create_accessible;
    Callback gTypeInfoCB_base_init;
    Hashtable accessibles = new Hashtable(9);
    static Hashtable instances = new Hashtable(9);
    static AccessibleType childType;
    static final String CHILD_TYPE = "SWTChild";
    static final String DEFAULT_PARENTTYPE = "GtkAccessible";
    static final String FACTORY_PARENTTYPE = "AtkObjectFactory";
    static final byte[] SWT_TYPE_PREFIX;
    static final byte[] FACTORY_TYPE;

    static {
        SWT_TYPE_PREFIX = "SWT".getBytes();
        FACTORY_TYPE = "SWTFactory".getBytes();
    }

    private AccessibleFactory(int widgetType) {
        int widgetTypeName = ATK.g_type_name((int)widgetType);
        int widgetTypeNameLength = OS.strlen((int)widgetTypeName) + 1;
        byte[] buffer = new byte[widgetTypeNameLength];
        OS.memmove((byte[])buffer, (int)widgetTypeName, (int)widgetTypeNameLength);
        byte[] factoryName = new byte[FACTORY_TYPE.length + widgetTypeNameLength];
        System.arraycopy(FACTORY_TYPE, 0, factoryName, 0, FACTORY_TYPE.length);
        System.arraycopy(buffer, 0, factoryName, FACTORY_TYPE.length, widgetTypeNameLength);
        if (ATK.g_type_from_name((byte[])factoryName) == 0) {
            int registry = ATK.atk_get_default_registry();
            int previousFactory = ATK.atk_registry_get_factory((int)registry, (int)widgetType);
            int parentType = ATK.atk_object_factory_get_accessible_type((int)previousFactory);
            int swtFactory = this.createFactory(factoryName);
            if (parentType == 0) {
                parentType = ATK.g_type_from_name((byte[])Converter.wcsToMbcs(null, DEFAULT_PARENTTYPE, true));
            }
            ATK.atk_registry_set_factory_type((int)registry, (int)widgetType, (int)swtFactory);
            byte[] newTypeName = new byte[SWT_TYPE_PREFIX.length + widgetTypeNameLength];
            System.arraycopy(SWT_TYPE_PREFIX, 0, newTypeName, 0, SWT_TYPE_PREFIX.length);
            System.arraycopy(buffer, 0, newTypeName, SWT_TYPE_PREFIX.length, widgetTypeNameLength);
            this.accessibleType = new AccessibleType(newTypeName, parentType);
        }
    }

    void addAccessible(Accessible accessible, int widgetHandle) {
        this.accessibles.put(new Integer(widgetHandle), accessible);
    }

    int atkObjectFactory_create_accessible(int widget) {
        Accessible accessible = (Accessible)this.accessibles.get(new Integer(widget));
        return this.accessibleType.createObject(accessible, widget);
    }

    int createFactory(byte[] name) {
        int parent = ATK.g_type_from_name((byte[])Converter.wcsToMbcs(null, FACTORY_PARENTTYPE, true));
        this.gTypeInfoCB_base_init = new Callback(this, "gTypeInfo_base_init", 1);
        GTypeInfo typeInfo = new GTypeInfo();
        typeInfo.base_init = this.gTypeInfoCB_base_init.getAddress();
        typeInfo.class_size = ATK.AtkObjectFactoryClass_sizeof();
        typeInfo.instance_size = ATK.AtkObjectFactory_sizeof();
        this.handle = OS.g_malloc((int)36);
        ATK.memmove((int)this.handle, (GTypeInfo)typeInfo, (int)36);
        return ATK.g_type_register_static((int)parent, (byte[])name, (int)this.handle, (int)0);
    }

    static AccessibleType getChildType() {
        if (childType == null) {
            byte[] typeName = Converter.wcsToMbcs(null, CHILD_TYPE, true);
            int parentType = ATK.g_type_from_name((byte[])Converter.wcsToMbcs(null, DEFAULT_PARENTTYPE, true));
            childType = new AccessibleType(typeName, parentType);
        }
        return childType;
    }

    int gTypeInfo_base_init(int klass) {
        int atkObjectFactoryClass = ATK.ATK_OBJECT_FACTORY_CLASS((int)klass);
        AtkObjectFactoryClass objectFactoryClassStruct = new AtkObjectFactoryClass();
        ATK.memmove((AtkObjectFactoryClass)objectFactoryClassStruct, (int)atkObjectFactoryClass);
        this.atkObjectFactoryCB_create_accessible = new Callback(this, "atkObjectFactory_create_accessible", 1);
        objectFactoryClassStruct.create_accessible = this.atkObjectFactoryCB_create_accessible.getAddress();
        ATK.memmove((int)atkObjectFactoryClass, (AtkObjectFactoryClass)objectFactoryClassStruct);
        return 0;
    }

    static void registerAccessible(Accessible accessible, int widgetHandle) {
        int widgetType = ATK.G_TYPE_FROM_INSTANCE((int)widgetHandle);
        AccessibleFactory factory = (AccessibleFactory)instances.get(new Integer(widgetType));
        if (factory == null) {
            factory = new AccessibleFactory(widgetType);
            instances.put(new Integer(widgetType), factory);
        }
        factory.addAccessible(accessible, widgetHandle);
    }
}

