/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.program;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.Library;
import org.eclipse.swt.internal.gtk.GNOME;
import org.eclipse.swt.internal.gtk.GnomeVFSMimeApplication;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Display;

public final class Program {
    String name;
    String extension;
    String command;
    Display display;
    boolean gnomeExpectUri;
    private static final String desktopData = "Program_DESKTOP";
    static final int DESKTOP_UNKNOWN = 0;
    static final int DESKTOP_KDE = 1;
    static final int DESKTOP_GNOME = 2;

    Program() {
    }

    static int getDesktop(Display display) {
        if (display == null) {
            return 0;
        }
        Integer desktopValue = (Integer)display.getData(desktopData);
        if (desktopValue != null) {
            return desktopValue;
        }
        int desktop = 0;
        if (Program.isGnomeDesktop() && Program.gnome_init()) {
            desktop = 2;
        }
        display.setData(desktopData, new Integer(desktop));
        return desktop;
    }

    public static Program findProgram(String extension) {
        return Program.findProgram(Display.getCurrent(), extension);
    }

    private static Program findProgram(Display display, String extension) {
        if (extension == null) {
            SWT.error(4);
        }
        if (extension.length() == 0) {
            return null;
        }
        if (extension.charAt(0) != '.') {
            extension = "." + extension;
        }
        String command = null;
        String name = null;
        int desktop = Program.getDesktop(display);
        Hashtable mimeInfo = null;
        if (desktop == 2) {
            mimeInfo = Program.gnome_getMimeInfo(display);
        }
        if (mimeInfo == null) {
            return null;
        }
        Iterator keys = mimeInfo.keySet().iterator();
        block0: while (name == null && keys.hasNext()) {
            String mimeType = (String)keys.next();
            Vector mimeExts = (Vector)mimeInfo.get(mimeType);
            int index = 0;
            while (index < mimeExts.size()) {
                if (extension.equals(mimeExts.elementAt(index))) {
                    name = mimeType;
                    continue block0;
                }
                ++index;
            }
        }
        if (name == null) {
            return null;
        }
        boolean[] gnomeExpectUri = null;
        if (desktop == 2) {
            gnomeExpectUri = new boolean[1];
            command = Program.gnome_getMimeTypeCommand(name, gnomeExpectUri);
        }
        if (command == null) {
            return null;
        }
        Program program = new Program();
        program.name = name;
        program.command = command;
        if (desktop == 2) {
            program.gnomeExpectUri = gnomeExpectUri[0];
        }
        program.extension = extension;
        program.display = display;
        return program;
    }

    public static String[] getExtensions() {
        return Program.getExtensions(Display.getCurrent());
    }

    private static String[] getExtensions(Display display) {
        int desktop = Program.getDesktop(display);
        Hashtable mimeInfo = null;
        if (desktop == 2) {
            mimeInfo = Program.gnome_getMimeInfo(display);
        }
        if (mimeInfo == null) {
            return new String[0];
        }
        Vector extensions = new Vector();
        Iterator keys = mimeInfo.keySet().iterator();
        while (keys.hasNext()) {
            String mimeType = (String)keys.next();
            Vector mimeExts = (Vector)mimeInfo.get(mimeType);
            int index = 0;
            while (index < mimeExts.size()) {
                if (!extensions.contains(mimeExts.elementAt(index))) {
                    extensions.addElement(mimeExts.elementAt(index));
                }
                ++index;
            }
        }
        String[] extStrings = new String[extensions.size()];
        int index = 0;
        while (index < extensions.size()) {
            extStrings[index] = (String)extensions.elementAt(index);
            ++index;
        }
        return extStrings;
    }

    public static Program[] getPrograms() {
        return Program.getPrograms(Display.getCurrent());
    }

    private static Program[] getPrograms(Display display) {
        int desktop = Program.getDesktop(display);
        Hashtable mimeInfo = null;
        if (desktop == 2) {
            mimeInfo = Program.gnome_getMimeInfo(display);
        }
        if (mimeInfo == null) {
            return new Program[0];
        }
        Vector<Program> programs = new Vector<Program>();
        boolean[] gnomeExpectUri = null;
        if (desktop == 2) {
            gnomeExpectUri = new boolean[1];
        }
        Iterator keys = mimeInfo.keySet().iterator();
        while (keys.hasNext()) {
            String mimeType = (String)keys.next();
            Vector mimeExts = (Vector)mimeInfo.get(mimeType);
            String extension = "";
            if (mimeExts.size() > 0) {
                extension = (String)mimeExts.elementAt(0);
            }
            String command = null;
            if (desktop == 2) {
                command = Program.gnome_getMimeTypeCommand(mimeType, gnomeExpectUri);
            }
            if (command == null) continue;
            Program program = new Program();
            program.name = mimeType;
            program.command = command;
            if (desktop == 2) {
                program.gnomeExpectUri = gnomeExpectUri[0];
            }
            program.extension = extension;
            program.display = display;
            programs.addElement(program);
        }
        Program[] programList = new Program[programs.size()];
        int index = 0;
        while (index < programList.length) {
            programList[index] = (Program)programs.elementAt(index);
            ++index;
        }
        return programList;
    }

    private static boolean isGnomeDesktop() {
        byte[] name = Converter.wcsToMbcs(null, "_WIN_SUPPORTING_WM_CHECK", true);
        int atom = OS.gdk_atom_intern((byte[])name, (boolean)true);
        if (atom == 0) {
            return false;
        }
        int[] actualType = new int[1];
        int[] actualFormat = new int[1];
        int[] actualLength = new int[1];
        int[] data = new int[1];
        if (!OS.gdk_property_get((int)OS.GDK_ROOT_PARENT(), (int)atom, (int)6, (int)0, (int)1, (int)0, (int[])actualType, (int[])actualFormat, (int[])actualLength, (int[])data)) {
            return false;
        }
        if (data[0] != 0) {
            OS.g_free((int)data[0]);
        }
        return actualLength[0] > 0;
    }

    private static Hashtable gnome_getMimeInfo(Display display) {
        int mimeList;
        Hashtable mimeInfo = new Hashtable();
        int[] mimeData = new int[1];
        int[] extensionData = new int[1];
        int mimeElement = mimeList = GNOME.gnome_vfs_get_registered_mime_types();
        while (mimeElement != 0) {
            OS.memmove((int[])mimeData, (int)mimeElement, (int)4);
            int mimePtr = mimeData[0];
            int mimeLength = OS.strlen((int)mimePtr);
            byte[] mimeTypeBuffer = new byte[mimeLength];
            OS.memmove((byte[])mimeTypeBuffer, (int)mimePtr, (int)mimeLength);
            String mimeType = new String(Converter.mbcsToWcs(null, mimeTypeBuffer));
            int extensionList = GNOME.gnome_vfs_mime_get_extensions_list((int)mimePtr);
            if (extensionList != 0) {
                Vector<String> extensions = new Vector<String>();
                int extensionElement = extensionList;
                while (extensionElement != 0) {
                    OS.memmove((int[])extensionData, (int)extensionElement, (int)4);
                    int extensionPtr = extensionData[0];
                    int extensionLength = OS.strlen((int)extensionPtr);
                    byte[] extensionBuffer = new byte[extensionLength];
                    OS.memmove((byte[])extensionBuffer, (int)extensionPtr, (int)extensionLength);
                    String extension = new String(Converter.mbcsToWcs(null, extensionBuffer));
                    extension = String.valueOf('.') + extension;
                    extensions.add(extension);
                    extensionElement = GNOME.g_list_next((int)extensionElement);
                }
                GNOME.gnome_vfs_mime_extensions_list_free((int)extensionList);
                if (extensions.size() > 0) {
                    mimeInfo.put(mimeType, extensions);
                }
            }
            mimeElement = GNOME.g_list_next((int)mimeElement);
        }
        if (mimeList != 0) {
            GNOME.gnome_vfs_mime_registered_mime_type_list_free((int)mimeList);
        }
        return mimeInfo;
    }

    private static String gnome_getMimeTypeCommand(String mimeType, boolean[] gnomeExpectUri) {
        String command = null;
        GnomeVFSMimeApplication application = new GnomeVFSMimeApplication();
        byte[] mimeTypeBuffer = Converter.wcsToMbcs(null, mimeType, true);
        int ptr = GNOME.gnome_vfs_mime_get_default_application((byte[])mimeTypeBuffer);
        if (ptr != 0) {
            GNOME.memmove((GnomeVFSMimeApplication)application, (int)ptr, (int)28);
            int length = OS.strlen((int)application.command);
            byte[] buffer = new byte[length];
            OS.memmove((byte[])buffer, (int)application.command, (int)length);
            command = new String(Converter.mbcsToWcs(null, buffer));
            gnomeExpectUri[0] = application.expects_uris == 0;
            GNOME.gnome_vfs_mime_application_free((int)ptr);
        }
        return command;
    }

    /*
     * Unable to fully structure code
     */
    private static String[] parseCommand(String cmd) {
        args = new Vector<String>();
        sIndex = 0;
        ** GOTO lbl25
        {
            ++sIndex;
            do {
                if (sIndex < cmd.length() && Compatibility.isWhitespace(cmd.charAt(sIndex))) continue block0;
                if (sIndex >= cmd.length()) continue;
                if (cmd.charAt(sIndex) == '\"' || cmd.charAt(sIndex) == '\'') {
                    eIndex = sIndex + 1;
                    while (eIndex < cmd.length() && cmd.charAt(eIndex) != cmd.charAt(sIndex)) {
                        ++eIndex;
                    }
                    if (eIndex >= cmd.length()) {
                        args.addElement(cmd.substring(sIndex, eIndex));
                    } else {
                        args.addElement(cmd.substring(sIndex + 1, eIndex));
                    }
                    sIndex = eIndex + 1;
                    continue;
                }
                eIndex = sIndex;
                while (eIndex < cmd.length() && !Compatibility.isWhitespace(cmd.charAt(eIndex))) {
                    ++eIndex;
                }
                args.addElement(cmd.substring(sIndex, eIndex));
                sIndex = eIndex + 1;
lbl25:
                // 4 sources

            } while (sIndex < cmd.length());
        }
        strings = new String[args.size()];
        index = 0;
        while (index < args.size()) {
            strings[index] = (String)args.elementAt(index);
            ++index;
        }
        return strings;
    }

    public static boolean launch(String fileName) {
        return Program.launch(Display.getCurrent(), fileName);
    }

    private static boolean launch(Display display, String fileName) {
        String extension;
        Program program;
        int index;
        if (fileName == null) {
            SWT.error(4);
        }
        if ((index = fileName.lastIndexOf(46)) > 0 && (program = Program.findProgram(display, extension = fileName.substring(index))) != null && program.execute(fileName)) {
            return true;
        }
        try {
            Compatibility.exec(fileName);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean execute(String fileName) {
        int desktop;
        if (fileName == null) {
            SWT.error(4);
        }
        if ((desktop = Program.getDesktop(this.display)) == 2) {
            if (this.gnomeExpectUri) {
                fileName = "file://" + fileName;
            }
            String[] args = Program.parseCommand(this.command);
            int fileArg = -1;
            int index = 0;
            while (index < args.length) {
                int j = args[index].indexOf("%f");
                if (j != -1) {
                    String value = args[index];
                    fileArg = index;
                    args[index] = String.valueOf(value.substring(0, j)) + fileName + value.substring(j + 2);
                }
                ++index;
            }
            if (fileName.length() > 0 && fileArg < 0) {
                String[] newArgs = new String[args.length + 1];
                index = 0;
                while (index < args.length) {
                    newArgs[index] = args[index];
                    ++index;
                }
                newArgs[args.length] = fileName;
                args = newArgs;
            }
            try {
                Compatibility.exec(args);
            }
            catch (IOException iOException) {
                return false;
            }
            return true;
        }
        return false;
    }

    public ImageData getImageData() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Program) {
            Program program = (Program)other;
            return this.display == program.display && this.extension.equals(program.extension) && this.name.equals(program.name) && this.command.equals(program.command);
        }
        return false;
    }

    public int hashCode() {
        return this.extension.hashCode() ^ this.name.hashCode() ^ this.command.hashCode() ^ this.display.hashCode();
    }

    public String toString() {
        return "Program {" + this.name + "}";
    }

    static boolean gnome_init() {
        try {
            Library.loadLibrary((String)"swt-gnome");
            return GNOME.gnome_vfs_init();
        }
        catch (Throwable throwable) {
            return false;
        }
    }
}

