/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GtkFileSelection;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Shell;

public class DirectoryDialog
extends Dialog {
    String message = "";
    String filterPath = "";

    public DirectoryDialog(Shell parent) {
        this(parent, 32768);
    }

    public DirectoryDialog(Shell parent, int style) {
        super(parent, style);
        this.checkSubclass();
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public String getMessage() {
        return this.message;
    }

    public String open() {
        int fileNamePtr;
        byte[] titleBytes = Converter.wcsToMbcs(null, this.title, true);
        int handle = OS.gtk_file_selection_new((byte[])titleBytes);
        if (this.parent != null) {
            OS.gtk_window_set_transient_for((int)handle, (int)this.parent.topHandle());
        }
        String answer = null;
        if (this.filterPath != null) {
            int length = this.filterPath.length();
            char[] buffer = new char[length + 1];
            this.filterPath.getChars(0, length, buffer, 0);
            int utf8Ptr = OS.g_utf16_to_utf8((char[])buffer, (int)-1, null, null, null);
            fileNamePtr = OS.g_filename_from_utf8((int)utf8Ptr, (int)-1, null, null, null);
            OS.gtk_file_selection_set_filename((int)handle, (int)fileNamePtr);
            OS.g_free((int)utf8Ptr);
            OS.g_free((int)fileNamePtr);
        }
        GtkFileSelection selection = new GtkFileSelection();
        OS.memmove((GtkFileSelection)selection, (int)handle);
        OS.gtk_file_selection_hide_fileop_buttons((int)handle);
        int fileListParent = OS.gtk_widget_get_parent((int)selection.file_list);
        OS.gtk_widget_hide((int)selection.file_list);
        OS.gtk_widget_hide((int)fileListParent);
        int response = OS.gtk_dialog_run((int)handle);
        if (response == -5) {
            fileNamePtr = OS.gtk_file_selection_get_filename((int)handle);
            int utf8Ptr = OS.g_filename_to_utf8((int)fileNamePtr, (int)-1, null, null, null);
            int[] items_written = new int[1];
            int utf16Ptr = OS.g_utf8_to_utf16((int)utf8Ptr, (int)-1, null, (int[])items_written, null);
            int length = items_written[0];
            char[] buffer = new char[length];
            OS.memmove((char[])buffer, (int)utf16Ptr, (int)(length * 2));
            String osAnswer = new String(buffer);
            OS.g_free((int)utf16Ptr);
            OS.g_free((int)utf8Ptr);
            if (osAnswer != null) {
                answer = osAnswer;
                char separator = System.getProperty("file.separator").charAt(0);
                int separatorIndex = answer.lastIndexOf(separator);
                if (separatorIndex != answer.length() - 1) {
                    answer = String.valueOf(answer) + separator;
                }
                this.filterPath = answer;
            }
        }
        OS.gtk_widget_destroy((int)handle);
        return answer;
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }

    public void setMessage(String string) {
        this.message = string;
    }
}

