/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Shell;

public class MessageBox
extends Dialog {
    String message = "";
    int handle;

    public MessageBox(Shell parent) {
        this(parent, 65570);
    }

    public MessageBox(Shell parent, int style) {
        super(parent, MessageBox.checkStyle(style));
        this.checkSubclass();
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public int open() {
        int parentHandle = this.parent != null ? this.parent.topHandle() : 0;
        int dialogFlags = 2;
        if ((this.style & 0x38000) != 0) {
            dialogFlags |= 1;
        }
        int messageType = 0;
        if ((this.style & 8) != 0) {
            messageType = 1;
        }
        if ((this.style & 4) != 0) {
            messageType = 2;
        }
        if ((this.style & 1) != 0) {
            messageType = 3;
        }
        this.handle = OS.gtk_message_dialog_new((int)parentHandle, (int)dialogFlags, (int)messageType, (int)0, (String)this.message);
        if (this.handle == 0) {
            SWT.error(2);
        }
        this.createButtons();
        int result = OS.gtk_dialog_run((int)this.handle);
        OS.gtk_widget_destroy((int)this.handle);
        return result;
    }

    private void createButtons() {
        if ((this.style & 0x20) != 0) {
            OS.gtk_dialog_add_button((int)this.handle, (String)"gtk-ok", (int)32);
        }
        if ((this.style & 0x100) != 0) {
            OS.gtk_dialog_add_button((int)this.handle, (String)"gtk-cancel", (int)256);
        }
        if ((this.style & 0x40) != 0) {
            OS.gtk_dialog_add_button((int)this.handle, (String)"gtk-yes", (int)64);
        }
        if ((this.style & 0x80) != 0) {
            OS.gtk_dialog_add_button((int)this.handle, (String)"gtk-no", (int)128);
        }
        if ((this.style & 0x200) != 0) {
            OS.gtk_dialog_add_button((int)this.handle, (String)SWT.getMessage("SWT_Abort"), (int)512);
        }
        if ((this.style & 0x400) != 0) {
            OS.gtk_dialog_add_button((int)this.handle, (String)SWT.getMessage("SWT_Retry"), (int)1024);
        }
        if ((this.style & 0x800) != 0) {
            OS.gtk_dialog_add_button((int)this.handle, (String)SWT.getMessage("SWT_Ignore"), (int)2048);
        }
    }

    private static int checkStyle(int style) {
        int mask = 4064;
        int bits = style & mask;
        if (bits == 32 || bits == 256 || bits == 288) {
            return style;
        }
        if (bits == 64 || bits == 128 || bits == 192 || bits == 448) {
            return style;
        }
        if (bits == 1280 || bits == 3584) {
            return style;
        }
        style = style & ~mask | 0x20;
        return style;
    }
}

