/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XTextProperty;
import org.eclipse.swt.widgets.Display;

public class TextTransfer
extends ByteArrayTransfer {
    private static TextTransfer _instance = new TextTransfer();
    private static final String TYPENAME1 = "COMPOUND_TEXT";
    private static final int TYPEID1 = Transfer.registerType("COMPOUND_TEXT");
    private static final String TYPENAME2 = "STRING";
    private static final int TYPEID2 = Transfer.registerType("STRING");

    private TextTransfer() {
    }

    public static TextTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (object == null || !(object instanceof String)) {
            return;
        }
        byte[] buffer = Converter.wcsToMbcs(null, (String)object, true);
        if (transferData.type == TYPEID1) {
            Display display = Display.getCurrent();
            if (display == null) {
                transferData.result = 0;
                return;
            }
            int xDisplay = display.xDisplay;
            int pBuffer = OS.XtMalloc(buffer.length);
            OS.memmove(pBuffer, buffer, buffer.length);
            int list = OS.XtMalloc(4);
            OS.memmove(list, new int[]{pBuffer}, 4);
            XTextProperty text_prop_return = new XTextProperty();
            int result = OS.XmbTextListToTextProperty(xDisplay, list, 1, 1, text_prop_return);
            OS.XtFree(pBuffer);
            OS.XtFree(list);
            if (result != 0) {
                transferData.result = 0;
            } else {
                transferData.format = text_prop_return.format;
                transferData.length = text_prop_return.nitems;
                transferData.pValue = text_prop_return.value;
                transferData.type = text_prop_return.encoding;
                transferData.result = 1;
            }
        } else {
            super.javaToNative(buffer, transferData);
        }
    }

    public Object nativeToJava(TransferData transferData) {
        byte[] buffer = null;
        if (transferData.type == TYPEID1) {
            Display display = Display.getCurrent();
            if (display == null) {
                return null;
            }
            int xDisplay = display.xDisplay;
            XTextProperty text_prop = new XTextProperty();
            text_prop.encoding = transferData.type;
            text_prop.format = transferData.format;
            text_prop.nitems = transferData.length;
            text_prop.value = transferData.pValue;
            int[] list_return = new int[1];
            int[] count_return = new int[1];
            int result = OS.XmbTextPropertyToTextList(xDisplay, text_prop, list_return, count_return);
            if (result != 0 || list_return[0] == 0) {
                return null;
            }
            int[] ptr = new int[1];
            OS.memmove(ptr, list_return[0], 4);
            int length = OS.strlen(ptr[0]);
            buffer = new byte[length];
            OS.memmove(buffer, ptr[0], buffer.length);
            OS.XFreeStringList(list_return[0]);
        } else {
            buffer = (byte[])super.nativeToJava(transferData);
        }
        if (buffer == null) {
            return null;
        }
        char[] unicode = Converter.mbcsToWcs(null, buffer);
        String string = new String(unicode);
        int end = string.indexOf(0);
        return end == -1 ? string : string.substring(0, end);
    }

    protected String[] getTypeNames() {
        return new String[]{TYPENAME1, TYPENAME2};
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID1, TYPEID2};
    }
}

