/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XAnyEvent;
import org.eclipse.swt.internal.motif.XColor;
import org.eclipse.swt.internal.motif.XConfigureEvent;
import org.eclipse.swt.internal.motif.XExposeEvent;
import org.eclipse.swt.internal.motif.XKeyEvent;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Synchronizer;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swt.widgets.WidgetTable;

public class Display
extends Device {
    public XAnyEvent xEvent = new XAnyEvent();
    int lastSerial;
    Callback windowCallback;
    int windowProc;
    int shellHandle;
    static boolean XtInitialized;
    static Object XInitLock;
    static String APP_NAME;
    byte[] displayName;
    byte[] appName;
    byte[] appClass;
    Event[] eventQueue;
    XKeyEvent keyEvent = new XKeyEvent();
    EventTable eventTable;
    EventTable filterTable;
    boolean postFocusOut;
    Font defaultFont;
    Font listFont;
    Font textFont;
    Font buttonFont;
    Font labelFont;
    int dialogBackground;
    int dialogForeground;
    int buttonBackground;
    int buttonForeground;
    int buttonShadowThickness;
    int compositeBackground;
    int compositeForeground;
    int compositeTopShadow;
    int compositeBottomShadow;
    int compositeBorder;
    int listBackground;
    int listForeground;
    int listSelect;
    int textBackground;
    int textForeground;
    int labelBackground;
    int labelForeground;
    int scrollBarBackground;
    int scrollBarForeground;
    int scrolledInsetX;
    int scrolledInsetY;
    int scrolledMarginX;
    int scrolledMarginY;
    int defaultBackground;
    int defaultForeground;
    int textHighlightThickness;
    XColor COLOR_WIDGET_DARK_SHADOW;
    XColor COLOR_WIDGET_NORMAL_SHADOW;
    XColor COLOR_WIDGET_LIGHT_SHADOW;
    XColor COLOR_WIDGET_HIGHLIGHT_SHADOW;
    XColor COLOR_WIDGET_FOREGROUND;
    XColor COLOR_WIDGET_BACKGROUND;
    XColor COLOR_WIDGET_BORDER;
    XColor COLOR_LIST_FOREGROUND;
    XColor COLOR_LIST_BACKGROUND;
    XColor COLOR_LIST_SELECTION;
    XColor COLOR_LIST_SELECTION_TEXT;
    Color COLOR_INFO_BACKGROUND;
    int leftBorderWidth = 2;
    int rightBorderWidth = 2;
    int topBorderHeight = 2;
    int bottomBorderHeight = 2;
    int leftResizeWidth = 3;
    int rightResizeWidth = 3;
    int topResizeHeight = 3;
    int bottomResizeHeight = 3;
    int leftTitleBorderWidth = 3;
    int rightTitleBorderWidth = 2;
    int topTitleBorderHeight = 26;
    int bottomTitleBorderHeight = 2;
    int leftTitleResizeWidth = 3;
    int rightTitleResizeWidth = 3;
    int topTitleResizeHeight = 26;
    int bottomTitleResizeHeight = 3;
    int leftTitleWidth = 0;
    int rightTitleWidth = 0;
    int topTitleHeight = 23;
    int bottomTitleHeight = 0;
    Synchronizer synchronizer = new Synchronizer(this);
    Thread thread;
    Runnable[] disposeList;
    int[] timerIds;
    Runnable[] timerList;
    Callback timerCallback;
    int timerProc;
    Callback windowTimerCallback;
    int windowTimerProc;
    static int[][] KeyTable;
    static Display Default;
    static Display[] Displays;
    int lastTime;
    int lastButton;
    Caret currentCaret;
    Callback caretCallback;
    int caretID;
    int caretProc;
    static boolean DisplayDisposed;
    static final String PACKAGE_PREFIX = "org.eclipse.swt.widgets.";
    Callback mouseHoverCallback;
    int mouseHoverID;
    int mouseHoverProc;
    int mouseHoverHandle;
    int toolTipHandle;
    int dragTranslations;
    int arrowTranslations;
    int tabTranslations;
    Callback checkExposeCallback;
    int checkExposeProc;
    int exposeCount;
    int lastExpose;
    XExposeEvent xExposeEvent = new XExposeEvent();
    Callback checkResizeCallback;
    int checkResizeProc;
    int resizeWidth;
    int resizeHeight;
    int resizeCount;
    int resizeWindow;
    XConfigureEvent xConfigureEvent = new XConfigureEvent();
    Callback wakeCallback;
    int wakeProc;
    int read_fd;
    int write_fd;
    int inputID;
    byte[] wake_buffer = new byte[1];
    int[] timeout = new int[2];
    byte[] fd_set;
    Object data;
    String[] keys;
    Object[] values;

    static void setDevice(Device device) {
        Device.CurrentDevice = device;
    }

    public Display() {
        this(null);
    }

    public Display(DeviceData data) {
        super(Display.checkNull(data));
    }

    static DeviceData checkNull(DeviceData data) {
        if (data == null) {
            data = new DeviceData();
        }
        if (data.application_name == null) {
            data.application_name = APP_NAME;
        }
        if (data.application_class == null) {
            data.application_class = APP_NAME;
        }
        return data;
    }

    protected void checkDevice() {
        if (!this.isValidThread()) {
            this.error(22);
        }
        if (this.isDisposed()) {
            this.error(45);
        }
    }

    void addMouseHoverTimeOut(int handle) {
        if (this.mouseHoverID != 0) {
            OS.XtRemoveTimeOut(this.mouseHoverID);
        }
        int xtContext = OS.XtDisplayToApplicationContext(this.xDisplay);
        this.mouseHoverID = OS.XtAppAddTimeOut(xtContext, 400, this.mouseHoverProc, handle);
        this.mouseHoverHandle = handle;
    }

    void addFilter(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.filterTable == null) {
            this.filterTable = new EventTable();
        }
        this.filterTable.hook(eventType, listener);
    }

    public void addListener(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        this.eventTable.hook(eventType, listener);
    }

    public void asyncExec(Runnable runnable) {
        if (this.isDisposed()) {
            this.error(45);
        }
        this.synchronizer.asyncExec(runnable);
    }

    public void beep() {
        this.checkDevice();
        OS.XBell(this.xDisplay, 100);
        OS.XFlush(this.xDisplay);
    }

    int caretProc(int clientData, int id) {
        this.caretID = 0;
        if (this.currentCaret == null) {
            return 0;
        }
        if (this.currentCaret.blinkCaret()) {
            int blinkRate = this.currentCaret.blinkRate;
            int xtContext = OS.XtDisplayToApplicationContext(this.xDisplay);
            this.caretID = OS.XtAppAddTimeOut(xtContext, blinkRate, this.caretProc, 0);
        } else {
            this.currentCaret = null;
        }
        return 0;
    }

    int checkExposeProc(int display, int event, int window) {
        OS.memmove(this.xExposeEvent, event, 96);
        if (this.xExposeEvent.window != window) {
            return 0;
        }
        switch (this.xExposeEvent.type) {
            case 12: 
            case 13: {
                ++this.exposeCount;
                this.lastExpose = event;
                this.xExposeEvent.count = 1;
                OS.memmove(event, this.xExposeEvent, 96);
            }
        }
        return 0;
    }

    int checkResizeProc(int display, int event, int arg) {
        OS.memmove(this.xConfigureEvent, event, 96);
        if (this.xConfigureEvent.window != this.resizeWindow) {
            return 0;
        }
        switch (this.xConfigureEvent.type) {
            case 22: {
                int width = this.xConfigureEvent.width;
                int height = this.xConfigureEvent.height;
                if (width == this.resizeWidth && height == this.resizeHeight) break;
                ++this.resizeCount;
            }
        }
        return 0;
    }

    static synchronized void checkDisplay(Thread thread) {
        int i = 0;
        while (i < Displays.length) {
            if (Displays[i] != null && Display.Displays[i].thread == thread) {
                SWT.error(22);
            }
            ++i;
        }
    }

    protected void checkSubclass() {
        if (!Display.isValidClass(this.getClass())) {
            this.error(43);
        }
    }

    public void close() {
        this.checkDevice();
        Event event = new Event();
        this.sendEvent(21, event);
        if (event.doit) {
            this.dispose();
        }
    }

    String convertToLf(String text) {
        char Cr = '\r';
        char Lf = '\n';
        int length = text.length();
        if (length == 0) {
            return text;
        }
        int i = text.indexOf(Lf, 0);
        if (i == -1 || i == 0) {
            return text;
        }
        if (text.charAt(i - 1) != Cr) {
            return text;
        }
        i = 0;
        StringBuffer result = new StringBuffer();
        while (i < length) {
            int j = text.indexOf(Cr, i);
            if (j == -1) {
                j = length;
            }
            String s = text.substring(i, j);
            result.append(s);
            i = j + 2;
            result.append(Lf);
        }
        return result.toString();
    }

    protected void create(DeviceData data) {
        this.checkSubclass();
        this.thread = Thread.currentThread();
        Display.checkDisplay(this.thread);
        this.createDisplay(data);
        Display.register(this);
        if (Default == null) {
            Default = this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createDisplay(DeviceData data) {
        Object object = XInitLock;
        synchronized (object) {
            if (!XtInitialized) {
                OS.XtToolkitInitialize();
            }
            XtInitialized = true;
        }
        int[] argc = new int[]{0};
        int xtContext = OS.XtCreateApplicationContext();
        OS.XtSetLanguageProc(xtContext, 0, 0);
        int ptr1 = 0;
        int ptr2 = 0;
        if (OS.IsLinux && OS.IsDBLocale) {
            int[] spec;
            String resource = "*fontList: -*-*-medium-r-*-*-*-120-*-*-*-*-*-*:";
            byte[] buffer = Converter.wcsToMbcs(null, resource, true);
            ptr1 = OS.XtMalloc(buffer.length);
            if (ptr1 != 0) {
                OS.memmove(ptr1, buffer, buffer.length);
            }
            if ((ptr2 = OS.XtMalloc((spec = new int[]{ptr1, 0}).length * 4)) != 0) {
                OS.memmove(ptr2, spec, spec.length * 4);
            }
            OS.XtAppSetFallbackResources(xtContext, ptr2);
        }
        String display_name = null;
        String application_name = APP_NAME;
        String application_class = APP_NAME;
        if (data != null) {
            if (data.display_name != null) {
                display_name = data.display_name;
            }
            if (data.application_name != null) {
                application_name = data.application_name;
            }
            if (data.application_class != null) {
                application_class = data.application_class;
            }
        }
        if (display_name != null) {
            this.displayName = Converter.wcsToMbcs(null, display_name, true);
        }
        if (application_name != null) {
            this.appName = Converter.wcsToMbcs(null, application_name, true);
        }
        if (application_class != null) {
            this.appClass = Converter.wcsToMbcs(null, application_class, true);
        }
        this.xDisplay = OS.XtOpenDisplay(xtContext, this.displayName, this.appName, this.appClass, 0, 0, argc, 0);
        DisplayDisposed = false;
        if (ptr2 != 0) {
            OS.XtAppSetFallbackResources(xtContext, 0);
            OS.XtFree(ptr2);
        }
        if (ptr1 != 0) {
            OS.XtFree(ptr1);
        }
    }

    static synchronized void deregister(Display display) {
        int i = 0;
        while (i < Displays.length) {
            if (display == Displays[i]) {
                Display.Displays[i] = null;
            }
            ++i;
        }
    }

    protected void destroy() {
        if (this == Default) {
            Default = null;
        }
        Display.deregister(this);
        this.destroyDisplay();
    }

    void destroyDisplay() {
        OS.XtDestroyWidget(OS.XmGetXmDisplay(this.xDisplay));
        int xtContext = OS.XtDisplayToApplicationContext(this.xDisplay);
        OS.XtDestroyApplicationContext(xtContext);
        DisplayDisposed = true;
    }

    public void disposeExec(Runnable runnable) {
        this.checkDevice();
        if (this.disposeList == null) {
            this.disposeList = new Runnable[4];
        }
        int i = 0;
        while (i < this.disposeList.length) {
            if (this.disposeList[i] == null) {
                this.disposeList[i] = runnable;
                return;
            }
            ++i;
        }
        Runnable[] newDisposeList = new Runnable[this.disposeList.length + 4];
        System.arraycopy(this.disposeList, 0, newDisposeList, 0, this.disposeList.length);
        newDisposeList[this.disposeList.length] = runnable;
        this.disposeList = newDisposeList;
    }

    void error(int code) {
        SWT.error(code);
    }

    boolean filterEvent(Event event) {
        if (this.filterTable != null) {
            this.filterTable.sendEvent(event);
        }
        return false;
    }

    boolean filters(int eventType) {
        if (this.filterTable == null) {
            return false;
        }
        return this.filterTable.hooks(eventType);
    }

    boolean filterEvent(XAnyEvent event) {
        if (event.type != 2) {
            return false;
        }
        OS.memmove(this.keyEvent, event, 96);
        if (this.keyEvent.keycode == 0) {
            return false;
        }
        int xWindow = this.keyEvent.window;
        if (xWindow == 0) {
            return false;
        }
        int handle = OS.XtWindowToWidget(this.xDisplay, xWindow);
        if (handle == 0) {
            return false;
        }
        if ((handle = OS.XmGetFocusWidget(handle)) == 0) {
            return false;
        }
        Widget widget = WidgetTable.get(handle);
        if (widget == null) {
            return false;
        }
        int oldState = this.keyEvent.state;
        this.keyEvent.state = 0;
        byte[] buffer1 = new byte[4];
        int[] buffer2 = new int[1];
        int key = 0;
        if (OS.XLookupString(this.keyEvent, buffer1, 1, buffer2, null) != 0) {
            key = buffer1[0] & 0xFF;
        }
        int keysym = buffer2[0] & 0xFFFF;
        this.keyEvent.state = oldState;
        if ((keysym == 65293 || keysym == 65421) && event.serial != this.lastSerial) {
            if (OS.XFilterEvent(event, OS.XtWindow(handle))) {
                return true;
            }
            this.lastSerial = event.serial;
        }
        if (widget.translateAccelerator(key, keysym, this.keyEvent)) {
            return true;
        }
        if (key != 0 && widget.translateMnemonic(key, this.keyEvent)) {
            return true;
        }
        if (keysym == 0) {
            return false;
        }
        switch (keysym) {
            case 65289: 
            case 65293: 
            case 65307: 
            case 65361: 
            case 65362: 
            case 65363: 
            case 65364: 
            case 65365: 
            case 65366: 
            case 65385: 
            case 65421: {
                if (!widget.translateTraversal(keysym, this.keyEvent)) break;
                return true;
            }
        }
        return false;
    }

    public Widget findWidget(int handle) {
        this.checkDevice();
        return WidgetTable.get(handle);
    }

    public Shell getActiveShell() {
        this.checkDevice();
        int[] buffer1 = new int[1];
        int[] buffer2 = new int[1];
        OS.XGetInputFocus(this.xDisplay, buffer1, buffer2);
        int xWindow = buffer1[0];
        if (xWindow == 0) {
            return null;
        }
        int handle = OS.XtWindowToWidget(this.xDisplay, xWindow);
        if (handle == 0) {
            return null;
        }
        do {
            if (!OS.XtIsSubclass(handle, OS.ShellWidgetClass())) continue;
            Widget widget = WidgetTable.get(handle);
            if (widget instanceof Shell) {
                return (Shell)widget;
            }
            return null;
        } while ((handle = OS.XtParent(handle)) != 0);
        return null;
    }

    public static synchronized Display getCurrent() {
        return Display.findDisplay(Thread.currentThread());
    }

    public static synchronized Display findDisplay(Thread thread) {
        int i = 0;
        while (i < Displays.length) {
            Display display = Displays[i];
            if (display != null && display.thread == thread) {
                return display;
            }
            ++i;
        }
        return null;
    }

    public Control getCursorControl() {
        int xWindow;
        this.checkDevice();
        int[] unused = new int[1];
        int[] buffer = new int[1];
        int xParent = OS.XDefaultRootWindow(this.xDisplay);
        do {
            if (OS.XQueryPointer(this.xDisplay, xParent, unused, buffer, unused, unused, unused, unused, unused) == 0) {
                return null;
            }
            xWindow = buffer[0];
            if (xWindow == 0) continue;
            xParent = xWindow;
        } while (xWindow != 0);
        int handle = OS.XtWindowToWidget(this.xDisplay, xParent);
        if (handle == 0) {
            return null;
        }
        do {
            Control control;
            Widget widget;
            if ((widget = WidgetTable.get(handle)) == null || !(widget instanceof Control) || !(control = (Control)widget).getEnabled()) continue;
            return control;
        } while ((handle = OS.XtParent(handle)) != 0);
        return null;
    }

    public Point getCursorLocation() {
        this.checkDevice();
        int window = OS.XDefaultRootWindow(this.xDisplay);
        int[] rootX = new int[1];
        int[] rootY = new int[1];
        int[] unused = new int[1];
        OS.XQueryPointer(this.xDisplay, window, unused, unused, rootX, rootY, unused, unused, unused);
        return new Point(rootX[0], rootY[0]);
    }

    public static synchronized Display getDefault() {
        if (Default == null) {
            Default = new Display();
        }
        return Default;
    }

    public Object getData(String key) {
        this.checkDevice();
        if (key == null) {
            this.error(4);
        }
        if (this.keys == null) {
            return null;
        }
        int i = 0;
        while (i < this.keys.length) {
            if (this.keys[i].equals(key)) {
                return this.values[i];
            }
            ++i;
        }
        return null;
    }

    public Object getData() {
        this.checkDevice();
        return this.data;
    }

    public int getDismissalAlignment() {
        this.checkDevice();
        return 16384;
    }

    public int getDoubleClickTime() {
        this.checkDevice();
        return OS.XtGetMultiClickTime(this.xDisplay);
    }

    public Control getFocusControl() {
        this.checkDevice();
        int[] buffer1 = new int[1];
        int[] buffer2 = new int[1];
        OS.XGetInputFocus(this.xDisplay, buffer1, buffer2);
        int xWindow = buffer1[0];
        if (xWindow == 0) {
            return null;
        }
        int handle = OS.XtWindowToWidget(this.xDisplay, xWindow);
        if (handle == 0) {
            return null;
        }
        if ((handle = OS.XmGetFocusWidget(handle)) == 0) {
            return null;
        }
        do {
            Control window;
            Widget widget;
            if ((widget = WidgetTable.get(handle)) == null || !(widget instanceof Control) || !(window = (Control)widget).getEnabled()) continue;
            return window;
        } while ((handle = OS.XtParent(handle)) != 0);
        return null;
    }

    public int getIconDepth() {
        return this.getDepth();
    }

    int getLastEventTime() {
        return OS.XtLastTimestampProcessed(this.xDisplay);
    }

    public Shell[] getShells() {
        this.checkDevice();
        int count = 0;
        Shell[] shells = WidgetTable.shells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            if (!shell.isDisposed() && this == shell.getDisplay()) {
                ++count;
            }
            ++i;
        }
        if (count == shells.length) {
            return shells;
        }
        int index = 0;
        Shell[] result = new Shell[count];
        int i2 = 0;
        while (i2 < shells.length) {
            Shell shell = shells[i2];
            if (!shell.isDisposed() && this == shell.getDisplay()) {
                result[index++] = shell;
            }
            ++i2;
        }
        return result;
    }

    public Thread getSyncThread() {
        if (this.isDisposed()) {
            this.error(45);
        }
        return this.synchronizer.syncThread;
    }

    public Color getSystemColor(int id) {
        this.checkDevice();
        XColor xColor = null;
        switch (id) {
            case 28: {
                return super.getSystemColor(2);
            }
            case 29: {
                return this.COLOR_INFO_BACKGROUND;
            }
            case 30: {
                return super.getSystemColor(1);
            }
            case 31: {
                return super.getSystemColor(10);
            }
            case 32: {
                return super.getSystemColor(9);
            }
            case 33: {
                return super.getSystemColor(2);
            }
            case 34: {
                return super.getSystemColor(16);
            }
            case 35: {
                return super.getSystemColor(15);
            }
            case 17: {
                xColor = this.COLOR_WIDGET_DARK_SHADOW;
                break;
            }
            case 18: {
                xColor = this.COLOR_WIDGET_NORMAL_SHADOW;
                break;
            }
            case 19: {
                xColor = this.COLOR_WIDGET_LIGHT_SHADOW;
                break;
            }
            case 20: {
                xColor = this.COLOR_WIDGET_HIGHLIGHT_SHADOW;
                break;
            }
            case 22: {
                xColor = this.COLOR_WIDGET_BACKGROUND;
                break;
            }
            case 21: {
                xColor = this.COLOR_WIDGET_FOREGROUND;
                break;
            }
            case 23: {
                xColor = this.COLOR_WIDGET_BORDER;
                break;
            }
            case 24: {
                xColor = this.COLOR_LIST_FOREGROUND;
                break;
            }
            case 25: {
                xColor = this.COLOR_LIST_BACKGROUND;
                break;
            }
            case 26: {
                xColor = this.COLOR_LIST_SELECTION;
                break;
            }
            case 27: {
                xColor = this.COLOR_LIST_SELECTION_TEXT;
                break;
            }
            default: {
                return super.getSystemColor(id);
            }
        }
        if (xColor == null) {
            return super.getSystemColor(2);
        }
        return Color.motif_new(this, xColor);
    }

    public Font getSystemFont() {
        this.checkDevice();
        return this.defaultFont;
    }

    public Thread getThread() {
        if (this.isDisposed()) {
            this.error(45);
        }
        return this.thread;
    }

    void hideToolTip() {
        if (this.toolTipHandle != 0) {
            int shellHandle = OS.XtParent(this.toolTipHandle);
            OS.XtDestroyWidget(shellHandle);
        }
        this.toolTipHandle = 0;
    }

    protected void init() {
        super.init();
        this.initializeDisplay();
        this.initializeButton();
        this.initializeComposite();
        this.initializeDialog();
        this.initializeLabel();
        this.initializeList();
        this.initializeScrollBar();
        this.initializeText();
        this.initializeSystemColors();
        this.initializeDefaults();
        this.initializeTranslations();
    }

    void initializeButton() {
        int widgetClass = OS.TopLevelShellWidgetClass();
        int shellHandle = OS.XtAppCreateShell(this.appName, this.appClass, widgetClass, this.xDisplay, null, 0);
        int widgetHandle = OS.XmCreatePushButton(shellHandle, null, null, 0);
        OS.XtManageChild(widgetHandle);
        OS.XtSetMappedWhenManaged(shellHandle, false);
        OS.XtRealizeWidget(shellHandle);
        int[] argList = new int[]{OS.XmNforeground, 0, OS.XmNbackground, 0, OS.XmNshadowThickness, 0, OS.XmNfontList, 0};
        OS.XtGetValues(widgetHandle, argList, argList.length / 2);
        this.buttonForeground = argList[1];
        this.buttonBackground = argList[3];
        this.buttonShadowThickness = argList[5];
        this.buttonFont = Font.motif_new(this, OS.XmFontListCopy(argList[7]));
        OS.XtDestroyWidget(shellHandle);
    }

    void initializeComposite() {
        int widgetClass = OS.TopLevelShellWidgetClass();
        int shellHandle = OS.XtAppCreateShell(this.appName, this.appClass, widgetClass, this.xDisplay, null, 0);
        int scrolledHandle = OS.XmCreateMainWindow(shellHandle, null, null, 0);
        int[] argList1 = new int[]{OS.XmNorientation, 2};
        int hScrollHandle = OS.XmCreateScrollBar(scrolledHandle, null, argList1, argList1.length / 2);
        OS.XtManageChild(hScrollHandle);
        int[] argList2 = new int[]{OS.XmNorientation, 1};
        int vScrollHandle = OS.XmCreateScrollBar(scrolledHandle, null, argList2, argList2.length / 2);
        OS.XtManageChild(vScrollHandle);
        OS.XtManageChild(scrolledHandle);
        int[] argList5 = new int[]{OS.XmNmarginWidth, 3, OS.XmNmarginHeight, 3};
        int formHandle = OS.XmCreateForm(scrolledHandle, null, argList5, argList5.length / 2);
        OS.XtManageChild(formHandle);
        int[] argList6 = new int[]{OS.XmNmarginWidth, 0, OS.XmNmarginHeight, 0, OS.XmNresizePolicy, 0, OS.XmNtopAttachment, 1, OS.XmNbottomAttachment, 1, OS.XmNleftAttachment, 1, OS.XmNrightAttachment, 1};
        int widgetHandle = OS.XmCreateDrawingArea(formHandle, null, argList6, argList6.length / 2);
        OS.XtManageChild(widgetHandle);
        OS.XmMainWindowSetAreas(scrolledHandle, 0, 0, hScrollHandle, vScrollHandle, formHandle);
        OS.XtSetMappedWhenManaged(shellHandle, false);
        int screen = OS.XDefaultScreen(this.xDisplay);
        OS.XtResizeWidget(shellHandle, OS.XDisplayWidth(this.xDisplay, screen), OS.XDisplayHeight(this.xDisplay, screen), 0);
        OS.XtRealizeWidget(shellHandle);
        int[] argList3 = new int[]{OS.XmNwidth, 0, OS.XmNheight, 0};
        OS.XtGetValues(scrolledHandle, argList3, argList3.length / 2);
        int[] argList8 = new int[]{OS.XmNx, 0, OS.XmNy, 0, OS.XmNwidth, 0, OS.XmNheight, 0};
        OS.XtGetValues(formHandle, argList8, argList8.length / 2);
        int[] argList4 = new int[]{OS.XmNx, 0, OS.XmNy, 0, OS.XmNwidth, 0, OS.XmNheight, 0, OS.XmNforeground, 0, OS.XmNbackground, 0, OS.XmNtopShadowColor, 0, OS.XmNbottomShadowColor, 0, OS.XmNborderColor, 0};
        OS.XtGetValues(widgetHandle, argList4, argList4.length / 2);
        this.scrolledInsetX = argList4[1] + argList8[1];
        this.scrolledInsetY = argList4[3] + argList8[3];
        this.scrolledMarginX = argList3[1] - argList8[1] - argList4[1] - argList4[5];
        this.scrolledMarginY = argList3[3] - argList8[3] - argList4[3] - argList4[7];
        this.compositeForeground = argList4[9];
        this.compositeBackground = argList4[11];
        this.compositeTopShadow = argList4[13];
        this.compositeBottomShadow = argList4[15];
        this.compositeBorder = argList4[17];
        OS.XtDestroyWidget(shellHandle);
    }

    void initializeDefaults() {
        this.defaultFont = this.labelFont;
        this.defaultForeground = this.compositeForeground;
        this.defaultBackground = this.compositeBackground;
    }

    void initializeDialog() {
        int widgetClass = OS.TopLevelShellWidgetClass();
        int shellHandle = OS.XtAppCreateShell(this.appName, this.appClass, widgetClass, this.xDisplay, null, 0);
        int widgetHandle = OS.XmCreateDialogShell(shellHandle, null, null, 0);
        OS.XtSetMappedWhenManaged(shellHandle, false);
        OS.XtRealizeWidget(shellHandle);
        int[] argList = new int[]{OS.XmNforeground, 0, OS.XmNbackground, 0};
        OS.XtGetValues(widgetHandle, argList, argList.length / 2);
        this.dialogForeground = argList[1];
        this.dialogBackground = argList[3];
        OS.XtDestroyWidget(shellHandle);
    }

    void initializeDisplay() {
        int[] filedes;
        this.windowCallback = new Callback(this, "windowProc", 4);
        this.windowProc = this.windowCallback.getAddress();
        if (this.windowProc == 0) {
            this.error(3);
        }
        this.windowTimerCallback = new Callback(this, "windowTimerProc", 2);
        this.windowTimerProc = this.windowTimerCallback.getAddress();
        if (this.windowTimerProc == 0) {
            this.error(3);
        }
        this.timerCallback = new Callback(this, "timerProc", 2);
        this.timerProc = this.timerCallback.getAddress();
        if (this.timerProc == 0) {
            this.error(3);
        }
        this.caretCallback = new Callback(this, "caretProc", 2);
        this.caretProc = this.caretCallback.getAddress();
        if (this.caretProc == 0) {
            this.error(3);
        }
        this.mouseHoverCallback = new Callback(this, "mouseHoverProc", 2);
        this.mouseHoverProc = this.mouseHoverCallback.getAddress();
        if (this.mouseHoverProc == 0) {
            this.error(3);
        }
        this.checkExposeCallback = new Callback(this, "checkExposeProc", 3);
        this.checkExposeProc = this.checkExposeCallback.getAddress();
        if (this.checkExposeProc == 0) {
            this.error(3);
        }
        this.checkResizeCallback = new Callback(this, "checkResizeProc", 3);
        this.checkResizeProc = this.checkResizeCallback.getAddress();
        if (this.checkResizeProc == 0) {
            this.error(3);
        }
        this.wakeCallback = new Callback(this, "wakeProc", 3);
        this.wakeProc = this.wakeCallback.getAddress();
        if (this.wakeProc == 0) {
            this.error(3);
        }
        if (OS.pipe(filedes = new int[2]) != 0) {
            this.error(2);
        }
        this.read_fd = filedes[0];
        this.write_fd = filedes[1];
        int xtContext = OS.XtDisplayToApplicationContext(this.xDisplay);
        this.inputID = OS.XtAppAddInput(xtContext, this.read_fd, 1, this.wakeProc, 0);
        this.fd_set = new byte[OS.fd_set_sizeof()];
        int xmDisplay = OS.XmGetXmDisplay(this.xDisplay);
        int[] args = new int[]{OS.XmNenableThinThickness, 1, OS.XmNdragInitiatorProtocolStyle, 5, OS.XmNdragReceiverProtocolStyle, 5};
        OS.XtSetValues(xmDisplay, args, args.length / 2);
        int xScreen = OS.XDefaultScreen(this.xDisplay);
        int widgetClass = OS.TopLevelShellWidgetClass();
        this.shellHandle = OS.XtAppCreateShell(this.appName, this.appClass, widgetClass, this.xDisplay, null, 0);
        OS.XtSetMappedWhenManaged(this.shellHandle, false);
        OS.XtResizeWidget(this.shellHandle, OS.XDisplayWidth(this.xDisplay, xScreen), OS.XDisplayHeight(this.xDisplay, xScreen), 0);
        OS.XtRealizeWidget(this.shellHandle);
    }

    void initializeLabel() {
        int widgetClass = OS.TopLevelShellWidgetClass();
        int shellHandle = OS.XtAppCreateShell(this.appName, this.appClass, widgetClass, this.xDisplay, null, 0);
        byte[] buffer = Converter.wcsToMbcs(null, "string", true);
        int widgetHandle = OS.XmCreateLabel(shellHandle, buffer, null, 0);
        OS.XtManageChild(widgetHandle);
        OS.XtSetMappedWhenManaged(shellHandle, false);
        OS.XtRealizeWidget(shellHandle);
        int[] argList2 = new int[]{OS.XmNforeground, 0, OS.XmNbackground, 0, OS.XmNfontList, 0};
        OS.XtGetValues(widgetHandle, argList2, argList2.length / 2);
        this.labelForeground = argList2[1];
        this.labelBackground = argList2[3];
        this.labelFont = Font.motif_new(this, OS.XmFontListCopy(argList2[5]));
        OS.XtDestroyWidget(shellHandle);
    }

    void initializeList() {
        int widgetClass = OS.TopLevelShellWidgetClass();
        int shellHandle = OS.XtAppCreateShell(this.appName, this.appClass, widgetClass, this.xDisplay, null, 0);
        int widgetHandle = OS.XmCreateScrolledList(shellHandle, new byte[1], null, 0);
        OS.XtManageChild(widgetHandle);
        OS.XtSetMappedWhenManaged(shellHandle, false);
        OS.XtRealizeWidget(shellHandle);
        int[] argList = new int[]{OS.XmNforeground, 0, OS.XmNbackground, 0, OS.XmNfontList, 0, OS.XmNselectColor, 0, OS.XmNhighlightColor, 0};
        OS.XtGetValues(widgetHandle, argList, argList.length / 2);
        this.listForeground = argList[1];
        this.listBackground = argList[3];
        this.listFont = Font.motif_new(this, OS.XmFontListCopy(argList[5]));
        byte selectColor = (byte)argList[7];
        switch (selectColor) {
            case -2: 
            case -1: {
                this.listSelect = this.listForeground;
                break;
            }
            case -3: {
                this.listSelect = argList[9];
                break;
            }
            default: {
                this.listSelect = argList[7];
            }
        }
        OS.XtDestroyWidget(shellHandle);
    }

    void initializeScrollBar() {
        int widgetClass = OS.TopLevelShellWidgetClass();
        int shellHandle = OS.XtAppCreateShell(this.appName, this.appClass, widgetClass, this.xDisplay, null, 0);
        int widgetHandle = OS.XmCreateScrollBar(shellHandle, null, null, 0);
        OS.XtManageChild(widgetHandle);
        OS.XtSetMappedWhenManaged(shellHandle, false);
        OS.XtRealizeWidget(shellHandle);
        int[] argList = new int[]{OS.XmNforeground, 0, OS.XmNbackground, 0};
        OS.XtGetValues(widgetHandle, argList, argList.length / 2);
        this.scrollBarForeground = argList[1];
        this.scrollBarBackground = argList[3];
        OS.XtDestroyWidget(shellHandle);
    }

    void initializeSystemColors() {
        int[] argList = new int[]{OS.XmNcolormap, 0};
        OS.XtGetValues(this.shellHandle, argList, argList.length / 2);
        int colormap = argList[1];
        this.COLOR_WIDGET_DARK_SHADOW = new XColor();
        this.COLOR_WIDGET_DARK_SHADOW.pixel = this.compositeBottomShadow;
        OS.XQueryColor(this.xDisplay, colormap, this.COLOR_WIDGET_DARK_SHADOW);
        this.COLOR_WIDGET_NORMAL_SHADOW = new XColor();
        this.COLOR_WIDGET_NORMAL_SHADOW.pixel = this.compositeBottomShadow;
        OS.XQueryColor(this.xDisplay, colormap, this.COLOR_WIDGET_NORMAL_SHADOW);
        this.COLOR_WIDGET_LIGHT_SHADOW = new XColor();
        this.COLOR_WIDGET_LIGHT_SHADOW.pixel = this.compositeTopShadow;
        OS.XQueryColor(this.xDisplay, colormap, this.COLOR_WIDGET_LIGHT_SHADOW);
        this.COLOR_WIDGET_HIGHLIGHT_SHADOW = new XColor();
        this.COLOR_WIDGET_HIGHLIGHT_SHADOW.pixel = this.compositeTopShadow;
        OS.XQueryColor(this.xDisplay, colormap, this.COLOR_WIDGET_HIGHLIGHT_SHADOW);
        this.COLOR_WIDGET_FOREGROUND = new XColor();
        this.COLOR_WIDGET_FOREGROUND.pixel = this.textForeground;
        OS.XQueryColor(this.xDisplay, colormap, this.COLOR_WIDGET_FOREGROUND);
        this.COLOR_WIDGET_BACKGROUND = new XColor();
        this.COLOR_WIDGET_BACKGROUND.pixel = this.compositeBackground;
        OS.XQueryColor(this.xDisplay, colormap, this.COLOR_WIDGET_BACKGROUND);
        this.COLOR_WIDGET_BORDER = new XColor();
        this.COLOR_WIDGET_BORDER.pixel = this.compositeBorder;
        OS.XQueryColor(this.xDisplay, colormap, this.COLOR_WIDGET_BORDER);
        this.COLOR_LIST_FOREGROUND = new XColor();
        this.COLOR_LIST_FOREGROUND.pixel = this.listForeground;
        OS.XQueryColor(this.xDisplay, colormap, this.COLOR_LIST_FOREGROUND);
        this.COLOR_LIST_BACKGROUND = new XColor();
        this.COLOR_LIST_BACKGROUND.pixel = this.listBackground;
        OS.XQueryColor(this.xDisplay, colormap, this.COLOR_LIST_BACKGROUND);
        this.COLOR_LIST_SELECTION = new XColor();
        this.COLOR_LIST_SELECTION.pixel = this.listSelect;
        OS.XQueryColor(this.xDisplay, colormap, this.COLOR_LIST_SELECTION);
        this.COLOR_LIST_SELECTION_TEXT = new XColor();
        this.COLOR_LIST_SELECTION_TEXT.pixel = this.listBackground;
        OS.XQueryColor(this.xDisplay, colormap, this.COLOR_LIST_SELECTION_TEXT);
        this.COLOR_INFO_BACKGROUND = new Color(this, 255, 255, 225);
    }

    void initializeText() {
        int widgetClass = OS.TopLevelShellWidgetClass();
        int shellHandle = OS.XtAppCreateShell(this.appName, this.appClass, widgetClass, this.xDisplay, null, 0);
        int widgetHandle = OS.XmCreateScrolledText(shellHandle, new byte[1], null, 0);
        OS.XtManageChild(widgetHandle);
        OS.XtSetMappedWhenManaged(shellHandle, false);
        OS.XtRealizeWidget(shellHandle);
        int[] argList = new int[]{OS.XmNforeground, 0, OS.XmNbackground, 0, OS.XmNfontList, 0, OS.XmNhighlightThickness, 0};
        OS.XtGetValues(widgetHandle, argList, argList.length / 2);
        this.textForeground = argList[1];
        this.textBackground = argList[3];
        this.textHighlightThickness = argList[7];
        this.textFont = Font.motif_new(this, OS.XmFontListCopy(argList[5]));
        OS.XtDestroyWidget(shellHandle);
    }

    void initializeTranslations() {
        byte[] buffer1 = Converter.wcsToMbcs(null, "<Key>osfUp:\n<Key>osfDown:\n<Key>osfLeft:\n<Key>osfRight:\u0000");
        this.arrowTranslations = OS.XtParseTranslationTable(buffer1);
        byte[] buffer2 = Converter.wcsToMbcs(null, "~Meta ~Alt <Key>Tab:\nShift ~Meta ~Alt <Key>Tab:\u0000");
        this.tabTranslations = OS.XtParseTranslationTable(buffer2);
        byte[] buffer3 = Converter.wcsToMbcs(null, "<Btn2Down>:\u0000");
        this.dragTranslations = OS.XtParseTranslationTable(buffer3);
    }

    public int internal_new_GC(GCData data) {
        int xDrawable;
        int xGC;
        if (this.isDisposed()) {
            SWT.error(45);
        }
        if ((xGC = OS.XCreateGC(this.xDisplay, xDrawable = OS.XDefaultRootWindow(this.xDisplay), 0, null)) == 0) {
            SWT.error(2);
        }
        OS.XSetSubwindowMode(this.xDisplay, xGC, 1);
        if (data != null) {
            data.device = this;
            data.display = this.xDisplay;
            data.drawable = xDrawable;
            data.fontList = this.defaultFont.handle;
            data.codePage = this.defaultFont.codePage;
            data.colormap = OS.XDefaultColormap(this.xDisplay, OS.XDefaultScreen(this.xDisplay));
        }
        return xGC;
    }

    public void internal_dispose_GC(int gc, GCData data) {
        OS.XFreeGC(this.xDisplay, gc);
    }

    boolean isValidThread() {
        return this.thread == Thread.currentThread();
    }

    static boolean isValidClass(Class clazz) {
        String name = clazz.getName();
        int index = name.lastIndexOf(46);
        return name.substring(0, index + 1).equals(PACKAGE_PREFIX);
    }

    int mouseHoverProc(int handle, int id) {
        this.mouseHoverHandle = 0;
        this.mouseHoverID = 0;
        Widget widget = WidgetTable.get(handle);
        if (widget == null) {
            return 0;
        }
        return widget.hoverProc(id);
    }

    void postEvent(Event event) {
        if (this.eventQueue == null) {
            this.eventQueue = new Event[4];
        }
        int index = 0;
        int length = this.eventQueue.length;
        while (index < length) {
            if (this.eventQueue[index] == null) break;
            ++index;
        }
        if (index == length) {
            Event[] newQueue = new Event[length + 4];
            System.arraycopy(this.eventQueue, 0, newQueue, 0, length);
            this.eventQueue = newQueue;
        }
        this.eventQueue[index] = event;
    }

    public boolean readAndDispatch() {
        this.checkDevice();
        int xtContext = OS.XtDisplayToApplicationContext(this.xDisplay);
        int status = OS.XtAppPending(xtContext);
        if (status != 0) {
            if ((status & 2) != 0) {
                OS.XtAppProcessEvent(xtContext, 2);
                status = OS.XtAppPending(xtContext);
            }
            if ((status & 4) != 0) {
                OS.XtAppProcessEvent(xtContext, 4);
                status = OS.XtAppPending(xtContext);
            }
            if ((status & 1) != 0) {
                OS.XtAppNextEvent(xtContext, this.xEvent);
                if (!this.filterEvent(this.xEvent)) {
                    OS.XtDispatchEvent(this.xEvent);
                }
            }
            this.runDeferredEvents();
            return true;
        }
        OS.XtAppAddTimeOut(xtContext, 1, 0, 0);
        OS.XtAppProcessEvent(xtContext, 2);
        return this.runAsyncMessages();
    }

    static synchronized void register(Display display) {
        int i = 0;
        while (i < Displays.length) {
            if (Displays[i] == null) {
                Display.Displays[i] = display;
                return;
            }
            ++i;
        }
        Display[] newDisplays = new Display[Displays.length + 4];
        System.arraycopy(Displays, 0, newDisplays, 0, Displays.length);
        newDisplays[Display.Displays.length] = display;
        Displays = newDisplays;
    }

    protected void release() {
        this.sendEvent(12, new Event());
        Shell[] shells = WidgetTable.shells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            if (!shell.isDisposed() && this == shell.getDisplay()) {
                shell.dispose();
            }
            ++i;
        }
        while (this.readAndDispatch()) {
        }
        if (this.disposeList != null) {
            int i2 = 0;
            while (i2 < this.disposeList.length) {
                if (this.disposeList[i2] != null) {
                    this.disposeList[i2].run();
                }
                ++i2;
            }
        }
        this.disposeList = null;
        this.synchronizer.releaseSynchronizer();
        this.synchronizer = null;
        this.releaseDisplay();
        super.release();
    }

    void releaseDisplay() {
        if (this.shellHandle != 0) {
            OS.XtDestroyWidget(this.shellHandle);
        }
        this.shellHandle = 0;
        if (this.caretID != 0) {
            OS.XtRemoveTimeOut(this.caretID);
        }
        this.caretProc = 0;
        this.caretID = 0;
        this.caretCallback.dispose();
        this.caretCallback = null;
        if (this.timerIds != null) {
            int i = 0;
            while (i < this.timerIds.length) {
                if (this.timerIds[i] != 0) {
                    OS.XtRemoveTimeOut(this.timerIds[i]);
                }
                ++i;
            }
        }
        this.timerIds = null;
        this.timerList = null;
        this.timerProc = 0;
        this.timerCallback.dispose();
        this.timerCallback = null;
        this.windowTimerProc = 0;
        this.windowTimerCallback.dispose();
        this.windowTimerCallback = null;
        if (this.mouseHoverID != 0) {
            OS.XtRemoveTimeOut(this.mouseHoverID);
        }
        this.toolTipHandle = 0;
        this.mouseHoverHandle = 0;
        this.mouseHoverProc = 0;
        this.mouseHoverID = 0;
        this.mouseHoverCallback.dispose();
        this.mouseHoverCallback = null;
        this.windowCallback.dispose();
        this.windowCallback = null;
        this.checkExposeCallback.dispose();
        this.checkExposeCallback = null;
        this.checkExposeProc = 0;
        this.checkResizeCallback.dispose();
        this.checkResizeCallback = null;
        this.checkResizeProc = 0;
        if (this.inputID != 0) {
            OS.XtRemoveInput(this.inputID);
        }
        this.wakeCallback.dispose();
        this.wakeCallback = null;
        this.wakeProc = 0;
        OS.close(this.read_fd);
        OS.close(this.write_fd);
        if (this.buttonFont != null) {
            OS.XmFontListFree(this.buttonFont.handle);
            this.buttonFont.handle = 0;
        }
        if (this.labelFont != null) {
            OS.XmFontListFree(this.labelFont.handle);
            this.labelFont.handle = 0;
        }
        if (this.textFont != null) {
            OS.XmFontListFree(this.textFont.handle);
            this.textFont.handle = 0;
        }
        if (this.listFont != null) {
            OS.XmFontListFree(this.listFont.handle);
            this.listFont.handle = 0;
        }
        this.buttonFont = null;
        this.labelFont = null;
        this.textFont = null;
        this.listFont = null;
        this.defaultFont = null;
        this.thread = null;
        this.xEvent = null;
        this.buttonForeground = 0;
        this.buttonBackground = 0;
        this.defaultForeground = 0;
        this.defaultBackground = 0;
        this.COLOR_LIST_SELECTION_TEXT = null;
        this.COLOR_LIST_SELECTION = null;
        this.COLOR_LIST_BACKGROUND = null;
        this.COLOR_LIST_FOREGROUND = null;
        this.COLOR_WIDGET_BORDER = null;
        this.COLOR_WIDGET_BACKGROUND = null;
        this.COLOR_WIDGET_FOREGROUND = null;
        this.COLOR_WIDGET_HIGHLIGHT_SHADOW = null;
        this.COLOR_WIDGET_LIGHT_SHADOW = null;
        this.COLOR_WIDGET_NORMAL_SHADOW = null;
        this.COLOR_WIDGET_DARK_SHADOW = null;
        this.COLOR_INFO_BACKGROUND = null;
    }

    void releaseToolTipHandle(int handle) {
        int shellHandle;
        int shellParent;
        if (this.mouseHoverHandle == handle) {
            this.removeMouseHoverTimeOut();
        }
        if (this.toolTipHandle != 0 && handle == (shellParent = OS.XtParent(shellHandle = OS.XtParent(this.toolTipHandle)))) {
            this.toolTipHandle = 0;
        }
    }

    void removeMouseHoverTimeOut() {
        if (this.mouseHoverID != 0) {
            OS.XtRemoveTimeOut(this.mouseHoverID);
        }
        this.mouseHoverHandle = 0;
        this.mouseHoverID = 0;
    }

    void removeFilter(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.filterTable == null) {
            return;
        }
        this.filterTable.unhook(eventType, listener);
        if (this.filterTable.size() == 0) {
            this.filterTable = null;
        }
    }

    public void removeListener(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(eventType, listener);
    }

    boolean runAsyncMessages() {
        return this.synchronizer.runAsyncMessages();
    }

    boolean runDeferredEvents() {
        while (this.eventQueue != null) {
            Widget item;
            Event event = this.eventQueue[0];
            if (event == null) break;
            int length = this.eventQueue.length;
            System.arraycopy(this.eventQueue, 1, this.eventQueue, 0, --length);
            this.eventQueue[length] = null;
            Widget widget = event.widget;
            if (widget == null || widget.isDisposed() || (item = event.item) != null && item.isDisposed()) continue;
            widget.sendEvent(event);
        }
        this.eventQueue = null;
        return true;
    }

    boolean runFocusOutEvents() {
        if (this.eventQueue == null) {
            return false;
        }
        Event[] focusQueue = null;
        int index = 0;
        int count = 0;
        int length = this.eventQueue.length;
        while (index < length) {
            Event event = this.eventQueue[index];
            if (event != null && event.type == 16) {
                if (focusQueue == null) {
                    focusQueue = new Event[length];
                }
                focusQueue[count++] = event;
                System.arraycopy(this.eventQueue, index + 1, this.eventQueue, index, --length - index);
                this.eventQueue[length] = null;
                continue;
            }
            ++index;
        }
        if (focusQueue == null) {
            return false;
        }
        int i = 0;
        while (i < count) {
            Widget item;
            void event = focusQueue[i];
            Widget widget = event.widget;
            if (!(widget == null || widget.isDisposed() || (item = event.item) != null && item.isDisposed())) {
                widget.sendEvent((Event)event);
            }
            ++i;
        }
        return true;
    }

    void sendEvent(int eventType, Event event) {
        if (this.eventTable == null && this.filterTable == null) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        event.display = this;
        event.type = eventType;
        if (event.time == 0) {
            event.time = this.getLastEventTime();
        }
        if (!this.filterEvent(event) && this.eventTable != null) {
            this.eventTable.sendEvent(event);
        }
    }

    public void setCursorLocation(int x, int y) {
        this.checkDevice();
        int xWindow = OS.XDefaultRootWindow(this.xDisplay);
        OS.XWarpPointer(this.xDisplay, 0, xWindow, 0, 0, 0, 0, x, y);
    }

    public void setCursorLocation(Point point) {
        this.checkDevice();
        if (point == null) {
            this.error(4);
        }
        this.setCursorLocation(point.x, point.y);
    }

    public static void setAppName(String name) {
        APP_NAME = name;
    }

    void setCurrentCaret(Caret caret) {
        if (this.caretID != 0) {
            OS.XtRemoveTimeOut(this.caretID);
        }
        this.caretID = 0;
        this.currentCaret = caret;
        if (this.currentCaret != null) {
            int blinkRate = this.currentCaret.blinkRate;
            int xtContext = OS.XtDisplayToApplicationContext(this.xDisplay);
            this.caretID = OS.XtAppAddTimeOut(xtContext, blinkRate, this.caretProc, 0);
        }
    }

    public void setData(String key, Object value) {
        this.checkDevice();
        if (key == null) {
            this.error(4);
        }
        if (value == null) {
            if (this.keys == null) {
                return;
            }
            int index = 0;
            while (index < this.keys.length && !this.keys[index].equals(key)) {
                ++index;
            }
            if (index == this.keys.length) {
                return;
            }
            if (this.keys.length == 1) {
                this.keys = null;
                this.values = null;
            } else {
                String[] newKeys = new String[this.keys.length - 1];
                Object[] newValues = new Object[this.values.length - 1];
                System.arraycopy(this.keys, 0, newKeys, 0, index);
                System.arraycopy(this.keys, index + 1, newKeys, index, newKeys.length - index);
                System.arraycopy(this.values, 0, newValues, 0, index);
                System.arraycopy(this.values, index + 1, newValues, index, newValues.length - index);
                this.keys = newKeys;
                this.values = newValues;
            }
            return;
        }
        if (this.keys == null) {
            this.keys = new String[]{key};
            this.values = new Object[]{value};
            return;
        }
        int i = 0;
        while (i < this.keys.length) {
            if (this.keys[i].equals(key)) {
                this.values[i] = value;
                return;
            }
            ++i;
        }
        String[] newKeys = new String[this.keys.length + 1];
        Object[] newValues = new Object[this.values.length + 1];
        System.arraycopy(this.keys, 0, newKeys, 0, this.keys.length);
        System.arraycopy(this.values, 0, newValues, 0, this.values.length);
        newKeys[this.keys.length] = key;
        newValues[this.values.length] = value;
        this.keys = newKeys;
        this.values = newValues;
    }

    public void setData(Object data) {
        this.checkDevice();
        this.data = data;
    }

    public void setSynchronizer(Synchronizer synchronizer) {
        this.checkDevice();
        if (synchronizer == null) {
            this.error(4);
        }
        if (this.synchronizer != null) {
            this.synchronizer.runAsyncMessages();
        }
        this.synchronizer = synchronizer;
    }

    void setToolTipText(int handle, String toolTipText) {
        if (this.toolTipHandle == 0) {
            return;
        }
        int shellHandle = OS.XtParent(this.toolTipHandle);
        int shellParent = OS.XtParent(shellHandle);
        if (handle != shellParent) {
            return;
        }
        this.showToolTip(handle, toolTipText);
    }

    void showToolTip(int handle, String toolTipText) {
        int shellHandle = 0;
        byte[] buffer = Converter.wcsToMbcs(null, toolTipText, true);
        if (this.toolTipHandle != 0) {
            shellHandle = OS.XtParent(this.toolTipHandle);
            int shellParent = OS.XtParent(shellHandle);
            if (handle != shellParent) {
                return;
            }
            int xmString = OS.XmStringGenerate(buffer, null, 0, null);
            int[] argList = new int[]{OS.XmNlabelString, xmString};
            OS.XtSetValues(this.toolTipHandle, argList, argList.length / 2);
            if (xmString != 0) {
                OS.XmStringFree(xmString);
            }
        } else {
            int widgetClass = OS.OverrideShellWidgetClass();
            int[] argList1 = new int[]{OS.XmNmwmDecorations, 0, OS.XmNborderWidth, 1, OS.XmNallowShellResize, 1};
            shellHandle = OS.XtCreatePopupShell(null, widgetClass, handle, argList1, argList1.length / 2);
            Color infoForeground = this.getSystemColor(28);
            Color infoBackground = this.getSystemColor(29);
            int foregroundPixel = infoForeground.handle.pixel;
            int backgroundPixel = infoBackground.handle.pixel;
            int[] argList2 = new int[]{OS.XmNforeground, foregroundPixel, OS.XmNbackground, backgroundPixel, OS.XmNalignment, 0};
            this.toolTipHandle = OS.XmCreateLabel(shellHandle, buffer, argList2, argList2.length / 2);
            OS.XtManageChild(this.toolTipHandle);
        }
        if (toolTipText == null || toolTipText.length() == 0) {
            OS.XtPopdown(shellHandle);
        } else {
            int xWindow = OS.XDefaultRootWindow(this.xDisplay);
            int[] rootX = new int[1];
            int[] rootY = new int[1];
            int[] unused = new int[1];
            int[] mask = new int[1];
            OS.XQueryPointer(this.xDisplay, xWindow, unused, unused, rootX, rootY, unused, unused, mask);
            int x = rootX[0] + 16;
            int y = rootY[0] + 16;
            int screen = OS.XDefaultScreen(this.xDisplay);
            int width = OS.XDisplayWidth(this.xDisplay, screen);
            int height = OS.XDisplayHeight(this.xDisplay, screen);
            int[] argList4 = new int[]{OS.XmNwidth, 0, OS.XmNheight, 0};
            OS.XtGetValues(this.toolTipHandle, argList4, argList4.length / 2);
            x = Math.max(0, Math.min(x, width - argList4[1]));
            y = Math.max(0, Math.min(y, height - argList4[3]));
            OS.XtMoveWidget(shellHandle, x, y);
            int flags = 1792;
            if ((mask[0] & flags) == 0) {
                OS.XtPopup(shellHandle, 0);
            }
        }
    }

    public boolean sleep() {
        this.checkDevice();
        int display_fd = OS.ConnectionNumber(this.xDisplay);
        int max_fd = display_fd > this.read_fd ? display_fd : this.read_fd;
        OS.FD_ZERO(this.fd_set);
        OS.FD_SET(display_fd, this.fd_set);
        OS.FD_SET(this.read_fd, this.fd_set);
        this.timeout[0] = 0;
        this.timeout[1] = 100000;
        OS.select(max_fd + 1, this.fd_set, null, null, this.timeout);
        return OS.FD_ISSET(display_fd, this.fd_set);
    }

    public void syncExec(Runnable runnable) {
        if (this.isDisposed()) {
            this.error(45);
        }
        this.synchronizer.syncExec(runnable);
    }

    int textWidth(String string, Font font) {
        if (string.length() == 0) {
            return 0;
        }
        int fontList = font.handle;
        String codePage = font.codePage;
        byte[] textBuffer = Converter.wcsToMbcs(codePage, string, true);
        int xmString = OS.XmStringGenerate(textBuffer, null, 0, null);
        int width = OS.XmStringWidth(fontList, xmString);
        OS.XmStringFree(xmString);
        return width;
    }

    public void timerExec(int milliseconds, Runnable runnable) {
        int xtContext;
        int timerId;
        this.checkDevice();
        if (runnable == null) {
            this.error(4);
        }
        if (this.timerList == null) {
            this.timerList = new Runnable[4];
        }
        if (this.timerIds == null) {
            this.timerIds = new int[4];
        }
        int index = 0;
        while (index < this.timerList.length) {
            if (this.timerList[index] == runnable) break;
            ++index;
        }
        if (index != this.timerList.length) {
            OS.XtRemoveTimeOut(this.timerIds[index]);
            this.timerList[index] = null;
            this.timerIds[index] = 0;
            if (milliseconds < 0) {
                return;
            }
        } else {
            if (milliseconds < 0) {
                return;
            }
            index = 0;
            while (index < this.timerList.length) {
                if (this.timerList[index] == null) break;
                ++index;
            }
            if (index == this.timerList.length) {
                Runnable[] newTimerList = new Runnable[this.timerList.length + 4];
                System.arraycopy(this.timerList, 0, newTimerList, 0, this.timerList.length);
                this.timerList = newTimerList;
                int[] newTimerIds = new int[this.timerIds.length + 4];
                System.arraycopy(this.timerIds, 0, newTimerIds, 0, this.timerIds.length);
                this.timerIds = newTimerIds;
            }
        }
        if ((timerId = OS.XtAppAddTimeOut(xtContext = OS.XtDisplayToApplicationContext(this.xDisplay), milliseconds, this.timerProc, index)) != 0) {
            this.timerIds[index] = timerId;
            this.timerList[index] = runnable;
        }
    }

    int timerProc(int index, int id) {
        if (this.timerList == null) {
            return 0;
        }
        if (0 <= index && index < this.timerList.length) {
            Runnable runnable = this.timerList[index];
            this.timerList[index] = null;
            this.timerIds[index] = 0;
            if (runnable != null) {
                runnable.run();
            }
        }
        return 0;
    }

    static int translateKey(int key) {
        int i = 0;
        while (i < KeyTable.length) {
            if (KeyTable[i][0] == key) {
                return KeyTable[i][1];
            }
            ++i;
        }
        return 0;
    }

    static int untranslateKey(int key) {
        int i = 0;
        while (i < KeyTable.length) {
            if (KeyTable[i][1] == key) {
                return KeyTable[i][0];
            }
            ++i;
        }
        return 0;
    }

    public void update() {
        this.checkDevice();
        XAnyEvent event = new XAnyEvent();
        int mask = 1998848;
        OS.XSync(this.xDisplay, false);
        OS.XSync(this.xDisplay, false);
        while (OS.XCheckMaskEvent(this.xDisplay, mask, event)) {
            OS.XtDispatchEvent(event);
        }
    }

    public void wake() {
        if (this.isDisposed()) {
            this.error(45);
        }
        if (this.thread == Thread.currentThread()) {
            return;
        }
        while (OS.write(this.write_fd, this.wake_buffer, 1) != 1) {
        }
    }

    int wakeProc(int closure, int source, int id) {
        while (OS.read(this.read_fd, this.wake_buffer, 1) != 1) {
        }
        return 0;
    }

    int windowTimerProc(int handle, int id) {
        Widget widget = WidgetTable.get(handle);
        if (widget == null) {
            return 0;
        }
        return widget.timerProc(id);
    }

    int windowProc(int w, int client_data, int call_data, int continue_to_dispatch) {
        Widget widget = WidgetTable.get(w);
        if (widget == null) {
            return 0;
        }
        return widget.windowProc(w, client_data, call_data, continue_to_dispatch);
    }

    String wrapText(String text, Font font, int width) {
        String Lf = "\n";
        text = this.convertToLf(text);
        int length = text.length();
        if (width <= 0 || length == 0 || length == 1) {
            return text;
        }
        StringBuffer result = new StringBuffer();
        int lineStart = 0;
        int lineEnd = 0;
        while (lineStart < length) {
            boolean noLf;
            lineEnd = text.indexOf(Lf, lineStart);
            boolean bl = noLf = lineEnd == -1;
            if (noLf) {
                lineEnd = length;
            }
            int nextStart = lineEnd + Lf.length();
            while (lineEnd > lineStart + 1 && Compatibility.isWhitespace(text.charAt(lineEnd - 1))) {
                --lineEnd;
            }
            int wordStart = lineStart;
            int wordEnd = lineStart;
            int i = lineStart;
            while (i < lineEnd) {
                int lastStart = wordStart;
                int lastEnd = wordEnd;
                wordStart = i;
                while (i < lineEnd && !Compatibility.isWhitespace(text.charAt(i))) {
                    ++i;
                }
                wordEnd = i - 1;
                String line = text.substring(lineStart, wordEnd + 1);
                int lineWidth = this.textWidth(line, font);
                while (i < lineEnd && Compatibility.isWhitespace(text.charAt(i))) {
                    ++i;
                }
                if (lineWidth <= width) continue;
                if (lastStart == wordStart) {
                    while (wordStart < wordEnd) {
                        line = text.substring(lineStart, wordStart + 1);
                        lineWidth = this.textWidth(line, font);
                        if (lineWidth >= width) break;
                        ++wordStart;
                    }
                    if (wordStart == lastStart) {
                        ++wordStart;
                    }
                    lastEnd = wordStart - 1;
                }
                line = text.substring(lineStart, lastEnd + 1);
                result.append(line);
                result.append(Lf);
                i = wordStart;
                lineStart = wordStart;
                wordEnd = wordStart;
            }
            if (lineStart < lineEnd) {
                result.append(text.substring(lineStart, lineEnd));
            }
            if (!noLf) {
                result.append(Lf);
            }
            lineStart = nextStart;
        }
        return result.toString();
    }

    static {
        XInitLock = new Object();
        APP_NAME = "SWT";
        KeyTable = new int[][]{{65513, 65536}, {65514, 65536}, {65505, 131072}, {65506, 131072}, {65507, 262144}, {65508, 262144}, {65362, 0x1000001}, {65364, 0x1000002}, {65361, 0x1000003}, {65363, 0x1000004}, {65365, 0x1000005}, {65366, 0x1000006}, {65360, 0x1000007}, {65367, 0x1000008}, {65379, 0x1000009}, {65288, 8}, {65293, 13}, {65421, 13}, {65535, 127}, {65307, 27}, {65385, 27}, {65290, 10}, {65289, 9}, {65056, 9}, {65470, 0x100000A}, {65471, 0x100000B}, {65472, 0x100000C}, {65473, 0x100000D}, {65474, 0x100000E}, {65475, 0x100000F}, {65476, 0x1000010}, {65477, 0x1000011}, {65478, 0x1000012}, {65479, 0x1000013}, {65480, 0x1000014}, {65481, 0x1000015}};
        Displays = new Display[4];
        Device.DeviceFinder = new Runnable(){

            public void run() {
                Display device = Display.getCurrent();
                if (device == null) {
                    device = Display.getDefault();
                }
                Display.setDevice(device);
            }
        };
    }
}

