/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XSetWindowAttributes;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;

public class ProgressBar
extends Control {
    int timerId;
    static final int DELAY = 100;
    int lastForeground = this.defaultForeground();

    public ProgressBar(Composite parent, int style) {
        super(parent, ProgressBar.checkStyle(style | 0x800));
    }

    static int checkStyle(int style) {
        return Widget.checkBits(style, 256, 512, 0, 0, 0, 0);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int border = this.getBorderWidth();
        int width = border * 2;
        int height = border * 2;
        Display display = this.getDisplay();
        int hScroll = display.scrolledMarginX;
        int vScroll = display.scrolledMarginY;
        if ((this.style & 0x100) != 0) {
            width += hScroll * 10;
            height += vScroll;
        } else {
            width += hScroll;
            height += vScroll * 10;
        }
        if (wHint != -1) {
            width = wHint + border * 2;
        }
        if (hHint != -1) {
            height = hHint + border * 2;
        }
        return new Point(width, height);
    }

    void createHandle(int index) {
        this.state |= 0x800;
        int background = this.defaultBackground();
        int parentHandle = this.parent.handle;
        int[] argList = new int[]{OS.XmNshowArrows, 0, OS.XmNsliderSize, 1, OS.XmNtraversalOn, 0, OS.XmNtroughColor, background, OS.XmNtopShadowColor, background, OS.XmNbottomShadowColor, background, OS.XmNforeground, background, OS.XmNshadowThickness, 1, OS.XmNborderWidth, (this.style & 0x800) != 0 ? 1 : 0, OS.XmNorientation, (this.style & 0x100) != 0 ? 2 : 1, OS.XmNprocessingDirection, (this.style & 0x100) != 0 ? 3 : 0, OS.XmNancestorSensitive, 1, OS.XmNsliderVisual, 1};
        this.handle = OS.XmCreateScrollBar(parentHandle, null, argList, argList.length / 2);
        if (this.handle == 0) {
            this.error(2);
        }
        if ((this.style & 2) != 0) {
            this.createTimer();
        }
    }

    void createTimer() {
        Display display = this.getDisplay();
        int xDisplay = display.xDisplay;
        int windowTimerProc = display.windowTimerProc;
        int xtContext = OS.XtDisplayToApplicationContext(xDisplay);
        this.timerId = OS.XtAppAddTimeOut(xtContext, 100, windowTimerProc, this.handle);
    }

    void destroyTimer() {
        if (this.timerId != 0) {
            OS.XtRemoveTimeOut(this.timerId);
        }
        this.timerId = 0;
    }

    void disableButtonPress() {
        int xWindow = OS.XtWindow(this.handle);
        if (xWindow == 0) {
            return;
        }
        int xDisplay = OS.XtDisplay(this.handle);
        if (xDisplay == 0) {
            return;
        }
        int event_mask = OS.XtBuildEventMask(this.handle);
        XSetWindowAttributes attributes = new XSetWindowAttributes();
        attributes.event_mask = event_mask & 0xFFFFFFFB;
        OS.XChangeWindowAttributes(xDisplay, xWindow, 2048, attributes);
    }

    int getForegroundPixel() {
        boolean invisible;
        boolean bl = invisible = this.lastForeground != -1;
        if (invisible) {
            return this.lastForeground;
        }
        return super.getForegroundPixel();
    }

    public int getMaximum() {
        this.checkWidget();
        int[] argList = new int[]{OS.XmNmaximum, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        return argList[1];
    }

    public int getMinimum() {
        this.checkWidget();
        int[] argList = new int[]{OS.XmNminimum, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        return argList[1];
    }

    public int getSelection() {
        boolean invisible;
        this.checkWidget();
        int[] argList = new int[]{OS.XmNminimum, 0, OS.XmNsliderSize, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int minimum = argList[1];
        int sliderSize = argList[3];
        boolean bl = invisible = this.lastForeground != -1;
        if (invisible) {
            sliderSize = 0;
        }
        return minimum + sliderSize;
    }

    void propagateWidget(boolean enabled) {
        super.propagateWidget(enabled);
        if (enabled) {
            this.disableButtonPress();
        }
    }

    void realizeChildren() {
        super.realizeChildren();
        this.disableButtonPress();
    }

    void releaseWidget() {
        super.releaseWidget();
        this.destroyTimer();
    }

    public void setBackground(Color color) {
        boolean invisible;
        this.checkWidget();
        super.setBackground(color);
        boolean bl = invisible = this.lastForeground != -1;
        if (invisible) {
            int[] argList = new int[]{OS.XmNtroughColor, 0};
            OS.XtGetValues(this.handle, argList, argList.length / 2);
            this.setForegroundPixel(argList[1]);
        }
    }

    public void setForeground(Color color) {
        boolean invisible;
        this.checkWidget();
        boolean bl = invisible = this.lastForeground != -1;
        if (invisible) {
            this.lastForeground = color.handle.pixel;
        } else {
            super.setForeground(color);
        }
    }

    public void setMaximum(int value) {
        this.checkWidget();
        if (value < 0) {
            return;
        }
        int[] argList = new int[]{OS.XmNmaximum, value, OS.XmNvalue, 0};
        Display display = this.getDisplay();
        boolean warnings = display.getWarnings();
        display.setWarnings(false);
        OS.XtSetValues(this.handle, argList, argList.length / 2);
        display.setWarnings(warnings);
    }

    public void setMinimum(int value) {
        this.checkWidget();
        if (value < 0) {
            return;
        }
        int[] argList = new int[]{OS.XmNminimum, 0, OS.XmNmaximum, 0, OS.XmNsliderSize, 0, OS.XmNvalue, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int minimum = argList[1];
        int maximum = argList[3];
        int sliderSize = argList[5];
        if (value >= maximum) {
            return;
        }
        int selection = sliderSize + minimum;
        if (value > selection) {
            selection = value;
        }
        argList[1] = value;
        argList[7] = value;
        Display display = this.getDisplay();
        boolean warnings = display.getWarnings();
        display.setWarnings(false);
        OS.XtSetValues(this.handle, argList, argList.length / 2);
        display.setWarnings(warnings);
        this.setThumb(selection - value);
    }

    public void setSelection(int value) {
        this.checkWidget();
        int[] argList = new int[]{OS.XmNminimum, 0, OS.XmNmaximum, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int minimum = argList[1];
        int maximum = argList[3];
        int selection = value;
        if (selection < minimum) {
            selection = minimum;
        }
        if (selection > maximum) {
            selection = maximum;
        }
        this.setThumb(selection - minimum);
    }

    void setThumb(int sliderSize) {
        boolean invisible;
        int[] argList1 = new int[]{OS.XmNtroughColor, 0, OS.XmNminimum, 0};
        OS.XtGetValues(this.handle, argList1, argList1.length / 2);
        int troughColor = argList1[1];
        boolean bl = invisible = this.lastForeground != -1;
        if (sliderSize == 0) {
            if (!invisible) {
                this.lastForeground = this.getForegroundPixel();
                this.setForegroundPixel(troughColor);
            }
        } else if (invisible) {
            this.setForegroundPixel(this.lastForeground);
            this.lastForeground = -1;
        }
        int[] argList2 = new int[]{OS.XmNsliderSize, sliderSize == 0 ? 1 : sliderSize, OS.XmNvalue, argList1[3]};
        Display display = this.getDisplay();
        boolean warnings = display.getWarnings();
        display.setWarnings(false);
        OS.XtSetValues(this.handle, argList2, argList2.length / 2);
        display.setWarnings(warnings);
    }

    int timerProc(int id) {
        int minimum = this.getMinimum();
        int range = this.getMaximum() - minimum + 1;
        int value = this.getSelection() - minimum + 1;
        this.setSelection(minimum + value % range);
        this.createTimer();
        return 0;
    }
}

