/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.SelectableItem;

abstract class SelectableItemWidget
extends Composite {
    private static final int DEFAULT_WIDTH = 64;
    private static final int DEFAULT_HEIGHT = 64;
    private static final int HORIZONTAL_SCROLL_INCREMENT = 5;
    private static ImageData UncheckedImageData;
    private static ImageData GrayUncheckedImageData;
    private static ImageData CheckMarkImageData;
    private int topIndex = 0;
    private int itemHeight = 0;
    private Point itemImageExtent = null;
    private int textHeight = -1;
    private int contentWidth = 0;
    private int horizontalOffset = 0;
    private Vector selectedItems;
    private SelectableItem lastSelectedItem;
    private SelectableItem lastFocusItem;
    private SelectableItem insertItem;
    private boolean isInsertAfter;
    private boolean isCtrlSelection = false;
    private boolean isRemovingAll = false;
    private boolean hasFocus;
    private Image uncheckedImage;
    private Image grayUncheckedImage;
    private Image checkMarkImage;
    private Point checkBoxExtent = null;
    private Listener listener;
    private int drawCount = 0;

    SelectableItemWidget(Composite parent, int style) {
        super(parent, style | 0x100 | 0x200 | 0x100000);
        this.initialize();
    }

    void addedItem(SelectableItem item, int index) {
        this.calculateVerticalScrollbar();
        if (this.getLastFocus() == null) {
            this.setLastFocus(item, true);
        }
    }

    void addingItem(SelectableItem item, int index) {
        if (index >= 0 && index <= this.getBottomIndex()) {
            this.scrollVerticalAddingItem(index);
        }
    }

    void calculateHorizontalScrollbar() {
        int newMaximum = this.getContentWidth();
        ScrollBar horizontalBar = this.getHorizontalBar();
        if (horizontalBar.getMaximum() != newMaximum) {
            horizontalBar.setMaximum(newMaximum);
            if (!this.getVerticalBar().getVisible()) {
                horizontalBar.setMaximum(newMaximum);
            }
            this.resizeHorizontalScrollbar();
        }
    }

    void calculateItemHeight(SelectableItem item) {
        int itemHeight = -1;
        if (this.itemImageExtent != null && this.textHeight != -1) {
            return;
        }
        String itemText = item.getText();
        if (itemText != null && this.textHeight == -1) {
            GC gc = new GC(this);
            this.textHeight = itemHeight = gc.stringExtent((String)itemText).y;
            gc.dispose();
        }
        if (this.itemImageExtent == null) {
            this.itemImageExtent = this.getImageExtent(item);
            if (this.itemImageExtent != null) {
                itemHeight = this.itemImageExtent.y > this.textHeight ? this.itemImageExtent.y : this.textHeight;
            }
        }
        if ((itemHeight += this.getItemPadding()) > this.getItemHeight()) {
            this.setItemHeight(itemHeight);
        }
    }

    int[] calculateShiftSelectionRange(int hitItemIndex) {
        int[] selectionRange = new int[]{-1, -1};
        SelectableItem closestItem = null;
        Enumeration selectedItems = this.getSelectionVector().elements();
        while (selectedItems.hasMoreElements()) {
            SelectableItem selectedItem = (SelectableItem)selectedItems.nextElement();
            if (closestItem == null) {
                closestItem = selectedItem;
                continue;
            }
            if (Math.abs(hitItemIndex - this.getVisibleIndex(selectedItem)) >= Math.abs(hitItemIndex - this.getVisibleIndex(closestItem))) continue;
            closestItem = selectedItem;
        }
        if (closestItem == null) {
            closestItem = this.getLastSelection();
        }
        if (closestItem != null) {
            selectionRange[0] = this.getVisibleIndex(closestItem);
            selectionRange[1] = hitItemIndex;
        }
        return selectionRange;
    }

    void calculateVerticalScrollbar() {
        int newMaximum = this.getVisibleItemCount();
        ScrollBar verticalBar = this.getVerticalBar();
        verticalBar.setMaximum(newMaximum);
        if (!this.getHorizontalBar().getVisible()) {
            verticalBar.setMaximum(newMaximum);
        }
        this.resizeVerticalScrollbar();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = this.getContentWidth();
        int height = this.getItemCount() * this.getItemHeight();
        int scrollBarWidth = this.computeTrim((int)0, (int)0, (int)0, (int)0).width;
        if (width == 0) {
            width = 64;
        }
        if (height == 0) {
            height = 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        if ((this.getStyle() & 0x200) != 0) {
            width += scrollBarWidth;
        }
        if ((this.getStyle() & 0x100) != 0) {
            height += scrollBarWidth;
        }
        return new Point(width, height);
    }

    void ctrlShiftSelect(SelectableItem hitItem, int hitItemIndex) {
        int fromIndex = -1;
        int toIndex = -1;
        int lastSelectionIndex = -1;
        SelectableItem lastSelection = this.getLastSelection();
        if (lastSelection != null) {
            lastSelectionIndex = this.getVisibleIndex(lastSelection);
        }
        if (this.getSelectionVector().contains(hitItem) && hitItemIndex != lastSelectionIndex) {
            this.setLastSelection(hitItem, true);
        } else if (this.isCtrlSelection()) {
            fromIndex = lastSelectionIndex;
            toIndex = hitItemIndex;
        } else {
            int[] selectionRange = this.calculateShiftSelectionRange(hitItemIndex);
            fromIndex = selectionRange[0];
            toIndex = selectionRange[1];
        }
        if (fromIndex != -1 && toIndex != -1) {
            this.selectRange(fromIndex, toIndex);
        }
    }

    void deselect(SelectableItem item) {
        Vector selectedItems = this.getSelectionVector();
        if (item != null && item.isSelected()) {
            item.setSelected(false);
            this.redrawSelection(item);
            selectedItems.removeElement(item);
        }
    }

    void deselectAllExcept(SelectableItem keepSelected) {
        SelectableItem item;
        Vector selectedItems = this.getSelectionVector();
        Vector<SelectableItem> deselectedItems = new Vector<SelectableItem>(selectedItems.size());
        Enumeration elements = selectedItems.elements();
        while (elements.hasMoreElements()) {
            item = (SelectableItem)elements.nextElement();
            if (!item.isSelected() || item == keepSelected) continue;
            item.setSelected(false);
            this.redrawSelection(item);
            deselectedItems.addElement(item);
        }
        elements = deselectedItems.elements();
        while (elements.hasMoreElements()) {
            item = (SelectableItem)elements.nextElement();
            selectedItems.removeElement(item);
        }
        this.setLastSelection(keepSelected, false);
    }

    void deselectAllExcept(Vector keepSelected) {
        SelectableItem item;
        Vector selectedItems = this.getSelectionVector();
        Vector<SelectableItem> deselectedItems = new Vector<SelectableItem>(selectedItems.size());
        Enumeration elements = selectedItems.elements();
        while (elements.hasMoreElements()) {
            item = (SelectableItem)elements.nextElement();
            if (!item.isSelected() || keepSelected.contains(item)) continue;
            item.setSelected(false);
            this.redrawSelection(item);
            deselectedItems.addElement(item);
        }
        elements = deselectedItems.elements();
        while (elements.hasMoreElements()) {
            item = (SelectableItem)elements.nextElement();
            selectedItems.removeElement(item);
        }
        if (keepSelected.size() > 0) {
            this.setLastSelection((SelectableItem)keepSelected.firstElement(), false);
        }
    }

    void deselectNotify(SelectableItem item) {
        Event event = new Event();
        if (item.isSelected()) {
            this.deselect(item);
            this.setLastSelection(item, true);
            this.update();
        }
        event.item = item;
        this.notifyListeners(13, event);
    }

    void deselectRange(int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            int i = toIndex;
            while (i <= fromIndex) {
                this.deselect(this.getVisibleItem(i));
                ++i;
            }
        } else if (fromIndex < toIndex) {
            int i = toIndex;
            while (i >= fromIndex) {
                this.deselect(this.getVisibleItem(i));
                --i;
            }
        }
        this.setLastSelection(this.getVisibleItem(fromIndex), true);
    }

    void doArrowDown(int keyMask) {
        SelectableItem lastFocus = this.getLastFocus();
        int focusItemIndex = this.getVisibleIndex(lastFocus);
        if (focusItemIndex < this.getVisibleItemCount() - 1) {
            SelectableItem newFocus = this.getVisibleItem(++focusItemIndex);
            if (keyMask == SWT.MOD1 && this.isMultiSelect()) {
                this.setLastFocus(newFocus, true);
            } else if (keyMask == SWT.MOD2 && this.isMultiSelect()) {
                this.shiftSelect(newFocus, focusItemIndex);
            } else {
                this.deselectAllExcept(newFocus);
                this.selectNotify(newFocus);
            }
        }
    }

    void doArrowLeft(int keyMask) {
        ScrollBar horizontalBar = this.getHorizontalBar();
        int scrollSelection = horizontalBar.getSelection();
        if (!horizontalBar.getVisible()) {
            return;
        }
        int scrollAmount = Math.min(5, scrollSelection);
        horizontalBar.setSelection(scrollSelection - scrollAmount);
        this.setHorizontalOffset(horizontalBar.getSelection() * -1);
    }

    void doArrowRight(int keyMask) {
        ScrollBar horizontalBar = this.getHorizontalBar();
        int scrollSelection = horizontalBar.getSelection();
        if (!horizontalBar.getVisible()) {
            return;
        }
        int scrollAmount = Math.min(5, horizontalBar.getMaximum() - horizontalBar.getPageIncrement() - scrollSelection);
        horizontalBar.setSelection(scrollSelection + scrollAmount);
        this.setHorizontalOffset(horizontalBar.getSelection() * -1);
    }

    void doArrowUp(int keyMask) {
        SelectableItem lastFocus = this.getLastFocus();
        int focusItemIndex = this.getVisibleIndex(lastFocus);
        if (focusItemIndex > 0) {
            SelectableItem newFocus = this.getVisibleItem(--focusItemIndex);
            if (keyMask == SWT.MOD1 && this.isMultiSelect()) {
                this.setLastFocus(newFocus, true);
            } else if (keyMask == SWT.MOD2 && this.isMultiSelect()) {
                this.shiftSelect(newFocus, focusItemIndex);
            } else {
                this.deselectAllExcept(newFocus);
                this.selectNotify(newFocus);
            }
        }
    }

    void doCheckItem(SelectableItem item) {
        Event event = new Event();
        item.setChecked(!item.getChecked());
        event.item = item;
        event.detail = 32;
        this.notifyListeners(13, event);
    }

    void doDispose() {
        this.setRemovingAll(true);
        this.getSelectionVector().removeAllElements();
        this.lastFocusItem = null;
        this.lastSelectedItem = null;
        if (this.uncheckedImage != null) {
            this.uncheckedImage.dispose();
        }
        if (this.grayUncheckedImage != null) {
            this.grayUncheckedImage.dispose();
        }
        if (this.checkMarkImage != null) {
            this.checkMarkImage.dispose();
        }
    }

    void doEnd(int keyMask) {
        int lastItemIndex;
        SelectableItem lastFocus = this.getLastFocus();
        int focusItemIndex = this.getVisibleIndex(lastFocus);
        if (focusItemIndex < (lastItemIndex = this.getVisibleItemCount() - 1)) {
            SelectableItem newFocus = this.getVisibleItem(lastItemIndex);
            if (keyMask == SWT.MOD1 && this.isMultiSelect()) {
                this.setLastFocus(newFocus, true);
            } else if (keyMask == SWT.MOD2 && this.isMultiSelect()) {
                this.shiftSelect(newFocus, lastItemIndex);
            } else {
                this.deselectAllExcept(newFocus);
                this.selectNotify(newFocus);
            }
        }
    }

    void doHome(int keyMask) {
        SelectableItem lastFocus = this.getLastFocus();
        int firstItemIndex = 0;
        if (this.getVisibleIndex(lastFocus) > firstItemIndex) {
            SelectableItem newFocus = this.getVisibleItem(firstItemIndex);
            if (keyMask == SWT.MOD1 && this.isMultiSelect()) {
                this.setLastFocus(newFocus, true);
            } else if (keyMask == SWT.MOD2 && this.isMultiSelect()) {
                this.shiftSelect(newFocus, firstItemIndex);
            } else {
                this.deselectAllExcept(newFocus);
                this.selectNotify(newFocus);
            }
        }
    }

    void doMouseSelect(SelectableItem item, int itemIndex, int eventStateMask, int button) {
        if (button != 1 && item.isSelected()) {
            return;
        }
        if ((eventStateMask & SWT.MOD1) != 0 && (eventStateMask & SWT.MOD2) != 0 && this.isMultiSelect()) {
            if (this.getSelectionVector().size() == 0) {
                this.selectNotify(item);
            } else {
                this.ctrlShiftSelect(item, itemIndex);
            }
            this.setCtrlSelection(true);
        } else if ((eventStateMask & SWT.MOD2) != 0 && this.isMultiSelect()) {
            this.shiftSelect(item, itemIndex);
            this.setCtrlSelection(false);
        } else if ((eventStateMask & SWT.MOD1) != 0 && this.isMultiSelect()) {
            this.toggleSelectionNotify(item);
            this.setCtrlSelection(true);
        } else if ((eventStateMask & (SWT.MOD3 | SWT.MOD4)) == 0) {
            this.deselectAllExcept(item);
            this.selectNotify(item);
            this.setCtrlSelection(false);
        }
    }

    void doPageDown(int keyMask) {
        int lastItemIndex;
        int focusItemIndex = this.getVisibleIndex(this.getLastFocus());
        if (focusItemIndex < (lastItemIndex = this.getVisibleItemCount() - 1)) {
            int visibleItemCount = this.getItemCountWhole();
            SelectableItem newFocus = this.getVisibleItem(focusItemIndex = Math.min(lastItemIndex, focusItemIndex + (visibleItemCount - 1)));
            if (newFocus == null) {
                return;
            }
            if (keyMask == SWT.MOD1 && this.isMultiSelect()) {
                this.setLastFocus(newFocus, true);
            } else if (keyMask == SWT.MOD2 && this.isMultiSelect()) {
                this.shiftSelect(newFocus, focusItemIndex);
            } else {
                this.deselectAllExcept(newFocus);
                this.selectNotify(newFocus);
            }
        }
    }

    void doPageUp(int keyMask) {
        int focusItemIndex = this.getVisibleIndex(this.getLastFocus());
        if (focusItemIndex > 0) {
            int visibleItemCount = this.getItemCountWhole();
            focusItemIndex = Math.max(0, focusItemIndex - (visibleItemCount - 1));
            SelectableItem newFocus = this.getVisibleItem(focusItemIndex);
            if (keyMask == SWT.MOD1 && this.isMultiSelect()) {
                this.setLastFocus(newFocus, true);
            } else if (keyMask == SWT.MOD2 && this.isMultiSelect()) {
                this.shiftSelect(newFocus, focusItemIndex);
            } else {
                this.deselectAllExcept(newFocus);
                this.selectNotify(newFocus);
            }
        }
    }

    void doSpace(int keyMask) {
        SelectableItem item = this.getLastFocus();
        if (item == null) {
            return;
        }
        if (item.isCheckable()) {
            this.doCheckItem(item);
        }
        int itemIndex = this.getVisibleIndex(item);
        if (keyMask == 0 && !item.isSelected()) {
            this.deselectAllExcept(item);
            this.selectNotify(item);
            return;
        }
        if (!this.isMultiSelect()) {
            return;
        }
        if (keyMask == SWT.MOD1) {
            this.toggleSelectionNotify(item);
        } else if ((keyMask & SWT.MOD1) != 0 && (keyMask & SWT.MOD2) != 0) {
            this.deselectAllExcept(item);
            this.selectNotify(item);
        } else if (keyMask == SWT.MOD2) {
            this.shiftSelect(item, itemIndex);
        }
    }

    void claimBottomFreeSpace() {
        int clientAreaItemCount = this.getItemCountWhole();
        int topIndex = this.getTopIndex();
        int lastItemIndex = this.getVisibleItemCount() - topIndex;
        if (topIndex > 0 && lastItemIndex > 0 && lastItemIndex < clientAreaItemCount) {
            int newTopIndex = Math.max(0, topIndex - (clientAreaItemCount - lastItemIndex));
            this.setTopIndex(newTopIndex, true);
        }
    }

    void claimRightFreeSpace() {
        int clientAreaWidth = this.getClientArea().width;
        int newHorizontalOffset = clientAreaWidth - this.getContentWidth();
        if (newHorizontalOffset - this.getHorizontalOffset() > 0) {
            newHorizontalOffset = Math.min(0, newHorizontalOffset);
            this.setHorizontalOffset(newHorizontalOffset);
        }
    }

    void focusChange(Event event) {
        Enumeration items = this.getSelectionVector().elements();
        SelectableItem lastFocusItem = this.getLastFocus();
        while (items.hasMoreElements()) {
            SelectableItem item = (SelectableItem)items.nextElement();
            this.redrawSelection(item);
        }
        if (lastFocusItem != null) {
            this.redrawSelection(lastFocusItem);
        }
    }

    void focusIn(Event event) {
        Enumeration items = this.getSelectionVector().elements();
        SelectableItem lastFocusItem = this.getLastFocus();
        this.hasFocus = true;
        while (items.hasMoreElements()) {
            SelectableItem item = (SelectableItem)items.nextElement();
            this.redrawSelection(item);
        }
        if (lastFocusItem != null) {
            this.redrawSelection(lastFocusItem);
        }
        this.update();
    }

    void focusOut(Event event) {
        Enumeration items = this.getSelectionVector().elements();
        SelectableItem lastFocusItem = this.getLastFocus();
        this.hasFocus = false;
        while (items.hasMoreElements()) {
            SelectableItem item = (SelectableItem)items.nextElement();
            this.redrawSelection(item);
        }
        if (lastFocusItem != null) {
            this.redrawSelection(lastFocusItem);
        }
        this.update();
    }

    int getBottomIndex() {
        return this.getTopIndex() + this.getItemCountTruncated(this.getClientArea());
    }

    Point getCheckBoxExtent() {
        if (this.checkBoxExtent == null) {
            Image checkedImage = this.getUncheckedImage();
            if (checkedImage != null) {
                Rectangle imageBounds = checkedImage.getBounds();
                this.checkBoxExtent = new Point(imageBounds.width, imageBounds.height);
            } else {
                this.checkBoxExtent = new Point(0, 0);
            }
        }
        return this.checkBoxExtent;
    }

    Image getCheckMarkImage() {
        if (this.checkMarkImage == null) {
            this.checkMarkImage = new Image((Device)this.getDisplay(), CheckMarkImageData);
        }
        return this.checkMarkImage;
    }

    int getContentWidth() {
        return this.contentWidth;
    }

    int getHorizontalOffset() {
        return this.horizontalOffset;
    }

    Point getImageExtent() {
        return this.itemImageExtent;
    }

    Point getImageExtent(SelectableItem item) {
        Image image = item.getImage();
        Point imageExtent = null;
        if (image != null) {
            Rectangle imageBounds = image.getBounds();
            imageExtent = new Point(imageBounds.width, imageBounds.height);
        }
        return imageExtent;
    }

    abstract int getIndex(SelectableItem var1);

    int[] getIndexRange(Rectangle clipRectangle) {
        int[] visibleRange = new int[]{0, 0};
        visibleRange[0] = clipRectangle.y / this.getItemHeight();
        visibleRange[1] = visibleRange[0] + this.getItemCountTruncated(clipRectangle) - 1;
        return visibleRange;
    }

    SelectableItem getInsertItem() {
        return this.insertItem;
    }

    public abstract int getItemCount();

    int getItemCountTruncated(Rectangle rectangle) {
        int itemHeight = this.getItemHeight();
        int itemCount = 0;
        int startIndex = rectangle.y / itemHeight;
        itemCount = Compatibility.ceil(rectangle.y + rectangle.height, itemHeight) - startIndex;
        return itemCount;
    }

    int getItemCountWhole() {
        return this.getClientArea().height / this.getItemHeight();
    }

    public int getItemHeight() {
        this.checkWidget();
        if (this.itemHeight == 0) {
            GC gc = new GC(this);
            this.itemHeight = gc.stringExtent((String)"String").y + this.getItemPadding();
            gc.dispose();
        }
        return this.itemHeight;
    }

    int getItemPadding() {
        return 2 + this.getDisplay().textHighlightThickness;
    }

    SelectableItem getLastFocus() {
        return this.lastFocusItem;
    }

    SelectableItem getLastSelection() {
        return this.lastSelectedItem;
    }

    Listener getListener() {
        return this.listener;
    }

    int getRedrawY(SelectableItem item) {
        int redrawIndex = this.getVisibleIndex(item);
        int redrawY = -1;
        if (redrawIndex != -1) {
            redrawY = (redrawIndex - this.getTopIndex()) * this.getItemHeight();
        }
        return redrawY;
    }

    public int getSelectionCount() {
        this.checkWidget();
        return this.getSelectionVector().size();
    }

    Vector getSelectionVector() {
        return this.selectedItems;
    }

    int getTextWidth(String text) {
        int textWidth = 0;
        if (text != null) {
            GC gc = new GC(this);
            textWidth = gc.stringExtent((String)text).x;
            gc.dispose();
        }
        return textWidth;
    }

    int getTopIndex() {
        return this.topIndex;
    }

    Image getUncheckedImage() {
        if (this.uncheckedImage == null) {
            this.uncheckedImage = new Image((Device)this.getDisplay(), UncheckedImageData);
        }
        return this.uncheckedImage;
    }

    Image getGrayUncheckedImage() {
        if (this.grayUncheckedImage == null) {
            this.grayUncheckedImage = new Image((Device)this.getDisplay(), GrayUncheckedImageData);
        }
        return this.grayUncheckedImage;
    }

    abstract int getVisibleIndex(SelectableItem var1);

    abstract SelectableItem getVisibleItem(int var1);

    int getVisibleItemCount() {
        return this.getItemCount();
    }

    abstract int getVisibleRedrawY(SelectableItem var1);

    void handleEvents(Event event) {
        switch (event.type) {
            case 12: {
                this.doDispose();
                break;
            }
            case 1: {
                this.keyDown(event);
                break;
            }
            case 11: {
                this.resize(event);
                break;
            }
            case 13: {
                if (event.widget == this.getVerticalBar()) {
                    this.scrollVertical(event);
                    break;
                }
                if (event.widget != this.getHorizontalBar()) break;
                this.scrollHorizontal(event);
                break;
            }
            case 16: {
                this.focusOut(event);
                break;
            }
            case 15: {
                this.focusIn(event);
                break;
            }
            case 31: {
                switch (event.detail) {
                    case 2: 
                    case 4: 
                    case 8: 
                    case 16: {
                        event.doit = true;
                    }
                }
            }
        }
    }

    boolean hasFocus(SelectableItem item) {
        return this.isFocusControl() && item == this.getLastFocus();
    }

    void initialize() {
        Display display = this.getDisplay();
        ScrollBar horizontalBar = this.getHorizontalBar();
        ScrollBar verticalBar = this.getVerticalBar();
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                SelectableItemWidget.this.handleEvents(event);
            }
        };
        this.setSelectionVector(new Vector());
        this.installListeners();
        this.calculateVerticalScrollbar();
        this.calculateHorizontalScrollbar();
        horizontalBar.setMinimum(0);
        verticalBar.setMinimum(0);
        horizontalBar.setIncrement(5);
        this.setForeground(display.getSystemColor(24));
        this.setBackground(display.getSystemColor(25));
    }

    static void initializeImageData() {
        PaletteData uncheckedPalette = new PaletteData(new RGB[]{new RGB(128, 128, 128), new RGB(255, 255, 255)});
        PaletteData grayUncheckedPalette = new PaletteData(new RGB[]{new RGB(128, 128, 128), new RGB(192, 192, 192)});
        PaletteData checkMarkPalette = new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(252, 3, 251)});
        byte[] checkbox = new byte[]{0, 0, 127, -64, 127, -64, 127, -64, 127, -64, 127, -64, 127, -64, 127, -64, 127, -64, 127, -64, 0, 0};
        UncheckedImageData = new ImageData(11, 11, 1, uncheckedPalette, 2, checkbox);
        GrayUncheckedImageData = new ImageData(11, 11, 1, grayUncheckedPalette, 2, checkbox);
        CheckMarkImageData = new ImageData(7, 7, 1, checkMarkPalette, 1, new byte[]{-4, -8, 112, 34, 6, -114, -34});
        SelectableItemWidget.CheckMarkImageData.transparentPixel = 1;
    }

    void installListeners() {
        Listener listener = this.getListener();
        this.addListener(12, listener);
        this.addListener(11, listener);
        this.addListener(1, listener);
        this.addListener(16, listener);
        this.addListener(15, listener);
        this.addListener(31, listener);
        this.getVerticalBar().addListener(13, listener);
        this.getHorizontalBar().addListener(13, listener);
    }

    boolean isCtrlSelection() {
        return this.isCtrlSelection;
    }

    boolean isRemovingAll() {
        return this.isRemovingAll;
    }

    public boolean isFocusControl() {
        return this.hasFocus;
    }

    boolean isInsertAfter() {
        return this.isInsertAfter;
    }

    boolean isMultiSelect() {
        return (this.getStyle() & 2) != 0;
    }

    void itemChanged(SelectableItem changedItem, int repaintStartX, int repaintWidth) {
        int yPosition;
        int oldItemHeight = this.getItemHeight();
        Point oldImageExtent = this.getImageExtent();
        this.calculateItemHeight(changedItem);
        if (repaintWidth == 0 || (yPosition = this.getVisibleRedrawY(changedItem)) == -1) {
            return;
        }
        int itemHeight = this.getItemHeight();
        if (oldItemHeight == itemHeight && oldImageExtent == this.getImageExtent()) {
            if ((repaintWidth = Math.min(repaintWidth, this.getClientArea().width - repaintStartX)) > 0) {
                this.redraw(repaintStartX, yPosition, repaintWidth, itemHeight, true);
            }
        } else {
            this.redraw();
        }
    }

    void keyDown(Event event) {
        boolean isCtrlSelection = this.isCtrlSelection();
        if (event.stateMask != SWT.MOD1) {
            isCtrlSelection = false;
        }
        switch (event.keyCode) {
            case 0x1000001: {
                this.doArrowUp(event.stateMask);
                break;
            }
            case 0x1000002: {
                this.doArrowDown(event.stateMask);
                break;
            }
            case 0x1000003: {
                this.doArrowLeft(event.stateMask);
                break;
            }
            case 0x1000004: {
                this.doArrowRight(event.stateMask);
                break;
            }
            case 0x1000005: {
                this.doPageUp(event.stateMask);
                break;
            }
            case 0x1000006: {
                this.doPageDown(event.stateMask);
                break;
            }
            case 0x1000007: {
                this.doHome(event.stateMask);
                break;
            }
            case 0x1000008: {
                this.doEnd(event.stateMask);
                break;
            }
            default: {
                isCtrlSelection = this.isCtrlSelection();
            }
        }
        if (event.character == ' ') {
            this.doSpace(event.stateMask);
            boolean bl = isCtrlSelection = event.stateMask == SWT.MOD1;
        }
        if (event.character == '\r') {
            Event forwardEvent = new Event();
            forwardEvent.item = this.getLastFocus();
            this.notifyListeners(14, forwardEvent);
        }
        this.setCtrlSelection(isCtrlSelection);
    }

    void motif_setInsertMark(SelectableItem item, boolean after) {
        int redrawY;
        SelectableItem currentItem = this.getInsertItem();
        this.setInsertItem(item);
        this.setInsertAfter(after);
        if (currentItem != null && (redrawY = this.getVisibleRedrawY(currentItem)) != -1) {
            currentItem.redrawInsertMark(redrawY);
        }
        if (item != null && (redrawY = this.getVisibleRedrawY(item)) != -1) {
            item.redrawInsertMark(redrawY);
        }
    }

    public void redraw() {
        this.checkWidget();
        if (this.drawCount == 0) {
            super.redraw();
        }
    }

    public void redraw(int x, int y, int width, int height, boolean all) {
        this.checkWidget();
        if (this.drawCount == 0) {
            super.redraw(x, y, width, height, all);
        }
    }

    void redrawSelection(SelectableItem item) {
        int redrawPosition = this.getVisibleRedrawY(item);
        if (redrawPosition != -1) {
            item.redrawSelection(redrawPosition);
        }
    }

    void removedItem(SelectableItem item) {
        this.claimBottomFreeSpace();
        this.calculateVerticalScrollbar();
        if (this.getItemCount() == 0) {
            this.reset();
        }
    }

    void removingItem(SelectableItem item) {
        SelectableItem nextFocusItem = null;
        int itemIndex = this.getVisibleIndex(item);
        int itemCount = this.getVisibleItemCount();
        if (item.isSelected()) {
            this.getSelectionVector().removeElement(item);
        }
        if (item == this.getLastFocus() && itemCount > 1) {
            nextFocusItem = itemIndex == itemCount - 1 ? this.getVisibleItem(itemIndex - 1) : this.getVisibleItem(itemIndex + 1);
            this.setLastFocus(nextFocusItem, true);
        }
        if (itemIndex != -1 && itemIndex <= this.getBottomIndex()) {
            this.scrollVerticalRemovedItem(itemIndex);
        }
    }

    void reset() {
        this.setSelectionVector(new Vector());
        this.setTopIndexNoScroll(0, true);
        this.lastSelectedItem = null;
        this.lastFocusItem = null;
        this.resetItemData();
    }

    void resetItemData() {
        this.setHorizontalOffset(0);
        this.setItemHeight(0);
        this.itemImageExtent = null;
        this.textHeight = -1;
        this.claimRightFreeSpace();
    }

    void resize(Event event) {
        int horizontalPageSize = this.getHorizontalBar().getPageIncrement();
        this.resizeHorizontalScrollbar();
        this.resizeVerticalScrollbar();
        if (this.getClientArea().width > horizontalPageSize) {
            this.claimRightFreeSpace();
        }
        this.claimBottomFreeSpace();
    }

    void resizeHorizontalScrollbar() {
        ScrollBar horizontalBar = this.getHorizontalBar();
        int clientAreaWidth = this.getClientArea().width;
        if (clientAreaWidth < this.getContentWidth()) {
            if (!horizontalBar.getVisible()) {
                horizontalBar.setVisible(true);
                horizontalBar.setSelection(0);
            }
        } else if (horizontalBar.getVisible()) {
            horizontalBar.setVisible(false);
        }
        horizontalBar.setThumb(clientAreaWidth);
        horizontalBar.setPageIncrement(clientAreaWidth);
    }

    void resizeVerticalScrollbar() {
        int clientAreaItemCount = this.getItemCountWhole();
        ScrollBar verticalBar = this.getVerticalBar();
        if (clientAreaItemCount == 0) {
            return;
        }
        if (clientAreaItemCount < this.getVisibleItemCount()) {
            if (!verticalBar.getVisible()) {
                verticalBar.setVisible(true);
            }
            verticalBar.setPageIncrement(clientAreaItemCount);
            verticalBar.setThumb(clientAreaItemCount);
        } else if (verticalBar.getVisible()) {
            verticalBar.setVisible(false);
        }
    }

    void scroll(int destX, int destY, int x, int y, int width, int height, boolean all) {
        if (this.drawCount == 0) {
            this.update();
            GC gc = new GC(this);
            gc.copyArea(x, y, width, height, destX, destY);
            gc.dispose();
        }
    }

    abstract void scrollHorizontal(int var1);

    void scrollHorizontal(Event event) {
        this.setHorizontalOffset(this.getHorizontalBar().getSelection() * -1);
    }

    void scrollShowItem(int index) {
        int itemIndexFromTop = index - this.getTopIndex();
        int clientAreaWholeItemCount = this.getItemCountWhole();
        int scrollAmount = 0;
        if (itemIndexFromTop >= clientAreaWholeItemCount) {
            scrollAmount = itemIndexFromTop;
            if (clientAreaWholeItemCount > 0) {
                scrollAmount -= clientAreaWholeItemCount - 1;
            }
        } else if (itemIndexFromTop < 0) {
            scrollAmount = itemIndexFromTop;
        }
        this.setTopIndex(this.getTopIndex() + scrollAmount, true);
    }

    abstract void scrollVertical(int var1);

    void scrollVertical(Event event) {
        this.setTopIndex(this.getVerticalBar().getSelection(), false);
    }

    void scrollVerticalAddingItem(int index) {
        Rectangle clientArea = this.getClientArea();
        int itemHeight = this.getItemHeight();
        int sourceY = Math.max(0, (index - this.getTopIndex()) * itemHeight);
        this.scroll(0, sourceY + itemHeight, 0, sourceY, clientArea.width, clientArea.height, true);
    }

    void scrollVerticalRemovedItem(int index) {
        Rectangle clientArea = this.getClientArea();
        int itemHeight = this.getItemHeight();
        int destinationY = Math.max(0, (index - this.getTopIndex()) * itemHeight);
        this.scroll(0, destinationY, 0, destinationY + itemHeight, clientArea.width, clientArea.height, true);
    }

    void select(SelectableItem item) {
        Vector selectedItems = this.getSelectionVector();
        if (item != null && !item.isSelected() && !this.isRemovingAll()) {
            item.setSelected(true);
            this.redrawSelection(item);
            selectedItems.addElement(item);
        }
    }

    void selectNotify(final SelectableItem item, boolean asyncNotify) {
        if (!this.isRemovingAll()) {
            if (!item.isSelected()) {
                this.select(item);
                this.setLastSelection(item, true);
                this.update();
            }
            if (!asyncNotify) {
                Event event = new Event();
                event.item = item;
                this.notifyListeners(13, event);
            } else {
                this.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (!item.isDisposed()) {
                            Event event = new Event();
                            event.item = item;
                            SelectableItemWidget.this.notifyListeners(13, event);
                        }
                    }
                });
            }
        }
    }

    void selectNotify(SelectableItem item) {
        this.selectNotify(item, false);
    }

    void selectRange(int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            int i = fromIndex;
            while (i > toIndex) {
                this.select(this.getVisibleItem(i));
                --i;
            }
        } else {
            int i = fromIndex;
            while (i < toIndex) {
                this.select(this.getVisibleItem(i));
                ++i;
            }
        }
        this.selectNotify(this.getVisibleItem(toIndex));
    }

    void setContentWidth(int newWidth) {
        if (this.contentWidth != newWidth) {
            ScrollBar horizontalBar = this.getHorizontalBar();
            boolean scrollBarVisible = horizontalBar.getVisible();
            this.contentWidth = newWidth;
            this.calculateHorizontalScrollbar();
            if (scrollBarVisible != horizontalBar.getVisible()) {
                this.resizeVerticalScrollbar();
            }
        }
    }

    void setCtrlSelection(boolean isCtrlSelection) {
        this.isCtrlSelection = isCtrlSelection;
    }

    public void setFont(Font font) {
        this.checkWidget();
        super.setFont(font);
        this.textHeight = -1;
    }

    void setHorizontalOffset(int offset) {
        int offsetChange = offset - this.horizontalOffset;
        if (offsetChange != 0) {
            this.scrollHorizontal(offsetChange);
            this.horizontalOffset = offset;
        }
    }

    void setInsertAfter(boolean after) {
        this.isInsertAfter = after;
    }

    void setInsertItem(SelectableItem item) {
        this.insertItem = item;
    }

    void setItemHeight(int height) {
        this.itemHeight = height;
    }

    void setLastFocus(SelectableItem focusItem, boolean showItem) {
        SelectableItem oldFocusItem = this.lastFocusItem;
        if (focusItem != this.lastFocusItem) {
            this.lastFocusItem = focusItem;
            if (oldFocusItem != null) {
                this.redrawSelection(oldFocusItem);
            }
            if (this.lastFocusItem != null && this.isFocusControl()) {
                this.redrawSelection(this.lastFocusItem);
            }
        }
        if (focusItem != null && showItem) {
            this.showSelectableItem(focusItem);
        }
    }

    void setLastSelection(SelectableItem selectedItem, boolean showItem) {
        if (selectedItem == null) {
            return;
        }
        this.setLastFocus(selectedItem, showItem);
        this.lastSelectedItem = selectedItem;
    }

    public void setRedraw(boolean redraw) {
        this.checkWidget();
        if (redraw) {
            if (--this.drawCount == 0) {
                this.redraw();
            }
        } else {
            ++this.drawCount;
        }
    }

    void setRemovingAll(boolean removingAll) {
        this.isRemovingAll = removingAll;
    }

    void setSelectableSelection(SelectableItem[] selectionItems) {
        SelectableItem item = null;
        int selectionCount = selectionItems.length;
        if (!this.isMultiSelect() && selectionCount > 1) {
            selectionCount = 1;
        }
        Vector<SelectableItem> keepSelected = new Vector<SelectableItem>(selectionItems.length);
        int i = 0;
        while (i < selectionCount) {
            if (selectionItems[i] != null) {
                if (selectionItems[i].isDisposed()) {
                    this.error(5);
                }
                keepSelected.addElement(selectionItems[i]);
            }
            ++i;
        }
        this.deselectAllExcept(keepSelected);
        int i2 = selectionCount - 1;
        while (i2 >= 0) {
            item = selectionItems[i2];
            if (item != null) {
                this.select(item);
            }
            --i2;
        }
        if (item != null) {
            this.setLastSelection(item, true);
        }
    }

    void setSelectionVector(Vector newVector) {
        this.selectedItems = newVector;
    }

    void setTopIndex(int index, boolean adjustScrollbar) {
        int indexDiff = index - this.topIndex;
        if (indexDiff != 0) {
            this.scrollVertical(indexDiff);
            this.setTopIndexNoScroll(index, adjustScrollbar);
        }
    }

    void setTopIndexNoScroll(int index, boolean adjustScrollbar) {
        this.topIndex = index;
        if (adjustScrollbar) {
            this.getVerticalBar().setSelection(index);
        }
    }

    void shiftSelect(SelectableItem hitItem, int hitItemIndex) {
        int fromIndex = -1;
        int toIndex = -1;
        int lastSelectionIndex = -1;
        SelectableItem lastSelection = this.getLastSelection();
        if (lastSelection != null) {
            lastSelectionIndex = this.getVisibleIndex(lastSelection);
        }
        if (this.isCtrlSelection()) {
            this.deselectAllExcept(lastSelection);
            fromIndex = lastSelectionIndex;
            toIndex = hitItemIndex;
        } else if (this.getSelectionVector().contains(hitItem)) {
            this.deselectRange(hitItemIndex, lastSelectionIndex);
        } else {
            int[] selectionRange = this.calculateShiftSelectionRange(hitItemIndex);
            fromIndex = selectionRange[0];
            toIndex = selectionRange[1];
        }
        if (hitItemIndex == lastSelectionIndex) {
            return;
        }
        if (fromIndex == -1 || toIndex == -1) {
            this.toggleSelectionNotify(hitItem);
        } else {
            if (lastSelectionIndex < fromIndex && hitItemIndex > fromIndex || lastSelectionIndex > fromIndex && hitItemIndex < fromIndex) {
                this.deselectAllExcept((SelectableItem)null);
            }
            this.selectRange(fromIndex, toIndex);
        }
    }

    void showSelectableItem(SelectableItem item) {
        if (item.getSelectableParent() != this) {
            return;
        }
        int index = this.getIndex(item);
        this.showSelectableItem(index);
    }

    void showSelectableItem(int index) {
        this.scrollShowItem(index);
        this.scrollShowItem(index);
    }

    public void showSelection() {
        this.checkWidget();
        Vector selection = this.getSelectionVector();
        if (selection.size() > 0) {
            SelectableItem selectionItem = (SelectableItem)selection.firstElement();
            this.showSelectableItem(selectionItem);
        }
    }

    void sort(SelectableItem[] array, int start, int end) {
        int middle = (start + end) / 2;
        if (start + 1 < middle) {
            this.sort(array, start, middle);
        }
        if (middle + 1 < end) {
            this.sort(array, middle, end);
        }
        if (start + 1 >= end) {
            return;
        }
        if (this.getVisibleIndex(array[middle - 1]) <= this.getVisibleIndex(array[middle])) {
            return;
        }
        if (start + 2 == end) {
            SelectableItem temp = array[start];
            array[start] = array[middle];
            array[middle] = temp;
            return;
        }
        int i1 = start;
        int i2 = middle;
        int i3 = 0;
        SelectableItem[] merge = new SelectableItem[end - start];
        while (i1 < middle && i2 < end) {
            SelectableItem selectableItem = merge[i3++] = this.getVisibleIndex(array[i1]) <= this.getVisibleIndex(array[i2]) ? array[i1++] : array[i2++];
        }
        if (i1 < middle) {
            System.arraycopy(array, i1, merge, i3, middle - i1);
        }
        System.arraycopy(merge, 0, array, start, i2 - start);
    }

    void toggleSelectionNotify(SelectableItem item) {
        if (item.isSelected()) {
            this.deselectNotify(item);
        } else {
            this.selectNotify(item);
        }
    }

    static {
        SelectableItemWidget.initializeImageData();
    }
}

