/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;

class FileImageDescriptor
extends ImageDescriptor {
    private Class location;
    private String name;

    FileImageDescriptor(Class clazz, String filename) {
        this.location = clazz;
        this.name = filename;
    }

    public boolean equals(Object o) {
        if (!(o instanceof FileImageDescriptor)) {
            return false;
        }
        FileImageDescriptor other = (FileImageDescriptor)o;
        if (this.location != null ? !this.location.equals(other.location) : other.location != null) {
            return false;
        }
        return this.name.equals(other.name);
    }

    public ImageData getImageData() {
        InputStream in = this.getStream();
        if (in != null) {
            ImageData imageData;
            try {
                imageData = new ImageData(in);
                Object var2_3 = null;
            }
            catch (Throwable throwable) {
                Object var2_4 = null;
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    return null;
                }
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException iOException) {
                return null;
            }
            return imageData;
        }
        return null;
    }

    private InputStream getStream() {
        InputStream is = null;
        if (this.location != null) {
            is = this.location.getResourceAsStream(this.name);
        } else {
            try {
                is = new FileInputStream(this.name);
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }
        return is;
    }

    public int hashCode() {
        int code = this.name.hashCode();
        if (this.location != null) {
            code += this.location.hashCode();
        }
        return code;
    }

    public String toString() {
        return "FileImageDescriptor(location=" + this.location + ", name=" + this.name + ")";
    }
}

