/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.audio;

import com.sun.speech.freetts.audio.AudioPlayer;
import com.sun.speech.freetts.util.Utilities;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

public class MultiFile8BitAudioPlayer
implements AudioPlayer {
    private boolean debug = false;
    private AudioFormat currentFormat = new AudioFormat(8000.0f, 8, 1, false, false);
    private int fileCount = 0;
    private String baseName;
    private byte[] outputData;
    private int curIndex = 0;
    private AudioFileFormat.Type outputType;

    public MultiFile8BitAudioPlayer(String string, AudioFileFormat.Type type) {
        this.baseName = string;
        this.outputType = type;
        this.debug = Utilities.getBoolean("com.sun.speech.freetts.audio.AudioPlayer.debug");
    }

    public synchronized void setAudioFormat(AudioFormat audioFormat) {
    }

    public AudioFormat getAudioFormat() {
        return this.currentFormat;
    }

    public void pause() {
    }

    public synchronized void resume() {
    }

    public void startFirstSampleTimer() {
    }

    public synchronized void cancel() {
    }

    public synchronized void reset() {
    }

    public synchronized void close() {
    }

    public float getVolume() {
        return 1.0f;
    }

    public void setVolume(float f) {
    }

    public void begin(int n) {
        this.outputData = new byte[n / 2];
        this.curIndex = 0;
    }

    public boolean end() {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.outputData);
        AudioInputStream audioInputStream = new AudioInputStream(byteArrayInputStream, this.currentFormat, this.outputData.length / this.currentFormat.getFrameSize());
        String string = this.baseName;
        string = string + this.fileCount;
        string = string + "." + this.outputType.getExtension();
        File file = new File(string);
        try {
            AudioSystem.write(audioInputStream, this.outputType, file);
        }
        catch (IOException iOException) {
            System.err.println("Can't write audio to " + file);
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println("Can't write audio type " + this.outputType);
            return false;
        }
        ++this.fileCount;
        return true;
    }

    public boolean drain() {
        return true;
    }

    public synchronized long getTime() {
        return -1L;
    }

    public synchronized void resetTime() {
    }

    public boolean write(byte[] byArray) {
        return this.write(byArray, 0, byArray.length);
    }

    public boolean write(byte[] byArray, int n, int n2) {
        byArray = MultiFile8BitAudioPlayer.convert16To8Bits(byArray);
        System.arraycopy(byArray, n, this.outputData, this.curIndex, n2 /= 2);
        this.curIndex += n2;
        return true;
    }

    private static byte[] convert16To8Bits(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length / 2];
        int n = 0;
        int n2 = 0;
        while (n < byArray.length) {
            int n3 = 0xFF & byArray[n];
            byArray2[n2] = (byte)(n3 + 128);
            n += 2;
            ++n2;
        }
        return byArray2;
    }

    private synchronized boolean waitResume() {
        return true;
    }

    public String toString() {
        return "MultiFile8BitAudioPlayer";
    }

    private void debugPrint(String string) {
        if (this.debug) {
            System.out.println(this.toString() + ": " + string);
        }
    }

    public void showMetrics() {
    }
}

