/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.clunits;

import com.sun.speech.freetts.FeatureSet;
import com.sun.speech.freetts.FeatureSetImpl;
import com.sun.speech.freetts.Item;
import com.sun.speech.freetts.PathExtractor;
import com.sun.speech.freetts.PathExtractorImpl;
import com.sun.speech.freetts.ProcessException;
import com.sun.speech.freetts.Relation;
import com.sun.speech.freetts.Utterance;
import com.sun.speech.freetts.UtteranceProcessor;
import com.sun.speech.freetts.cart.CART;
import com.sun.speech.freetts.clunits.ClusterUnit;
import com.sun.speech.freetts.clunits.ClusterUnitDatabase;
import com.sun.speech.freetts.clunits.Cost;
import java.io.IOException;
import java.net.URL;

public class ClusterUnitSelector
implements UtteranceProcessor {
    static final boolean DEBUG = false;
    private static final PathExtractor DNAME = new PathExtractorImpl("R:SylStructure.parent.parent.name", true);
    private ClusterUnitDatabase clunitDB;

    public ClusterUnitSelector(URL uRL) throws IOException {
        if (uRL == null) {
            throw new IOException("Can't load cluster unit database");
        }
        boolean bl = uRL.getPath().endsWith(".bin");
        this.clunitDB = new ClusterUnitDatabase(uRL, bl);
    }

    public void processUtterance(Utterance utterance) throws ProcessException {
        Relation relation = utterance.getRelation("Segment");
        utterance.setObject("SampleInfo", this.clunitDB.getSampleInfo());
        utterance.setObject("sts_list", this.clunitDB.getSts());
        Viterbi viterbi = new Viterbi(relation, this.clunitDB);
        Item item = relation.getHead();
        while (item != null) {
            this.setUnitName(item);
            item = item.getNext();
        }
        viterbi.decode();
        if (!viterbi.result("selected_unit")) {
            utterance.getVoice().error("clunits: can't find path");
        }
        viterbi.copyFeature("unit_prev_move");
        viterbi.copyFeature("unit_this_move");
        Relation relation2 = utterance.createRelation("Unit");
        Item item2 = relation.getHead();
        while (item2 != null) {
            Item item3 = relation2.appendItem();
            FeatureSet featureSet = item3.getFeatures();
            int n = item2.getFeatures().getInt("selected_unit");
            featureSet.setString("name", item2.getFeatures().getString("name"));
            String string = item2.getFeatures().getString("clunit_name");
            int n2 = item2.getFeatures().isPresent("unit_this_move") ? item2.getFeatures().getInt("unit_this_move") : this.clunitDB.getStart(n);
            int n3 = item2.getNext() != null && item2.getNext().getFeatures().isPresent("unit_prev_move") ? item2.getNext().getFeatures().getInt("unit_prev_move") : this.clunitDB.getEnd(n);
            featureSet.setInt("unit_entry", n);
            ClusterUnit clusterUnit = new ClusterUnit(this.clunitDB, string, n2, n3);
            featureSet.setObject("unit", clusterUnit);
            featureSet.setInt("unit_start", clusterUnit.getStart());
            featureSet.setInt("unit_end", clusterUnit.getEnd());
            featureSet.setInt("target_end", (int)(item2.getFeatures().getFloat("end") * (float)this.clunitDB.getSampleInfo().getSampleRate()));
            item2 = item2.getNext();
        }
    }

    private void setUnitName(Item item) {
        String string = null;
        String string2 = item.getFeatures().getString("name");
        if (string2.equals("pau")) {
            string = "pau_" + item.findFeature("p.name");
        } else {
            String string3 = ((String)DNAME.findFeature(item)).toLowerCase();
            string = string2 + "_" + this.stripQuotes(string3);
        }
        item.getFeatures().setString("clunit_name", string);
    }

    private String stripQuotes(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c != '\'') {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return "ClusterUnitSelector";
    }

    static void debug(String string) {
    }

    static class ViterbiPath {
        int score = 0;
        int state = 0;
        ViterbiCandidate candidate = null;
        private FeatureSet f = null;
        ViterbiPath from = null;
        ViterbiPath next = null;

        ViterbiPath() {
        }

        void setFeature(String string, Object object) {
            if (this.f == null) {
                this.f = new FeatureSetImpl();
            }
            this.f.setObject(string, object);
        }

        Object getFeature(String string) {
            Object object = null;
            if (this.f != null) {
                object = this.f.getObject(string);
            }
            return object;
        }

        boolean isPresent(String string) {
            if (this.f == null) {
                return false;
            }
            return this.getFeature(string) != null;
        }

        public String toString() {
            return "ViterbiPath score " + this.score + " state " + this.state;
        }
    }

    static class ViterbiCandidate {
        int score = 0;
        Object value = null;
        int ival = 0;
        int pos = 0;
        Item item = null;
        ViterbiCandidate next = null;

        ViterbiCandidate() {
        }

        void set(Object object) {
            this.value = object;
        }

        void setInt(int n) {
            this.ival = n;
            this.set(new Integer(n));
        }

        public String toString() {
            return "VC: Score " + this.score + " ival " + this.ival + " Pos " + this.pos;
        }
    }

    static class ViterbiPoint {
        Item item = null;
        int numStates = 0;
        int numPaths = 0;
        ViterbiCandidate cands = null;
        ViterbiPath paths = null;
        ViterbiPath[] statePaths = null;
        ViterbiPoint next = null;

        public ViterbiPoint(Item item) {
            this.item = item;
        }

        public void initPathArray(int n) {
            this.numStates = n;
            this.statePaths = new ViterbiPath[n];
        }

        public void initDynamicPathArray(ViterbiCandidate viterbiCandidate) {
            int n = 0;
            ViterbiCandidate viterbiCandidate2 = viterbiCandidate;
            while (viterbiCandidate2 != null) {
                viterbiCandidate2.pos = n++;
                viterbiCandidate2 = viterbiCandidate2.next;
            }
            this.initPathArray(n);
        }

        public String toString() {
            return " pnt: " + this.numStates + " paths " + this.numPaths;
        }
    }

    static class Viterbi {
        private int numStates = -1;
        private boolean bigIsGood = false;
        private ViterbiPoint timeline = null;
        private ViterbiPoint lastPoint = null;
        private FeatureSet f = null;
        private ClusterUnitDatabase clunitDB;

        public Viterbi(Relation relation, ClusterUnitDatabase clusterUnitDatabase) {
            ViterbiPoint viterbiPoint;
            ViterbiPoint viterbiPoint2 = null;
            this.clunitDB = clusterUnitDatabase;
            this.f = new FeatureSetImpl();
            Item item = relation.getHead();
            while (true) {
                viterbiPoint = new ViterbiPoint(item);
                if (this.numStates > 0) {
                    viterbiPoint.initPathArray(this.numStates);
                }
                if (viterbiPoint2 != null) {
                    viterbiPoint2.next = viterbiPoint;
                } else {
                    this.timeline = viterbiPoint;
                }
                viterbiPoint2 = viterbiPoint;
                if (item == null) break;
                item = item.getNext();
            }
            this.lastPoint = viterbiPoint;
            if (this.numStates == 0) {
                this.timeline.paths = new ViterbiPath();
            }
            if (this.numStates == -1) {
                this.timeline.initPathArray(1);
            }
        }

        public void setFeature(String string, Object object) {
            this.f.setObject(string, object);
        }

        public Object getFeature(String string) {
            return this.f.getObject(string);
        }

        void decode() {
            ViterbiPoint viterbiPoint = this.timeline;
            while (viterbiPoint.next != null) {
                viterbiPoint.cands = this.getCandidate(viterbiPoint.item);
                if (this.numStates != 0) {
                    if (this.numStates == -1) {
                        viterbiPoint.next.initDynamicPathArray(viterbiPoint.cands);
                    }
                    int n = 0;
                    while (n < viterbiPoint.numStates) {
                        if (viterbiPoint == this.timeline && n == 0 || viterbiPoint.statePaths[n] != null) {
                            ViterbiCandidate viterbiCandidate = viterbiPoint.cands;
                            while (viterbiCandidate != null) {
                                ViterbiPath viterbiPath = this.getPath(viterbiPoint.statePaths[n], viterbiCandidate);
                                this.addPaths(viterbiPoint.next, viterbiPath);
                                viterbiCandidate = viterbiCandidate.next;
                            }
                        }
                        ++n;
                    }
                } else {
                    System.err.println("Viterbi.decode: general beam search not implemented");
                }
                viterbiPoint = viterbiPoint.next;
            }
        }

        void addPaths(ViterbiPoint viterbiPoint, ViterbiPath viterbiPath) {
            ViterbiPath viterbiPath2 = viterbiPath;
            while (viterbiPath2 != null) {
                ViterbiPath viterbiPath3 = viterbiPath2.next;
                this.addPath(viterbiPoint, viterbiPath2);
                viterbiPath2 = viterbiPath3;
            }
        }

        void addPath(ViterbiPoint viterbiPoint, ViterbiPath viterbiPath) {
            if (viterbiPoint.statePaths[viterbiPath.state] == null) {
                viterbiPoint.statePaths[viterbiPath.state] = viterbiPath;
            } else if (this.isBetterThan(viterbiPath.score, viterbiPoint.statePaths[viterbiPath.state].score)) {
                viterbiPoint.statePaths[viterbiPath.state] = viterbiPath;
            }
        }

        private boolean isBetterThan(int n, int n2) {
            if (this.bigIsGood) {
                return n > n2;
            }
            return n < n2;
        }

        /*
         * Unable to fully structure code
         */
        boolean result(String var1_1) {
            if (this.timeline == null || this.timeline.next == null) {
                return true;
            }
            var2_2 = this.findBestPath();
            if (var2_2 != null) ** GOTO lbl9
            return false;
lbl-1000:
            // 1 sources

            {
                if (var2_2.candidate != null) {
                    var2_2.candidate.item.getFeatures().setObject(var1_1, var2_2.candidate.value);
                }
                var2_2 = var2_2.from;
lbl9:
                // 2 sources

                ** while (var2_2 != null)
            }
lbl10:
            // 1 sources

            return true;
        }

        /*
         * Unable to fully structure code
         */
        void copyFeature(String var1_1) {
            var2_2 = this.findBestPath();
            if (var2_2 != null) ** GOTO lbl7
            return;
lbl-1000:
            // 1 sources

            {
                if (var2_2.candidate != null && var2_2.isPresent(var1_1)) {
                    var2_2.candidate.item.getFeatures().setObject(var1_1, var2_2.getFeature(var1_1));
                }
                var2_2 = var2_2.from;
lbl7:
                // 2 sources

                ** while (var2_2 != null)
            }
lbl8:
            // 1 sources

        }

        private ViterbiCandidate getCandidate(Item item) {
            ViterbiCandidate viterbiCandidate;
            String string = item.getFeatures().getString("clunit_name");
            CART cART = this.clunitDB.getTree(string);
            int[] nArray = (int[])cART.interpret(item);
            ViterbiCandidate viterbiCandidate2 = null;
            int n = 0;
            while (n < nArray.length) {
                viterbiCandidate = new ViterbiCandidate();
                viterbiCandidate.next = viterbiCandidate2;
                viterbiCandidate.item = item;
                viterbiCandidate.score = 0;
                viterbiCandidate.setInt(this.clunitDB.getUnitIndex(string, nArray[n]));
                viterbiCandidate2 = viterbiCandidate;
                ++n;
            }
            if (this.clunitDB.getExtendSelections() > 0 && item.getPrevious() != null) {
                ViterbiCandidate viterbiCandidate3 = (ViterbiCandidate)item.getPrevious().getFeatures().getObject("clunit_cands");
                int n2 = 0;
                while (viterbiCandidate3 != null && n2 < this.clunitDB.getExtendSelections()) {
                    int n3 = this.clunitDB.getNextUnit(viterbiCandidate3.ival);
                    if (n3 != 65535) {
                        ViterbiCandidate viterbiCandidate4 = viterbiCandidate2;
                        while (viterbiCandidate4 != null) {
                            if (n3 == viterbiCandidate4.ival) break;
                            viterbiCandidate4 = viterbiCandidate4.next;
                        }
                        if (viterbiCandidate4 == null && this.clunitDB.isUnitTypeEqual(n3, viterbiCandidate2.ival)) {
                            viterbiCandidate = new ViterbiCandidate();
                            viterbiCandidate.next = viterbiCandidate2;
                            viterbiCandidate.item = item;
                            viterbiCandidate.score = 0;
                            viterbiCandidate.setInt(n3);
                            viterbiCandidate2 = viterbiCandidate;
                            ++n2;
                        }
                    }
                    viterbiCandidate3 = viterbiCandidate3.next;
                }
            }
            item.getFeatures().setObject("clunit_cands", viterbiCandidate2);
            return viterbiCandidate2;
        }

        private ViterbiPath getPath(ViterbiPath viterbiPath, ViterbiCandidate viterbiCandidate) {
            int n;
            ViterbiPath viterbiPath2 = new ViterbiPath();
            viterbiPath2.candidate = viterbiCandidate;
            viterbiPath2.from = viterbiPath;
            if (viterbiPath == null || viterbiPath.candidate == null) {
                n = 0;
            } else {
                int n2 = viterbiPath.candidate.ival;
                int n3 = viterbiCandidate.ival;
                if (this.clunitDB.getOptimalCoupling() == 1) {
                    Cost cost = this.getOptimalCouple(n2, n3);
                    if (cost.u0Move != -1) {
                        viterbiPath2.setFeature("unit_prev_move", new Integer(cost.u0Move));
                    }
                    if (cost.u1Move != -1) {
                        viterbiPath2.setFeature("unit_this_move", new Integer(cost.u1Move));
                    }
                    n = cost.cost;
                } else {
                    n = this.clunitDB.getOptimalCoupling() == 2 ? this.getOptimalCoupleFrame(n2, n3) : 0;
                }
            }
            viterbiPath2.state = viterbiCandidate.pos;
            viterbiPath2.score = viterbiPath == null ? n + viterbiCandidate.score : (n *= 5) + viterbiCandidate.score + viterbiPath.score;
            return viterbiPath2;
        }

        private ViterbiPath findBestPath() {
            ViterbiPath viterbiPath = null;
            int n = this.bigIsGood ? Integer.MIN_VALUE : Integer.MAX_VALUE;
            int n2 = n;
            ViterbiPoint viterbiPoint = this.lastPoint;
            if (this.numStates != 0) {
                int n3 = 0;
                while (n3 < viterbiPoint.numStates) {
                    if (viterbiPoint.statePaths[n3] != null && this.isBetterThan(viterbiPoint.statePaths[n3].score, n2)) {
                        n2 = viterbiPoint.statePaths[n3].score;
                        viterbiPath = viterbiPoint.statePaths[n3];
                    }
                    ++n3;
                }
            }
            return viterbiPath;
        }

        Cost getOptimalCouple(int n, int n2) {
            int n3;
            int n4;
            int n5;
            Cost cost = new Cost();
            int n6 = this.clunitDB.getPrevUnit(n2);
            if (n6 == n) {
                return cost;
            }
            if (n6 == 65535 || this.clunitDB.getPhone(n) != this.clunitDB.getPhone(n6)) {
                cost.cost = 10 * this.getOptimalCoupleFrame(n, n2);
                return cost;
            }
            int n7 = this.clunitDB.getEnd(n) - this.clunitDB.getStart(n);
            int n8 = n7 - (n5 = n7 / 3) < (n4 = this.clunitDB.getEnd(n6) - this.clunitDB.getStart(n6)) - (n3 = n4 / 3) ? n7 - n5 : n4 - n3;
            int n9 = n7;
            int n10 = n4;
            int n11 = Integer.MAX_VALUE;
            int n12 = 0;
            while (n12 < n8) {
                int n13;
                int n14 = this.clunitDB.getStart(n) + n5 + n12;
                int n15 = this.getFrameDistance(n14, n13 = this.clunitDB.getStart(n6) + n3 + n12, this.clunitDB.getJoinWeights(), this.clunitDB.getMcep().getSampleInfo().getNumberOfChannels()) + Math.abs(this.clunitDB.getSts().getFrameSize(n14) - this.clunitDB.getSts().getFrameSize(n13)) * this.clunitDB.getContinuityWeight();
                if (n15 < n11) {
                    n11 = n15;
                    n9 = n5 + n12;
                    n10 = n3 + n12;
                }
                ++n12;
            }
            cost.u0Move = this.clunitDB.getStart(n) + n9;
            cost.u1Move = this.clunitDB.getStart(n6) + n10;
            cost.cost = 30000 + n11;
            return cost;
        }

        int getOptimalCoupleFrame(int n, int n2) {
            if (this.clunitDB.getPrevUnit(n2) == n) {
                return 0;
            }
            int n3 = this.clunitDB.getEnd(n);
            int n4 = this.clunitDB.getStart(n2);
            return this.getFrameDistance(n3, n4, this.clunitDB.getJoinWeights(), this.clunitDB.getMcep().getSampleInfo().getNumberOfChannels()) + Math.abs(this.clunitDB.getSts().getFrameSize(n3) - this.clunitDB.getSts().getFrameSize(n4)) * this.clunitDB.getContinuityWeight();
        }

        public int getFrameDistance(int n, int n2, int[] nArray, int n3) {
            short[] sArray = this.clunitDB.getMcep().getSample(n2).getFrameData();
            short[] sArray2 = this.clunitDB.getMcep().getSample(n).getFrameData();
            int n4 = 0;
            int n5 = 0;
            while (n5 < n3) {
                int n6 = sArray2[n5] - sArray[n5];
                n4 += Math.abs(n6) * nArray[n5] / 65536;
                ++n5;
            }
            return n4;
        }
    }
}

