/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.diphone;

import com.sun.speech.freetts.diphone.Diphone;
import com.sun.speech.freetts.relp.Sample;
import com.sun.speech.freetts.relp.SampleInfo;
import com.sun.speech.freetts.util.BulkTimer;
import com.sun.speech.freetts.util.Utilities;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class DiphoneUnitDatabase {
    private String name;
    private int sampleRate;
    private int numChannels;
    private int residualFold = 1;
    private float lpcMin;
    private float lpcRange;
    private int lineCount = 0;
    private Diphone defaultDiphone;
    private Map diphoneMap = null;
    private Map diphoneIndex;
    private SampleInfo sampleInfo;
    private boolean useNewIO = Utilities.getProperty("com.sun.speech.freetts.useNewIO", "true").equals("true");
    private String cacheType = Utilities.getProperty("com.sun.speech.freetts.diphone.UnitDatabase.cacheType", "preload");
    private boolean useIndexing = !this.cacheType.equals("preload");
    private boolean useCache = !this.cacheType.equals("demand");
    private boolean useSoftCache = this.cacheType.equals("soft");
    private static final int MAGIC = -17958194;
    private static final int INDEX_MAGIC = 16435934;
    private static final int VERSION = 1;
    private static final int MAX_DB_SIZE = 0x400000;
    private String indexName = null;
    private MappedByteBuffer mbb = null;
    private int defaultIndex = -1;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$sun$speech$freetts$diphone$DiphoneUnitDatabase;

    public DiphoneUnitDatabase(URL uRL, boolean bl) throws IOException {
        if (!this.useIndexing || this.useCache) {
            this.diphoneMap = new LinkedHashMap();
        }
        InputStream inputStream = Utilities.getInputStream(uRL);
        this.indexName = this.getIndexName(uRL.toString());
        if (bl) {
            this.loadBinary(inputStream);
        } else {
            this.loadText(inputStream);
        }
        inputStream.close();
        this.sampleInfo = new SampleInfo(this.sampleRate, this.numChannels, this.residualFold, this.lpcMin, this.lpcRange, 0.0f);
    }

    SampleInfo getSampleInfo() {
        return this.sampleInfo;
    }

    private String getIndexName(String string) {
        String string2 = null;
        if (string.lastIndexOf(".") != -1) {
            string2 = string.substring(0, string.lastIndexOf(".")) + ".idx";
        }
        return string2;
    }

    private void loadText(InputStream inputStream) {
        if (inputStream == null) {
            throw new Error("Can't load diphone db file.");
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            try {
                String string = bufferedReader.readLine();
                ++this.lineCount;
                while (string != null) {
                    if (!string.startsWith("***")) {
                        this.parseAndAdd(string, bufferedReader);
                    }
                    string = bufferedReader.readLine();
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                throw new Error(iOException.getMessage() + " at line " + this.lineCount);
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            throw throwable;
        }
    }

    private void parseAndAdd(String string, BufferedReader bufferedReader) {
        block15: {
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
                String string2 = stringTokenizer.nextToken();
                if (string2.equals("NAME")) {
                    this.name = stringTokenizer.nextToken();
                    break block15;
                }
                if (string2.equals("SAMPLE_RATE")) {
                    this.sampleRate = Integer.parseInt(stringTokenizer.nextToken());
                    break block15;
                }
                if (string2.equals("NUM_CHANNELS")) {
                    this.numChannels = Integer.parseInt(stringTokenizer.nextToken());
                    break block15;
                }
                if (string2.equals("LPC_MIN")) {
                    this.lpcMin = Float.parseFloat(stringTokenizer.nextToken());
                    break block15;
                }
                if (string2.equals("COEFF_MIN")) {
                    this.lpcMin = Float.parseFloat(stringTokenizer.nextToken());
                    break block15;
                }
                if (string2.equals("COEFF_RANGE")) {
                    this.lpcRange = Float.parseFloat(stringTokenizer.nextToken());
                    break block15;
                }
                if (string2.equals("LPC_RANGE")) {
                    this.lpcRange = Float.parseFloat(stringTokenizer.nextToken());
                    break block15;
                }
                if (string2.equals("DIPHONE")) {
                    String string3 = stringTokenizer.nextToken();
                    int n = Integer.parseInt(stringTokenizer.nextToken());
                    int n2 = Integer.parseInt(stringTokenizer.nextToken());
                    int n3 = Integer.parseInt(stringTokenizer.nextToken());
                    int n4 = n3 - n;
                    int n5 = n2 - n;
                    if (this.numChannels <= 0) {
                        throw new Error("Bad number of channels " + this.numChannels);
                    }
                    if (n4 <= 0) {
                        throw new Error("Bad number of samples " + n4);
                    }
                    Sample[] sampleArray = new Sample[n4];
                    int n6 = 0;
                    while (n6 < sampleArray.length) {
                        sampleArray[n6] = new Sample(bufferedReader, this.numChannels);
                        if (!$assertionsDisabled && sampleArray[n6].getFrameData().length != this.numChannels) {
                            throw new AssertionError();
                        }
                        ++n6;
                    }
                    Diphone diphone = new Diphone(string3, sampleArray, n5);
                    this.add(diphone);
                    break block15;
                }
                throw new Error("Unsupported tag " + string2);
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new Error("Error parsing db " + noSuchElementException.getMessage());
            }
            catch (NumberFormatException numberFormatException) {
                throw new Error("Error parsing numbers in db " + numberFormatException.getMessage());
            }
        }
    }

    private void add(Diphone diphone) {
        this.diphoneMap.put(diphone.getName(), diphone);
        if (this.defaultDiphone == null) {
            this.defaultDiphone = diphone;
        }
    }

    public Diphone getUnit(String string) {
        Diphone diphone = null;
        if (this.useIndexing) {
            int n;
            diphone = this.getFromCache(string);
            if (diphone == null && (n = this.getIndex(string)) != -1) {
                this.mbb.position(n);
                try {
                    diphone = Diphone.loadBinary(this.mbb);
                    if (diphone != null) {
                        this.putIntoCache(string, diphone);
                    }
                }
                catch (IOException iOException) {
                    System.err.println("Can't load diphone " + string);
                    diphone = null;
                }
            }
        } else {
            diphone = (Diphone)this.diphoneMap.get(string);
        }
        if (diphone == null) {
            System.err.println("Can't find diphone " + string);
            diphone = this.defaultDiphone;
        }
        return diphone;
    }

    private Diphone getFromCache(String string) {
        if (this.diphoneMap == null) {
            return null;
        }
        Diphone diphone = null;
        if (this.useSoftCache) {
            Reference reference = (Reference)this.diphoneMap.get(string);
            if (reference != null && (diphone = (Diphone)reference.get()) == null) {
                this.diphoneMap.remove(string);
            }
        } else {
            diphone = (Diphone)this.diphoneMap.get(string);
        }
        return diphone;
    }

    private void putIntoCache(String string, Diphone diphone) {
        if (this.diphoneMap == null) {
            return;
        }
        if (this.useSoftCache) {
            this.diphoneMap.put(string, new WeakReference<Diphone>(diphone));
        } else {
            this.diphoneMap.put(string, diphone);
        }
    }

    private void dumpCacheSize() {
        int n = 0;
        int n2 = 0;
        System.out.println("Entries: " + this.diphoneMap.size());
        Iterator iterator = this.diphoneMap.values().iterator();
        while (iterator.hasNext()) {
            Reference reference = (Reference)iterator.next();
            if (reference.get() == null) {
                ++n;
                continue;
            }
            ++n2;
        }
        System.out.println("   empty: " + n);
        System.out.println("    full: " + n2);
    }

    public String getName() {
        return this.name;
    }

    public void dump() {
        System.out.println("Name        " + this.name);
        System.out.println("SampleRate  " + this.sampleRate);
        System.out.println("NumChannels " + this.numChannels);
        System.out.println("lpcMin      " + this.lpcMin);
        System.out.println("lpcRange    " + this.lpcRange);
        Iterator iterator = this.diphoneMap.values().iterator();
        while (iterator.hasNext()) {
            Diphone diphone = (Diphone)iterator.next();
            diphone.dump();
        }
    }

    public void dumpBinary(String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            FileChannel fileChannel = fileOutputStream.getChannel();
            ByteBuffer byteBuffer = ByteBuffer.allocate(10000);
            byteBuffer.putInt(-17958194);
            byteBuffer.putInt(1);
            byteBuffer.putInt(this.sampleRate);
            byteBuffer.putInt(this.numChannels);
            byteBuffer.putFloat(this.lpcMin);
            byteBuffer.putFloat(this.lpcRange);
            byteBuffer.putInt(this.diphoneMap.size());
            byteBuffer.flip();
            fileChannel.write(byteBuffer);
            byteBuffer.clear();
            Iterator iterator = this.diphoneMap.values().iterator();
            while (iterator.hasNext()) {
                Diphone diphone = (Diphone)iterator.next();
                diphone.dumpBinary(byteBuffer);
                byteBuffer.flip();
                fileChannel.write(byteBuffer);
                byteBuffer.clear();
            }
            fileChannel.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new Error("Can't dump binary database " + fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            throw new Error("Can't write binary database " + iOException.getMessage());
        }
    }

    void dumpBinaryIndex(String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
            dataOutputStream.writeInt(16435934);
            dataOutputStream.writeInt(this.diphoneIndex.keySet().size());
            Iterator iterator = this.diphoneIndex.keySet().iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                int n = (Integer)this.diphoneIndex.get(string2);
                dataOutputStream.writeUTF(string2);
                dataOutputStream.writeInt(n);
            }
            dataOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new Error("Can't dump binary index " + fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            throw new Error("Can't write binary index " + iOException.getMessage());
        }
    }

    private void loadBinaryIndex(URL uRL) {
        this.diphoneIndex = new HashMap();
        try {
            InputStream inputStream = Utilities.getInputStream(uRL);
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            if (dataInputStream.readInt() != 16435934) {
                throw new Error("Bad index file format");
            }
            int n = dataInputStream.readInt();
            int n2 = 0;
            while (n2 < n) {
                String string = dataInputStream.readUTF();
                int n3 = dataInputStream.readInt();
                this.diphoneIndex.put(string, new Integer(n3));
                ++n2;
            }
            dataInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new Error("Can't load binary index " + fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            throw new Error("Can't read binary index " + iOException.getMessage());
        }
    }

    private int getIndex(String string) {
        Integer n = (Integer)this.diphoneIndex.get(string);
        if (n != null) {
            int n2 = n;
            if (this.defaultIndex == -1) {
                this.defaultIndex = n2;
            }
            return n2;
        }
        System.out.println("Can't find index entry for " + string);
        return this.defaultIndex;
    }

    private void loadBinary(InputStream inputStream) throws IOException {
        if (this.useNewIO && inputStream instanceof FileInputStream) {
            FileInputStream fileInputStream = (FileInputStream)inputStream;
            if (this.useIndexing) {
                this.loadBinaryIndex(new URL(this.indexName));
                this.mapDatabase(fileInputStream);
            } else {
                this.loadMappedBinary(fileInputStream);
            }
        } else {
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
            this.loadBinary(dataInputStream);
        }
    }

    private void loadBinary(DataInputStream dataInputStream) throws IOException {
        if (dataInputStream.readInt() != -17958194) {
            throw new Error("Bad magic in db");
        }
        if (dataInputStream.readInt() != 1) {
            throw new Error("Bad VERSION in db");
        }
        this.sampleRate = dataInputStream.readInt();
        this.numChannels = dataInputStream.readInt();
        this.lpcMin = dataInputStream.readFloat();
        this.lpcRange = dataInputStream.readFloat();
        int n = dataInputStream.readInt();
        int n2 = 0;
        while (n2 < n) {
            Diphone diphone = Diphone.loadBinary(dataInputStream);
            this.add(diphone);
            ++n2;
        }
    }

    private void loadMappedBinary(FileInputStream fileInputStream) throws IOException {
        FileChannel fileChannel = fileInputStream.getChannel();
        MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, (int)fileChannel.size());
        mappedByteBuffer.load();
        this.loadDatabase(mappedByteBuffer);
        fileInputStream.close();
    }

    private void mapDatabase(FileInputStream fileInputStream) throws IOException {
        FileChannel fileChannel = fileInputStream.getChannel();
        this.mbb = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, (int)fileChannel.size());
        this.mbb.load();
        this.loadDatabaseHeader(this.mbb);
    }

    private void loadDatabaseHeader(ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer.getInt() != -17958194) {
            throw new Error("Bad magic in db");
        }
        if (byteBuffer.getInt() != 1) {
            throw new Error("Bad VERSION in db");
        }
        this.sampleRate = byteBuffer.getInt();
        this.numChannels = byteBuffer.getInt();
        this.lpcMin = byteBuffer.getFloat();
        this.lpcRange = byteBuffer.getFloat();
    }

    private void loadDatabase(ByteBuffer byteBuffer) throws IOException {
        this.loadDatabaseHeader(byteBuffer);
        int n = byteBuffer.getInt();
        this.diphoneIndex = new HashMap();
        int n2 = 0;
        while (n2 < n) {
            int n3 = byteBuffer.position();
            Diphone diphone = Diphone.loadBinary(byteBuffer);
            this.add(diphone);
            this.diphoneIndex.put(diphone.getName(), new Integer(n3));
            ++n2;
        }
    }

    public boolean compare(DiphoneUnitDatabase diphoneUnitDatabase) {
        if (this.sampleRate != diphoneUnitDatabase.sampleRate) {
            return false;
        }
        if (this.numChannels != diphoneUnitDatabase.numChannels) {
            return false;
        }
        if (this.lpcMin != diphoneUnitDatabase.lpcMin) {
            return false;
        }
        if (this.lpcRange != diphoneUnitDatabase.lpcRange) {
            return false;
        }
        Iterator iterator = this.diphoneMap.values().iterator();
        while (iterator.hasNext()) {
            Diphone diphone;
            Diphone diphone2 = (Diphone)iterator.next();
            if (diphone2.compare(diphone = diphoneUnitDatabase.getUnit(diphone2.getName()))) continue;
            System.out.println("Diphones differ:");
            System.out.println("THis:");
            diphone2.dump();
            System.out.println("Other:");
            diphone.dump();
            return false;
        }
        return true;
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        try {
            if (stringArray.length > 0) {
                BulkTimer bulkTimer = BulkTimer.LOAD;
                bulkTimer.start();
                int n = 0;
                while (n < stringArray.length) {
                    Object object;
                    if (stringArray[n].equals("-generate_binary")) {
                        object = "diphone_units.txt";
                        if (n + 1 < stringArray.length) {
                            object = stringArray[++n];
                        }
                        int n2 = ((String)object).lastIndexOf(".txt");
                        String string = "diphone_units.bin";
                        if (n2 != -1) {
                            string = ((String)object).substring(0, n2) + ".bin";
                        }
                        String string2 = "diphone_units.idx";
                        if (n2 != -1) {
                            string2 = ((String)object).substring(0, n2) + ".idx";
                        }
                        bulkTimer.start("load_text");
                        DiphoneUnitDatabase diphoneUnitDatabase = new DiphoneUnitDatabase(new URL("file:./" + (String)object), false);
                        bulkTimer.stop("load_text");
                        bulkTimer.start("dump_binary");
                        diphoneUnitDatabase.dumpBinary(string);
                        bulkTimer.stop("dump_binary");
                        bulkTimer.start("load_binary");
                        DiphoneUnitDatabase diphoneUnitDatabase2 = new DiphoneUnitDatabase(new URL("file:./" + string), true);
                        bulkTimer.stop("load_binary");
                        bulkTimer.start("dump index");
                        diphoneUnitDatabase2.dumpBinaryIndex(string2);
                        bulkTimer.stop("dump index");
                    } else if (stringArray[n].equals("-compare")) {
                        bulkTimer.start("load_text");
                        object = new DiphoneUnitDatabase(new URL("file:./diphone_units.txt"), false);
                        bulkTimer.stop("load_text");
                        bulkTimer.start("load_binary");
                        DiphoneUnitDatabase diphoneUnitDatabase = new DiphoneUnitDatabase(new URL("file:./diphone_units.bin"), true);
                        bulkTimer.stop("load_binary");
                        bulkTimer.start("compare");
                        if (((DiphoneUnitDatabase)object).compare(diphoneUnitDatabase)) {
                            System.out.println("other compare ok");
                        } else {
                            System.out.println("other compare different");
                        }
                        bulkTimer.stop("compare");
                    } else if (stringArray[n].equals("-showtimes")) {
                        bl = true;
                    } else {
                        System.out.println("Unknown option " + stringArray[n]);
                    }
                    ++n;
                }
                bulkTimer.stop();
                if (bl) {
                    bulkTimer.show("DiphoneUnitDatabase");
                }
            } else {
                System.out.println("Options: ");
                System.out.println("    -compare");
                System.out.println("    -generate_binary");
                System.out.println("    -showTimes");
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$sun$speech$freetts$diphone$DiphoneUnitDatabase == null ? (class$com$sun$speech$freetts$diphone$DiphoneUnitDatabase = DiphoneUnitDatabase.class$("com.sun.speech.freetts.diphone.DiphoneUnitDatabase")) : class$com$sun$speech$freetts$diphone$DiphoneUnitDatabase).desiredAssertionStatus();
    }
}

