/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.en.us;

import com.sun.speech.freetts.FeatureSet;
import com.sun.speech.freetts.Item;
import com.sun.speech.freetts.en.us.WordRelation;
import com.sun.speech.freetts.util.Utilities;

public class NumberExpander {
    private static final String[] digit2num = new String[]{"zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine"};
    private static final String[] digit2teen = new String[]{"ten", "eleven", "twelve", "thirteen", "fourteen", "fifteen", "sixteen", "seventeen", "eighteen", "nineteen"};
    private static final String[] digit2enty = new String[]{"zero", "ten", "twenty", "thirty", "forty", "fifty", "sixty", "seventy", "eighty", "ninety"};
    private static final String[] ord2num = new String[]{"zeroth", "first", "second", "third", "fourth", "fifth", "sixth", "seventh", "eighth", "ninth"};
    private static final String[] ord2teen = new String[]{"tenth", "eleventh", "twelfth", "thirteenth", "fourteenth", "fifteenth", "sixteenth", "seventeenth", "eighteenth", "nineteenth"};
    private static final String[] ord2enty = new String[]{"zeroth", "tenth", "twentieth", "thirtieth", "fortieth", "fiftieth", "sixtieth", "seventieth", "eightieth", "ninetieth"};

    private NumberExpander() {
    }

    public static void expandNumber(String string, WordRelation wordRelation) {
        int n = string.length();
        if (n != 0) {
            if (n == 1) {
                NumberExpander.expandDigits(string, wordRelation);
            } else if (n == 2) {
                NumberExpander.expand2DigitNumber(string, wordRelation);
            } else if (n == 3) {
                NumberExpander.expand3DigitNumber(string, wordRelation);
            } else if (n < 7) {
                NumberExpander.expandBelow7DigitNumber(string, wordRelation);
            } else if (n < 10) {
                NumberExpander.expandBelow10DigitNumber(string, wordRelation);
            } else if (n < 13) {
                NumberExpander.expandBelow13DigitNumber(string, wordRelation);
            } else {
                NumberExpander.expandDigits(string, wordRelation);
            }
        }
    }

    private static void expand2DigitNumber(String string, WordRelation wordRelation) {
        if (string.charAt(0) == '0') {
            if (string.charAt(1) != '0') {
                String string2 = digit2num[string.charAt(1) - 48];
                wordRelation.addWord(string2);
            }
        } else if (string.charAt(1) == '0') {
            String string3 = digit2enty[string.charAt(0) - 48];
            wordRelation.addWord(string3);
        } else if (string.charAt(0) == '1') {
            String string4 = digit2teen[string.charAt(1) - 48];
            wordRelation.addWord(string4);
        } else {
            String string5 = digit2enty[string.charAt(0) - 48];
            wordRelation.addWord(string5);
            NumberExpander.expandDigits(string.substring(1, string.length()), wordRelation);
        }
    }

    private static void expand3DigitNumber(String string, WordRelation wordRelation) {
        if (string.charAt(0) == '0') {
            NumberExpander.expandNumberAt(string, 1, wordRelation);
        } else {
            String string2 = digit2num[string.charAt(0) - 48];
            wordRelation.addWord(string2);
            wordRelation.addWord("hundred");
            NumberExpander.expandNumberAt(string, 1, wordRelation);
        }
    }

    private static void expandBelow7DigitNumber(String string, WordRelation wordRelation) {
        NumberExpander.expandLargeNumber(string, "thousand", 3, wordRelation);
    }

    private static void expandBelow10DigitNumber(String string, WordRelation wordRelation) {
        NumberExpander.expandLargeNumber(string, "million", 6, wordRelation);
    }

    private static void expandBelow13DigitNumber(String string, WordRelation wordRelation) {
        NumberExpander.expandLargeNumber(string, "billion", 9, wordRelation);
    }

    private static void expandLargeNumber(String string, String string2, int n, WordRelation wordRelation) {
        int n2 = string.length();
        int n3 = n2 - n;
        String string3 = string.substring(0, n3);
        Item item = wordRelation.getTail();
        NumberExpander.expandNumber(string3, wordRelation);
        if (wordRelation.getTail() == item) {
            NumberExpander.expandNumberAt(string, n3, wordRelation);
        } else {
            wordRelation.addWord(string2);
            NumberExpander.expandNumberAt(string, n3, wordRelation);
        }
    }

    private static void expandNumberAt(String string, int n, WordRelation wordRelation) {
        NumberExpander.expandNumber(string.substring(n, string.length()), wordRelation);
    }

    public static void expandDigits(String string, WordRelation wordRelation) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (NumberExpander.isDigit(c)) {
                wordRelation.addWord(digit2num[string.charAt(n2) - 48]);
            } else {
                wordRelation.addWord("umpty");
            }
            ++n2;
        }
    }

    public static void expandOrdinal(String string, WordRelation wordRelation) {
        String string2 = Utilities.deleteChar(string, ',');
        NumberExpander.expandNumber(string2, wordRelation);
        Item item = wordRelation.getTail();
        if (item != null) {
            FeatureSet featureSet = item.getFeatures();
            String string3 = featureSet.getString("name");
            String string4 = NumberExpander.findMatchInArray(string3, digit2num, ord2num);
            if (string4 == null) {
                string4 = NumberExpander.findMatchInArray(string3, digit2teen, ord2teen);
            }
            if (string4 == null) {
                string4 = NumberExpander.findMatchInArray(string3, digit2enty, ord2enty);
            }
            if (string3.equals("hundred")) {
                string4 = "hundredth";
            } else if (string3.equals("thousand")) {
                string4 = "thousandth";
            } else if (string3.equals("billion")) {
                string4 = "billionth";
            }
            if (string4 != null) {
                wordRelation.setLastWord(string4);
            }
        }
    }

    private static String findMatchInArray(String string, String[] stringArray, String[] stringArray2) {
        int n = 0;
        while (n < stringArray.length) {
            if (string.equals(stringArray[n])) {
                if (n < stringArray2.length) {
                    return stringArray2[n];
                }
                return null;
            }
            ++n;
        }
        return null;
    }

    public static void expandID(String string, WordRelation wordRelation) {
        int n = string.length();
        if (n == 2 && string.charAt(0) == '0') {
            wordRelation.addWord("oh");
            NumberExpander.expandDigits(string.substring(1, 2), wordRelation);
        } else if (n == 4 && string.charAt(1) == '0' || n < 3) {
            NumberExpander.expandNumber(string, wordRelation);
        } else if (n % 2 == 1) {
            String string2 = digit2num[string.charAt(0) - 48];
            wordRelation.addWord(string2);
            NumberExpander.expandID(string.substring(1, n), wordRelation);
        } else {
            NumberExpander.expandNumber(string.substring(0, 2), wordRelation);
            NumberExpander.expandID(string.substring(2, n), wordRelation);
        }
    }

    public static void expandReal(String string, WordRelation wordRelation) {
        int n = string.length();
        if (string.charAt(0) == '-') {
            wordRelation.addWord("minus");
            NumberExpander.expandReal(string.substring(1, n), wordRelation);
        } else if (string.charAt(0) == '+') {
            wordRelation.addWord("plus");
            NumberExpander.expandReal(string.substring(1, n), wordRelation);
        } else {
            int n2 = string.indexOf(101);
            if (n2 != -1 || (n2 = string.indexOf(69)) != -1) {
                NumberExpander.expandReal(string.substring(0, n2), wordRelation);
                wordRelation.addWord("e");
                NumberExpander.expandReal(string.substring(n2 + 1), wordRelation);
            } else {
                n2 = string.indexOf(46);
                if (n2 != -1) {
                    String string2 = string.substring(0, n2);
                    if (string2.length() > 0) {
                        NumberExpander.expandReal(string2, wordRelation);
                    }
                    wordRelation.addWord("point");
                    String string3 = string.substring(n2 + 1);
                    if (string3.length() > 0) {
                        NumberExpander.expandDigits(string3, wordRelation);
                    }
                } else {
                    NumberExpander.expandNumber(string, wordRelation);
                }
            }
        }
    }

    public static void expandLetters(String string, WordRelation wordRelation) {
        string = string.toLowerCase();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (NumberExpander.isDigit(c)) {
                wordRelation.addWord(digit2num[c - 48]);
            } else if (string.equals("a")) {
                wordRelation.addWord("_a");
            } else {
                wordRelation.addWord(String.valueOf(c));
            }
            ++n;
        }
    }

    public static int expandRoman(String string) {
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (c == 'X') {
                n += 10;
            } else if (c == 'V') {
                n += 5;
            } else if (c == 'I') {
                if (n2 + 1 < string.length()) {
                    char c2 = string.charAt(n2 + 1);
                    if (c2 == 'V') {
                        n += 4;
                        ++n2;
                    } else if (c2 == 'X') {
                        n += 9;
                        ++n2;
                    } else {
                        ++n;
                    }
                } else {
                    ++n;
                }
            }
            ++n2;
        }
        return n;
    }

    public static boolean isDigit(char c) {
        return '0' <= c && c <= '9';
    }
}

