/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.jsapi;

import com.sun.speech.freetts.ValidationException;
import com.sun.speech.freetts.jsapi.FreeTTSSynthesizerModeDesc;
import com.sun.speech.freetts.jsapi.FreeTTSVoice;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.speech.EngineCentral;
import javax.speech.EngineList;
import javax.speech.EngineModeDesc;
import javax.speech.synthesis.Voice;

public class FreeTTSEngineCentral
implements EngineCentral {
    private String engineName = "FreeTTS Synthesizer";
    private List descriptors = new ArrayList();
    static /* synthetic */ Class class$com$sun$speech$freetts$jsapi$FreeTTSEngineCentral;

    public FreeTTSEngineCentral() throws Exception {
        try {
            this.loadDescriptorsFromProperties("synthesizer.properties");
        }
        catch (Exception exception) {
            System.err.println("FreeTTSEngineCentral: trouble loading properties");
            exception.printStackTrace();
            throw exception;
        }
    }

    private void loadDescriptorsFromProperties(String string) {
        Class clazz = class$com$sun$speech$freetts$jsapi$FreeTTSEngineCentral == null ? (class$com$sun$speech$freetts$jsapi$FreeTTSEngineCentral = FreeTTSEngineCentral.class$("com.sun.speech.freetts.jsapi.FreeTTSEngineCentral")) : class$com$sun$speech$freetts$jsapi$FreeTTSEngineCentral;
        InputStream inputStream = clazz.getResourceAsStream("synthesizer.properties");
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
            this.engineName = properties.getProperty("engineName", this.engineName);
            String string2 = properties.getProperty("synthesizers");
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                this.loadSynthesizer(string3, properties);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void loadSynthesizer(String string, Properties properties) {
        String string2 = properties.getProperty(string + ".engineName", this.engineName);
        String string3 = properties.getProperty(string + ".lexicon");
        Locale locale = this.getLocale(string, properties);
        String string4 = properties.getProperty(string + ".audioPlayer", "com.sun.speech.freetts.audio.JavaClipAudioPlayer");
        if (string3 == null) {
            return;
        }
        String string5 = properties.getProperty(string + ".modes");
        StringTokenizer stringTokenizer = new StringTokenizer(string5);
        while (stringTokenizer.hasMoreTokens()) {
            String string6 = stringTokenizer.nextToken();
            this.loadMode(string, string6, string2, locale, string3, string4, properties);
        }
    }

    private Locale getLocale(String string, Properties properties) {
        Locale locale = Locale.getDefault();
        String string2 = properties.getProperty(string + ".locale.language");
        if (string2 != null) {
            String string3;
            String string4 = properties.getProperty(string + ".locale.country");
            locale = string4 == null ? new Locale(string2) : ((string3 = properties.getProperty(string + ".locale.variant")) == null ? new Locale(string2, string4) : new Locale(string2, string4, string3));
        }
        return locale;
    }

    private void loadMode(String string, String string2, String string3, Locale locale, String string4, String string5, Properties properties) {
        String string6 = properties.getProperty(string + "." + string2 + ".modeName", string2);
        FreeTTSSynthesizerModeDesc freeTTSSynthesizerModeDesc = new FreeTTSSynthesizerModeDesc(string3, string6, locale, string4, string5);
        String string7 = properties.getProperty(string + "." + string2 + ".voices");
        StringTokenizer stringTokenizer = new StringTokenizer(string7);
        while (stringTokenizer.hasMoreTokens()) {
            String string8 = stringTokenizer.nextToken();
            Voice voice = this.loadVoice(string, string2, string8, properties);
            if (voice == null) continue;
            freeTTSSynthesizerModeDesc.addVoice(voice);
        }
        this.descriptors.add(freeTTSSynthesizerModeDesc);
    }

    private Voice loadVoice(String string, String string2, String string3, Properties properties) {
        FreeTTSVoice freeTTSVoice = null;
        String string4 = string + "." + string2 + "." + string3 + ".";
        String string5 = properties.getProperty(string4 + "style", "standard");
        try {
            float f = Float.parseFloat(properties.getProperty(string4 + "pitch", "100"));
            float f2 = Float.parseFloat(properties.getProperty(string4 + "pitchRange", "10"));
            float f3 = Float.parseFloat(properties.getProperty(string4 + "speakingRate", "150"));
            float f4 = Float.parseFloat(properties.getProperty(string4 + "volume", "1.0"));
            String string6 = properties.getProperty(string4 + "class");
            String string7 = properties.getProperty(string4 + "dbName");
            int n = this.stringToGender(properties.getProperty(string4 + "gender", "GENDER_NEUTRAL"));
            int n2 = this.stringToAge(properties.getProperty(string4 + "age", "AGE_NEUTRAL"));
            String string8 = properties.getProperty(string4 + "validator");
            if (string6 != null) {
                freeTTSVoice = new FreeTTSVoice(string + "." + string2 + "." + string3, string3, n, n2, string5, f, f2, f3, f4, string6, string7, string8);
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Error while parsing voice property data");
        }
        return freeTTSVoice;
    }

    private int stringToGender(String string) {
        int n = 4;
        if (string != null) {
            if (string.equals("GENDER_MALE")) {
                n = 2;
            } else if (string.equals("GENDER_FEMALE")) {
                n = 1;
            } else if (string.equals("GENDER_NEUTRAL")) {
                n = 4;
            } else if (string.equals("GENDER_DONT_CARE")) {
                n = 65535;
            }
        }
        return n;
    }

    private int stringToAge(String string) {
        int n = 32;
        if (string != null) {
            if (string.equals("AGE_CHILD")) {
                n = 1;
            } else if (string.equals("AGE_DONT_CARE")) {
                n = 65535;
            } else if (string.equals("AGE_MIDDLE_ADULT")) {
                n = 8;
            } else if (string.equals("AGE_NEUTRAL")) {
                n = 32;
            } else if (string.equals("AGE_OLDER_ADULT")) {
                n = 16;
            } else if (string.equals("AGE_TEENAGER")) {
                n = 2;
            } else if (string.equals("AGE_YOUNGER_ADULT")) {
                n = 4;
            }
        }
        return n;
    }

    public EngineList createEngineList(EngineModeDesc engineModeDesc) {
        EngineList engineList = null;
        if (this.descriptors == null) {
            return engineList;
        }
        Iterator iterator = this.descriptors.iterator();
        while (iterator.hasNext()) {
            FreeTTSSynthesizerModeDesc freeTTSSynthesizerModeDesc = (FreeTTSSynthesizerModeDesc)((Object)iterator.next());
            if (engineModeDesc != null && !freeTTSSynthesizerModeDesc.match(engineModeDesc)) continue;
            try {
                freeTTSSynthesizerModeDesc.validate();
                if (engineList == null) {
                    engineList = new EngineList();
                }
                engineList.addElement((Object)freeTTSSynthesizerModeDesc);
            }
            catch (ValidationException validationException) {
                System.err.println(validationException.getMessage());
            }
        }
        return engineList;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

