/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.jsapi;

import com.sun.speech.engine.BaseEngineProperties;
import com.sun.speech.engine.synthesis.BaseSynthesizer;
import com.sun.speech.engine.synthesis.BaseSynthesizerProperties;
import com.sun.speech.engine.synthesis.BaseSynthesizerQueueItem;
import com.sun.speech.engine.synthesis.BaseVoice;
import com.sun.speech.freetts.OutputQueue;
import com.sun.speech.freetts.Voice;
import com.sun.speech.freetts.audio.AudioPlayer;
import com.sun.speech.freetts.jsapi.FreeTTSSynthesizerModeDesc;
import com.sun.speech.freetts.jsapi.FreeTTSSynthesizerQueueItem;
import com.sun.speech.freetts.jsapi.FreeTTSVoice;
import com.sun.speech.freetts.lexicon.Lexicon;
import java.beans.PropertyVetoException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.speech.EngineException;
import javax.speech.EngineStateError;
import javax.speech.synthesis.SynthesizerModeDesc;

public class FreeTTSSynthesizer
extends BaseSynthesizer {
    OutputHandler outputHandler = new OutputHandler();
    private FreeTTSVoice curVoice;
    private AudioPlayer audio;
    private Lexicon lexicon;
    private OutputQueue outputQueue;

    public FreeTTSSynthesizer(FreeTTSSynthesizerModeDesc freeTTSSynthesizerModeDesc) {
        super(freeTTSSynthesizerModeDesc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleAllocate() throws EngineException {
        long[] lArray;
        Object object;
        boolean bl = false;
        FreeTTSSynthesizerModeDesc freeTTSSynthesizerModeDesc = (FreeTTSSynthesizerModeDesc)this.getEngineModeDesc();
        this.audio = freeTTSSynthesizerModeDesc.getAudioPlayer();
        if (this.audio == null) {
            throw new EngineException("Can't get audio player");
        }
        this.outputQueue = Voice.createOutputThread();
        this.lexicon = freeTTSSynthesizerModeDesc.getLexicon();
        if (freeTTSSynthesizerModeDesc.getVoices().length > 0) {
            object = (FreeTTSVoice)freeTTSSynthesizerModeDesc.getVoices()[0];
            bl = this.setCurrentVoice((FreeTTSVoice)((Object)object));
        }
        if (bl) {
            object = this.engineStateLock;
            synchronized (object) {
                long l = 516L;
                lArray = this.setEngineState(-1L, l |= this.outputHandler.isQueueEmpty() ? 65536L : 131072L);
            }
        } else {
            throw new EngineException("Can't allocate FreeTTS synthesizer");
        }
        this.outputHandler.start();
        this.postEngineAllocated(lArray[0], lArray[1]);
    }

    private boolean setCurrentVoice(FreeTTSVoice freeTTSVoice) {
        Voice voice = freeTTSVoice.getFreeTTSVoice();
        boolean bl = false;
        if (!voice.isLoaded()) {
            if (this.lexicon != null) {
                voice.setLexicon(this.lexicon);
            }
            voice.setOutputQueue(this.outputQueue);
            voice.load();
            voice.setAudioPlayer(this.audio);
        }
        if (voice.isLoaded()) {
            this.curVoice = freeTTSVoice;
            bl = true;
            FreeTTSSynthesizerProperties freeTTSSynthesizerProperties = (FreeTTSSynthesizerProperties)this.getSynthesizerProperties();
            freeTTSSynthesizerProperties.checkForPropertyChanges();
        }
        return bl;
    }

    protected void handleDeallocate() throws EngineException {
        long[] lArray = this.setEngineState(-1L, 1L);
        this.outputHandler.cancelAllItems();
        this.outputHandler.terminate();
        if (this.audio != null) {
            this.audio.close();
        }
        this.postEngineDeallocated(lArray[0], lArray[1]);
    }

    protected BaseSynthesizerQueueItem createQueueItem() {
        return new FreeTTSSynthesizerQueueItem();
    }

    public Enumeration enumerateQueue() throws EngineStateError {
        this.checkEngineState(9L);
        return this.outputHandler.enumerateQueue();
    }

    protected void appendQueue(BaseSynthesizerQueueItem baseSynthesizerQueueItem) {
        this.outputHandler.appendQueue((FreeTTSSynthesizerQueueItem)baseSynthesizerQueueItem);
    }

    public void cancel() throws EngineStateError {
        this.checkEngineState(9L);
        this.outputHandler.cancelItem();
    }

    public void cancel(Object object) throws IllegalArgumentException, EngineStateError {
        this.checkEngineState(9L);
        this.outputHandler.cancelItem(object);
    }

    public void cancelAll() throws EngineStateError {
        this.checkEngineState(9L);
        this.outputHandler.cancelAllItems();
    }

    protected void handlePause() {
        this.audio.pause();
    }

    protected void handleResume() {
        this.audio.resume();
    }

    protected BaseEngineProperties createEngineProperties() {
        SynthesizerModeDesc synthesizerModeDesc = (SynthesizerModeDesc)this.engineModeDesc;
        FreeTTSVoice freeTTSVoice = (FreeTTSVoice)synthesizerModeDesc.getVoices()[0];
        return new FreeTTSSynthesizerProperties(freeTTSVoice, freeTTSVoice.getPitch(), freeTTSVoice.getPitchRange(), freeTTSVoice.getSpeakingRate(), freeTTSVoice.getVolume());
    }

    class OutputHandler
    extends Thread {
        protected boolean done = false;
        protected Vector queue = new Vector();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void terminate() {
            Vector vector = this.queue;
            synchronized (vector) {
                this.done = true;
                this.queue.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Enumeration enumerateQueue() {
            Vector vector = this.queue;
            synchronized (vector) {
                Enumeration enumeration = this.queue.elements();
                return enumeration;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isQueueEmpty() {
            Vector vector = this.queue;
            synchronized (vector) {
                boolean bl = this.queue.size() == 0;
                return bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void appendQueue(FreeTTSSynthesizerQueueItem freeTTSSynthesizerQueueItem) {
            boolean bl;
            Vector vector = this.queue;
            synchronized (vector) {
                bl = this.queue.size() == 0;
                this.queue.addElement(freeTTSSynthesizerQueueItem);
                this.queue.notifyAll();
            }
            if (bl) {
                long[] lArray = FreeTTSSynthesizer.super.setEngineState(65536L, 131072L);
                FreeTTSSynthesizer.this.postQueueUpdated(bl, lArray[0], lArray[1]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void cancelItem() {
            FreeTTSSynthesizerQueueItem freeTTSSynthesizerQueueItem = null;
            Vector vector = this.queue;
            synchronized (vector) {
                FreeTTSSynthesizer.this.audio.cancel();
                if (this.queue.size() != 0 && (freeTTSSynthesizerQueueItem = (FreeTTSSynthesizerQueueItem)this.queue.remove(0)) != null) {
                    freeTTSSynthesizerQueueItem.postSpeakableCancelled();
                    this.queueDrained();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void cancelAllItems() {
            Vector vector;
            FreeTTSSynthesizerQueueItem freeTTSSynthesizerQueueItem = null;
            Vector vector2 = this.queue;
            synchronized (vector2) {
                FreeTTSSynthesizer.this.audio.cancel();
                vector = (Vector)this.queue.clone();
                this.queue.clear();
                this.queueDrained();
            }
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                freeTTSSynthesizerQueueItem = (FreeTTSSynthesizerQueueItem)iterator.next();
                freeTTSSynthesizerQueueItem.postSpeakableCancelled();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void cancelItem(Object object) {
            FreeTTSSynthesizerQueueItem freeTTSSynthesizerQueueItem = null;
            Vector vector = this.queue;
            synchronized (vector) {
                int n = this.queue.indexOf(object);
                if (n == 0) {
                    this.cancelItem();
                } else {
                    freeTTSSynthesizerQueueItem = (FreeTTSSynthesizerQueueItem)this.queue.remove(n);
                    if (freeTTSSynthesizerQueueItem != null) {
                        freeTTSSynthesizerQueueItem.postSpeakableCancelled();
                        this.queueDrained();
                    }
                }
            }
        }

        public void run() {
            while (!this.done) {
                FreeTTSSynthesizerQueueItem freeTTSSynthesizerQueueItem = this.getQueueItem();
                if (freeTTSSynthesizerQueueItem == null) continue;
                this.outputItem(freeTTSSynthesizerQueueItem);
                this.removeQueueItem(freeTTSSynthesizerQueueItem);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected FreeTTSSynthesizerQueueItem getQueueItem() {
            FreeTTSSynthesizerQueueItem freeTTSSynthesizerQueueItem = null;
            Vector vector = this.queue;
            synchronized (vector) {
                while (this.queue.size() == 0 && !this.done) {
                    try {
                        this.queue.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        this.error("Unexpected interrupt");
                    }
                }
                if (this.done) {
                    return null;
                }
                freeTTSSynthesizerQueueItem = (FreeTTSSynthesizerQueueItem)this.queue.elementAt(0);
            }
            freeTTSSynthesizerQueueItem.postTopOfQueue();
            return freeTTSSynthesizerQueueItem;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void removeQueueItem(FreeTTSSynthesizerQueueItem freeTTSSynthesizerQueueItem) {
            boolean bl = false;
            Vector vector = this.queue;
            synchronized (vector) {
                boolean bl2 = this.queue.remove(freeTTSSynthesizerQueueItem);
                if (bl2) {
                    this.queueDrained();
                }
            }
        }

        private void queueDrained() {
            if (this.queue.size() == 0) {
                long[] lArray = FreeTTSSynthesizer.super.setEngineState(131072L, 65536L);
                FreeTTSSynthesizer.this.postQueueEmptied(lArray[0], lArray[1]);
            } else {
                long[] lArray = FreeTTSSynthesizer.super.setEngineState(131072L, 131072L);
                FreeTTSSynthesizer.this.postQueueUpdated(true, lArray[0], lArray[1]);
            }
        }

        protected void outputItem(FreeTTSSynthesizerQueueItem freeTTSSynthesizerQueueItem) {
            Voice voice = FreeTTSSynthesizer.this.curVoice.getFreeTTSVoice();
            voice.speak(freeTTSSynthesizerQueueItem);
        }

        private void error(String string) {
            System.out.println("Error: " + string);
        }

        private void trace(String string) {
            System.out.println("Trace: " + string);
        }
    }

    class FreeTTSSynthesizerProperties
    extends BaseSynthesizerProperties {
        FreeTTSSynthesizerProperties(BaseVoice baseVoice, float f, float f2, float f3, float f4) {
            super(baseVoice, f, f2, f3, f4);
        }

        public void reset() {
            super.reset();
        }

        void checkForPropertyChanges() {
            try {
                float f;
                float f2;
                float f3;
                float f4 = this.getPitch();
                if (f4 != this.currentPitch) {
                    super.setPitch(f4);
                }
                if ((f3 = this.getPitchRange()) != this.currentPitchRange) {
                    super.setPitchRange(f3);
                }
                if ((f2 = this.getVolume()) != this.currentVolume) {
                    super.setVolume(f2);
                }
                if ((f = this.getSpeakingRate()) != this.currentSpeakingRate) {
                    super.setSpeakingRate(f);
                }
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }

        public float getPitch() {
            Voice voice = FreeTTSSynthesizer.this.curVoice.getFreeTTSVoice();
            return voice.getPitch();
        }

        public void setVoice(javax.speech.synthesis.Voice voice) {
            if (!FreeTTSSynthesizer.this.curVoice.match(voice)) {
                FreeTTSSynthesizerModeDesc freeTTSSynthesizerModeDesc = (FreeTTSSynthesizerModeDesc)FreeTTSSynthesizer.this.getEngineModeDesc();
                javax.speech.synthesis.Voice[] voiceArray = freeTTSSynthesizerModeDesc.getVoices();
                int n = 0;
                while (n < voiceArray.length) {
                    if (voiceArray[n].match(voice) && FreeTTSSynthesizer.this.setCurrentVoice((FreeTTSVoice)voiceArray[n])) {
                        try {
                            super.setVoice(voice);
                            break;
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            // empty catch block
                        }
                    }
                    ++n;
                }
            }
        }

        public void setPitch(float f) throws PropertyVetoException {
            if (f != this.getPitch()) {
                Voice voice = FreeTTSSynthesizer.this.curVoice.getFreeTTSVoice();
                voice.setPitch(f);
                super.setPitch(f);
            }
        }

        public float getPitchRange() {
            Voice voice = FreeTTSSynthesizer.this.curVoice.getFreeTTSVoice();
            return voice.getPitchRange();
        }

        public void setPitchRange(float f) throws PropertyVetoException {
            if (f != this.getPitchRange()) {
                Voice voice = FreeTTSSynthesizer.this.curVoice.getFreeTTSVoice();
                voice.setPitchRange(f);
                super.setPitchRange(f);
            }
        }

        public float getSpeakingRate() {
            Voice voice = FreeTTSSynthesizer.this.curVoice.getFreeTTSVoice();
            return voice.getRate();
        }

        public void setSpeakingRate(float f) throws PropertyVetoException {
            if (f != this.getSpeakingRate()) {
                Voice voice = FreeTTSSynthesizer.this.curVoice.getFreeTTSVoice();
                voice.setRate(f);
                super.setSpeakingRate(f);
            }
        }

        public float getVolume() {
            Voice voice = FreeTTSSynthesizer.this.curVoice.getFreeTTSVoice();
            return voice.getVolume();
        }

        public void setVolume(float f) throws PropertyVetoException {
            if (f > 1.0f) {
                f = 1.0f;
            } else if (f < 0.0f) {
                f = 0.0f;
            }
            if (f != this.getVolume()) {
                Voice voice = FreeTTSSynthesizer.this.curVoice.getFreeTTSVoice();
                voice.setVolume(f);
                super.setVolume(f);
            }
        }
    }
}

