/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.util;

import com.sun.speech.freetts.FeatureSet;
import com.sun.speech.freetts.Item;
import com.sun.speech.freetts.Relation;

public class SegmentRelationUtils {
    public static Item getItem(Relation relation, float f) {
        Item item = relation.getTail();
        float f2 = SegmentRelationUtils.getSegmentEnd(item);
        if (f < 0.0f || f2 < f) {
            return null;
        }
        if (f2 - f > f) {
            return SegmentRelationUtils.findFromFront(relation, f);
        }
        return SegmentRelationUtils.findFromEnd(relation, f);
    }

    public static float getSegmentEnd(Item item) {
        FeatureSet featureSet = item.getFeatures();
        return featureSet.getFloat("end");
    }

    public static Item findFromFront(Relation relation, float f) {
        Item item = relation.getHead();
        while (item != null && f > SegmentRelationUtils.getSegmentEnd(item)) {
            item = item.getNext();
        }
        return item;
    }

    public static Item findFromEnd(Relation relation, float f) {
        Item item = relation.getTail();
        while (item != null && SegmentRelationUtils.getSegmentEnd(item) > f) {
            item = item.getPrevious();
        }
        if (item != relation.getTail()) {
            item = item.getNext();
        }
        return item;
    }
}

